/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.remoteserver;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.text.SimpleDateFormat;

public class RemoteDependencyNotification_TL
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = -5697447678504066717L;
    private long id;
    private long serverID;
    private int eventTypeCode = -1;
    private String eventStatusCode;
    private long objectID;
    private String objectName;
    private int eventSourceCode;
    private long eventSourceID;
    private String eventSourceInfo;
    private long statusTimestamp;
    private long notificationHistoryID;
    private String userJobName;
    private long remoteDependencyID;
    private long jobSuiteID;
    private String jobSuiteName;

    public long getId() {
        return this.id;
    }

    public long getServerID() {
        return this.serverID;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventStatusCode() {
        return this.eventStatusCode;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getEventSourceCode() {
        return this.eventSourceCode;
    }

    public long getEventSourceID() {
        return this.eventSourceID;
    }

    public String getEventSourceInfo() {
        return this.eventSourceInfo;
    }

    public long getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public long getNotificationHistoryID() {
        return this.notificationHistoryID;
    }

    public long getRemoteDependencyID() {
        return this.remoteDependencyID;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setServerID(long l) {
        this.serverID = l;
    }

    public void setEventTypeCode(int n) {
        this.eventTypeCode = n;
    }

    public void setEventStatusCode(String string) {
        this.eventStatusCode = string;
    }

    public void setObjectID(long l) {
        this.objectID = l;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setEventSourceCode(int n) {
        this.eventSourceCode = n;
    }

    public void setEventSourceID(long l) {
        this.eventSourceID = l;
    }

    public void setEventSourceInfo(String string) {
        this.eventSourceInfo = string;
    }

    public void setStatusTimestamp(long l) {
        this.statusTimestamp = l;
    }

    public void setNotificationHistoryID(long l) {
        this.notificationHistoryID = l;
    }

    public void setRemoteDependencyID(long l) {
        this.remoteDependencyID = l;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
    }

    public void setJobSuiteName(String string) {
        this.jobSuiteName = string;
    }

    public void setUserJobName(String string) {
        this.userJobName = string;
    }

    public String getUserJobName() {
        return this.userJobName;
    }

    public String toString() {
        String string = "";
        try {
            if (this.eventTypeCode > -1) {
                string = PrereqEventType.persistanceCodeToEnum(this.eventTypeCode).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "";
        try {
            if (this.eventStatusCode != null && !this.eventStatusCode.isEmpty()) {
                string2 = PrereqStatusType.persistanceCodeToEnum(this.eventStatusCode).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        return MessageUtil.formatMsg((String)"{0} {1} {2} {3}", (Object[])new Object[]{string, this.objectID, string2, simpleDateFormat.format(this.getStatusTimestamp())});
    }

    public static RemoteDependencyNotification_TL fromRemoteDependencyNotification(RemoteDependencyNotification remoteDependencyNotification) {
        ValidationHelper.checkForNull((String)"Remote Dependency Notification", (Object)((Object)remoteDependencyNotification));
        RemoteDependencyNotification_TL remoteDependencyNotification_TL = new RemoteDependencyNotification_TL();
        remoteDependencyNotification_TL.setId(remoteDependencyNotification.getId());
        remoteDependencyNotification_TL.setServerID(remoteDependencyNotification.getServerID());
        remoteDependencyNotification_TL.setEventTypeCode(remoteDependencyNotification.getEventType().persistanceCode());
        remoteDependencyNotification_TL.setEventStatusCode(remoteDependencyNotification.getEventStatus().persistanceCode());
        remoteDependencyNotification_TL.setObjectID(remoteDependencyNotification.getObjectID());
        remoteDependencyNotification_TL.setObjectName(remoteDependencyNotification.getObjectName());
        remoteDependencyNotification_TL.setEventSourceCode(remoteDependencyNotification.getEventSource().persistanceCode());
        remoteDependencyNotification_TL.setEventSourceID(remoteDependencyNotification.getEventSourceID());
        remoteDependencyNotification_TL.setEventSourceInfo(remoteDependencyNotification.getEventSourceInfo());
        remoteDependencyNotification_TL.setStatusTimestamp(remoteDependencyNotification.getStatusTimestamp());
        remoteDependencyNotification_TL.setNotificationHistoryID(remoteDependencyNotification.getNotificationHistoryID());
        remoteDependencyNotification_TL.setUserJobName(remoteDependencyNotification.getUserJobName());
        remoteDependencyNotification_TL.setRemoteDependencyID(remoteDependencyNotification.getRemoteDependencyID());
        remoteDependencyNotification_TL.setJobSuiteID(remoteDependencyNotification.getJobSuiteID());
        remoteDependencyNotification_TL.setJobSuiteName(remoteDependencyNotification.getJobSuiteName());
        return remoteDependencyNotification_TL;
    }
}

