/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.logger;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ScheduleLogger {
    private static String formatterString = "yyyy-MM-dd HH:mm:ss z";
    private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
    private static DateFormat formatterSecs = new SimpleDateFormat(formatterString);
    public static final long NULL_ID = 0L;
    private static final Logger logger = Logger.getLogger(ScheduleLogger.class);

    public static String formatTimeStamp(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        return ScheduleLogger.formatTimeStamp(calendar.getTime());
    }

    public static String formatTimeStampTZ(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatterString);
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatTimeStampSecs(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        return ScheduleLogger.formatTimeStampSecs(calendar.getTime());
    }

    public static String formatTimeStamp(long l) {
        return ScheduleLogger.formatTimeStamp(new Date(l));
    }

    public static String formatTimeStamp(Date date) {
        if (date == null) {
            return "";
        }
        return formatter.format(date);
    }

    public static String formatTimeStampSecs(Date date) {
        if (date == null) {
            return "";
        }
        return formatterSecs.format(date);
    }

    public static String formatTimeStampSecs(long l) {
        return ScheduleLogger.formatTimeStampSecs(new Date(l));
    }

    public void write(RosettaMsg rosettaMsg) {
        ScheduleLogEntry scheduleLogEntry = ScheduleLogger.makeEntry(rosettaMsg, 0L, 0L, 0L);
        ScheduleLogger.write(scheduleLogEntry);
    }

    public static void write(RosettaMsg rosettaMsg, long l, long l2, long l3) {
        ScheduleLogEntry scheduleLogEntry = ScheduleLogger.makeEntry(rosettaMsg, l, l2, l3);
        ScheduleLogger.write(scheduleLogEntry);
    }

    public static ScheduleLogEntry makeEntry(RosettaMsg rosettaMsg, long l, long l2, long l3) {
        ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, l, l2, l3);
        return scheduleLogEntry;
    }

    public static void write(ScheduleLogEntry scheduleLogEntry) {
        try {
            ScheduleLogDM scheduleLogDM = (ScheduleLogDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleLogDM");
            scheduleLogDM.save(scheduleLogEntry);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error writing schedule log entry: " + scheduleLogEntry.toString()), throwable);
        }
    }

    public static void write(Connection connection, ScheduleLogEntry scheduleLogEntry) {
        try {
            ScheduleLogDM scheduleLogDM = (ScheduleLogDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleLogDM");
            scheduleLogDM.save(connection, scheduleLogEntry);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error writing schedule log entry: " + scheduleLogEntry.toString()), throwable);
        }
    }
}

