/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableValue;
import junit.framework.TestCase;

public class SkybotVariableValueTest
extends TestCase {
    private SkybotVariableValue val;

    protected void setUp() throws Exception {
        super.setUp();
        this.val = new SkybotVariableValue();
    }

    protected void tearDown() throws Exception {
        this.val = null;
        super.tearDown();
    }

    public void testGetAction() {
        this.val.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_GET);
        SkybotVariableValueTest.assertEquals((Object)((Object)SkybotVariableValue.SKYVAR_ACTION.ACTION_GET), (Object)((Object)this.val.getAction()));
        this.val.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_SET);
        SkybotVariableValueTest.assertEquals((Object)((Object)SkybotVariableValue.SKYVAR_ACTION.ACTION_SET), (Object)((Object)this.val.getAction()));
    }

    public void testGetName() {
        this.val.setName("@@NAME");
        SkybotVariableValueTest.assertEquals((String)"@@NAME", (String)this.val.getName());
    }

    public void testGetValue() {
        this.val.setValue("1234ABC");
        SkybotVariableValueTest.assertEquals((String)"1234ABC", (String)this.val.getValue());
    }

    public void testGetStatus() {
        this.val.setStatus(0);
        SkybotVariableValueTest.assertEquals((int)0, (int)this.val.getStatus());
        this.val.setStatus(1);
        SkybotVariableValueTest.assertEquals((int)1, (int)this.val.getStatus());
        this.val.setStatus(2);
        SkybotVariableValueTest.assertEquals((int)2, (int)this.val.getStatus());
    }

    public void testIsStatusFailed() {
        this.val.setStatus(2);
        SkybotVariableValueTest.assertFalse((boolean)this.val.isStatusFailed());
        this.val.setStatus(0);
        SkybotVariableValueTest.assertTrue((boolean)this.val.isStatusFailed());
    }

    public void testIsStatusPending() {
        this.val.setStatus(1);
        SkybotVariableValueTest.assertFalse((boolean)this.val.isStatusPending());
        this.val.setStatus(2);
        SkybotVariableValueTest.assertTrue((boolean)this.val.isStatusPending());
    }

    public void testIsStatusSuccessful() {
        this.val.setStatus(0);
        SkybotVariableValueTest.assertFalse((boolean)this.val.isStatusSuccessful());
        this.val.setStatus(1);
        SkybotVariableValueTest.assertTrue((boolean)this.val.isStatusSuccessful());
    }

    public void testGetReplyMessage() {
        this.val.setReplyMessage("SOME MESSAGE");
        SkybotVariableValueTest.assertEquals((String)"SOME MESSAGE", (String)this.val.getReplyMessage());
    }

    public void testGetLogDescription() {
        this.val.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_GET);
        this.val.setName("@@NAME");
        SkybotVariableValueTest.assertTrue((boolean)this.val.getLogDescription().contains("@@NAME"));
        this.val.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_SET);
        this.val.setValue("AEIOU");
        SkybotVariableValueTest.assertTrue((boolean)this.val.getLogDescription().contains("@@NAME"));
        SkybotVariableValueTest.assertTrue((boolean)this.val.getLogDescription().contains("="));
        SkybotVariableValueTest.assertTrue((boolean)this.val.getLogDescription().contains("AEIOU"));
    }

    public void testValidateRequiresName() {
        try {
            this.val.validate();
            SkybotVariableValueTest.fail((String)"validate() allowed no variable name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

