/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableValue;
import org.apache.log4j.Logger;

public class SkybotVariableCommand
extends AgentCommand {
    private static final long serialVersionUID = 4929011453962245938L;
    private static final Logger logger = Logger.getLogger(SkybotVariableCommand.class);
    public static final String COMMAND_NAME = "ROVAR";
    public static final String MODE_GET = "GET";
    public static final String MODE_SET = "SET";
    private String mode = null;
    private SkybotVariableValue skybotVariableValue = null;

    public SkybotVariableCommand() {
    }

    public SkybotVariableCommand(long l) {
        super(l);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        stringBuffer.append(string + "\"" + this.skybotVariableValue.getLogDescription() + "\"");
        if (string.length() == 0) {
            string = " ";
        }
        return "Mode: " + this.mode + " Variables: " + stringBuffer.toString();
    }

    @Override
    public void validate() throws ActionFailedException {
        if (!MODE_GET.equals(this.mode) && !MODE_SET.equals(this.mode)) {
            throw new ActionFailedException("Invalid mode: " + this.mode);
        }
        if (this.skybotVariableValue == null) {
            throw new ActionFailedException("An Automate Schedule Variable must be specified.");
        }
        if (this.skybotVariableValue.isStatusPending()) {
            this.skybotVariableValue.validate();
        }
    }

    @Override
    public void parseParameters(String[] stringArray) throws ActionFailedException {
        for (int i = 0; i < stringArray.length; ++i) {
            logger.trace((Object)("Parsing parameter: " + stringArray[i]));
            if (stringArray[i].toLowerCase().equals("-m")) {
                if (i + 1 >= stringArray.length) {
                    throw new IllegalArgumentException("A value is required for the mode parameter.");
                }
                this.setMode(stringArray[i + 1]);
                ++i;
                continue;
            }
            if (stringArray[i].length() > 0) {
                if (this.mode == null) {
                    throw new IllegalStateException("Mode must be set before parsing variable names.");
                }
                if (this.skybotVariableValue != null) {
                    throw new ActionFailedException("More than one Automate Schedule Variable specified.");
                }
                this.skybotVariableValue = new SkybotVariableValue();
                if (MODE_SET.equalsIgnoreCase(this.mode)) {
                    this.skybotVariableValue.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_SET);
                    int n = stringArray[i].indexOf("=");
                    if (n > 0) {
                        this.skybotVariableValue.setName(stringArray[i].substring(0, n).trim());
                        this.skybotVariableValue.setValue(stringArray[i].substring(n + 1));
                        continue;
                    }
                    this.skybotVariableValue.setName(stringArray[i].trim());
                    continue;
                }
                this.skybotVariableValue.setAction(SkybotVariableValue.SKYVAR_ACTION.ACTION_GET);
                this.skybotVariableValue.setName(stringArray[i].trim());
                continue;
            }
            throw new ActionFailedException("Invalid parameter: " + stringArray[i]);
        }
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isGetMode() {
        return MODE_GET.equals(this.mode);
    }

    public boolean isSetMode() {
        return MODE_SET.equals(this.mode);
    }

    public void setMode(String string) {
        if (string == null) {
            throw new NullPointerException("Command mode is null.");
        }
        String string2 = string.trim().toUpperCase();
        if (!MODE_GET.equals(string2) && !MODE_SET.equals(string2)) {
            throw new IllegalArgumentException("Command mode is invalid: " + string);
        }
        this.mode = string2;
    }

    public SkybotVariableValue getSkybotVariableValue() {
        return this.skybotVariableValue;
    }

    public void setSkybotVariableValue(SkybotVariableValue skybotVariableValue) {
        this.skybotVariableValue = skybotVariableValue;
    }
}

