/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import org.apache.log4j.Logger;

public class SendMessageCommand
extends AgentCommand {
    private static final long serialVersionUID = 3256083069659294284L;
    private static final Logger logger = Logger.getLogger(SendMessageCommand.class);
    public static final String COMMAND_NAME = "SENDMSG";
    public static final String MODE_EMAIL = "EMAIL";
    public static final String MODE_SKYBOT = "SKYBOT";
    public static final String MODE_TRAP = "TRAP";
    public static final String MODE_SNDMSG = "SNDMSG";
    public static final String TRAP_SEVERITY_ATTN = "AT";
    public static final String TRAP_SEVERITY_WARN = "WR";
    public static final String TRAP_SEVERITY_INFO = "IN";
    private String mode = null;
    private String r_parm = null;
    private String t_parm = null;
    private String c_parm = null;
    private String j_parm = null;
    private String s_parm = null;

    public SendMessageCommand() {
    }

    public SendMessageCommand(long l) {
        super(l);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    protected String getCommandInfo() {
        return "Mode: " + this.mode + " R-Parm: " + this.r_parm + " T-Parm: " + this.t_parm + " C-Parm: " + this.c_parm + " J-Parm: " + this.j_parm + " S-Parm: " + this.s_parm;
    }

    @Override
    public void validate() throws ActionFailedException {
        if (MODE_EMAIL.equals(this.mode)) {
            this.validateEmailMsg();
        } else if (MODE_SKYBOT.equals(this.mode)) {
            this.validateSkybotMsg();
        } else if (MODE_TRAP.equals(this.mode)) {
            this.validateTrapMsg();
        } else if (MODE_SNDMSG.equals(this.mode)) {
            this.validateUserMsg();
        } else {
            throw new ActionFailedException("Invalid Mode: " + this.mode);
        }
    }

    private void validateEmailMsg() throws ActionFailedException {
        if (this.r_parm == null || this.r_parm.trim().length() == 0) {
            throw new ActionFailedException("A to-recipient must be specified with the '-r' parameter.");
        }
        if (this.s_parm == null || this.s_parm.trim().length() == 0) {
            throw new ActionFailedException("A subject must be specified with the '-s' parameter.");
        }
        if (this.t_parm == null || this.t_parm.trim().length() == 0) {
            throw new ActionFailedException("Message text must be specified with the '-t' parameter.");
        }
    }

    private void validateSkybotMsg() throws ActionFailedException {
        if (!(this.r_parm != null && this.r_parm.trim().length() != 0 || this.j_parm != null && this.j_parm.trim().length() != 0)) {
            throw new ActionFailedException("An Automate Schedule job name (-r parameter) or job number (-j parameter) must be specified.");
        }
        if (this.c_parm == null || this.c_parm.trim().length() == 0) {
            throw new ActionFailedException("An Automate Schedule completion code must be specified with the '-c' parameter.");
        }
        String string = this.c_parm.trim().toUpperCase();
        if (!(string.equals("B") || string.equals("C") || string.equals("D") || string.equals("K") || string.equals("P") || string.equals("R") || string.equals("S") || string.equals("T"))) {
            throw new RuntimeException("Automate Schedule completion code for the '-c' parameter must be B, C, D, K, P, R, S, or T.");
        }
        this.c_parm = string;
    }

    private void validateTrapMsg() throws ActionFailedException {
        if (this.c_parm == null || this.c_parm.trim().length() == 0) {
            throw new ActionFailedException("A severity code must be specified with the '-c' parameter.");
        }
        String string = this.c_parm.trim().toUpperCase();
        if (!(string.equals(TRAP_SEVERITY_WARN) || string.equals(TRAP_SEVERITY_ATTN) || string.equals(TRAP_SEVERITY_INFO))) {
            throw new RuntimeException("Severity code for the '-c' parameter must be AT, WR, or IN.");
        }
        this.c_parm = string;
        if (this.t_parm == null || this.t_parm.trim().length() == 0) {
            throw new ActionFailedException("Message text must be specified with the '-t' parameter.");
        }
    }

    private void validateUserMsg() throws ActionFailedException {
        if (this.r_parm == null || this.r_parm.trim().length() == 0) {
            throw new ActionFailedException("An user profile must be specified with the '-r' parameter.");
        }
        if (this.t_parm == null || this.t_parm.trim().length() == 0) {
            throw new ActionFailedException("Message text must be specified with the '-t' parameter.");
        }
    }

    @Override
    public void parseParameters(String[] stringArray) throws ActionFailedException {
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            logger.trace((Object)("Parsing parameter: " + stringArray[i]));
            string = stringArray[i].trim().toLowerCase();
            string2 = null;
            if (i + 1 >= stringArray.length) {
                throw new ActionFailedException("A value is required for the " + string + " parameter.");
            }
            string2 = stringArray[i + 1];
            try {
                if (string.equals("-f")) {
                    ++i;
                    continue;
                }
                if (string.equals("-m")) {
                    this.setMode(string2);
                    ++i;
                    continue;
                }
                if (string.equals("-r")) {
                    this.setR_parm(string2);
                    ++i;
                    continue;
                }
                if (string.equals("-t")) {
                    this.setT_parm(string2);
                    ++i;
                    continue;
                }
                if (string.equals("-c")) {
                    this.setC_parm(string2);
                    ++i;
                    continue;
                }
                if (string.equals("-j")) {
                    this.setJ_parm(string2);
                    ++i;
                    continue;
                }
                if (string.equals("-s")) {
                    this.setS_parm(string2);
                    ++i;
                    continue;
                }
                throw new ActionFailedException("Invalid option parameter: " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        if (string == null) {
            throw new NullPointerException("Command mode is null.");
        }
        String string2 = string.trim().toUpperCase();
        if (!(MODE_EMAIL.equals(string2) || MODE_SKYBOT.equals(string2) || MODE_TRAP.equals(string2) || MODE_SNDMSG.equals(string2))) {
            throw new IllegalArgumentException("Command mode is invalid: " + string);
        }
        this.mode = string2;
    }

    public String getR_parm() {
        return this.r_parm;
    }

    public void setR_parm(String string) {
        this.r_parm = string;
    }

    public String getT_parm() {
        return this.t_parm;
    }

    public void setT_parm(String string) {
        this.t_parm = string;
    }

    public String getC_parm() {
        return this.c_parm;
    }

    public void setC_parm(String string) {
        this.c_parm = string;
    }

    public String getJ_parm() {
        return this.j_parm;
    }

    public void setJ_parm(String string) {
        this.j_parm = string;
    }

    public String getS_parm() {
        return this.s_parm;
    }

    public void setS_parm(String string) {
        this.s_parm = string;
    }
}

