/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferDetails;

public class FileTransferCommand
extends AgentCommand {
    private static final long serialVersionUID = -987654321009L;
    public static final String COMMAND_NAME = "FTP";
    FileTransferDetails details = new FileTransferDetails();

    public FileTransferDetails getFileTransferDetails() {
        return this.details;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void parseParameters(String[] stringArray) throws ActionFailedException {
        this.details.parseParameters(stringArray);
    }

    @Override
    protected String getCommandInfo() {
        return this.details.getCommandInfo();
    }

    @Override
    public void validate() throws ActionFailedException {
        int n = this.details.getSystemTransferType();
        if (n != 0 && n != 2 && n != 1) {
            throw new ActionFailedException("Invalid System Transfer Type: " + n);
        }
        if (this.details.getPassword() == null) {
            throw new ActionFailedException("Password is missing. ");
        }
        if (this.details.getHostFile() == null) {
            throw new ActionFailedException("Host File is missing. ");
        }
        if (this.details.getAgentFile() == null) {
            throw new ActionFailedException("Agent File is missing. ");
        }
        if (this.details.getUser() == null) {
            throw new ActionFailedException("User File is missing. ");
        }
        if (this.details.getHost() == null) {
            throw new ActionFailedException("Host is missing. ");
        }
    }
}

