/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusCommand;
import com.helpsystems.enterprise.core.cmdlineobj.ImportCronCommand;
import com.helpsystems.enterprise.core.cmdlineobj.InformaticaCommand;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SendMessageCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import java.util.Date;

public abstract class AgentCommand
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = 4920171775872585423L;
    private long requestTimestamp = 0L;
    private String agentName = null;
    private String enterpriseServerName = null;
    private PeerID initiatingAgent = null;

    public static AgentCommand loadAgentCommand(String string) throws ActionFailedException {
        if (string.equals("SENDMSG")) {
            return new SendMessageCommand();
        }
        if (string.equals("GETACTIVITY")) {
            return new GetActivityCommand();
        }
        if (string.equals("GETSTATUS")) {
            return new GetAgentStatusCommand();
        }
        if (string.equals("ROVAR")) {
            return new SkybotVariableCommand();
        }
        if (string.equals("FTP")) {
            return new FileTransferCommand();
        }
        if (string.equals("IMPORTCRON")) {
            return new ImportCronCommand();
        }
        if (string.equals("REPORT")) {
            return new ReportCommand();
        }
        if (string.equals(InformaticaCommand.COMMAND_NAME)) {
            return new InformaticaCommand();
        }
        throw new ActionFailedException("Undefined Command ID: " + string);
    }

    public AgentCommand() {
        this.requestTimestamp = System.currentTimeMillis();
    }

    public AgentCommand(long l) {
        this.requestTimestamp = l;
    }

    protected abstract String getCommandInfo();

    public abstract String getCommandName();

    public abstract void validate() throws ActionFailedException;

    public abstract void parseParameters(String[] var1) throws ActionFailedException;

    public long getRequestTimestamp() {
        return this.requestTimestamp;
    }

    public void setRequestTimestamp(long l) {
        this.requestTimestamp = l;
    }

    public String getAgentName() {
        if (this.agentName == null) {
            return "";
        }
        return this.agentName;
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public String getEnterpriseServerName() {
        if (this.enterpriseServerName == null) {
            return "";
        }
        return this.enterpriseServerName;
    }

    public void setEnterpriseServerName(String string) {
        this.enterpriseServerName = string;
    }

    public String getLogDescription() {
        return "Agent Command(" + this.getCommandName() + ") Info(" + this.getCommandInfo() + ") Agent Timestamp(" + DateTranslator.formatDateTime((Date)new Date(this.requestTimestamp)) + ")";
    }

    public String toString() {
        return this.getLogDescription();
    }

    public PeerID getInitiatingAgent() {
        return this.initiatingAgent;
    }

    public void setInitiatingAgent(PeerID peerID) {
        this.initiatingAgent = peerID;
    }
}

