/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.common.core.busobj.SNMPTrap;
import com.helpsystems.common.core.network.StdMsg;
import com.helpsystems.common.core.util.Equal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class EnterpriseSNMPTrap
extends SNMPTrap {
    public static final String VB_ID_SKYBOT_SCHEDULER = "1.3.6.1.4.1.6872.2.1.1";
    protected static final String VB_ID_AGENT_ID = "1.3.6.1.4.1.6872.2.1.1.1";
    protected static final String VB_ID_AGENT_NAME = "1.3.6.1.4.1.6872.2.1.1.2";
    protected static final String VB_ID_JOB_ID = "1.3.6.1.4.1.6872.2.1.1.3";
    protected static final String VB_ID_JOB_NAME = "1.3.6.1.4.1.6872.2.1.1.4";
    protected static final String VB_ID_DATE = "1.3.6.1.4.1.6872.2.1.1.5";
    protected static final String VB_ID_TIME = "1.3.6.1.4.1.6872.2.1.1.6";
    protected static final String VB_ID_TEXT = "1.3.6.1.4.1.6872.2.1.1.7";
    protected static final String VB_ID_END_CODE = "1.3.6.1.4.1.6872.2.1.1.8";
    protected static final String VB_ID_SEVERITY = "1.3.6.1.4.1.6872.2.1.1.9";
    protected static final String VB_ID_EVENT_ID = "1.3.6.1.4.1.6872.2.1.1.10";
    protected static final String VB_ID_EVENT_NAME = "1.3.6.1.4.1.6872.2.1.1.11";
    protected static final String VB_ID_EVENT_DATA = "1.3.6.1.4.1.6872.2.1.1.12";
    protected static final String VB_ID_EVENT_TYPE = "1.3.6.1.4.1.6872.2.1.1.13";
    protected static final String VB_ID_RUN_ID = "1.3.6.1.4.1.6872.2.1.1.14";
    protected static final String VB_ID_SUITE_RUN_ID = "1.3.6.1.4.1.6872.2.1.1.15";
    protected static final String VB_ID_SAP_SERVERNAME = "1.3.6.1.4.1.6872.2.1.1.16";
    protected static final String VB_ID_SUITE_NAME = "1.3.6.1.4.1.6872.2.1.1.17";
    protected static final String VB_ID_SUITE_ID = "1.3.6.1.4.1.6872.2.1.1.18";
    protected static final String EMPTY_VALUE = " ";
    public static final int SPECIFIC_AGENT_DISCONNECT = 1;
    public static final int SPECIFIC_AGENT_CONNECT = 2;
    public static final int SPECIFIC_JOB_SUBMITTED = 3;
    public static final int SPECIFIC_JOB_RUNNING = 4;
    public static final int SPECIFIC_JOB_COMPLETED = 5;
    public static final int SPECIFIC_JOB_FAILED = 6;
    public static final int SPECIFIC_JOB_CANCELED = 7;
    public static final int SPECIFIC_JOB_RETRY_WAIT = 8;
    public static final int SPECIFIC_SERVER_EVENT = 9;
    public static final int SPECIFIC_AGENT_EVENT = 10;
    public static final int SPECIFIC_AGENT_MANUAL_EVENT = 11;
    public static final int SPECIFIC_AGENT_FILE_ADDED_EVENT = 12;
    public static final int SPECIFIC_AGENT_FILE_REMOVED_EVENT = 13;
    public static final int SPECIFIC_AGENT_FILE_CHANGED_EVENT = 14;
    public static final int SPECIFIC_AGENT_FILE_THRESHOLD_EVENT = 15;
    public static final int SPECIFIC_AGENT_DIRECTORY_ADDED_EVENT = 16;
    public static final int SPECIFIC_AGENT_DIRECTORY_REMOVED_EVENT = 17;
    public static final int SPECIFIC_AGENT_DIRECTORY_CHANGED_EVENT = 18;
    public static final int SPECIFIC_AGENT_DIRECTORY_THRESHOLD_EVENT = 19;
    public static final int SPECIFIC_AGENT_PROCESS_STARTED_EVENT = 20;
    public static final int SPECIFIC_AGENT_PROCESS_ENDED_EVENT = 21;
    public static final int SPECIFIC_JOB_UNDERRUN_EVENT = 22;
    public static final int SPECIFIC_JOB_OVERRUN_EVENT = 23;
    public static final int SPECIFIC_JOB_LATE_START_EVENT = 24;
    public static final int SPECIFIC_JOB_SKIPPED = 25;
    public static final int SPECIFIC_JOB_SUITE_MEMEBER_CANCELED = 26;
    public static final int SPECIFIC_JOB_SUITE_MEMBER_FAILED = 27;
    public static final int SPECIFIC_JOB_SUITE_RUNNING = 28;
    public static final int SPECIFIC_JOB_SUITE_COMPLETED = 29;
    public static final int SPECIFIC_JOB_SUITE_SKIPPED = 30;
    public static final int SPECIFIC_JOB_SUITE_UNDERRUN_EVENT = 31;
    public static final int SPECIFIC_JOB_SUITE_OVERRUN_EVENT = 32;
    public static final int SPECIFIC_JOB_SUITE_LATE_START_EVENT = 33;
    public static final int SAP_EVENT_PROCESSED = 34;
    public static final String SEVERITY_ATTENTION = "AT";
    public static final String SEVERITY_WARNING = "WR";
    public static final String SEVERITY_INFORMATION = "IN";
    DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    DateFormat timeFormatter = new SimpleDateFormat("HH:mm z");
    private int type;
    private String text;
    private Timestamp serverDateTime;
    private String severity;
    private static final Collection<String> VALID_SEVERITY_VALUES;
    private static final Collection<Integer> VALID_TYPE_VALUES;

    public EnterpriseSNMPTrap() {
        this.setEnterprise(VB_ID_SKYBOT_SCHEDULER);
        this.setServerDateTime(new Timestamp(System.currentTimeMillis()));
    }

    public Timestamp getServerDateTime() {
        return this.serverDateTime;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public int getType() {
        return this.type;
    }

    public void setServerDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            throw new NullPointerException(StdMsg.nullValue((String)"Server Date/Time"));
        }
        this.serverDateTime = timestamp;
        String string = this.dateFormatter.format(timestamp);
        this.addVariableBinding(VB_ID_DATE, string);
        String string2 = this.timeFormatter.format(timestamp);
        this.addVariableBinding(VB_ID_TIME, string2);
    }

    public void setSeverity(String string) {
        if (!VALID_SEVERITY_VALUES.contains(string)) {
            throw new IllegalArgumentException("Severity is invalid.");
        }
        this.severity = string;
        this.addVariableBinding(VB_ID_SEVERITY, string);
    }

    public void setText(String string) {
        if (string != null) {
            this.text = string;
            this.addVariableBinding(VB_ID_TEXT, string);
        } else {
            this.addVariableBinding(VB_ID_TEXT, EMPTY_VALUE);
        }
    }

    public void setType(int n) {
        if (!VALID_TYPE_VALUES.contains(n)) {
            throw new IllegalArgumentException("Type is invalid.");
        }
        this.type = n;
        this.setSpecificCode(n);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EnterpriseSNMPTrap)) {
            return false;
        }
        EnterpriseSNMPTrap enterpriseSNMPTrap = (EnterpriseSNMPTrap)((Object)object);
        return Equal.isEqual((long)this.type, (long)enterpriseSNMPTrap.type) && Equal.isEqual((Object)this.serverDateTime, (Object)enterpriseSNMPTrap.serverDateTime) && Equal.isEqual((Object)this.severity, (Object)enterpriseSNMPTrap.severity) && Equal.isEqual((Object)this.text, (Object)enterpriseSNMPTrap.text);
    }

    static {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(SEVERITY_INFORMATION);
        hashSet.add(SEVERITY_WARNING);
        hashSet.add(SEVERITY_ATTENTION);
        VALID_SEVERITY_VALUES = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet();
        hashSet.add(1);
        hashSet.add(2);
        hashSet.add(3);
        hashSet.add(4);
        hashSet.add(5);
        hashSet.add(6);
        hashSet.add(7);
        hashSet.add(8);
        hashSet.add(9);
        hashSet.add(10);
        hashSet.add(11);
        hashSet.add(12);
        hashSet.add(13);
        hashSet.add(14);
        hashSet.add(15);
        hashSet.add(16);
        hashSet.add(17);
        hashSet.add(18);
        hashSet.add(19);
        hashSet.add(20);
        hashSet.add(21);
        hashSet.add(22);
        hashSet.add(23);
        hashSet.add(24);
        hashSet.add(25);
        hashSet.add(26);
        hashSet.add(27);
        hashSet.add(28);
        hashSet.add(29);
        hashSet.add(30);
        hashSet.add(31);
        hashSet.add(32);
        hashSet.add(33);
        hashSet.add(34);
        VALID_TYPE_VALUES = Collections.unmodifiableSet(hashSet);
    }
}

