/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommand;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantAction;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class SAPVariantActionList
extends EnterpriseProxy
implements SAPCommand {
    private static final long serialVersionUID = -1L;
    private long sapSystemEnvironmentID;
    private long sapSystemDefinitionID;
    private String sapProgramName;
    private String sapVariant;
    private ArrayList<SAPVariantAction> sapVariantActions = new ArrayList();

    public ArrayList<SAPVariantAction> getSAPVariantActions() {
        return this.sapVariantActions;
    }

    public void addSAPVariantAction(SAPVariantAction sAPVariantAction) {
        if (this.sapVariantActions.isEmpty()) {
            this.init(sAPVariantAction);
        } else if (this.sapSystemEnvironmentID != sAPVariantAction.getSAPSystemEnvironmentID()) {
            throw new InvalidParameterException("SAP System Environment ID " + sAPVariantAction.getSAPSystemEnvironmentID() + " does not match previous variant actions with Environment ID " + this.getSAPSystemEnvironmentID());
        }
        this.sapVariantActions.add(sAPVariantAction);
    }

    private void init(SAPVariantAction sAPVariantAction) {
        this.setSAPSystemEnvironmentID(sAPVariantAction.getSAPSystemEnvironmentID());
        this.setSapProgramName(sAPVariantAction.getSapProgramName());
        this.setSapVariant(sAPVariantAction.getSapVariant());
        this.setName("Change SAP Variant " + sAPVariantAction.getSapVariant() + " in Program " + sAPVariantAction.getSapProgramName());
    }

    public void setSAPSystemDefinitionID(long l) {
        this.sapSystemDefinitionID = l;
    }

    @Override
    public long getSAPSystemDefinitionID() {
        return this.sapSystemDefinitionID;
    }

    public void setSAPSystemEnvironmentID(long l) {
        this.sapSystemEnvironmentID = l;
    }

    @Override
    public long getSAPSystemEnvironmentID() {
        return this.sapSystemEnvironmentID;
    }

    public String getSapProgramName() {
        return this.sapProgramName;
    }

    public void setSapProgramName(String string) {
        this.sapProgramName = string;
    }

    public String getSapVariant() {
        return this.sapVariant;
    }

    public void setSapVariant(String string) {
        this.sapVariant = string;
    }

    @Override
    public String getSAPCommandName() {
        return this.getName();
    }
}

