/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableProcessChain;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobStatus;
import com.helpsystems.enterprise.core.busobj.sap.SAPObject;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcessStatus;

public class SAPProcess
extends EnterpriseProxy
implements SAPObject {
    private String processChain;
    private String eventPStart;
    private SAPProcessStatus sapProcessStatus;
    private String jobName;
    private String jobCount;
    private SAPJobStatus sapJobStatus = SAPJobStatus.UNKNOWN;
    private String processType;
    private String variant;
    private String instance;
    private SAPExecutableProcessChain innerProcessChain;

    public SAPProcess() {
    }

    public SAPProcess(String string, String string2, SAPProcessStatus sAPProcessStatus, String string3, String string4, String string5, String string6) {
        this.setProcessChain(string);
        this.setEventPStart(string2);
        this.setSapProcessStatus(sAPProcessStatus);
        this.setProcessType(string3);
        this.setVariant(string4);
        this.setInstance(string5);
        this.setJobCount(string6);
    }

    public String getProcessChain() {
        return this.processChain;
    }

    public void setProcessChain(String string) {
        this.processChain = string;
    }

    public String getEventPStart() {
        return this.eventPStart;
    }

    public void setEventPStart(String string) {
        this.eventPStart = string;
    }

    public SAPJobStatus getSapJobStatus() {
        return this.sapJobStatus;
    }

    public void setSapJobStatus(SAPJobStatus sAPJobStatus) {
        if (this.sapJobStatus == null || !this.sapJobStatus.isTerminal()) {
            this.sapJobStatus = sAPJobStatus;
        }
    }

    public String getJobCount() {
        if (this.jobCount == null) {
            return "";
        }
        return this.jobCount;
    }

    public void setJobCount(String string) {
        this.jobCount = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        if (this.jobName == null) {
            this.jobName = string;
        }
    }

    public boolean isActive() {
        return !this.sapProcessStatus.isTerminal() && this.hasJobCount();
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String string) {
        this.processType = string;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String string) {
        this.variant = string;
    }

    public boolean hasJobNameAndCount() {
        return this.hasJobName() && this.hasJobCount();
    }

    private boolean hasJobName() {
        return this.jobName != null && this.jobName.length() > 0;
    }

    private boolean hasJobCount() {
        return this.jobCount != null && this.jobCount.length() > 0;
    }

    public String getInstance() {
        if (this.instance == null) {
            return "";
        }
        return this.instance;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public SAPProcessStatus getSapProcessStatus() {
        return this.sapProcessStatus;
    }

    public void setSapProcessStatus(SAPProcessStatus sAPProcessStatus) {
        this.sapProcessStatus = sAPProcessStatus;
    }

    public String getHashMapID() {
        return this.eventPStart + this.variant;
    }

    public SAPExecutableProcessChain getInnerProcessChain() {
        return this.innerProcessChain;
    }

    public void setInnerProcessChain(SAPExecutableProcessChain sAPExecutableProcessChain) {
        this.innerProcessChain = sAPExecutableProcessChain;
    }

    public String toString() {
        return "Chain:" + this.processChain + " EventPStart:" + this.eventPStart + " Status:" + this.sapProcessStatus + " JobName:" + this.jobName + "(" + this.jobCount + ")" + " Job Status:" + this.sapJobStatus + " Type:" + this.processType + " Variant:" + this.variant + " Instance:" + this.instance;
    }
}

