/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.informatica;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.util.UnacodeMash;

public class InformaticaCloudServer
extends AbstractBusinessObject
implements BasicIdentifier {
    private static final long serialVersionUID = 1346116921217588941L;
    private long OID;
    private String baseURL;
    private String userEmail;
    private String passwordSalt;
    private String encryptedPassword;
    private boolean verboseLogging = false;
    private int initialPollingInterval;
    private int initialPollingAttempts;
    private int statusPollingInterval;

    public long getOID() {
        return this.OID;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String string) {
        this.userEmail = string;
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void setPasswordSalt(String string) {
        this.passwordSalt = string;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String string) {
        this.encryptedPassword = string;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean bl) {
        this.verboseLogging = bl;
    }

    public int getInitialPollingInterval() {
        return this.initialPollingInterval;
    }

    public void setInitialPollingInterval(int n) {
        this.initialPollingInterval = n;
    }

    public int getInitialPollingAttempts() {
        return this.initialPollingAttempts;
    }

    public void setInitialPollingAttempts(int n) {
        this.initialPollingAttempts = n;
    }

    public int getStatusPollingInterval() {
        return this.statusPollingInterval;
    }

    public void setStatusPollingInterval(int n) {
        this.statusPollingInterval = n;
    }

    public String getDecryptedPassword() {
        if (this.getEncryptedPassword() == null || this.getEncryptedPassword().trim().length() == 0) {
            return "";
        }
        if (this.getPasswordSalt() == null) {
            return this.getEncryptedPassword();
        }
        String string = null;
        try {
            string = UnacodeMash.unMash(this.getEncryptedPassword());
            string = string.replaceAll(this.getPasswordSalt(), "");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RuntimeException("An error occurred while decrypting a password.", resourceUnavailableException);
        }
        return string;
    }
}

