/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.automate;

import com.helpsystems.enterprise.core.busobj.automate.AutoMateSearchSelection;
import com.helpsystems.enterprise.core.util.JSONHelper;
import java.util.Comparator;

public class AutoMateObject {
    public static Comparator<? super AutoMateObject> ID_COMPARATOR = new AutoMateComparator(AutoMateSearchSelection.BY_ID);
    public static Comparator<? super AutoMateObject> NAME_COMPARATOR = new AutoMateComparator(AutoMateSearchSelection.BY_NAME);
    public static Comparator<? super AutoMateObject> PATH_WITH_NAME_COMPARATOR = new AutoMateComparator(AutoMateSearchSelection.PATH_OR_ID);
    private String id;
    private String name;
    private String path;

    protected static int compareStrings(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private static int compareByFolder(AutoMateObject autoMateObject, AutoMateObject autoMateObject2) {
        int n = AutoMateObject.compareStrings(autoMateObject.getPathForCompare(), autoMateObject2.getPathForCompare());
        if (n == 0) {
            return AutoMateObject.compareStrings(autoMateObject.getName().toLowerCase(), autoMateObject2.getName().toLowerCase());
        }
        return n;
    }

    public AutoMateObject(String string, String string2) {
        this.id = string;
        this.name = string2;
    }

    public AutoMateObject(String string, String string2, String string3) {
        this.id = string;
        this.name = string2;
        this.path = string3;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getJSONString() {
        String string = "{" + this.getJSONAttribute("id", this.getId()) + "," + this.getJSONAttribute("name", this.getName()) + "," + this.getJSONAttribute("path", this.getPath()) + "}";
        return string;
    }

    protected String getJSONAttribute(String string, String string2) {
        String string3 = "\"";
        return string3 + string + string3 + ":" + string3 + JSONHelper.escapeJSONString(string2) + string3;
    }

    public String getPathWithName() throws Exception {
        if (this.path == null || this.path.length() == 0) {
            throw new Exception("path is null for Agent " + this.name);
        }
        return this.path + "\\" + this.name;
    }

    private String getPathForCompare() {
        if (this.path == null) {
            return "";
        }
        return this.path.toLowerCase();
    }

    public String toString() {
        return "ID: " + this.getId() + "; Name: " + this.getName() + "; Path: " + this.getPath();
    }

    public static void main(String[] stringArray) {
        AutoMateObject autoMateObject = new AutoMateObject("myID", "myName", "\\myPath\\has\\folders");
        System.out.println(autoMateObject.toString());
        System.out.println(autoMateObject.getJSONString());
    }

    static class AutoMateComparator
    implements Comparator<AutoMateObject> {
        private AutoMateSearchSelection searchSelection;

        public AutoMateComparator(AutoMateSearchSelection autoMateSearchSelection) {
            this.searchSelection = autoMateSearchSelection;
        }

        @Override
        public int compare(AutoMateObject autoMateObject, AutoMateObject autoMateObject2) {
            String string = null;
            String string2 = null;
            switch (this.searchSelection) {
                case BY_ID: {
                    string = autoMateObject.getId().toLowerCase();
                    string2 = autoMateObject2.getId().toLowerCase();
                    return AutoMateObject.compareStrings(string, string2);
                }
                case BY_NAME: {
                    string = autoMateObject.getName().toLowerCase();
                    string2 = autoMateObject2.getName().toLowerCase();
                    return AutoMateObject.compareStrings(string, string2);
                }
                case PATH_OR_ID: {
                    return AutoMateObject.compareByFolder(autoMateObject, autoMateObject2);
                }
            }
            throw new IllegalStateException("Undefined search selection: " + (Object)((Object)this.searchSelection));
        }
    }
}

