/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.util.LongConverter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class TimeHelper {
    private static final Logger logger = Logger.getLogger(TimeHelper.class);
    private static DateFormat df = DateFormat.getDateTimeInstance(3, 1);
    public static int END_OF_DAY_TIME = 2400;

    private TimeHelper() {
    }

    public static boolean isWithinRange(Calendar calendar, int n, int n2, int n3) {
        if (calendar == null) {
            logger.error((Object)"Actual time provided for time range test is null.");
            return false;
        }
        int n4 = calendar.get(11) * 10000000 + calendar.get(12) * 100000 + calendar.get(13) * 1000 + calendar.get(14);
        int n5 = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        return TimeHelper.isWithinRange_internal(n5, n4, n, n2, n3, calendar.getTimeZone());
    }

    public static boolean isWithinRange(Calendar calendar, long l, int n, int n2, int n3) {
        if (l == 0L) {
            return TimeHelper.isWithinRange(calendar, n, n2, n3);
        }
        long l2 = l % 10000L * 100000L;
        int n4 = LongConverter.intValue(l2);
        l2 = l / 10000L;
        int n5 = LongConverter.intValue(l2);
        return TimeHelper.isWithinRange_internal(n5, n4, n, n2, n3, calendar.getTimeZone());
    }

    private static boolean isWithinRange_internal(int n, int n2, int n3, int n4, int n5, TimeZone timeZone) {
        if (n3 > n) {
            return false;
        }
        int n6 = n4 * 100000;
        if (n3 == n && n6 > n2) {
            return false;
        }
        int n7 = n3;
        int n8 = n5 * 100000;
        if (n5 % 100 == 59) {
            n8 = (n5 + 1) * 100000;
        }
        if (n6 > n8) {
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.clear();
            calendar.set(n3 / 10000, n3 % 10000 / 100 - 1, n3 % 100, 0, 0, 0);
            calendar.add(5, 1);
            n7 = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        }
        if (n7 < n) {
            return false;
        }
        return n7 != n || n8 >= n2;
    }

    public static String formatDate(Date date) {
        return TimeHelper.formatDate(date, TimeZone.getDefault());
    }

    public static String formatDate(long l) {
        return TimeHelper.formatDate(l, TimeZone.getDefault());
    }

    public static String formatDate(Calendar calendar) {
        return TimeHelper.formatDate(calendar.getTime(), calendar.getTimeZone());
    }

    public static String formatDate(Calendar calendar, TimeZone timeZone) {
        return TimeHelper.formatDate(calendar.getTime(), timeZone);
    }

    public static String formatDate(long l, TimeZone timeZone) {
        if (l == 0L) {
            return "** Zero Time **";
        }
        return TimeHelper.formatDate(new Date(l), timeZone);
    }

    public static String formatDate(Date date, TimeZone timeZone) {
        df.setTimeZone(timeZone);
        return df.format(date);
    }
}

