/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.FiscalCalendar;
import com.helpsystems.enterprise.core.scheduler.FiscalYear;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.EnumSet;
import junit.framework.TestCase;

public class ReactivityDayOfPeriodTest
extends TestCase {
    private ReactivityDayOfPeriod obj;

    public ReactivityDayOfPeriodTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = new ReactivityDayOfPeriod();
    }

    public void testSetDayNumber() {
        this.obj.setDayNumber(1234);
        ReactivityDayOfPeriodTest.assertEquals((int)1234, (int)this.obj.getDayNumber());
    }

    public void testSetEndOption() {
        this.obj.setEndOption(WindowEndOption.CANCEL_JOB);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowEndOption.CANCEL_JOB, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.DO_NOTHING);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowEndOption.DO_NOTHING, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.FAIL_JOB);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowEndOption.FAIL_JOB, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.SUBMIT_JOB);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowEndOption.SUBMIT_JOB, (Object)this.obj.getEndOption());
    }

    public void testSetStartOption() {
        this.obj.setStartOption(WindowStartOption.DO_NOTHING);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowStartOption.DO_NOTHING, (Object)this.obj.getStartOption());
        this.obj.setStartOption(WindowStartOption.CHECK_PREREQS);
        ReactivityDayOfPeriodTest.assertEquals((Object)WindowStartOption.CHECK_PREREQS, (Object)this.obj.getStartOption());
    }

    public void testSetJobID() {
        this.obj.setJobID(1234567L);
        ReactivityDayOfPeriodTest.assertEquals((long)1234567L, (long)this.obj.getJobID());
    }

    public void testSetId() {
        this.obj.setId(7654321L);
        ReactivityDayOfPeriodTest.assertEquals((long)7654321L, (long)this.obj.getId());
    }

    public void testSetPeriodType() {
        this.obj.setPeriodType(CalendarObject.PeriodType.MONTH);
        ReactivityDayOfPeriodTest.assertEquals((Object)CalendarObject.PeriodType.MONTH, (Object)this.obj.getPeriodType());
        this.obj.setPeriodType(CalendarObject.PeriodType.QUARTER);
        ReactivityDayOfPeriodTest.assertEquals((Object)CalendarObject.PeriodType.QUARTER, (Object)this.obj.getPeriodType());
        this.obj.setPeriodType(CalendarObject.PeriodType.HALF_YEAR);
        ReactivityDayOfPeriodTest.assertEquals((Object)CalendarObject.PeriodType.HALF_YEAR, (Object)this.obj.getPeriodType());
        this.obj.setPeriodType(CalendarObject.PeriodType.YEAR);
        ReactivityDayOfPeriodTest.assertEquals((Object)CalendarObject.PeriodType.YEAR, (Object)this.obj.getPeriodType());
    }

    public void testIsTimeAcceptedWithNullCalendarObject() {
        Calendar calendar = null;
        CalendarObject calendarObject = null;
        ScheduleJobProxy scheduleJobProxy = null;
        ReactivityDayOfPeriodTest.assertTrue((boolean)this.obj.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAcceptedWithDayNumberZero() {
        long l = 123456L;
        long l2 = 5678L;
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestCalObject(l2);
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        this.obj.setDayNumber(0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)this.obj.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted() {
        long l = 123456L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(54321L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(18);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(100);
        reactivityDayOfPeriod.setEndTime(2300);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(98765L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(-14);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(100);
        reactivityDayOfPeriod2.setEndTime(2300);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestCalObject(l2);
        this.updateCalendar(calendar, 2010, 4, 18, 1, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 18, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 18, 22, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 18, 23, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 18, 0, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 18, 23, 0, 0, 1);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 17, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 19, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted_FiscalCalendar() {
        long l = 123456L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(54321L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(18);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(100);
        reactivityDayOfPeriod.setEndTime(2300);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(98765L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(-14);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(100);
        reactivityDayOfPeriod2.setEndTime(2300);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestFiscalCalendar(l2);
        this.updateCalendar(calendar, 2010, 7, 2, 1, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 2, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 2, 22, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 2, 23, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 2, 0, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 2, 23, 0, 0, 1);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 1, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 3, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted_month_end_midnight_rollover() {
        long l = 12345L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(2L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(31);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(1300);
        reactivityDayOfPeriod.setEndTime(1200);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(3L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(-1);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(1300);
        reactivityDayOfPeriod2.setEndTime(1200);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestCalObject(l2);
        this.updateCalendar(calendar, 2010, 4, 31, 13, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 31, 23, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 1, 0, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 1, 11, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 1, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 31, 12, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 1, 12, 0, 0, 1);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 30, 22, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 2, 2, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted_month_end_midnight_rollover_fiscal_calendar() {
        long l = 12345L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(2L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(29);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(1300);
        reactivityDayOfPeriod.setEndTime(1200);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(3L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(-3);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(1300);
        reactivityDayOfPeriod2.setEndTime(1200);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestFiscalCalendar(l2);
        this.updateCalendar(calendar, 2010, 7, 13, 13, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 13, 23, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 14, 0, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 14, 11, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 14, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 13, 12, 59, 59, 999);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 14, 12, 0, 0, 1);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 12, 22, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 15, 2, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted_last_day_of_period() {
        long l = 12345L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(4L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(30);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(0);
        reactivityDayOfPeriod.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(5L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(31);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(0);
        reactivityDayOfPeriod2.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod3 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod3.setId(6L);
        reactivityDayOfPeriod3.setJobID(l);
        reactivityDayOfPeriod3.setDayNumber(-1);
        reactivityDayOfPeriod3.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod3.setStartTime(0);
        reactivityDayOfPeriod3.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod4 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod4.setId(7L);
        reactivityDayOfPeriod4.setJobID(l);
        reactivityDayOfPeriod4.setDayNumber(-1);
        reactivityDayOfPeriod4.setPeriodType(CalendarObject.PeriodType.QUARTER);
        reactivityDayOfPeriod4.setStartTime(0);
        reactivityDayOfPeriod4.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod5 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod5.setId(8L);
        reactivityDayOfPeriod5.setJobID(l);
        reactivityDayOfPeriod5.setDayNumber(-1);
        reactivityDayOfPeriod5.setPeriodType(CalendarObject.PeriodType.HALF_YEAR);
        reactivityDayOfPeriod5.setStartTime(0);
        reactivityDayOfPeriod5.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod6 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod6.setId(9L);
        reactivityDayOfPeriod6.setJobID(l);
        reactivityDayOfPeriod6.setDayNumber(-1);
        reactivityDayOfPeriod6.setPeriodType(CalendarObject.PeriodType.YEAR);
        reactivityDayOfPeriod6.setStartTime(0);
        reactivityDayOfPeriod6.setEndTime(2400);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestCalObject(l2);
        this.updateCalendar(calendar, 2010, 4, 30, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 4, 31, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 5, 30, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 11, 31, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    public void testIsTimeAccepted_last_day_of_period_Fiscal_calendar() {
        long l = 12345L;
        long l2 = 5678L;
        ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
        scheduleJobProxy.setSkybotJobNumber(l);
        scheduleJobProxy.setName("JOBPROXY");
        scheduleJobProxy.setDescription("Sample Proxy Job");
        scheduleJobProxy.setCalendarID(l2);
        scheduleJobProxy.setDayType(CalendarObject.DayType.ALL_DAYS);
        ReactivityDayOfPeriod reactivityDayOfPeriod = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod.setId(4L);
        reactivityDayOfPeriod.setJobID(l);
        reactivityDayOfPeriod.setDayNumber(30);
        reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod.setStartTime(0);
        reactivityDayOfPeriod.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod2 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod2.setId(5L);
        reactivityDayOfPeriod2.setJobID(l);
        reactivityDayOfPeriod2.setDayNumber(31);
        reactivityDayOfPeriod2.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod2.setStartTime(0);
        reactivityDayOfPeriod2.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod3 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod3.setId(6L);
        reactivityDayOfPeriod3.setJobID(l);
        reactivityDayOfPeriod3.setDayNumber(-1);
        reactivityDayOfPeriod3.setPeriodType(CalendarObject.PeriodType.MONTH);
        reactivityDayOfPeriod3.setStartTime(0);
        reactivityDayOfPeriod3.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod4 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod4.setId(7L);
        reactivityDayOfPeriod4.setJobID(l);
        reactivityDayOfPeriod4.setDayNumber(-1);
        reactivityDayOfPeriod4.setPeriodType(CalendarObject.PeriodType.QUARTER);
        reactivityDayOfPeriod4.setStartTime(0);
        reactivityDayOfPeriod4.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod5 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod5.setId(8L);
        reactivityDayOfPeriod5.setJobID(l);
        reactivityDayOfPeriod5.setDayNumber(-1);
        reactivityDayOfPeriod5.setPeriodType(CalendarObject.PeriodType.HALF_YEAR);
        reactivityDayOfPeriod5.setStartTime(0);
        reactivityDayOfPeriod5.setEndTime(2400);
        ReactivityDayOfPeriod reactivityDayOfPeriod6 = new ReactivityDayOfPeriod();
        reactivityDayOfPeriod6.setId(9L);
        reactivityDayOfPeriod6.setJobID(l);
        reactivityDayOfPeriod6.setDayNumber(-1);
        reactivityDayOfPeriod6.setPeriodType(CalendarObject.PeriodType.YEAR);
        reactivityDayOfPeriod6.setStartTime(0);
        reactivityDayOfPeriod6.setEndTime(2400);
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = this.buildTestFiscalCalendar(l2);
        this.updateCalendar(calendar, 2010, 7, 14, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 7, 15, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2010, 9, 15, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2011, 0, 15, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        this.updateCalendar(calendar, 2011, 6, 15, 12, 0, 0, 0);
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertFalse((boolean)reactivityDayOfPeriod2.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod3.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod4.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod5.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
        ReactivityDayOfPeriodTest.assertTrue((boolean)reactivityDayOfPeriod6.isTimeAccepted(calendar, calendarObject, scheduleJobProxy));
    }

    private void updateCalendar(Calendar calendar, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        calendar.clear();
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.set(14, n7);
    }

    private CalendarObject buildTestFiscalCalendar(long l) {
        FiscalCalendar fiscalCalendar = new FiscalCalendar();
        fiscalCalendar.setID(l);
        fiscalCalendar.setName("TEST_CAL");
        fiscalCalendar.setDescription("This is a test calendar");
        FiscalYear fiscalYear = new FiscalYear(20100716, 20110715);
        DateRange[] dateRangeArray = new DateRange[]{new DateRange(20100716, 20100815), new DateRange(20100816, 20100915), new DateRange(20100916, 20101015), new DateRange(20101016, 20101115), new DateRange(20101116, 20101215), new DateRange(20101216, 20110115), new DateRange(20110116, 20110215), new DateRange(20110216, 20110315), new DateRange(20110316, 20110415), new DateRange(20110416, 20110515), new DateRange(20110516, 20110615), new DateRange(20110616, 20110715)};
        fiscalYear.setMonths(dateRangeArray);
        fiscalYear.setYear(2011);
        fiscalCalendar.setYears(new FiscalYear[]{fiscalYear});
        int n = 20100704;
        int n2 = 20101225;
        int[] nArray = new int[]{n, n2};
        fiscalCalendar.setHolidays(nArray);
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.of(CalendarObject.DayOfWeek.SUN);
        fiscalCalendar.setNonWorkdayByDOW(enumSet);
        return fiscalCalendar;
    }

    private CalendarObject buildTestCalObject(long l) {
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setID(l);
        calendarObject.setName("TEST_CAL");
        calendarObject.setDescription("This is a test calendar");
        int n = 20100704;
        int n2 = 20101225;
        int[] nArray = new int[]{n, n2};
        calendarObject.setHolidays(nArray);
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.of(CalendarObject.DayOfWeek.SUN);
        calendarObject.setNonWorkdayByDOW(enumSet);
        return calendarObject;
    }
}

