/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.ReactivityDateObject;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class ReactivityDateObjectTest
extends TestCase {
    private ReactivityDateObject obj;

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = new ReactivityDateObject();
    }

    protected void tearDown() throws Exception {
        this.obj = null;
        super.tearDown();
    }

    public void testSetId() {
        this.obj.setId(1234567L);
        ReactivityDateObjectTest.assertEquals((long)1234567L, (long)this.obj.getId());
    }

    public void testSetJobID() {
        this.obj.setJobID(7654321L);
        ReactivityDateObjectTest.assertEquals((long)7654321L, (long)this.obj.getJobID());
    }

    public void testSetDateObjectID() {
        DateObject dateObject = new DateObject();
        this.obj.setDateObject(dateObject);
        ReactivityDateObjectTest.assertEquals((Object)dateObject, (Object)this.obj.getDateObject());
    }

    public void testSetEndTime() {
        this.obj.setEndTime(1234);
        ReactivityDateObjectTest.assertEquals((int)1234, (int)this.obj.getEndTime());
    }

    public void testSetStartTime() {
        this.obj.setStartTime(4321);
        ReactivityDateObjectTest.assertEquals((int)4321, (int)this.obj.getStartTime());
    }

    public void testNotAcceptedIfNoDateObject() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 5);
        gregorianCalendar.set(5, 23);
        gregorianCalendar.set(11, 12);
        CalendarObject calendarObject = new CalendarObject();
        ReactivityDateObjectTest.assertTrue((boolean)calendarObject.isWorkday(gregorianCalendar));
        this.obj.setStartTime(900);
        this.obj.setEndTime(1800);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
    }

    public void testTimeRangeSpansMidnight() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 5);
        gregorianCalendar.set(5, 23);
        gregorianCalendar.set(11, 12);
        CalendarObject calendarObject = new CalendarObject();
        ReactivityDateObjectTest.assertTrue((boolean)calendarObject.isWorkday(gregorianCalendar));
        DateObject dateObject = new DateObject();
        dateObject.addDates(new int[]{20100623, 20100624});
        this.obj.setDateObject(dateObject);
        this.obj.setStartTime(900);
        this.obj.setEndTime(1800);
        gregorianCalendar.set(11, 3);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 12);
        ReactivityDateObjectTest.assertTrue((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 21);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        this.obj.setStartTime(1800);
        this.obj.setEndTime(900);
        gregorianCalendar.set(11, 3);
        ReactivityDateObjectTest.assertTrue((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 12);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 21);
        ReactivityDateObjectTest.assertTrue((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(5, 26);
        this.obj.setStartTime(900);
        this.obj.setEndTime(1800);
        gregorianCalendar.set(11, 3);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 12);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
        gregorianCalendar.set(11, 21);
        ReactivityDateObjectTest.assertFalse((boolean)this.obj.isTimeAccepted(gregorianCalendar, calendarObject));
    }

    public void testSetStartOption() {
        this.obj.setStartOption(WindowStartOption.CHECK_PREREQS);
        ReactivityDateObjectTest.assertEquals((Object)WindowStartOption.CHECK_PREREQS, (Object)this.obj.getStartOption());
        this.obj.setStartOption(WindowStartOption.DO_NOTHING);
        ReactivityDateObjectTest.assertEquals((Object)WindowStartOption.DO_NOTHING, (Object)this.obj.getStartOption());
    }

    public void testSetEndOption() {
        this.obj.setEndOption(WindowEndOption.CANCEL_JOB);
        ReactivityDateObjectTest.assertEquals((Object)WindowEndOption.CANCEL_JOB, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.DO_NOTHING);
        ReactivityDateObjectTest.assertEquals((Object)WindowEndOption.DO_NOTHING, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.FAIL_JOB);
        ReactivityDateObjectTest.assertEquals((Object)WindowEndOption.FAIL_JOB, (Object)this.obj.getEndOption());
        this.obj.setEndOption(WindowEndOption.SUBMIT_JOB);
        ReactivityDateObjectTest.assertEquals((Object)WindowEndOption.SUBMIT_JOB, (Object)this.obj.getEndOption());
    }
}

