/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public enum PrereqObjectType implements PersistableEnum<String>
{
    JOB("Job"),
    JOB_SUITE("JobSuite"),
    JOB_SUITE_MEMBER_JOB("JobSuiteMemberJob"),
    MEMBER_JOB("MemberJob"),
    AGENT_EVENT_MONITOR("AgentEventMonitor"),
    SNMP_TRAP_EVENT("SnmpTrapEvent"),
    SAP_EVENT_MONITOR("SapEventMonitor");

    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, PrereqObjectType> map;

    private PrereqObjectType(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static PrereqObjectType persistanceCodeToEnum(String string) {
        PrereqObjectType prereqObjectType = map.get(string);
        if (prereqObjectType == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return prereqObjectType;
    }

    public static PrereqObjectType convert(RemoteEventType remoteEventType) {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: 
            case JOB_MONITOR_EVENT: {
                return JOB;
            }
            case JOB_SUITE_STATUS_CHANGE: 
            case JOB_SUITE_MONITOR_EVENT: {
                return JOB_SUITE;
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return JOB_SUITE_MEMBER_JOB;
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return MEMBER_JOB;
            }
            case AGENT_EVENT: {
                return AGENT_EVENT_MONITOR;
            }
            case SNMP_TRAP_EVENT: {
                return SNMP_TRAP_EVENT;
            }
            case SAP_MONITOR_EVENT: {
                return SAP_EVENT_MONITOR;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])PrereqObjectType.values());
    }
}

