/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.PersistedJobQueueEntry;
import java.sql.Timestamp;
import junit.framework.TestCase;

public class PersistedJobQueueEntryTest
extends TestCase {
    private PersistedJobQueueEntry entry;

    protected void setUp() throws Exception {
        super.setUp();
        this.entry = new PersistedJobQueueEntry();
    }

    protected void tearDown() throws Exception {
        this.entry = null;
        super.tearDown();
    }

    public void testHashCode() {
        PersistedJobQueueEntry persistedJobQueueEntry = new PersistedJobQueueEntry(123L, PersistedJobQueueEntry.Action.MOVED_TO_TOP_OF_QUEUE, 789);
        int n = persistedJobQueueEntry.hashCode();
        for (int i = 0; i < 20; ++i) {
            PersistedJobQueueEntryTest.assertEquals((int)n, (int)persistedJobQueueEntry.hashCode());
        }
    }

    public void testEqualsObject() {
        PersistedJobQueueEntry persistedJobQueueEntry = new PersistedJobQueueEntry(123L, PersistedJobQueueEntry.Action.MOVED_TO_TOP_OF_QUEUE, 789);
        PersistedJobQueueEntry persistedJobQueueEntry2 = new PersistedJobQueueEntry(123L, PersistedJobQueueEntry.Action.MOVED_TO_TOP_OF_QUEUE, 789);
        PersistedJobQueueEntryTest.assertFalse((boolean)persistedJobQueueEntry.equals(null));
        PersistedJobQueueEntryTest.assertFalse((boolean)persistedJobQueueEntry.equals(new Object()));
        PersistedJobQueueEntryTest.assertTrue((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry));
        PersistedJobQueueEntryTest.assertTrue((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry2));
        PersistedJobQueueEntryTest.assertTrue((boolean)persistedJobQueueEntry2.equals((Object)persistedJobQueueEntry));
        persistedJobQueueEntry2.setJobHistoryOID(321L);
        PersistedJobQueueEntryTest.assertFalse((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry2));
        persistedJobQueueEntry2.setJobHistoryOID(123L);
        persistedJobQueueEntry2.setAction(PersistedJobQueueEntry.Action.REMOVED_FROM_QUEUE);
        PersistedJobQueueEntryTest.assertFalse((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry2));
        persistedJobQueueEntry2.setAction(PersistedJobQueueEntry.Action.MOVED_TO_TOP_OF_QUEUE);
        persistedJobQueueEntry2.setGroupID(987);
        PersistedJobQueueEntryTest.assertFalse((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry2));
        persistedJobQueueEntry2.setGroupID(789);
        PersistedJobQueueEntryTest.assertTrue((boolean)persistedJobQueueEntry.equals((Object)persistedJobQueueEntry2));
    }

    public void testToString() {
        long l = 1234567L;
        PersistedJobQueueEntry.Action action = PersistedJobQueueEntry.Action.MOVED_TO_TOP_OF_QUEUE;
        int n = 3456789;
        this.entry = new PersistedJobQueueEntry(l, action, n);
        String string = this.entry.toString();
        PersistedJobQueueEntryTest.assertTrue((boolean)string.contains("jobHistoryOID: 1234567"));
        PersistedJobQueueEntryTest.assertTrue((boolean)string.contains("action: MOVED_TO_TOP_OF_QUEUE"));
        PersistedJobQueueEntryTest.assertTrue((boolean)string.contains("groupID: 3456789"));
    }

    public void testSetJobHistoryOID() {
        this.entry.setJobHistoryOID(1234567L);
        PersistedJobQueueEntryTest.assertEquals((long)1234567L, (long)this.entry.getJobHistoryOID());
    }

    public void testSetCreatedAt() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.entry.setCreatedAt(timestamp);
        PersistedJobQueueEntryTest.assertEquals((Object)timestamp, (Object)this.entry.getCreatedAt());
    }

    public void testSetAction() {
        PersistedJobQueueEntry.Action[] actionArray;
        for (PersistedJobQueueEntry.Action action : actionArray = PersistedJobQueueEntry.Action.values()) {
            this.entry.setAction(action);
            PersistedJobQueueEntryTest.assertEquals((Object)action, (Object)this.entry.getAction());
        }
    }

    public void testSetAction_asInt() {
        PersistedJobQueueEntry.Action[] actionArray;
        for (PersistedJobQueueEntry.Action action : actionArray = PersistedJobQueueEntry.Action.values()) {
            this.entry.setAction_asInt(action.persistanceCode());
            PersistedJobQueueEntryTest.assertEquals((Object)action, (Object)this.entry.getAction());
            PersistedJobQueueEntryTest.assertEquals((int)action.persistanceCode(), (int)this.entry.getAction_asInt());
        }
    }

    public void testSetGroupID() {
        this.entry.setGroupID(47474747);
        PersistedJobQueueEntryTest.assertEquals((int)47474747, (int)this.entry.getGroupID());
    }

    public void testSetOID() {
        this.entry.setOID(345789L);
        PersistedJobQueueEntryTest.assertEquals((long)345789L, (long)this.entry.getOID());
    }

    public void testPersistanceCodeToEnumUnknownValue() {
        try {
            PersistedJobQueueEntry.Action.persistanceCodeToEnum(1234);
            PersistedJobQueueEntryTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

