/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NotificationList
extends Proxy
implements BasicIdentifier {
    private static final long serialVersionUID = 204405306359326378L;
    private static Logger logger = Logger.getLogger(NotificationList.class);
    private ArrayList<User> userList = new ArrayList();
    private ArrayList<String> emailContacts = new ArrayList();
    private long oid;
    private boolean publicList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(User user) {
        ArrayList<User> arrayList = this.userList;
        synchronized (arrayList) {
            this.userList.add(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmailContact(String string) {
        ValidationHelper.checkForNull((String)"Email Contact", (Object)string);
        ArrayList<String> arrayList = this.emailContacts;
        synchronized (arrayList) {
            this.emailContacts.add(string);
        }
    }

    public void addUser(User user, int n) {
        ValidationHelper.checkForNull((String)"User", (Object)((Object)user));
        this.userList.add(n + 1, user);
    }

    public void setOid(long l) {
        if (this.oid > 0L) {
            throw new IllegalStateException("Changes to the oid are not allowed.");
        }
        this.oid = l;
    }

    public long getOid() {
        return this.oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] getUsers() {
        User[] userArray = null;
        ArrayList<User> arrayList = this.userList;
        synchronized (arrayList) {
            userArray = new User[this.userList.size()];
            userArray = this.userList.toArray(userArray);
        }
        if (userArray == null) {
            userArray = new User[]{};
        }
        return userArray;
    }

    public void sortUserListByName() {
        Collections.sort(this.userList, new Comparator<User>(){

            @Override
            public int compare(User user, User user2) {
                String string = user.getName();
                String string2 = user2.getName();
                return string.compareToIgnoreCase(string2);
            }
        });
    }

    public String[] getListOfUniqueEmails() {
        String string;
        int n;
        Vector<String> vector = new Vector<String>();
        User[] userArray = this.getUsers();
        if (userArray != null && userArray.length > 0) {
            for (n = 0; n < userArray.length; ++n) {
                if (userArray[n] == null) continue;
                string = userArray[n].getEmailAddress();
                if (string != null && string.trim().length() > 0) {
                    if (vector.contains(string.trim())) continue;
                    vector.addElement(string.trim());
                    continue;
                }
                logger.info((Object)("Email address is not specified for user: " + userArray[n].getUsername()));
            }
        }
        if (this.emailContacts != null && this.emailContacts.size() > 0) {
            for (n = 0; n < this.emailContacts.size(); ++n) {
                string = this.emailContacts.get(n);
                if (vector.contains(string.trim())) continue;
                vector.addElement(string.trim());
            }
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            try {
                Arrays.sort(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return objectArray;
        }
        return new String[0];
    }

    public boolean hasUsers() {
        return !this.userList.isEmpty();
    }

    public void setPubliList(boolean bl) {
        this.publicList = bl;
    }

    public boolean isPublicList() {
        return this.publicList;
    }
}

