/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.util.Arrays;
import java.util.List;

public enum JobStatusCode implements PersistableEnum<String>
{
    INITIATED("N", false),
    SUBMITTED("S", true),
    ERROR("E", false),
    RUNNING("R", true),
    COMPLETED("C", true),
    FAILED("F", true),
    MANAGED("M", false),
    CANCELED("A", true),
    CONDITION_CHECK("H", false),
    CONDITION_RETRY_WAIT("W", true),
    SKIPPED("K", true),
    MEMBER_FAILED("V", false),
    MEMBER_CANCELED("X", false);

    private String persistanceCode;
    private boolean isReactable;
    private static PersistanceCodeToEnumMap<String, JobStatusCode> map;
    public static final List<JobStatusCode> DEQUEUEABLE_STATES;
    public static final List<JobStatusCode> ENDABLE_JOB_STATES;
    public static final List<JobStatusCode> RUNNING_STATES;
    public static final List<JobStatusCode> PRE_RUNNING_STATES;
    public static final List<JobStatusCode> TERMINATABLE_STATES;
    public static final List<JobStatusCode> MEMBER_TERMINATABLE_STATES;
    public static final List<JobStatusCode> TERMINAL_STATES;
    public static final List<JobStatusCode> MANUAL_PURGE_TERMINAL_STATES;

    private JobStatusCode(String string2, boolean bl) {
        this.persistanceCode = string2;
        this.isReactable = bl;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public boolean isReactable() {
        return this.isReactable;
    }

    public boolean isTerminalState() {
        return TERMINAL_STATES.contains(this);
    }

    public static JobStatusCode persistanceCodeToEnum(String string) {
        JobStatusCode jobStatusCode = map.get(string);
        if (jobStatusCode == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return jobStatusCode;
    }

    public static String getJobStatusCodeDesc(JobStatusCode jobStatusCode) {
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
        switch (jobStatusCode) {
            case COMPLETED: {
                return translationDM.getTranslation("job_history.job_status.completed");
            }
            case SUBMITTED: {
                return translationDM.getTranslation("job_history.job_status.submitted");
            }
            case CANCELED: {
                return translationDM.getTranslation("job_history.job_status.canceled");
            }
            case CONDITION_RETRY_WAIT: {
                return translationDM.getTranslation("job_history.job_status.retry_wait");
            }
            case MANAGED: {
                return translationDM.getTranslation("job_history.job_status.managed");
            }
            case CONDITION_CHECK: {
                return translationDM.getTranslation("job_history.job_status.condition_check");
            }
            case ERROR: {
                return translationDM.getTranslation("job_history.job_status.error");
            }
            case FAILED: {
                return translationDM.getTranslation("job_history.job_status.failed");
            }
            case INITIATED: {
                return translationDM.getTranslation("job_history.job_status.initiated");
            }
            case RUNNING: {
                return translationDM.getTranslation("job_history.job_status.running");
            }
            case SKIPPED: {
                return translationDM.getTranslation("job_history.job_status.skipped");
            }
            case MEMBER_FAILED: {
                return translationDM.getTranslation("job_history.job_status.member_failed");
            }
            case MEMBER_CANCELED: {
                return translationDM.getTranslation("job_history.job_status.member_canceled");
            }
        }
        return "Unknown Job Status Code: " + jobStatusCode.name();
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])JobStatusCode.values());
        DEQUEUEABLE_STATES = Arrays.asList(INITIATED, SUBMITTED, CONDITION_RETRY_WAIT);
        ENDABLE_JOB_STATES = Arrays.asList(CANCELED, COMPLETED, FAILED);
        RUNNING_STATES = Arrays.asList(RUNNING, CONDITION_CHECK, CONDITION_RETRY_WAIT);
        PRE_RUNNING_STATES = Arrays.asList(SUBMITTED, CONDITION_CHECK, CONDITION_RETRY_WAIT);
        TERMINATABLE_STATES = Arrays.asList(INITIATED, SUBMITTED, RUNNING, CONDITION_CHECK, CONDITION_RETRY_WAIT);
        MEMBER_TERMINATABLE_STATES = Arrays.asList(INITIATED, SUBMITTED, RUNNING, CONDITION_CHECK, CONDITION_RETRY_WAIT, FAILED);
        TERMINAL_STATES = Arrays.asList(CANCELED, COMPLETED, ERROR, FAILED);
        MANUAL_PURGE_TERMINAL_STATES = Arrays.asList(CANCELED, COMPLETED, ERROR, FAILED, MANAGED, SKIPPED);
    }
}

