/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.util.Calendar;

public class JobMonitor
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = -558988551105679634L;
    private long OID;
    private long jobHistoryID;
    private long jobSuiteHistoryID;
    private long jobID;
    private long agentID;
    private MonitorType monitorType;
    private MonitorOption monitorOption;
    private long scheduledTime;
    private long monitorTime;
    private boolean jobStarted;
    private boolean jobCompleted;
    private long jobStartTime;
    private long jobEndTime;

    public JobMonitor() {
    }

    public JobMonitor(long l, long l2, long l3, long l4, MonitorType monitorType, long l5) {
        this.jobHistoryID = l;
        this.jobSuiteHistoryID = l2;
        this.jobID = l3;
        this.agentID = l4;
        this.monitorType = monitorType;
        this.scheduledTime = l5;
    }

    public JobMonitor(JobHistory jobHistory, MonitorType monitorType, MonitorOption monitorOption, long l) {
        this(jobHistory.getId(), jobHistory.getJobSuiteHistoryID(), jobHistory.getJobID(), jobHistory.getAgentID(), monitorType, monitorOption, jobHistory.getScheduledTime(), l);
    }

    public JobMonitor(long l, long l2, long l3, long l4, MonitorType monitorType, MonitorOption monitorOption, long l5, long l6) {
        this.jobHistoryID = l;
        this.jobSuiteHistoryID = l2;
        this.jobID = l3;
        this.agentID = l4;
        this.monitorType = monitorType;
        this.monitorOption = monitorOption;
        this.scheduledTime = l5;
        this.monitorTime = l6;
    }

    public long getJobHistoryID() {
        return this.jobHistoryID;
    }

    public long getJobSuiteHistoryID() {
        return this.jobSuiteHistoryID;
    }

    public long getJobID() {
        return this.jobID;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public int getMonitorTypeAsInt() {
        return this.monitorType.persistanceCode();
    }

    public MonitorOption getMonitorOption() {
        return this.monitorOption;
    }

    public int getMonitorOptionAsInt() {
        return this.monitorOption.persistanceCode();
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getMonitorTime() {
        return this.monitorTime;
    }

    public boolean isJobStarted() {
        return this.jobStarted;
    }

    public boolean isJobCompleted() {
        return this.jobCompleted;
    }

    public long getJobStartTime() {
        return this.jobStartTime;
    }

    public long getJobEndTime() {
        return this.jobEndTime;
    }

    public void setJobHistoryID(long l) {
        this.jobHistoryID = l;
    }

    public void setJobSuiteHistoryID(long l) {
        this.jobSuiteHistoryID = l;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public void setAgentID(long l) {
        this.agentID = l;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
    }

    public void setMonitorTypeAsInt(int n) {
        this.setMonitorType(MonitorType.persistanceCodeToEnum(n));
    }

    public void setMonitorOption(MonitorOption monitorOption) {
        this.monitorOption = monitorOption;
    }

    public void setMonitorOptionAsInt(int n) {
        this.setMonitorOption(MonitorOption.persistanceCodeToEnum(n));
    }

    public void setScheduledTime(long l) {
        this.scheduledTime = l;
    }

    public void setMonitorTime(long l) {
        this.monitorTime = l;
    }

    public void setJobStarted(boolean bl) {
        this.jobStarted = bl;
        this.setJobStartTime(Calendar.getInstance().getTimeInMillis());
    }

    public void setJobStartTime(long l) {
        this.jobStartTime = l;
    }

    public void setJobEndTime(long l) {
        this.jobEndTime = l;
    }

    public void setJobCompleted(boolean bl) {
        this.jobCompleted = bl;
        long l = Calendar.getInstance().getTimeInMillis();
        this.setJobEndTime(l);
        if (!this.isJobStarted()) {
            this.setJobStarted(true);
            this.setJobStartTime(l);
        }
    }

    public long getJobRunDuration() {
        return this.jobEndTime - this.jobStartTime;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public long getOID() {
        return this.OID;
    }

    public String toString() {
        return "jobHistoryOID:" + this.jobHistoryID + " jobSuiteHistoryID:" + this.jobSuiteHistoryID + " monitorType:" + this.monitorType + " monitorOption:" + this.monitorOption;
    }

    public static enum MonitorOption implements PersistableEnum<Integer>
    {
        NONE(0),
        RUN_DURATION(1),
        TARGET_TIME(2);

        private int monitorOption;
        private static PersistanceCodeToEnumMap<Integer, MonitorOption> map;

        private MonitorOption(int n2) {
            this.monitorOption = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.monitorOption;
        }

        public static MonitorOption persistanceCodeToEnum(int n) {
            MonitorOption monitorOption = map.get(n);
            if (monitorOption == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return monitorOption;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])MonitorOption.values());
        }
    }

    public static enum MonitorType implements PersistableEnum<Integer>
    {
        NONE(0),
        UNDERRUN(1),
        OVERRUN(2),
        LATESTART(3);

        private int monitorType;
        private static PersistanceCodeToEnumMap<Integer, MonitorType> map;

        private MonitorType(int n2) {
            this.monitorType = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.monitorType;
        }

        public static MonitorType persistanceCodeToEnum(int n) {
            MonitorType monitorType = map.get(n);
            if (monitorType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return monitorType;
        }

        public static String getJobMonitorTypeDesc(MonitorType monitorType) {
            TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
            switch (monitorType) {
                case LATESTART: {
                    return translationDM.getTranslation("job_monitor_events.index.late_start");
                }
                case UNDERRUN: {
                    return translationDM.getTranslation("job_monitor_events.index.under_run");
                }
                case OVERRUN: {
                    return translationDM.getTranslation("job_monitor_events.index.over_run");
                }
            }
            return "Unknown Job Monitor Type: " + monitorType.name();
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])MonitorType.values());
        }
    }
}

