/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CancelableCommand;
import com.helpsystems.enterprise.core.busobj.FileTransfer;
import com.helpsystems.enterprise.core.busobj.SqlServerJob;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPARequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskRequestComposite;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudCommand;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.oracle.OracleExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutable;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommand;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;

public class CommandSetCommand
extends AbstractBusinessObject
implements BasicIdentifier {
    public static final int COMMAND_TYPE_REGULAR = 0;
    public static final int COMMAND_TYPE_TRANSFER = 1;
    public static final int COMMAND_TYPE_SQL_JOB = 2;
    public static final int COMMAND_TYPE_WINDOWS_TRANSPONDER = 3;
    public static final int COMMAND_TYPE_SAP_JOB = 4;
    public static final int COMMAND_TYPE_SAP_EVENT = 5;
    public static final int COMMAND_TYPE_SAP_RUN_INTERCEPT = 6;
    public static final int COMMAND_TYPE_SAP_VARIANT_ACTION = 7;
    public static final int COMMAND_TYPE_INFORMATICA = 8;
    public static final int COMMAND_TYPE_ORACLE_CONCURRENT_REQUEST = 9;
    public static final int COMMAND_TYPE_WEB_SERVICE = 10;
    public static final int COMMAND_TYPE_SAP_PROCESS_CHAIN = 11;
    public static final int COMMAND_TYPE_INFORMATICA_CLOUD = 12;
    public static final int COMMAND_TYPE_AUTOMATE_TASK = 13;
    public static final int COMMAND_TYPE_AUTOMATE_BPA = 14;
    public static final int COMMAND_TYPE_UNIVERSAL_CONNECTOR = 15;
    public static final int ERROR_HANDLING_FAIL_JOB = 1;
    public static final int ERROR_HANDLING_IGNORE_JOB = 2;
    public static final int ERROR_HANDLING_RETRY_FAIL_JOB = 3;
    public static final int ERROR_HANDLING_RETRY_IGNORE_JOB = 4;
    public static final String CLEAR_AGT_ENV_SALT = "SET AGT_ENV_SALT=";
    public static final String CLEAR_AGT_ENV_PWD = "SET AGT_ENV_PWD=";
    public static final String RESET_ERROR_CODE = "ver > nul";
    private static final long serialVersionUID = 1325897931345052288L;
    public static final char PROTECTED_CHARACTER = '\u0000';
    private String commandString;
    private long oid;
    private int lineNumber;
    private byte[] rawBytes;
    private boolean cancelOnError;
    private boolean errorHandlingRetry;
    private int retriesCount;
    private int waitCount;
    private AgentReturnCode returnCode = null;
    private int commandType;
    private boolean waitOnGui = true;
    private FileTransfer fileTransfer = null;
    private SqlServerJob _sqlServerJob = null;
    private SAPExecutable theSAPExecutable;
    private CancelableCommand _cancelableCommand = null;
    private InformaticaWorkflowCommand infaWorkflowCmd = null;
    private OracleExecutable oracleExecutable;
    private WebServiceRequestComposite webServiceReq = null;
    private InformaticaCloudCommand infaCloudCommand = null;
    private AutoMateTaskRequestComposite autoMateTaskRequest = null;
    private AutoMateBPARequestComposite autoMateBPARequest = null;
    private UniversalConnectorCommand UniversalConnectorCommand;

    public CommandSetCommand() {
        this.addDoNotInvoke("getBytes");
        this.addDoNotInvoke("getReturnCodeOid");
        this.addDoNotInvoke("getCommandTypeString");
        this.addDoNotInvoke("getCommandAction");
    }

    public CommandSetCommand(String string) {
        this.setCommandString(string);
    }

    public FileTransfer getFileTransfer() {
        return this.fileTransfer;
    }

    public CancelableCommand getCancelableCommand() {
        return this._cancelableCommand;
    }

    public void setFileTransfer(FileTransfer fileTransfer) {
        this.fileTransfer = fileTransfer;
    }

    public int getCommandType() {
        return this.commandType;
    }

    public void setCommandType(int n) {
        this.commandType = n;
    }

    public boolean isWaitOnGui() {
        return this.waitOnGui;
    }

    public void setWaitOnGui(boolean bl) {
        this.waitOnGui = bl;
    }

    public boolean isCancelOnError() {
        return this.cancelOnError;
    }

    public boolean getCancelOnError() {
        return this.isCancelOnError();
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public boolean isErrorHandlingRetry() {
        return this.errorHandlingRetry;
    }

    public void setErrorHandlingRetry(boolean bl) {
        this.errorHandlingRetry = bl;
    }

    public void setRetriesCount(int n) {
        this.retriesCount = n;
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public void setWaitCount(int n) {
        this.waitCount = n;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void setCancelOnError(boolean bl) {
        if (bl != this.cancelOnError) {
            this.cancelOnError = bl;
        }
    }

    public void setCommandString(String string) {
        ValidationHelper.checkForNull((String)"Command", (Object)string);
        this.commandString = string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        if (this.oid > 0L) {
            throw new IllegalStateException("Changes to the oid are not allowed.");
        }
        this.oid = l;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public byte[] getBytes() {
        return this.rawBytes;
    }

    public void setBytes(byte[] byArray) {
        ValidationHelper.checkForNull((String)"Bytes", (Object)byArray);
        this.rawBytes = byArray;
    }

    public boolean containsProtectedCharacters() {
        return this.commandString.indexOf(0) != -1;
    }

    public AgentReturnCode getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(AgentReturnCode agentReturnCode) {
        if (agentReturnCode == null && this.returnCode == null) {
            return;
        }
        if (agentReturnCode == null || this.returnCode == null) {
            this.returnCode = agentReturnCode;
            return;
        }
        if (agentReturnCode.isPrivateType()) {
            this.returnCode = agentReturnCode;
            return;
        }
        if (!agentReturnCode.equals((Object)this.returnCode)) {
            this.returnCode = agentReturnCode;
        }
    }

    public long getReturnCodeOid() {
        if (this.returnCode != null) {
            return this.returnCode.getOid();
        }
        return 0L;
    }

    public void set_sqlServerJob(SqlServerJob sqlServerJob) {
        this._sqlServerJob = sqlServerJob;
        this._cancelableCommand = this._sqlServerJob;
    }

    public SqlServerJob get_sqlServerJob() {
        return this._sqlServerJob;
    }

    public SAPExecutable getSAPExecutable() {
        return this.theSAPExecutable;
    }

    public void setSAPExecutable(SAPExecutable sAPExecutable) {
        this.theSAPExecutable = sAPExecutable;
    }

    public boolean isSAPCommand() {
        return this.commandType == 4 || this.commandType == 5 || this.commandType == 6 || this.commandType == 7 || this.commandType == 11;
    }

    public InformaticaWorkflowCommand getInfaWorkflowCmd() {
        return this.infaWorkflowCmd;
    }

    public void setInfaWorkflowCmd(InformaticaWorkflowCommand informaticaWorkflowCommand) {
        this.infaWorkflowCmd = informaticaWorkflowCommand;
    }

    public boolean isInformaticaCommand() {
        return this.commandType == 8 || this.commandType == 12;
    }

    public OracleExecutable getOracleExecutable() {
        return this.oracleExecutable;
    }

    public void setOracleExecutable(OracleExecutable oracleExecutable) {
        this.oracleExecutable = oracleExecutable;
    }

    public boolean isOracleCommand() {
        return this.commandType == 9;
    }

    public void setWebServiceCmd(WebServiceRequestComposite webServiceRequestComposite) {
        this.webServiceReq = webServiceRequestComposite;
    }

    public boolean isWebServiceCommand() {
        return this.commandType == 10;
    }

    public WebServiceRequestComposite getWebServiceCommand() {
        return this.webServiceReq;
    }

    public InformaticaCloudCommand getInfaCloudCommand() {
        return this.infaCloudCommand;
    }

    public void setInfaCloudCmd(InformaticaCloudCommand informaticaCloudCommand) {
        this.infaCloudCommand = informaticaCloudCommand;
    }

    public AutoMateTaskRequestComposite getAutoMateTaskRequest() {
        return this.autoMateTaskRequest;
    }

    public void setAutoMateTaskRequest(AutoMateTaskRequestComposite autoMateTaskRequestComposite) {
        this.autoMateTaskRequest = autoMateTaskRequestComposite;
    }

    public AutoMateBPARequestComposite getAutoMateBPARequest() {
        return this.autoMateBPARequest;
    }

    public void setAutoMateBPARequest(AutoMateBPARequestComposite autoMateBPARequestComposite) {
        this.autoMateBPARequest = autoMateBPARequestComposite;
    }

    public UniversalConnectorCommand getUniversalConnectorCommand() {
        return this.UniversalConnectorCommand;
    }

    public void setUniversalConnectorCommand(UniversalConnectorCommand universalConnectorCommand) {
        this.UniversalConnectorCommand = universalConnectorCommand;
    }

    public boolean isUniversalConnectorCommand() {
        return this.commandType == 15;
    }

    public String getCommandTypeString() {
        switch (this.commandType) {
            case 0: {
                return "Simple";
            }
            case 1: {
                return "File Transfer";
            }
            case 2: {
                return "SQL Server Job";
            }
            case 3: {
                return "Windows Desktop Application";
            }
            case 4: {
                return "SAP Job";
            }
            case 5: {
                return "SAP Event";
            }
            case 6: {
                return "SAP Run Intercept";
            }
            case 7: {
                return "SAP Variant Action";
            }
            case 8: {
                return "Informatica Workflow";
            }
            case 9: {
                return "Oracle Concurrent Request";
            }
            case 10: {
                return "Web Service";
            }
            case 11: {
                return "SAP Process Chain";
            }
            case 12: {
                return "Informatica Cloud";
            }
            case 13: {
                return "Automate Task";
            }
            case 14: {
                return "Automate Enterprise";
            }
            case 15: {
                return "Universal Connector";
            }
        }
        return "Unknown";
    }

    public int getCommandAction() {
        if (this.isErrorHandlingRetry() && this.isCancelOnError()) {
            return 3;
        }
        if (this.isErrorHandlingRetry() && !this.isCancelOnError()) {
            return 4;
        }
        if (!this.isErrorHandlingRetry() && this.isCancelOnError()) {
            return 1;
        }
        return 2;
    }
}

