/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import java.util.ArrayList;
import java.util.List;

public class CommandSet
extends Proxy
implements BasicIdentifier {
    private static final long serialVersionUID = 204405306359315278L;
    private ArrayList<CommandSetCommand> commandList = new ArrayList();
    private int type = 1;
    private long oid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(CommandSetCommand commandSetCommand) {
        ArrayList<CommandSetCommand> arrayList = this.commandList;
        synchronized (arrayList) {
            this.commandList.add(commandSetCommand);
        }
    }

    public void addCommand(CommandSetCommand commandSetCommand, int n) {
        ValidationHelper.checkForNull((String)"Command", (Object)((Object)commandSetCommand));
        this.commandList.add(n + 1, commandSetCommand);
    }

    public void setOid(long l) {
        if (this.oid > 0L) {
            throw new IllegalStateException("Changes to the oid are not allowed.");
        }
        this.oid = l;
    }

    public long getOid() {
        return this.oid;
    }

    public void setType(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"{0} is an invalid Command Set Type.", (Object[])new Object[]{n}));
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public CommandSetCommand[] getCommands() {
        CommandSetCommand[] commandSetCommandArray = new CommandSetCommand[this.commandList.size()];
        commandSetCommandArray = this.commandList.toArray(commandSetCommandArray);
        return commandSetCommandArray;
    }

    public boolean hasCommands() {
        return !this.commandList.isEmpty();
    }

    public List<CommandSetCommand> getCommandList() {
        return this.commandList;
    }
}

