/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEventProcess;
import junit.framework.TestCase;

public class AgentProcessTest
extends TestCase {
    AgentEventProcess ap;

    protected void setUp() throws Exception {
        super.setUp();
        this.ap = new AgentEventProcess();
    }

    protected void tearDown() throws Exception {
        this.ap = null;
        super.tearDown();
    }

    public void testSetOID() {
        this.ap.setOID(38283L);
        AgentProcessTest.assertEquals((long)38283L, (long)this.ap.getOID());
    }

    public void testSetProcessName() {
        this.ap.setProcessName("/some/cool/name");
        AgentProcessTest.assertEquals((String)"/some/cool/name", (String)this.ap.getProcessName());
    }

    public void testSetProcessCompareValue() {
        this.ap.setProcessCompareValue(0);
        AgentProcessTest.assertEquals((int)0, (int)this.ap.getProcessCompareValue());
        this.ap.setProcessCompareValue(2);
        AgentProcessTest.assertEquals((int)2, (int)this.ap.getProcessCompareValue());
        this.ap.setProcessCompareValue(1);
        AgentProcessTest.assertEquals((int)1, (int)this.ap.getProcessCompareValue());
    }

    public void testProcessCompareMatchesEndsWith() {
        this.ap.setProcessName("waitexit.sh");
        this.ap.setProcessCompareValue(2);
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("waitexit.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/helpsystems/waitexit.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/other/waitexit.sh"));
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("/opt/other/wait.sh"));
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("/opt/waitexit.shx"));
    }

    public void testProcessCompareMatchesStartsWith() {
        this.ap.setProcessName("/opt");
        this.ap.setProcessCompareValue(0);
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/some.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/helpsystems/work.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt"));
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("/other/opt/waitexit.sh"));
    }

    public void testProcessCompareMatchesContains() {
        this.ap.setProcessName("wait");
        this.ap.setProcessCompareValue(1);
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/helpsystems/waitexit.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("/opt/other/wait.sh"));
        AgentProcessTest.assertTrue((boolean)this.ap.processCompareMatches("wait"));
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("/opt/want/waist/waif/lait.sh"));
    }

    public void testProcessCompareMatchesInvalidCompareValue() {
        this.ap.setProcessName("somename");
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("anyValue"));
        this.ap.setProcessCompareValue(-999);
        AgentProcessTest.assertFalse((boolean)this.ap.processCompareMatches("anyValue"));
    }

    public void testSetUserName() {
        this.ap.setUserName("USERNAME");
        AgentProcessTest.assertEquals((String)"USERNAME", (String)this.ap.getUserName());
    }

    public void testSetUserCompareValue() {
        this.ap.setUserCompareValue(2);
        AgentProcessTest.assertEquals((int)2, (int)this.ap.getUserCompareValue());
        this.ap.setUserCompareValue(3);
        AgentProcessTest.assertEquals((int)3, (int)this.ap.getUserCompareValue());
        this.ap.setUserCompareValue(1);
        AgentProcessTest.assertEquals((int)1, (int)this.ap.getUserCompareValue());
        this.ap.setUserCompareValue(0);
        AgentProcessTest.assertEquals((int)0, (int)this.ap.getUserCompareValue());
    }

    public void testUserCompareMatchesContains() {
        this.ap.setUserName("987");
        this.ap.setUserCompareValue(1);
        AgentProcessTest.assertTrue((boolean)this.ap.userCompareMatches("USER9872"));
        AgentProcessTest.assertFalse((boolean)this.ap.userCompareMatches("USER5372"));
    }

    public void testUserCompareMatchesIs() {
        this.ap.setUserName("USER987");
        this.ap.setUserCompareValue(2);
        AgentProcessTest.assertTrue((boolean)this.ap.userCompareMatches("USER987"));
        AgentProcessTest.assertFalse((boolean)this.ap.userCompareMatches("USER9872"));
    }

    public void testUserCompareMatchesIsNot() {
        this.ap.setUserName("USER987");
        this.ap.setUserCompareValue(3);
        AgentProcessTest.assertTrue((boolean)this.ap.userCompareMatches("USER9872"));
        AgentProcessTest.assertFalse((boolean)this.ap.userCompareMatches("USER987"));
    }

    public void testUserCompareMatchesStartsWith() {
        this.ap.setUserName("USR");
        this.ap.setUserCompareValue(0);
        AgentProcessTest.assertTrue((boolean)this.ap.userCompareMatches("USR9872"));
        AgentProcessTest.assertFalse((boolean)this.ap.userCompareMatches("USER437"));
    }

    public void testSetProcessTime() {
        this.ap.setProcessTime(1234);
        AgentProcessTest.assertEquals((int)1234, (int)this.ap.getProcessTime());
    }

    public void testMeetsFireCriteria() {
        AgentProcessTest.assertTrue((boolean)this.ap.meetsFireCriteria("processName", "userName", 5));
        this.ap.setProcessTime(5);
        this.ap.setProcessName("processName");
        this.ap.setUserName("userName");
        AgentProcessTest.assertTrue((boolean)this.ap.meetsFireCriteria("processName", "userName", 5));
        AgentProcessTest.assertTrue((boolean)this.ap.meetsFireCriteria("processName", "userName", 6));
        AgentProcessTest.assertFalse((boolean)this.ap.meetsFireCriteria("wrongProcessName", "userName", 5));
        AgentProcessTest.assertFalse((boolean)this.ap.meetsFireCriteria("processName", "wrongUserName", 5));
        AgentProcessTest.assertFalse((boolean)this.ap.meetsFireCriteria("processName", "userName", 4));
    }
}

