/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.webservice;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestPropertyDM;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class WebServiceRequestPropertyDMJdbc
extends AbstractHelpingDatabaseManager
implements WebServiceRequestPropertyDM {
    private static final String objDesc = "Web Service Request Property";
    private static final String WEB_SERVICE__REQUEST_PROPERTY_TABLE = "web_service_properties";
    private static final String COMMON_SQL_SELECT = "SELECT name, value, line_number";
    private String webServiceRequestPropertyTable;

    public WebServiceRequestPropertyDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.WebServiceRequestPropertyDM");
        this.webServiceRequestPropertyTable = string2 + "." + WEB_SERVICE__REQUEST_PROPERTY_TABLE;
    }

    @Override
    public void loadWebServiceRequestProperty(WebServiceRequest webServiceRequest, Connection connection) throws NoDataException, ResourceUnavailableException, BadDataException {
        String string = "SELECT name, value, line_number FROM " + this.webServiceRequestPropertyTable + " WHERE web_service_command_id=? ";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, webServiceRequest.getOID());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                WebServiceRequestProperty webServiceRequestProperty = new WebServiceRequestProperty();
                webServiceRequestProperty.setName(resultSet.getString("name"));
                webServiceRequestProperty.setValue(resultSet.getString("value"));
                webServiceRequestProperty.setLineNumber(resultSet.getInt("line_number"));
                webServiceRequest.addProperty(webServiceRequestProperty);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for Web Service request id {1}.", (Object[])new Object[]{objDesc, Long.toString(webServiceRequest.getOID())});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                WebServiceRequestPropertyDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        WebServiceRequestPropertyDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }
}

