/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledJobsList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class ScheduledJobsListJdbc
implements ScheduledJobsList {
    private static final Logger logger = Logger.getLogger(ScheduledJobsListJdbc.class);
    private Connection con;
    private PreparedStatement stmt;
    private ResultSet rs;
    private ScheduleJobDM scheduleJobDM;
    private AgentDM agentDM;
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

    ScheduledJobsListJdbc(PreparedStatement preparedStatement, ScheduleJobDM scheduleJobDM, AgentDM agentDM) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Prepared Statement", (Object)preparedStatement);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        ValidationHelper.checkForNull((String)"AgentDM", (Object)agentDM);
        this.stmt = preparedStatement;
        this.scheduleJobDM = scheduleJobDM;
        this.agentDM = agentDM;
        this.con = this.extractConnectionFromStmt();
        this.rs = this.runQuery();
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public int getJobNumber() throws ResourceUnavailableException {
        try {
            return this.rs.getInt("job_id");
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public Calendar getNextScheduledTime() throws ResourceUnavailableException {
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        calendar.clear();
        try {
            Timestamp timestamp = this.rs.getTimestamp("next_scheduled_time", calendar);
            if (timestamp != null) {
                Calendar calendar2 = (Calendar)this.cloneOnly_GMTCalendar.clone();
                calendar2.setTimeInMillis(timestamp.getTime());
                int n = this.rs.getInt("days_moved");
                int n2 = this.rs.getInt("minutes_moved");
                if (n != 0 || n2 != 0) {
                    calendar2 = new MovedNST(calendar2, n, n2);
                    TimeZone timeZone = this.timezone(this.getJobNumber(), this.getSystem());
                    calendar2.setTimeZone(timeZone);
                }
                return calendar2;
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public int getSystem() throws ResourceUnavailableException {
        try {
            return this.rs.getInt("agent_id");
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public void reload() throws ResourceUnavailableException {
        ResultSet resultSet = this.rs;
        this.rs = this.runQuery();
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            resultSet = null;
        }
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private ResultSet runQuery() throws ResourceUnavailableException {
        try {
            return this.stmt.executeQuery();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while retrieving the scheduled jobs list. ";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private String agentTimezoneID(long l) {
        String string;
        try {
            Agent agent = this.agentDM.get(l);
            string = agent.getTimeZone();
        }
        catch (Exception exception) {
            TimeZone timeZone = this.serverTimeZone();
            string = timeZone.getID();
            String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
            logger.error((Object)string2, (Throwable)exception);
        }
        return string;
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.stmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }

    private ScheduleJobProxy jobProxy(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load the ScheduleJobProxy for the job/suite with ID {0}.", (Object[])new Object[]{l}), exception);
        }
    }

    private TimeZone timezone(long l, long l2) {
        TimeZone timeZone;
        ScheduleJobProxy scheduleJobProxy = this.jobProxy(l);
        String string = scheduleJobProxy.getName();
        ScheduleInfo.TimeZoneType timeZoneType = scheduleJobProxy.getTimezoneType();
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                String string2 = this.agentTimezoneID(l2);
                timeZone = this.timezone(string2, string);
                break;
            }
            case JOB: {
                String string3 = scheduleJobProxy.getJobTimezone();
                if (string3 != null && !string3.isEmpty()) {
                    timeZone = this.timezone(string3, string);
                    break;
                }
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string4}));
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }
}

