/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.scheduler.PrereqListJdbc;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.EventHistoryXRef;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.AgentGroupPrereqStatus;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMember;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqGroup;
import com.helpsystems.enterprise.core.scheduler.PrereqList;
import com.helpsystems.enterprise.core.scheduler.PrereqSet;
import com.helpsystems.enterprise.core.scheduler.PrereqState;
import com.helpsystems.enterprise.core.scheduler.PrereqStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.util.LongConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PrereqDMJdbc
extends AbstractDatabaseManager
implements PrereqDM {
    private static final Logger logger = Logger.getLogger(PrereqDMJdbc.class);
    private static final String PREREQ_FIELDS = "id, dependent_job_id, prereq_object_id, prereq_object_type, prereq_type, sequence_number, conjunction, react_to_status, latch_status, keep_status, special_instance_id ";
    private static final String TABLE = "dependencies";
    private static final String PRQSTS_TABLE = "prerequisite_statuses";
    private String table;
    private String prereqStatusTable;
    private EventHistoryXRefDM eventHistoryXRefDM;
    private ScheduleJobDM scheduleJobDM;
    private JobSuiteDM jobSuiteDM;
    private AgentEventMonitorDM agentEventMonitorDM;
    private AgentGroupDM agentGroupDM;

    public PrereqDMJdbc(String string, String string2, String string3, EventHistoryXRefDM eventHistoryXRefDM, ScheduleJobDM scheduleJobDM, AgentGroupDM agentGroupDM, AgentEventMonitorDM agentEventMonitorDM, JobSuiteDM jobSuiteDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"EventHistoryXRefDM", (Object)eventHistoryXRefDM);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        ValidationHelper.checkForNull((String)"AgentGroupDM", (Object)agentGroupDM);
        ValidationHelper.checkForNull((String)"AgentEventMonitorDM", (Object)agentEventMonitorDM);
        ValidationHelper.checkForNull((String)"JobSuiteDM", (Object)jobSuiteDM);
        this.table = string2 + "." + TABLE;
        this.prereqStatusTable = string2 + "." + PRQSTS_TABLE;
        this.setName(string3);
        this.eventHistoryXRefDM = eventHistoryXRefDM;
        this.scheduleJobDM = scheduleJobDM;
        this.agentGroupDM = agentGroupDM;
        this.agentEventMonitorDM = agentEventMonitorDM;
        this.jobSuiteDM = jobSuiteDM;
    }

    @Override
    public boolean hasStatusDependency(long l, PrereqEventType prereqEventType, Connection connection) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.prereqStatusTable + " where prereq_type=? and history_id=? and last_status <> ''";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        Connection connection2 = null;
        try {
            connection2 = connection == null ? this.getConnection() : connection;
            preparedStatement = this.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, prereqEventType.persistanceCode().intValue());
            preparedStatement.setLong(2, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n += resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error getting count for event data.", (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                PrereqDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
        return n > 0;
    }

    @Override
    public Prereq getPrereq(long l) throws ResourceUnavailableException, NoDataException, BadDataException {
        PrereqGenerator prereqGenerator = new PrereqGenerator();
        String string = "SELECT id, dependent_job_id, prereq_object_id, prereq_object_type, prereq_type, sequence_number, conjunction, react_to_status, latch_status, keep_status, special_instance_id FROM " + this.table + " WHERE id=? ";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Prereq prereq;
                Prereq prereq2 = prereq = (Prereq)((Object)prereqGenerator.generateObject(resultSet));
                return prereq2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Prerequisite not found for Prerequisite ID {0}", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error retrieving prerequisite {0}.", (Object[])new Object[]{l});
                logger.debug((Object)string3, (Throwable)sQLException);
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public Prereq[] getPrereqByJobIdSortedBySeqNum(long l) throws ResourceUnavailableException, NoDataException, BadDataException {
        ArrayList<Prereq[]> arrayList = new ArrayList<Prereq[]>();
        PrereqGenerator prereqGenerator = new PrereqGenerator();
        String string = "SELECT id, dependent_job_id, prereq_object_id, prereq_object_type, prereq_type, sequence_number, conjunction, react_to_status, latch_status, keep_status, special_instance_id FROM " + this.table + " WHERE dependent_job_id=? order by sequence_number";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Prereq[] prereqArray;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                prereqArray = (Prereq[])prereqGenerator.generateObject(resultSet);
                arrayList.add(prereqArray);
            }
            prereqArray = arrayList.toArray(new Prereq[arrayList.size()]);
            return prereqArray;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error retrieving prerequisite by job ID {0}.", (Object[])new Object[]{l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public PrereqState getPrereqState(long l, PrereqSet prereqSet, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        PrereqGroup[] prereqGroupArray = prereqSet.getPrereqGroups();
        if (prereqGroupArray.length == 0) {
            return new PrereqState(true, null);
        }
        for (int i = 0; i < prereqGroupArray.length; ++i) {
            PrereqState prereqState = this.checkPrereqGroup(l, prereqGroupArray[i], i + 1, scheduleJobProxy);
            if (!prereqState.isSatisfied()) continue;
            return prereqState;
        }
        return new PrereqState(false, null);
    }

    private PrereqState checkPrereqGroup(long l, PrereqGroup prereqGroup, int n, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        Prereq[] prereqArray = prereqGroup.getPrereqs();
        if (prereqArray.length == 0) {
            String string = "Prereq Group #" + n + " is empty.";
            logger.debug((Object)string);
            return new PrereqState(false, prereqGroup);
        }
        for (int i = 0; i < prereqArray.length; ++i) {
            if (this.isPrereqStatisfied(l, prereqArray[i], scheduleJobProxy)) continue;
            String string = "Prereq " + prereqArray[i].toString() + " in Prereq Group #" + n + " is NOT satisfied: " + prereqArray[i].getPrereqText();
            logger.debug((Object)string);
            return new PrereqState(false, prereqGroup);
        }
        return new PrereqState(true, prereqGroup, n);
    }

    private void logDebugMsg(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
    }

    private boolean isPrereqStatisfied(long l, Prereq prereq, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        PrereqStatus[] prereqStatusArray;
        block73: {
            prereqStatusArray = this.getPrereqStatus(prereq.getID(), l);
            if (prereqStatusArray == null || prereqStatusArray.length == 0) {
                return false;
            }
            ScheduleJobProxy scheduleJobProxy2 = scheduleJobProxy;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Checking if prerequisite is satisfied: Dep Agent ID: " + l + " Dep Job ID: " + prereq.getDepJobID() + " Prereq Type: " + prereq.getType() + " Prereq ID: " + prereq.getID() + " Prereq Object ID: " + prereq.getPrereqObjectID() + " Special Instance ID: " + prereq.getSpecialInstanceID() + " React to Status: " + prereq.getReactToStatus() + " Prereq File: " + prereq.getPrereqObjectFile()));
                if (scheduleJobProxy == null) {
                    logger.trace((Object)"Prereq Checking does NOT have a Dep Job Proxy");
                } else {
                    logger.trace((Object)("Prereq Checking has Dep Job Proxy:  Job Number: " + scheduleJobProxy.getSkybotJobNumber() + " Job Name: " + scheduleJobProxy.getName()));
                }
            }
            if (prereq.getType() == PrereqEventType.JOB_STATUS_CHANGE || prereq.getType() == PrereqEventType.JOB_MONITOR_EVENT || prereq.getType() == PrereqEventType.JOB_SUITE_MEMBER_MONITOR_EVENT) {
                try {
                    ScheduleJobProxy scheduleJobProxy3 = this.scheduleJobDM.getScheduleJobProxy(prereq.getPrereqObjectID());
                    if (scheduleJobProxy2 == null) {
                        scheduleJobProxy2 = this.scheduleJobDM.getScheduleJobProxy(prereq.getDepJobID());
                    }
                    if (scheduleJobProxy3.getModel() != 0) {
                        AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy3.getModel());
                        if (scheduleJobProxy2.getSystem() != 0) {
                            switch (agentGroupProxy.getAgentGroupType()) {
                                case PREFERRED_AGENT: 
                                case UTILIZATION_BALANCED: {
                                    this.logDebugMsg("Prereq Checking JOB: Balanced Agent Group --> Agent");
                                    return this.processPrereqLoadBalancedAgentGroup(l, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                }
                                case ALL_AGENTS: {
                                    this.logDebugMsg("Prereq Checking JOB: All Agents Agent Group --> Agent");
                                    return this.processPrereqAgentGroupAgents(l, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                }
                            }
                            throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                        }
                        if (scheduleJobProxy2.isSuite()) {
                            switch (agentGroupProxy.getAgentGroupType()) {
                                case PREFERRED_AGENT: 
                                case UTILIZATION_BALANCED: {
                                    this.logDebugMsg("Prereq Checking JOB: Balanced Agent Group --> Suite");
                                    return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                }
                                case ALL_AGENTS: {
                                    this.logDebugMsg("Prereq Checking JOB: All Agents Agent Group --> Suite");
                                    return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                }
                            }
                            throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                        }
                        AgentGroupProxy agentGroupProxy2 = this.agentGroupDM.getProxy(scheduleJobProxy2.getModel());
                        switch (agentGroupProxy2.getAgentGroupType()) {
                            case PREFERRED_AGENT: 
                            case UTILIZATION_BALANCED: {
                                switch (agentGroupProxy.getAgentGroupType()) {
                                    case PREFERRED_AGENT: 
                                    case UTILIZATION_BALANCED: {
                                        this.logDebugMsg("Prereq Checking JOB: Balanced Agent Group --> Balanced Agent Group");
                                        return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                    }
                                    case ALL_AGENTS: {
                                        this.logDebugMsg("Prereq Checking JOB: All Agents Agent Group --> Balanced Agent Group");
                                        return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                    }
                                }
                                throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                            }
                            case ALL_AGENTS: {
                                switch (agentGroupProxy.getAgentGroupType()) {
                                    case PREFERRED_AGENT: 
                                    case UTILIZATION_BALANCED: {
                                        this.logDebugMsg("Prereq Checking JOB: Balanced Agent Group -->  All Agents Agent Group ");
                                        return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy3.getModel());
                                    }
                                    case ALL_AGENTS: {
                                        this.logDebugMsg("Prereq Checking JOB: All Agents Agent Group -->  All Agents Agent Group ");
                                        return this.findAgentPrereqStatus(l, prereqStatusArray, prereq);
                                    }
                                }
                                throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                            }
                        }
                        throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy2.getAgentGroupType());
                    }
                    if (scheduleJobProxy3.getSystem() != 0) {
                        return this.processPrereqAgent(l, scheduleJobProxy3.getSystem(), prereq, prereqStatusArray);
                    }
                    break block73;
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Error checking status of a prerequisite job.", throwable);
                    return false;
                }
            }
            if (prereq.getType() == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
                try {
                    JobSuiteDM jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobSuiteDM");
                    JobSuiteMember jobSuiteMember = jobSuiteDM.getMember(prereq.getPrereqObjectID());
                    ScheduleJobProxy scheduleJobProxy4 = this.scheduleJobDM.getScheduleJobProxy(jobSuiteMember.getJobID());
                    if (scheduleJobProxy2 == null) {
                        scheduleJobProxy2 = this.scheduleJobDM.getScheduleJobProxy(prereq.getDepJobID());
                    }
                    if (scheduleJobProxy4.getModel() != 0) {
                        AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy4.getModel());
                        if (scheduleJobProxy2.getSystem() != 0) {
                            switch (agentGroupProxy.getAgentGroupType()) {
                                case PREFERRED_AGENT: 
                                case UTILIZATION_BALANCED: {
                                    this.logDebugMsg("Prereq Checking JSM: Balanced Agent Group --> Agent");
                                    return this.processPrereqLoadBalancedAgentGroup(l, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                }
                                case ALL_AGENTS: {
                                    this.logDebugMsg("Prereq Checking JSM: All Agents Agent Group --> Agent");
                                    return this.processPrereqAgentGroupAgents(l, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                }
                            }
                            throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                        }
                        if (scheduleJobProxy2.isSuite()) {
                            switch (agentGroupProxy.getAgentGroupType()) {
                                case PREFERRED_AGENT: 
                                case UTILIZATION_BALANCED: {
                                    this.logDebugMsg("Prereq Checking JSM: Balanced Agent Group --> Suite");
                                    return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                }
                                case ALL_AGENTS: {
                                    this.logDebugMsg("Prereq Checking JSM: All Agents Agent Group --> Suite");
                                    return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                }
                            }
                            throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                        }
                        AgentGroupProxy agentGroupProxy3 = this.agentGroupDM.getProxy(scheduleJobProxy2.getModel());
                        switch (agentGroupProxy3.getAgentGroupType()) {
                            case PREFERRED_AGENT: 
                            case UTILIZATION_BALANCED: {
                                switch (agentGroupProxy.getAgentGroupType()) {
                                    case PREFERRED_AGENT: 
                                    case UTILIZATION_BALANCED: {
                                        this.logDebugMsg("Prereq Checking JSM: Balanced Agent Group --> Balanced Agent Group");
                                        return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                    }
                                    case ALL_AGENTS: {
                                        this.logDebugMsg("Prereq Checking JSM: All Agents Agent Group --> Balanced Agent Group");
                                        return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                    }
                                }
                                throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                            }
                            case ALL_AGENTS: {
                                switch (agentGroupProxy.getAgentGroupType()) {
                                    case PREFERRED_AGENT: 
                                    case UTILIZATION_BALANCED: {
                                        this.logDebugMsg("Prereq Checking JSM: Balanced Agent Group -->  All Agents Agent Group ");
                                        return this.processPrereqLoadBalancedAgentGroup(0L, prereq, prereqStatusArray, scheduleJobProxy4.getModel());
                                    }
                                    case ALL_AGENTS: {
                                        this.logDebugMsg("Prereq Checking JSM: All Agents Agent Group -->  All Agents Agent Group ");
                                        return this.findAgentPrereqStatus(l, prereqStatusArray, prereq);
                                    }
                                }
                                throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                            }
                        }
                        throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy3.getAgentGroupType());
                    }
                    if (scheduleJobProxy4.getSystem() != 0) {
                        this.logDebugMsg("Prereq Checking JSM: Agent --> Either");
                        return this.processPrereqAgent(l, scheduleJobProxy4.getSystem(), prereq, prereqStatusArray);
                    }
                    break block73;
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Error checking status of a prerequisite suite member job.", throwable);
                    return false;
                }
            }
            if (prereq.getType() == PrereqEventType.AGENT_EVENT) {
                try {
                    AgentEventMonitor agentEventMonitor = this.agentEventMonitorDM.get(prereq.getPrereqObjectID(), null);
                    if (scheduleJobProxy2 == null) {
                        scheduleJobProxy2 = this.scheduleJobDM.getScheduleJobProxy(prereq.getDepJobID());
                    }
                    if (agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                        if (scheduleJobProxy2.getSystem() != 0) {
                            this.logDebugMsg("Prereq Checking AEM: Agent Group --> Job");
                            return this.processPrereqAgentGroupAgents(l, prereq, prereqStatusArray, agentEventMonitor.getTargetID());
                        }
                        if (scheduleJobProxy2.isSuite()) {
                            this.logDebugMsg("Prereq Checking AEM: Agent Group --> Suite");
                            return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, agentEventMonitor.getTargetID());
                        }
                        AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy2.getTargetId());
                        switch (agentGroupProxy.getAgentGroupType()) {
                            case PREFERRED_AGENT: 
                            case UTILIZATION_BALANCED: {
                                this.logDebugMsg("Prereq Checking AEM: All Agents Agent Group --> Balanced Agent Group");
                                return this.processPrereqAgentGroupAgents(0L, prereq, prereqStatusArray, agentEventMonitor.getTargetID());
                            }
                            case ALL_AGENTS: {
                                this.logDebugMsg("Prereq Checking AEM: All Agents Agent Group --> All Agents Agent Group");
                                return this.findAgentPrereqStatus(l, prereqStatusArray, prereq);
                            }
                        }
                        throw new IllegalStateException("Undefined agent group type: " + agentGroupProxy.getAgentGroupType());
                    }
                    if (agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT) {
                        return this.processPrereqAgent(l, agentEventMonitor.getTargetID(), prereq, prereqStatusArray);
                    }
                    logger.error((Object)("Undefined Prereq AEM Target Type: " + agentEventMonitor.getTargetType()));
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Error checking status of a prerequisite Agent Event Monitor.", throwable);
                    return false;
                }
            }
        }
        if (prereq.getType() != PrereqEventType.SNMP_TRAP_EVENT && prereq.getType() != PrereqEventType.JOB_SUITE_MONITOR_EVENT && prereq.getType() != PrereqEventType.JOB_SUITE_STATUS_CHANGE && prereq.getType() != PrereqEventType.REMOTE_EVENT) {
            logger.debug((Object)("TODO: Prerequisite checking does not support type: " + prereq.getType()));
        }
        logger.trace((Object)"Prereq Checking processing: Non-Agent Prereq Processing...");
        prereq.setPrereqStatus(prereqStatusArray[0]);
        return prereq.isSatisfied();
    }

    private boolean findAgentPrereqStatus(long l, PrereqStatus[] prereqStatusArray, Prereq prereq) {
        for (int i = 0; i < prereqStatusArray.length; ++i) {
            if (prereqStatusArray[i].getPrereqAgentID() != l) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Found prereq status record match for the same agent...");
            }
            prereq.setPrereqStatus(prereqStatusArray[i]);
            return prereq.isSatisfied();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No status status record match found for the same agent...");
        }
        return false;
    }

    private boolean processPrereqAgentGroupAgents(long l, Prereq prereq, PrereqStatus[] prereqStatusArray, long l2) throws ResourceUnavailableException, DataException {
        AgentGroup agentGroup = this.agentGroupDM.get(l2);
        AgentGroupAgent[] agentGroupAgentArray = agentGroup.getAgents();
        for (int i = 0; i < agentGroupAgentArray.length; ++i) {
            long l3;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for prereq agent match for agent: " + agentGroupAgentArray[i].getAgentID()));
            }
            if (agentGroupAgentArray[i].currentlyIgnored(l3 = System.currentTimeMillis())) continue;
            boolean bl = false;
            for (int j = 0; j < prereqStatusArray.length; ++j) {
                if (agentGroupAgentArray[i].getAgentID() != prereqStatusArray[j].getPrereqAgentID()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found agent prereq status for agent: " + prereqStatusArray[j].getPrereqAgentID()));
                }
                prereq.setPrereqStatus(prereqStatusArray[j]);
                if (prereq.isSatisfied()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Prerequisite is Satisfied!");
                    }
                    bl = true;
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Prerequisite is NOT satisfied!");
            }
            if (bl) continue;
            return false;
        }
        AgentGroupPrereqStatus agentGroupPrereqStatus = new AgentGroupPrereqStatus(l2);
        prereq.setPrereqStatus(agentGroupPrereqStatus);
        return true;
    }

    private boolean processPrereqLoadBalancedAgentGroup(long l, Prereq prereq, PrereqStatus[] prereqStatusArray, long l2) throws ResourceUnavailableException, DataException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for matched prereq for any agent in a load balanced agent group: " + l2));
        }
        if (prereqStatusArray.length == 0 && logger.isDebugEnabled()) {
            logger.debug((Object)"No statuses were found for prereq load balanced agent group.");
            return false;
        }
        if (prereqStatusArray.length > 1) {
            logger.error((Object)("Multiple statuses were found for prereq load balanced agent group: " + l2));
            return false;
        }
        PrereqStatus prereqStatus = prereqStatusArray[0];
        boolean bl = false;
        prereq.setPrereqStatus(prereqStatus);
        if (prereq.isSatisfied()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Prerequisite on load balanced agent group is satisfied by agent: " + prereqStatus.getPrereqAgentID()));
            }
            bl = true;
        }
        return bl;
    }

    private boolean processPrereqAgent(long l, long l2, Prereq prereq, PrereqStatus[] prereqStatusArray) throws ResourceUnavailableException, DataException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for prereq agent match for agent: " + l2));
        }
        for (int i = 0; i < prereqStatusArray.length; ++i) {
            if (l2 == prereqStatusArray[i].getPrereqAgentID()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found agent prereq status for agent: " + l2));
                }
                prereq.setPrereqStatus(prereqStatusArray[i]);
                if (prereq.isSatisfied()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Prerequisite is Satisfied!");
                    }
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Prerequisite is NOT satisfied!");
                }
                return false;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Skipping prereq status for agent: " + prereqStatusArray[i].getPrereqAgentID()));
        }
        return true;
    }

    @Override
    public PrereqStatus[] getPrereqStatus(long l, long l2) throws ResourceUnavailableException {
        String string = "select id, dependency_id, dep_job_id, last_status, prereq_agent_id, history_id, status_time_utc from " + this.prereqStatusTable + " where dependency_id=? and dep_agent_id=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            PrereqStatus[] prereqStatusArray;
            preparedStatement = this.getPreparedStmtForForwardOnlyList(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            resultSet = preparedStatement.executeQuery();
            ArrayList<PrereqStatus[]> arrayList = new ArrayList<PrereqStatus[]>();
            while (resultSet.next()) {
                prereqStatusArray = new PrereqStatus();
                prereqStatusArray.setId(resultSet.getLong("id"));
                prereqStatusArray.setDependencyID(resultSet.getLong("dependency_id"));
                prereqStatusArray.setDepJobID(resultSet.getLong("dep_job_id"));
                prereqStatusArray.setPrereqAgentID(resultSet.getLong("prereq_agent_id"));
                prereqStatusArray.setHistoryID(resultSet.getLong("history_id"));
                prereqStatusArray.setStatusTime(resultSet.getLong("status_time_utc"));
                String string2 = resultSet.getString("last_status");
                PrereqStatusType prereqStatusType = PrereqStatusType.BLANK;
                try {
                    prereqStatusType = PrereqStatusType.persistanceCodeToEnum(string2);
                }
                catch (Exception exception) {
                    logger.debug((Object)("Error loading current status for prereq " + prereqStatusArray.getId()), (Throwable)exception);
                }
                prereqStatusArray.setCurrentStatus(prereqStatusType);
                arrayList.add(prereqStatusArray);
            }
            prereqStatusArray = arrayList.toArray(new PrereqStatus[0]);
            return prereqStatusArray;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error loading Prereq Status array.", (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public PrereqStatus[] getPrereqStatus(long l, long l2, long l3) throws ResourceUnavailableException {
        String string = "select id, dependency_id, dep_job_id, last_status, prereq_agent_id, history_id, status_time_utc from " + this.prereqStatusTable + " where dependency_id=? and dep_agent_id=? and prereq_agent_id=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            PrereqStatus[] prereqStatusArray;
            preparedStatement = this.getPreparedStmtForForwardOnlyList(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            resultSet = preparedStatement.executeQuery();
            ArrayList<PrereqStatus[]> arrayList = new ArrayList<PrereqStatus[]>();
            while (resultSet.next()) {
                prereqStatusArray = new PrereqStatus();
                prereqStatusArray.setId(resultSet.getLong("id"));
                prereqStatusArray.setDependencyID(resultSet.getLong("dependency_id"));
                prereqStatusArray.setDepJobID(resultSet.getLong("dep_job_id"));
                prereqStatusArray.setPrereqAgentID(resultSet.getLong("prereq_agent_id"));
                prereqStatusArray.setHistoryID(resultSet.getLong("history_id"));
                prereqStatusArray.setStatusTime(resultSet.getLong("status_time_utc"));
                String string2 = resultSet.getString("last_status");
                PrereqStatusType prereqStatusType = PrereqStatusType.BLANK;
                try {
                    prereqStatusType = PrereqStatusType.persistanceCodeToEnum(string2);
                }
                catch (Exception exception) {
                    logger.debug((Object)("Error loading current status for Prereq Status ID: " + prereqStatusArray.getId() + " Prereq ID: " + l + " Dep Agent ID: " + l2 + " Prereq Agent ID: " + l3), (Throwable)exception);
                }
                prereqStatusArray.setCurrentStatus(prereqStatusType);
                arrayList.add(prereqStatusArray);
            }
            prereqStatusArray = arrayList.toArray(new PrereqStatus[0]);
            return prereqStatusArray;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error loading Prereq Status array for Prereq ID: " + l + " Dep Agent ID: " + l2 + " Prereq Agent ID: " + l3, (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public PrereqSet loadPrereqSet(long l, long l2, PrereqList prereqList) throws ResourceUnavailableException {
        return this.loadPrereqSet2(l, l2, prereqList);
    }

    @Override
    public void resetPrereqStatus(long l, long l2, PrereqDM.ResetOption resetOption, long l3) throws ResourceUnavailableException {
        if (l3 != 0L) {
            this.createXrefRecord(l2, l, l3);
        }
        String string = "UPDATE " + this.prereqStatusTable + " SET history_id=0, last_status='', status_time_utc=? " + "WHERE dep_job_id=? and dep_agent_id=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(n + " prerequisite statuses were cleared for dependent job " + l2 + " on agent " + l + "."));
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error creating xref for prerequisite.", (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public void resetPrereqStatus(long l, long l2, PrereqDM.ResetOption resetOption) throws ResourceUnavailableException {
        String string = "select id from " + this.table + " where dependent_job_id=? and keep_status=?";
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.setBoolean(2, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string2 = "UPDATE " + this.prereqStatusTable + " SET history_id=0, last_status='', status_time_utc=?" + " WHERE dependency_id=? and dep_agent_id=?";
            while (resultSet.next()) {
                try {
                    preparedStatement2 = this.getDefaultPreparedStmt(string2);
                    preparedStatement2.setLong(1, 0L);
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.setLong(3, l);
                    preparedStatement2.executeUpdate();
                }
                catch (SQLException sQLException) {
                    throw new ResourceUnavailableException("Error clearing statuses for prerequisite.", (Throwable)sQLException);
                }
                finally {
                    if (preparedStatement2 == null) continue;
                    this.closeConnection(preparedStatement2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error creating xref for prerequisite.", (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public void resetPrereqStatus(PrereqDM.ResetOption resetOption, long l, long l2) throws ResourceUnavailableException {
        switch (resetOption) {
            case CLEAR_ALL_PREREQ_STATUS: {
                String string = "UPDATE " + this.prereqStatusTable + " SET history_id=0, last_status='', status_time_utc=0 " + "WHERE dep_job_id=? and dep_agent_id=?";
                PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
                try {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, l2);
                    preparedStatement.executeUpdate();
                    break;
                }
                catch (SQLException sQLException) {
                    String string2 = MessageUtil.formatMsg((String)"SQL error while resetting the prerequisite statuses for job {0}, on agent {1}.", (Object[])new Object[]{l, l2});
                    throw new ResourceUnavailableException(string2, (Throwable)sQLException);
                }
                finally {
                    this.closeConnection(preparedStatement);
                }
            }
            case CLEAR_UNKEPT_PREREQ_STATUS: {
                this.resetPrereqStatus(l2, l, resetOption);
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Reset Option {0} is not supported by this method.", (Object[])new Object[]{resetOption}));
            }
        }
    }

    @Override
    public PrereqList createPrereqList() throws ResourceUnavailableException {
        String string = "SELECT id, dependent_job_id, prereq_object_id, prereq_object_type, prereq_type, sequence_number, conjunction, react_to_status, latch_status, keep_status, special_instance_id FROM " + this.table + " WHERE dependent_job_id=? " + "ORDER BY sequence_number";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        PrereqGenerator prereqGenerator = new PrereqGenerator();
        PrereqListJdbc prereqListJdbc = new PrereqListJdbc(preparedStatement, (BusinessObjectGenerator)prereqGenerator);
        return prereqListJdbc;
    }

    private PrereqSet loadPrereqSet2(long l, long l2, PrereqList prereqList) throws ResourceUnavailableException {
        Object[] objectArray;
        this.updatePrereqList(l2, prereqList);
        PrereqSet prereqSet = new PrereqSet();
        PrereqGroup prereqGroup = null;
        ArrayList<PrereqGroup> arrayList = new ArrayList<PrereqGroup>();
        ArrayList<Prereq[]> arrayList2 = new ArrayList<Prereq[]>();
        int n = 0;
        while (prereqList.next()) {
            objectArray = prereqList.getPrereq();
            logger.debug((Object)("Loading: " + objectArray.toString()));
            ++n;
            if (prereqGroup == null || objectArray.getConjunction().equals("OR")) {
                if (arrayList2.size() > 0) {
                    Prereq[] prereqArray = new Prereq[]{};
                    prereqArray = arrayList2.toArray(prereqArray);
                    prereqGroup.setPrereqs(prereqArray);
                }
                prereqGroup = new PrereqGroup();
                arrayList.add(prereqGroup);
                arrayList2.clear();
            }
            arrayList2.add((Prereq[])objectArray);
        }
        if (arrayList2.size() > 0) {
            objectArray = new Prereq[]{};
            objectArray = arrayList2.toArray(objectArray);
            prereqGroup.setPrereqs((Prereq[])objectArray);
            arrayList2.clear();
        }
        objectArray = new PrereqGroup[]{};
        objectArray = (PrereqGroup[])arrayList.toArray(objectArray);
        prereqSet.setPrereqGroups((PrereqGroup[])objectArray);
        logger.debug((Object)("Loaded " + n + " Prereqs into " + objectArray.length + " PrereqGroups."));
        return prereqSet;
    }

    private void updatePrereqList(long l, PrereqList prereqList) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Prereq List", (Object)prereqList);
        PreparedStatement preparedStatement = ((PrereqListJdbc)prereqList).getStmt();
        try {
            preparedStatement.setLong(1, l);
            ((PrereqListJdbc)prereqList).runQuery(preparedStatement);
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving the Prereqs for job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public void createJobHistoryToEventXref(long l, long l2, long l3) throws ResourceUnavailableException {
        this.createXrefRecord(l, l2, l3);
    }

    private void createXrefRecord(long l, long l2, long l3) throws ResourceUnavailableException {
        String string = "select dep_job_id, history_id, prereq_type, dependency_id from " + this.prereqStatusTable + " where dep_job_id=? and dep_agent_id=? and (prereq_type=? or prereq_type=?)and history_id > 0";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPreparedStmtForForwardOnlyList(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setInt(3, PrereqEventType.AGENT_EVENT.persistanceCode());
            preparedStatement.setInt(4, PrereqEventType.SAP_MONITOR_EVENT.persistanceCode());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l4 = resultSet.getLong("history_id");
                long l5 = resultSet.getLong("dependency_id");
                if (l4 != 0L) {
                    EventHistoryXRef eventHistoryXRef = new EventHistoryXRef();
                    eventHistoryXRef.setEventHistoryID(l4);
                    eventHistoryXRef.setPrereqTypeAsInt(resultSet.getInt("prereq_type"));
                    eventHistoryXRef.setJobHistoryID(l3);
                    try {
                        this.eventHistoryXRefDM.save(preparedStatement.getConnection(), eventHistoryXRef);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ResourceUnavailableException("Error creating xref for prerequisite: " + l5, (Throwable)exception);
                    }
                }
                logger.debug((Object)"Event History ID is not set for dependency: + dependencyID");
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error creating xrefs for prerequisite.", (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public boolean eventIsPrerequisite(Connection connection, long l, PrereqEventType prereqEventType) throws ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block7: {
            boolean bl;
            connection2 = null;
            preparedStatement = null;
            resultSet = null;
            StringBuffer stringBuffer = new StringBuffer("select count(*) from ");
            stringBuffer.append(this.table);
            stringBuffer.append(" where prereq_object_id = ?");
            stringBuffer.append(" and prereq_type = ?");
            try {
                connection2 = connection == null ? this.getConnection() : connection;
                preparedStatement = connection2.prepareStatement(stringBuffer.toString());
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, prereqEventType.persistanceCode());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block7;
                int n = resultSet.getInt(1);
                bl = n > 0;
            }
            catch (SQLException sQLException) {
                try {
                    throw new ResourceUnavailableException("SQL exception:", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                    if (connection == null) {
                        AbstractDatabaseManager.closeEm((Connection)connection2, null, null);
                    }
                    throw throwable;
                }
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            if (connection == null) {
                AbstractDatabaseManager.closeEm((Connection)connection2, null, null);
            }
            return bl;
        }
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        if (connection == null) {
            AbstractDatabaseManager.closeEm((Connection)connection2, null, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrubPrereqStatusForJob(long l) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            this.scrubPrereqStatusForJob(l, (Connection)wrappedConnection);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error scrubbing prereq status for job ID: " + l), throwable);
        }
        finally {
            AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrubPrereqStatusForAEM(long l) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            this.scrubPrereqStatusForAEM(l, (Connection)wrappedConnection);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error scrubbing prereq status for AEM ID: " + l), throwable);
        }
        finally {
            AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubPrereqStatusForJob(long l, Connection connection) {
        logger.debug((Object)("Scrubbing prerequisite statuses for job: " + l));
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement4 = null;
        ResultSet resultSet3 = null;
        PreparedStatement preparedStatement5 = null;
        ResultSet resultSet4 = null;
        try {
            Object object;
            Enum enum_;
            long l2;
            long l3;
            String string = "select id, prereq_object_id, prereq_object_type, prereq_type from dependencies where dependent_job_id=?";
            String string2 = "select id, dependent_job_id, prereq_type from dependencies where prereq_object_id=? and (prereq_object_type='" + ParentType.JOBS.persistanceCode() + "' or" + " prereq_object_type='" + ParentType.MEMBER_JOB_MONITORS.persistanceCode() + "')";
            AgentListInfo agentListInfo = this.getAgentList(connection, l, ParentType.JOBS);
            logger.debug((Object)("---------- Scrubbing job prereqs for " + l + " with valid agents ----------: " + agentListInfo.agentList));
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                block14: {
                    l3 = resultSet.getLong("id");
                    l2 = resultSet.getLong("prereq_object_id");
                    enum_ = ParentType.persistanceCodeToEnum(resultSet.getString("prereq_object_type"));
                    PrereqEventType prereqEventType = PrereqEventType.persistanceCodeToEnum(resultSet.getInt("prereq_type"));
                    AgentListInfo agentListInfo2 = this.getAgentList(connection, l2, (ParentType)enum_);
                    String string3 = agentListInfo.agentList;
                    object = agentListInfo2.agentList;
                    if (agentListInfo.agentGroupType == AgentGroupType.PREFERRED_AGENT || agentListInfo.agentGroupType == AgentGroupType.UTILIZATION_BALANCED) {
                        string3 = "(0)";
                    }
                    try {
                        String string4 = "delete from prerequisite_statuses where dependency_id=? and ((prereq_type <> ?) or (dep_agent_id not in " + string3 + ")";
                        if (agentListInfo2.agentGroupType != AgentGroupType.PREFERRED_AGENT && agentListInfo2.agentGroupType != AgentGroupType.UTILIZATION_BALANCED) {
                            string4 = string4 + " or (prereq_agent_id not in " + (String)object + ")";
                        }
                        if (agentListInfo.agentGroupType == AgentGroupType.ALL_AGENTS && agentListInfo2.agentGroupType == AgentGroupType.ALL_AGENTS) {
                            string4 = string4 + " or (dep_agent_id <> prereq_agent_id)";
                        }
                        string4 = string4 + ")";
                        logger.debug((Object)("Scrubbing prereqs --> DepID: " + l3 + " Prereq type: " + prereqEventType.toString() + " Scrubbing SQL = " + string4));
                        preparedStatement2 = connection.prepareStatement(string4);
                        preparedStatement2.setLong(1, l3);
                        preparedStatement2.setInt(2, prereqEventType.persistanceCode());
                        long l4 = preparedStatement2.executeUpdate();
                        if (l4 <= 0L) break block14;
                        logger.debug((Object)("Prerequisite statuses scrubbed for job " + l + " dependency id " + l3 + ": " + l4));
                    }
                    catch (Throwable throwable) {
                        AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
                        preparedStatement2 = null;
                        throw throwable;
                    }
                }
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, null);
                preparedStatement2 = null;
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            preparedStatement = null;
            resultSet = null;
            AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
            preparedStatement2 = null;
            logger.debug((Object)("---------- Scrubbing job dependencies for " + l + " with valid agents ----------: " + agentListInfo.agentList));
            preparedStatement3 = connection.prepareStatement(string2);
            preparedStatement3.setLong(1, l);
            resultSet2 = preparedStatement3.executeQuery();
            while (resultSet2.next()) {
                l3 = resultSet2.getLong("id");
                l2 = resultSet2.getLong("dependent_job_id");
                enum_ = PrereqEventType.persistanceCodeToEnum(resultSet2.getInt("prereq_type"));
                this.scrubDependencyForPrereqJob(connection, l, l, l3, l2, (PrereqEventType)enum_, agentListInfo);
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement3, (ResultSet)resultSet2);
            logger.debug((Object)("---------- Scrubbing job dependencies for prereq member job " + l + " with valid agents ----------: " + agentListInfo.agentList));
            String string5 = "select id from job_suite_member_jobs where member_job_id=?";
            String string6 = "select id, dependent_job_id, prereq_type from dependencies where prereq_object_id=? and prereq_object_type='" + ParentType.MEMBER_JOB_STATUSES.persistanceCode() + "'";
            preparedStatement5 = connection.prepareStatement(string5);
            preparedStatement5.setLong(1, l);
            resultSet4 = preparedStatement5.executeQuery();
            while (resultSet4.next()) {
                l2 = resultSet4.getLong("id");
                logger.debug((Object)("Scrubbing Job ID: " + l + " for Member Job ID: " + l2));
                preparedStatement4 = connection.prepareStatement(string6);
                preparedStatement4.setLong(1, l2);
                resultSet3 = preparedStatement4.executeQuery();
                while (resultSet3.next()) {
                    long l5 = resultSet3.getLong("id");
                    long l6 = resultSet3.getLong("dependent_job_id");
                    object = PrereqEventType.persistanceCodeToEnum(resultSet3.getInt("prereq_type"));
                    this.scrubDependencyForPrereqJob(connection, l, l2, l5, l6, (PrereqEventType)object, agentListInfo);
                }
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement4, (ResultSet)resultSet3);
            }
        }
        catch (Throwable throwable) {
            try {
                logger.error((Object)("Error scrubbing prereq status for job: " + l), throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
                AbstractDatabaseManager.closeEm(null, preparedStatement3, resultSet2);
                AbstractDatabaseManager.closeEm(null, preparedStatement4, resultSet3);
                AbstractDatabaseManager.closeEm(null, preparedStatement5, resultSet4);
            }
        }
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, null);
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement3, (ResultSet)resultSet2);
        AbstractDatabaseManager.closeEm(null, preparedStatement4, resultSet3);
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement5, (ResultSet)resultSet4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubDependencyForPrereqJob(Connection connection, long l, long l2, long l3, long l4, PrereqEventType prereqEventType, AgentListInfo agentListInfo) {
        logger.debug((Object)("Scrubbing Dependency for Prereq Job ID: " + l + " Prereq Object ID: " + l2 + " Dependency ID: " + l3 + " Dep Job ID: " + l4 + " Prereq Event Type: " + prereqEventType));
        PreparedStatement preparedStatement = null;
        try {
            AgentListInfo agentListInfo2 = this.getAgentList(connection, l4, ParentType.JOBS);
            String string = agentListInfo2.agentList;
            String string2 = agentListInfo.agentList;
            if (agentListInfo2.agentGroupType == AgentGroupType.PREFERRED_AGENT || agentListInfo2.agentGroupType == AgentGroupType.UTILIZATION_BALANCED) {
                string = "(0)";
            }
            String string3 = "delete from prerequisite_statuses where dependency_id=? and (prereq_type <> ? or dep_agent_id not in " + string + " or prereq_agent_id not in " + string2;
            if (agentListInfo.agentGroupType == AgentGroupType.ALL_AGENTS && agentListInfo2.agentGroupType == AgentGroupType.ALL_AGENTS) {
                string3 = string3 + " or dep_agent_id <> prereq_agent_id";
            }
            string3 = string3 + ")";
            logger.debug((Object)("scrubDependencyForPrereqJob SQL: " + string3));
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setLong(1, l3);
            preparedStatement.setInt(2, prereqEventType.persistanceCode());
            long l5 = preparedStatement.executeUpdate();
            if (l5 > 0L) {
                logger.debug((Object)("Prerequisite statuses scrubbed for dep job " + l4 + " prereq job: " + l + " prereq object id: " + l2 + " dependency id " + l3 + ": " + l5));
            }
            if (agentListInfo.agentGroupType == AgentGroupType.PREFERRED_AGENT || agentListInfo.agentGroupType == AgentGroupType.UTILIZATION_BALANCED) {
                PreparedStatement preparedStatement2 = null;
                ResultSet resultSet = null;
                PreparedStatement preparedStatement3 = null;
                try {
                    Object object;
                    String[] stringArray = null;
                    if (agentListInfo2.agentGroupType == AgentGroupType.PREFERRED_AGENT || agentListInfo2.agentGroupType == AgentGroupType.UTILIZATION_BALANCED) {
                        object = new String[]{"0"};
                        stringArray = object;
                    } else {
                        object = string.replace("(", "");
                        object = ((String)object).replace(")", "");
                        stringArray = ((String)object).split(",");
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n;
                        String string4 = "select count(id) pscount from prerequisite_statuses where dependency_id=? and dep_agent_id=" + stringArray[i];
                        preparedStatement2 = connection.prepareStatement(string4);
                        preparedStatement2.setLong(1, l3);
                        resultSet = preparedStatement2.executeQuery();
                        if (resultSet.next() && (n = resultSet.getInt("pscount")) > 1) {
                            String string5 = "delete from prerequisite_statuses where dependency_id=? and dep_agent_id=" + stringArray[i];
                            preparedStatement3 = connection.prepareStatement(string5);
                            preparedStatement3.setLong(1, l3);
                            int n2 = preparedStatement3.executeUpdate();
                            if (n2 > 0) {
                                logger.debug((Object)(n2 + " prerequisite status records were deleted for dependencyID=" + l3 + " with dep_agent_id=" + stringArray[i]));
                            }
                        }
                        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, (ResultSet)resultSet);
                        AbstractDatabaseManager.closeEm(null, preparedStatement3, null);
                    }
                }
                finally {
                    AbstractDatabaseManager.closeEm(null, preparedStatement2, resultSet);
                    AbstractDatabaseManager.closeEm(null, preparedStatement3, null);
                }
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, null);
        }
        catch (SQLException sQLException) {
            logger.error((Object)"SQL Exception scrubbing dependencies for prerequisite.", (Throwable)sQLException);
        }
        finally {
            AbstractDatabaseManager.closeEm(null, preparedStatement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scrubPrereqStatusForAEM(long l, Connection connection) {
        logger.debug((Object)("Scrubbing prerequisite statuses for AEM: " + l));
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = null;
        try {
            String string = "select id, dependent_job_id from dependencies where prereq_object_id=? and prereq_object_type='" + ParentType.AGENT_EVENT_MONITORS.persistanceCode() + "'";
            AgentListInfo agentListInfo = this.getAgentList(connection, l, ParentType.AGENT_EVENT_MONITORS);
            logger.debug((Object)("---------- Scrubbing AEM " + l + " with valid agents ----------: " + agentListInfo.agentList));
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    long l2 = resultSet.getLong("id");
                    long l3 = resultSet.getLong("dependent_job_id");
                    AgentListInfo agentListInfo2 = this.getAgentList(connection, l3, ParentType.JOBS);
                    String string2 = agentListInfo2.agentList;
                    String string3 = agentListInfo.agentList;
                    if (agentListInfo2.agentGroupType == AgentGroupType.PREFERRED_AGENT || agentListInfo2.agentGroupType == AgentGroupType.UTILIZATION_BALANCED) {
                        string2 = "(0)";
                    }
                    String string4 = "delete from prerequisite_statuses where dependency_id=? and (dep_agent_id not in " + string2 + " or prereq_agent_id not in " + string3;
                    if (agentListInfo2.agentGroupType == AgentGroupType.ALL_AGENTS && agentListInfo.agentGroupType == AgentGroupType.ALL_AGENTS) {
                        string4 = string4 + " or dep_agent_id <> prereq_agent_id";
                    }
                    string4 = string4 + ")";
                    logger.debug((Object)("Dep Scrubbing SQL = " + string4));
                    preparedStatement2 = connection.prepareStatement(string4);
                    preparedStatement2.setLong(1, l2);
                    long l4 = preparedStatement2.executeUpdate();
                    if (l4 > 0L) {
                        logger.debug((Object)("Prerequisite statuses scrubbed for prereq AEM " + l + " dep job " + l3 + " dependency id " + l2 + ": " + l4));
                    }
                }
                catch (Throwable throwable) {
                    AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
                    throw throwable;
                }
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, null);
            }
        }
        catch (Throwable throwable) {
            try {
                logger.error((Object)("Error scrubbing prereq status for aem: " + l), throwable);
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
            }
        }
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        AbstractDatabaseManager.closeEm(null, preparedStatement2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrubPrereqStatusForAgentGroup(long l) {
        logger.debug((Object)("*** Scrubbing prerequisite statuses for Agent Group ***: " + l));
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string = "select id from jobs where target_type='" + ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode() + "' and target_id=?";
        String string2 = "select id from agent_event_monitors where target_type='" + ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode() + "' and target_id=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet2 = null;
        try {
            long l2;
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            logger.debug((Object)("========== Processing Jobs that reference Agent Group ==========: " + l));
            while (resultSet.next()) {
                l2 = resultSet.getLong("id");
                try {
                    this.scrubPrereqStatusForJob(l2, (Connection)wrappedConnection);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error scrubbing prereq status for job " + l2 + " for agent group " + l), throwable);
                }
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            preparedStatement = null;
            resultSet = null;
            preparedStatement2 = wrappedConnection.prepareStatement(string2);
            preparedStatement2.setLong(1, l);
            resultSet2 = preparedStatement2.executeQuery();
            logger.debug((Object)("========== Processing AEMs that reference Agent Group ==========: " + l));
            while (resultSet2.next()) {
                l2 = resultSet2.getLong("id");
                try {
                    this.scrubPrereqStatusForAEM(l2, (Connection)wrappedConnection);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error scrubbing prereq status for AEM " + l2 + " for agent group " + l), throwable);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                logger.error((Object)("Error scrubbing prereq status for Agent Group: " + l), throwable);
            }
            catch (Throwable throwable2) {
                AbstractDatabaseManager.closeEm(null, preparedStatement, resultSet);
                AbstractDatabaseManager.closeEm(null, preparedStatement2, resultSet2);
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
                throw throwable2;
            }
            AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            AbstractDatabaseManager.closeEm(null, preparedStatement2, resultSet2);
            AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
        }
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, (ResultSet)resultSet2);
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
        logger.debug((Object)("Finished scrubbing prerequisite statuses for Agent Group: " + l));
    }

    /*
     * Exception decompiling
     */
    private AgentListInfo getAgentList(Connection var1_1, long var2_2, ParentType var4_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean jobIsDependent(long l) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.table + " where dependent_job_id=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        int n = 0;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n += resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error getting count for job prerequisites.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                PrereqDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        PrereqDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return n > 0;
    }

    @Override
    public long[] getDepJobIds(long l, ParentType parentType) throws ResourceUnavailableException {
        long[] lArray;
        String string = "select dependent_job_id from " + this.table + " where prereq_object_id = ? and prereq_object_type= ? ";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, parentType.persistanceCode());
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("dependent_job_id"));
            }
            lArray = LongConverter.toLongArray(arrayList);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error retrieving dependent jobs for Prereq Object ID: " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return lArray;
    }

    private class PrereqGenerator
    extends AbstractBusObjGenerator {
        public PrereqGenerator() {
            super(11, "Prerequisite");
        }

        protected Object constructObject() {
            return new Prereq();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            Prereq prereq = (Prereq)((Object)object);
            switch (n) {
                case 1: {
                    prereq.setID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    prereq.setDepJobID(resultSet.getLong("dependent_job_id"));
                    break;
                }
                case 3: {
                    prereq.setPrereqObjectID(resultSet.getLong("prereq_object_id"));
                    break;
                }
                case 4: {
                    prereq.setPrereqObjectFile(ParentType.persistanceCodeToEnum(resultSet.getString("prereq_object_type")));
                    break;
                }
                case 5: {
                    prereq.setType(PrereqEventType.persistanceCodeToEnum(resultSet.getInt("prereq_type")));
                    break;
                }
                case 6: {
                    prereq.setSequenceNumber(resultSet.getInt("sequence_number"));
                    break;
                }
                case 7: {
                    prereq.setConjunction(resultSet.getString("conjunction"));
                    break;
                }
                case 8: {
                    prereq.setReactToStatus(PrereqStatusType.persistanceCodeToEnum(resultSet.getString("react_to_status")));
                    break;
                }
                case 9: {
                    prereq.setLatchStatus(resultSet.getBoolean("latch_status"));
                    break;
                }
                case 10: {
                    prereq.setKeepStatus(resultSet.getBoolean("keep_status"));
                    break;
                }
                case 11: {
                    prereq.setSpecialInstanceID(resultSet.getLong("special_instance_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ((Prereq)((Object)object)).validate();
        }
    }

    private class AgentListInfo {
        public String agentList = null;
        public boolean agentGroup = false;
        public AgentGroupType agentGroupType = null;

        public AgentListInfo(String string, boolean bl) {
            this.agentList = string;
            this.agentGroup = bl;
        }

        public AgentListInfo(String string, boolean bl, AgentGroupType agentGroupType) {
            this.agentList = string;
            this.agentGroup = bl;
            this.agentGroupType = agentGroupType;
        }
    }
}

