/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.scheduler.SharedPreparedStatement;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.forecast.ForecastMessageType;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent_MemberStatusChange;
import com.helpsystems.enterprise.core.forecast.ForecastProcessInfo;
import com.helpsystems.enterprise.core.forecast.ForecastReactivityCausePrereq;
import com.helpsystems.enterprise.core.forecast.ForecastStatus;
import com.helpsystems.enterprise.core.forecast.ForecastSuiteEventInfo;
import com.helpsystems.enterprise.core.forecast.ForecastTargetInfo;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectRunID;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectType;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.DependentObject;
import com.helpsystems.enterprise.core.scheduler.ForecastDM;
import com.helpsystems.enterprise.core.scheduler.ForecastDefinition;
import com.helpsystems.enterprise.core.scheduler.ForecastFilter;
import com.helpsystems.enterprise.core.scheduler.ForecastResults;
import com.helpsystems.enterprise.core.scheduler.ForecastRun;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent_SuiteMember;
import com.helpsystems.enterprise.core.scheduler.ForecastedEvent;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MemberRequiredPrereqs;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SharedResource;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ForecastDMJdbc
extends AbstractDatabaseManager
implements ForecastDM {
    private static final Logger logger = Logger.getLogger(ForecastDMJdbc.class);
    private static final String FORECAST_DEFINITIONS_TABLE = "forecast_definitions";
    private static final String FORECAST_HISTORY_TABLE = "forecasts";
    private static final String FORECASTED_EVENTS_TABLE = "forecast_jobs";
    private static final String FORECASTED_JOB_RUNS_TABLE = "forecast_job_runs";
    private static final String FORECASTED_PREREQS_TABLE = "forecasted_prereqs";
    private static final String JOBS_TABLE = "jobs";
    private static final String EXCLUDED_JOBS_TABLE = "excluded_jobs";
    private static final String FORECAST_EXCLUDED_JOBS_TABLE = "forecast_excluded_jobs";
    private static final String FORECAST_SCHEDULES_TABLE = "forecast_schedules";
    private static final String FORECAST_DATE_OBJECTS_TABLE = "forecast_date_objects";
    private static final String AGENT_EVENTS_TABLE = "agent_event_monitors";
    private static final String FORECAST_MESSAGES_TABLE = "forecast_messages";
    private static final String FORECAST_PROCESSES_TABLE = "forecast_processes";
    private static final String FORECAST_PROCESS_EVENTS_TABLE = "forecast_process_events";
    private static final String SPECIAL_INSTANCES_TABLE = "special_instances";
    private static final String SKIP_INSTANCES_TABLE = "skip_instances";
    private static final String MEMBER_JOBS_TABLE = "job_suite_member_jobs";
    private static final String AGENT_GROUPS_TABLE = "agent_groups";
    private static final String AGENT_GROUP_AGENTS_TABLE = "agent_group_agents";
    private static final String JOB_QUEUES_TABLE = "job_queues";
    private String forecastDefinitionsTable;
    private String forecastHistoryTable;
    private String forecastedEventsTable;
    private String forecastedJobRunsTable;
    private String forecastedPrereqsTable;
    private String jobsTable;
    private String excludedJobsTable;
    private String forecastSchedulesTable;
    private String forecastDateObjectsTable;
    private String agentEventsTable;
    private String forecastMessagesTable;
    private String forecastExcludedJobsTable;
    private String forecastProcessesTable;
    private String forecastProcessEventsTable;
    private String specialInstancesTable;
    private String skipInstancesTable;
    private String memberJobsTable;
    private String agentGroupsTable;
    private String agentGroupAgentsTable;
    private String jobQueuesTable;
    private SpecialInstanceDM specialInstanceDM;
    private AgentGroupDM agentGroupDM;
    private final long minute = 60000L;
    private final long hour = 3600000L;

    public ForecastDMJdbc(String string, String string2, String string3, SpecialInstanceDM specialInstanceDM, AgentGroupDM agentGroupDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"SpecialInstanceDM", (Object)specialInstanceDM);
        this.forecastDefinitionsTable = string2 + "." + FORECAST_DEFINITIONS_TABLE;
        this.forecastHistoryTable = string2 + "." + FORECAST_HISTORY_TABLE;
        this.forecastedEventsTable = string2 + "." + FORECASTED_EVENTS_TABLE;
        this.forecastedJobRunsTable = string2 + "." + FORECASTED_JOB_RUNS_TABLE;
        this.forecastedPrereqsTable = string2 + "." + FORECASTED_PREREQS_TABLE;
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.excludedJobsTable = string2 + "." + EXCLUDED_JOBS_TABLE;
        this.forecastSchedulesTable = string2 + "." + FORECAST_SCHEDULES_TABLE;
        this.forecastDateObjectsTable = string2 + "." + FORECAST_DATE_OBJECTS_TABLE;
        this.agentEventsTable = string2 + "." + AGENT_EVENTS_TABLE;
        this.forecastMessagesTable = string2 + "." + FORECAST_MESSAGES_TABLE;
        this.forecastExcludedJobsTable = string2 + "." + FORECAST_EXCLUDED_JOBS_TABLE;
        this.forecastProcessesTable = string2 + "." + FORECAST_PROCESSES_TABLE;
        this.forecastProcessEventsTable = string2 + "." + FORECAST_PROCESS_EVENTS_TABLE;
        this.specialInstancesTable = string2 + "." + SPECIAL_INSTANCES_TABLE;
        this.skipInstancesTable = string2 + "." + SKIP_INSTANCES_TABLE;
        this.memberJobsTable = string2 + "." + MEMBER_JOBS_TABLE;
        this.agentGroupsTable = string2 + "." + AGENT_GROUPS_TABLE;
        this.agentGroupAgentsTable = string2 + "." + AGENT_GROUP_AGENTS_TABLE;
        this.jobQueuesTable = string2 + "." + JOB_QUEUES_TABLE;
        this.setName(string3);
        this.specialInstanceDM = specialInstanceDM;
        this.agentGroupDM = agentGroupDM;
    }

    @Override
    public long createForecastProcessRecord() throws NotSavedException, ResourceUnavailableException {
        String string = "INSERT INTO " + this.forecastProcessesTable + " (lockout) VALUES(?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string, null);
        try {
            preparedStatement.setBoolean(1, false);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string2 = "Unable to create a Forecast Process record.";
                throw new NotSavedException(string2);
            }
            long l = this.retrieveGeneratedKey(preparedStatement);
            return l;
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while creating a Forecast Process record.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void deleteAllForecastProcessData() throws ResourceUnavailableException {
        Statement statement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            String string = "DELETE FROM " + this.forecastProcessesTable;
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error deleting all of the forecast process data.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, null);
        }
    }

    @Override
    public void deleteForecastProcessEvents(Set<ForecastableEvent> set, long l) throws ResourceUnavailableException {
        this.deleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.JOB_SUBMISSION, set, l);
        this.deleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.JOB_SUITE, set, l);
        this.deleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.MEMBER_JOB, set, l);
        this.deleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS, set, l);
    }

    @Override
    public void deleteObsoleteForecastProcessEvents(Set<ForecastableEvent> set, long l, long l2) throws ResourceUnavailableException {
        this.deleteObsoleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.JOB_SUBMISSION, set, l, l2);
        this.deleteObsoleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.JOB_SUITE, set, l, l2);
        this.deleteObsoleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.MEMBER_JOB, set, l, l2);
        this.deleteObsoleteForecastProcessEvents(ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS, set, l, l2);
    }

    @Override
    public Set<ForecastableEvent> getAllAgentTimezoneTypeJobsThatRunOnAgent(long l) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "SELECT id, name, job_type FROM " + this.jobsTable + " WHERE timezone_type = 'A' AND target_type = 'Agent' AND target_id = ?";
        String string2 = "SELECT j.id AS id, name, job_type FROM " + this.jobsTable + " j JOIN " + this.agentGroupAgentsTable + " ON target_id = agent_group_id " + "WHERE timezone_type = 'A' AND target_type = 'AgentGroup' AND agent_id = ?";
        String string3 = string + " UNION ALL " + string2;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent forecastableEvent;
                long l2 = resultSet.getLong("id");
                String string4 = Convert.trimR((String)resultSet.getString("name"));
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                switch (jobType) {
                    case JOB: {
                        forecastableEvent = new ForecastableEvent(l2, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                    }
                }
                forecastableEvent.setName(string4);
                hashSet.add(forecastableEvent);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving all the agent time zone type jobs that run on the agent with ID {0}.", (Object[])new Object[]{l}), (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public List<DependentObject> getAllDependentObjectsThatHaveAReactiveRange() throws ResourceUnavailableException {
        String string = "SELECT id, job_type from " + this.jobsTable + " WHERE schedule_type IN ('RDW', 'RDP', 'RDL')";
        ArrayList<DependentObject> arrayList = new ArrayList<DependentObject>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                long l = resultSet.getLong("id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                arrayList.add(new DependentObject(l, DependentObject.DependentObjectType.jobTypeToEnum(jobType)));
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the list of jobs that have a reactive range defined.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    @Override
    public ForecastableEvent[] getAllEventsThatHaveAForecastSchedule() throws ResourceUnavailableException {
        ArrayList<ForecastableEvent> arrayList = new ArrayList<ForecastableEvent>();
        String string = "SELECT parent_id, parent_type FROM " + this.forecastSchedulesTable + " WHERE schedule_type<>?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, ScheduleJobProxy.ScheduleType.UNSCHEDULED.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent.ForecastableEventType forecastableEventType;
                long l = resultSet.getLong("parent_id");
                ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.persistanceCodeToEnum(resultSet.getString("parent_type"));
                switch (forecastScheduleParentType) {
                    case JOB: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                        break;
                    }
                    case JOB_SUITE: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                        break;
                    }
                    case AGENT_EVENT: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Schedule Parent Type {0} is not supported by this method.", (Object[])new Object[]{forecastScheduleParentType}));
                    }
                }
                arrayList.add(new ForecastableEvent(l, forecastableEventType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving all the jobs/events that have a forecast schedule.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new ForecastableEvent[arrayList.size()]);
    }

    @Override
    public List<ForecastableEvent> getAllEventsThatHaveAForecastScheduleThatUsesThisCalendar(long l) throws ResourceUnavailableException {
        ArrayList<ForecastableEvent> arrayList = new ArrayList<ForecastableEvent>();
        String string = "SELECT parent_id, parent_type FROM " + this.forecastSchedulesTable + " WHERE calendar_id =? AND schedule_type<>?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, ScheduleJobProxy.ScheduleType.UNSCHEDULED.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent.ForecastableEventType forecastableEventType;
                long l2 = resultSet.getLong("parent_id");
                ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.persistanceCodeToEnum(resultSet.getString("parent_type"));
                switch (forecastScheduleParentType) {
                    case JOB: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                        break;
                    }
                    case JOB_SUITE: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                        break;
                    }
                    case AGENT_EVENT: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Schedule Parent Type {0} is not supported by this method.", (Object[])new Object[]{forecastScheduleParentType}));
                    }
                }
                arrayList.add(new ForecastableEvent(l2, forecastableEventType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving all the jobs/events that have a Forecast Schedule that refers to Calendar Object {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    @Override
    public Set<ForecastableEvent> getAllEventsThatHaveAForecastScheduleThatUsesThisDateList(long l) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "SELECT parent_id, parent_type FROM " + this.forecastDateObjectsTable + " JOIN " + this.forecastSchedulesTable + " s ON forecast_schedule_id = s.id" + " WHERE date_object_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent.ForecastableEventType forecastableEventType;
                long l2 = resultSet.getLong("parent_id");
                ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.persistanceCodeToEnum(resultSet.getString("parent_type"));
                switch (forecastScheduleParentType) {
                    case JOB: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                        break;
                    }
                    case JOB_SUITE: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                        break;
                    }
                    case AGENT_EVENT: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Schedule Parent Type {0} is not supported by this method.", (Object[])new Object[]{forecastScheduleParentType}));
                    }
                }
                hashSet.add(new ForecastableEvent(l2, forecastableEventType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving all the jobs/events that have a Forecast Schedule that refers to Date List {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public Set<ForecastableEvent> getAllEventsThatHaveASpecialInstanceThatUsesThisDateList(long l) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "SELECT parent_id, parent_type FROM " + this.specialInstancesTable + " WHERE date_object_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent.ForecastableEventType forecastableEventType;
                long l2 = resultSet.getLong("parent_id");
                ParentType parentType = ParentType.persistanceCodeToEnum(resultSet.getString("parent_type"));
                switch (parentType) {
                    case JOBS: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                        break;
                    }
                    case JOB_SUITES: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                        break;
                    }
                    case AGENT_EVENT_MONITORS: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Parent Type {0} is not supported by this method.", (Object[])new Object[]{parentType}));
                    }
                }
                hashSet.add(new ForecastableEvent(l2, forecastableEventType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving all the jobs/events that have a Special Instance that refers to Date List {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public Set<ForecastableEvent> getAllEventsThatReferToAgentGroup(long l) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "select id, job_type from " + this.jobsTable + " where target_type =? and target_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode());
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            block9: while (resultSet.next()) {
                long l2 = resultSet.getLong("id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                switch (jobType) {
                    case JOB: {
                        hashSet.add(new ForecastableEvent(l2, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION));
                        continue block9;
                    }
                    case SUITE_MEMBER: {
                        hashSet.addAll(this.membersAssociatedWithJob(l2));
                        continue block9;
                    }
                }
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving all the jobs/members that refer to Agent Group {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public Map<ForecastableEvent, AgentGroupProxy> getAllEventsThatRunOnAnAgentGroup() throws ResourceUnavailableException {
        HashMap<ForecastableEvent, AgentGroupProxy> hashMap = new HashMap<ForecastableEvent, AgentGroupProxy>();
        String string = "SELECT j.id AS object_id, j.name AS object_name, job_type, ag.id AS agent_group_id, ag.name AS agent_group_name, group_type FROM " + this.jobsTable + " j JOIN " + this.agentGroupsTable + " ag ON target_id = ag.id " + "WHERE target_type = 'AgentGroup' AND job_type = ?";
        String string2 = "SELECT m.id AS object_id, j.name AS object_name, job_type, ag.id AS agent_group_id, ag.name AS agent_group_name, group_type FROM " + this.jobsTable + " j JOIN " + this.agentGroupsTable + " ag ON target_id = ag.id " + "JOIN " + this.memberJobsTable + " m ON j.id = m.member_job_id " + "WHERE target_type = 'AgentGroup' AND job_type = ?";
        String string3 = string + " UNION ALL " + string2;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setInt(1, JobType.JOB.persistanceCode());
            preparedStatement.setInt(2, JobType.SUITE_MEMBER.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent forecastableEvent;
                long l = resultSet.getLong("object_id");
                String string4 = Convert.trimR((String)resultSet.getString("object_name"));
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                switch (jobType) {
                    case JOB: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                        break;
                    }
                    case SUITE_MEMBER: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.MEMBER_JOB);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                    }
                }
                forecastableEvent.setName(string4);
                AgentGroupProxy agentGroupProxy = new AgentGroupProxy();
                agentGroupProxy.setOid(resultSet.getLong("agent_group_id"));
                AgentGroupType agentGroupType = AgentGroupType.persistanceCodeToEnum(resultSet.getInt("group_type"));
                agentGroupProxy.setAgentGroupType(agentGroupType);
                agentGroupProxy.setName(Convert.trimR((String)resultSet.getString("agent_group_name")));
                hashMap.put(forecastableEvent, agentGroupProxy);
            }
        }
        catch (SQLException sQLException) {
            String string5 = "SQL error while retrieving all the jobs that run on an agent group.";
            throw new ResourceUnavailableException(string5, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashMap;
    }

    @Override
    public long[] getAllMembersWithExclusionPerSpecialInstanceInfo() throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT DISTINCT job_suite_member_job_id FROM " + this.skipInstancesTable;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error creating a Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("job_suite_member_job_id"));
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the list of suite members with exclusion per special instance information.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        }
        long[] lArray = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            lArray[n++] = l;
        }
        return lArray;
    }

    @Override
    public Collection<Long> getAllMembersWithTheANYOption() throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT id FROM " + this.memberJobsTable + " WHERE required_prereqs=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, MemberRequiredPrereqs.ANY.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving the IDs of all the members with the ANY option.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    @Override
    public long[] getAllReactiveJobsThatDoNotRunOnNonWorkDays() throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT id FROM " + this.jobsTable + " WHERE non_workday_option IN ('N', 'B', 'A')" + " AND schedule_type IN ('UJ', 'RDW', 'RDP', 'RDL')";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error creating a Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the list of reactive jobs and suites whose non_workday_option = 'N'.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        }
        long[] lArray = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            lArray[n++] = l;
        }
        return lArray;
    }

    @Override
    public long getCalendarObjectID(ForecastPrereqEvent forecastPrereqEvent) throws NoDataException, ResourceUnavailableException {
        switch (forecastPrereqEvent.getEventType()) {
            case JOB_STATUS_CHANGE: 
            case JOB_SUITE_STATUS_CHANGE: {
                return this.getCalendarObjectID_ForJob(forecastPrereqEvent.getEventID());
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                ForecastSuiteEventInfo forecastSuiteEventInfo = ((ForecastPrereqEvent_MemberStatusChange)forecastPrereqEvent).getSuiteEventInfo();
                long l = forecastSuiteEventInfo.getSuiteID();
                return this.getCalendarObjectID_ForJob(l);
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prereq Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastPrereqEvent.getEventType()}));
    }

    @Override
    public ForecastDefinition getForecastDefinition(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = "SELECT id, name, description, starting_date_option, starting_date, starting_time_option, starting_time, duration_option, duration_time, exclude_timed_interval_jobs, exclude_daily_interval_jobs, purge_history_with_system_settings, purge_history, purge_history_days, created_at, updated_at  FROM " + this.forecastDefinitionsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ForecastDefinition forecastDefinition = this.getDataFromRS(resultSet);
                return forecastDefinition;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Forecast Definition (id = {0}) not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Forecast Definition for id {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long getForecastScheduleID(ForecastableEvent forecastableEvent) throws NoDataException, ResourceUnavailableException {
        ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.forecastableEventToEnum(forecastableEvent);
        String string = "SELECT id FROM " + this.forecastSchedulesTable + " WHERE parent_id=? AND parent_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, forecastableEvent.getID());
            preparedStatement.setString(2, forecastScheduleParentType.persistanceCode);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong("id");
                return l;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Forecast Schedule for Forecastable Event {0} not found.", (Object[])new Object[]{forecastableEvent});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Forecast Schedule ID for Forecastable Event {0}.", (Object[])new Object[]{forecastableEvent});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long getInternalForecastProcessID() throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        Statement statement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block7: {
            wrappedConnection = this.getConnectionOrFail();
            statement = null;
            resultSet = null;
            try {
                statement = wrappedConnection.createStatement();
            }
            catch (SQLException sQLException) {
                ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
                throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
            }
            resultSet = statement.executeQuery("SELECT id from " + this.forecastProcessesTable);
            if (!resultSet.next()) break block7;
            long l = resultSet.getLong("id");
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
            return l;
        }
        try {
            try {
                throw new NoDataException("No internal forecast data.");
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("Error retrieving the internal forecast process ID.", (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, resultSet);
            throw throwable;
        }
    }

    @Override
    public ForecastProcessInfo getInternalForecastProcessInfo() throws NoDataException, ResourceUnavailableException {
        long l = this.getInternalForecastProcessID();
        return this.getForecastProcessInfo(l);
    }

    @Override
    public ForecastableEvent[] getJobsToForecast(ForecastFilter forecastFilter, boolean bl, boolean bl2) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = MessageUtil.formatMsg((String)"job_type IN ({0}, {1})", (Object[])new Object[]{JobType.JOB.persistanceCode(), JobType.SUITE.persistanceCode()});
        String string2 = "SELECT id, name, job_type, job_queue_name FROM " + this.jobsTable + " jobs WHERE " + string;
        if (forecastFilter != null) {
            string2 = string2 + " AND ";
            string2 = string2 + this.agentSelectionClause(forecastFilter);
        }
        string2 = string2 + " AND ";
        string2 = string2 + this.scheduleTypeSelection(bl, bl2);
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent forecastableEvent;
                long l = resultSet.getLong("id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                switch (jobType) {
                    case JOB: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                        forecastableEvent.setJobQueueName(resultSet.getString("job_queue_name"));
                        break;
                    }
                    case SUITE: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUITE);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                    }
                }
                forecastableEvent.setName(resultSet.getString("name"));
                hashSet.add(forecastableEvent);
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving jobs to forecast.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new ForecastableEvent[hashSet.size()]);
    }

    @Override
    public ForecastableEvent[] getJobsToForecast(ForecastDefinition forecastDefinition, ForecastFilter forecastFilter) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = MessageUtil.formatMsg((String)"job_type IN ({0}, {1})", (Object[])new Object[]{JobType.JOB.persistanceCode(), JobType.SUITE.persistanceCode()});
        String string2 = "SELECT id, name, job_type, job_queue_name FROM " + this.jobsTable + " jobs WHERE " + string;
        if (forecastFilter != null) {
            string2 = string2 + " AND ";
            string2 = string2 + this.agentSelectionClause(forecastFilter);
        }
        string2 = string2 + " AND ";
        string2 = string2 + this.scheduleTypeSelection(forecastDefinition) + " AND " + "(NOT EXISTS(" + "SELECT * FROM " + this.excludedJobsTable + " WHERE forecast_definition_id=? AND jobs.id = job_id))";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, forecastDefinition.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent forecastableEvent;
                long l = resultSet.getLong("id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                switch (jobType) {
                    case JOB: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                        forecastableEvent.setJobQueueName(resultSet.getString("job_queue_name"));
                        break;
                    }
                    case SUITE: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUITE);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                    }
                }
                forecastableEvent.setName(resultSet.getString("name"));
                hashSet.add(forecastableEvent);
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving jobs to forecast.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new ForecastableEvent[hashSet.size()]);
    }

    @Override
    public List<Long> getJobsCreatedAfter(long l) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        String string = "SELECT id FROM " + this.jobsTable + " WHERE created_at > ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setTimestamp(1, new Timestamp(l), gregorianCalendar);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
            ArrayList<Long> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving all the jobs created after a certain date/time.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public Map<Long, Long> getJobsThatDoNotUseTheStandardCalendar(long l) throws ResourceUnavailableException {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        String string = "SELECT id, calendar_id FROM " + this.jobsTable + " WHERE calendar_id IS NOT NULL AND calendar_id <> ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("id");
                long l3 = resultSet.getLong("calendar_id");
                hashMap.put(l2, l3);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the jobs that do not use the Calendar Object with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashMap;
    }

    @Override
    public long getJobIDForMember(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT member_job_id FROM " + this.memberJobsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("member_job_id");
                return l2;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Member {0} not found.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job ID associated with member {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public List<Long> getJobsUpdatedAfter(long l) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        String string = "SELECT id FROM " + this.jobsTable + " WHERE updated_at > ?" + " AND updated_at <> created_at";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setTimestamp(1, new Timestamp(l), gregorianCalendar);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
            ArrayList<Long> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving all the jobs updated after a certain date/time.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long getMatchedSuiteEventID(long l) throws ResourceUnavailableException {
        Object object;
        String string = "SELECT id FROM " + this.forecastProcessEventsTable + " WHERE history_id=? AND history_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            String string2 = this.toHistoryTypeString(ForecastedObjectType.JOB_SUITE);
            preparedStatement.setString(2, string2);
            object = preparedStatement.executeQuery();
            if (object.next()) {
                long l2 = object.getLong("id");
                return l2;
            }
            long l3 = 0L;
            return l3;
        }
        catch (SQLException sQLException) {
            object = MessageUtil.formatMsg((String)"SQL error while retrieving the forecast event that was matched to suite run {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ForecastableEvent[] getMembersToForecast() throws ResourceUnavailableException {
        HashSet<ForecastableEvent_SuiteMember> hashSet = new HashSet<ForecastableEvent_SuiteMember>();
        String string = "SELECT m.id AS member_id, member_job_id AS job_id, name AS job_name, job_type, job_queue_name FROM " + this.memberJobsTable + " m JOIN " + this.jobsTable + " j ON member_job_id = j.id";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("member_id");
                long l2 = resultSet.getLong("job_id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                String string2 = resultSet.getString("job_name");
                ForecastableEvent_SuiteMember forecastableEvent_SuiteMember = new ForecastableEvent_SuiteMember(l, l2, jobType, string2);
                forecastableEvent_SuiteMember.setName(string2);
                forecastableEvent_SuiteMember.setJobQueueName(resultSet.getString("job_queue_name"));
                hashSet.add(forecastableEvent_SuiteMember);
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving members to forecast.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new ForecastableEvent[hashSet.size()]);
    }

    @Override
    public ForecastableEvent[] getMembersToForecast(ForecastDefinition forecastDefinition) throws ResourceUnavailableException {
        HashSet<ForecastableEvent_SuiteMember> hashSet = new HashSet<ForecastableEvent_SuiteMember>();
        String string = "SELECT m.id AS member_id, member_job_id, name AS job_name, job_type, job_queue_name FROM " + this.memberJobsTable + " m JOIN " + this.jobsTable + " j ON member_job_id = j.id " + "WHERE NOT EXISTS(" + "SELECT * FROM " + this.excludedJobsTable + " WHERE forecast_definition_id=? AND job_suite_id = job_id)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, forecastDefinition.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("member_id");
                long l2 = resultSet.getLong("member_job_id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                String string2 = resultSet.getString("job_name");
                ForecastableEvent_SuiteMember forecastableEvent_SuiteMember = new ForecastableEvent_SuiteMember(l, l2, jobType, string2);
                forecastableEvent_SuiteMember.setName(string2);
                forecastableEvent_SuiteMember.setJobQueueName(resultSet.getString("job_queue_name"));
                hashSet.add(forecastableEvent_SuiteMember);
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving members to forecast.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new ForecastableEvent[hashSet.size()]);
    }

    @Override
    public ForecastableEvent[] getEventsToForecast(ForecastFilter forecastFilter) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "SELECT parent_id, parent_type, name FROM " + this.forecastSchedulesTable + " JOIN {0} t2 ON parent_id = t2.id WHERE parent_type = ''{1}''";
        String string2 = MessageUtil.formatMsg((String)string, (Object[])new Object[]{this.agentEventsTable, ForecastScheduleParentType.AGENT_EVENT.persistanceCode()});
        if (forecastFilter != null) {
            string2 = string2 + " AND ";
            string2 = string2 + this.agentSelectionClause(forecastFilter);
        }
        String string3 = string2;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ForecastableEvent forecastableEvent;
                long l = resultSet.getLong("parent_id");
                ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.persistanceCodeToEnum(resultSet.getString("parent_type"));
                switch (forecastScheduleParentType) {
                    case AGENT_EVENT: {
                        forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Schedule Parent Type {0} is not supported by this method.", (Object[])new Object[]{forecastScheduleParentType}));
                    }
                }
                forecastableEvent.setName(resultSet.getString("name"));
                hashSet.add(forecastableEvent);
            }
        }
        catch (SQLException sQLException) {
            String string4 = "SQL error while retrieving events to forecast.";
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new ForecastableEvent[hashSet.size()]);
    }

    @Override
    public SpecialInstance[] getMemberSkipInstances(long l) throws ResourceUnavailableException {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT special_instance_id FROM " + this.skipInstancesTable + " WHERE job_suite_member_job_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            object = preparedStatement.executeQuery();
            while (object.next()) {
                arrayList.add(object.getLong("special_instance_id"));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the member skip instances for member {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        object = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            try {
                object.add(this.specialInstanceDM.get(l2));
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to properly check if member {0} is skipped because there was an error retrieving the special instance object with ID {1}.", (Object[])new Object[]{l, l2}), (Throwable)exception);
            }
        }
        return object.toArray(new SpecialInstance[object.size()]);
    }

    @Override
    public boolean getMemberSkipMatchedSetting(long l) throws ResourceUnavailableException {
        String string = "SELECT skip_matched FROM " + this.memberJobsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getBoolean("skip_matched");
                return bl;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Skip matched information for the member with ID {0} not found.", (Object[])new Object[]{l});
                throw new IllegalStateException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Skip matched information for the member with ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ForecastTargetInfo getTargetInfo(DependentObject dependentObject) throws NoDataException, ResourceUnavailableException {
        switch (dependentObject.getType()) {
            case JOB: {
                return this.getTargetInfo_ForJob(dependentObject.getID());
            }
            case JOB_SUITE: {
                return new ForecastTargetInfo(0L, null);
            }
            case MEMBER_JOB: {
                return this.getTargetInfo_ForMember(dependentObject.getID());
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
    }

    @Override
    public ForecastTargetInfo getTargetInfo(long l, PrereqEventType prereqEventType) throws NoDataException, ResourceUnavailableException {
        String string;
        switch (prereqEventType) {
            case JOB_STATUS_CHANGE: {
                string = this.jobsTable;
                break;
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return new ForecastTargetInfo(0L, null);
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return this.getTargetInfo_ForMember(l);
            }
            case AGENT_EVENT: {
                string = this.agentEventsTable;
                break;
            }
            case JOB_MONITOR_EVENT: {
                string = this.jobsTable;
                break;
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return new ForecastTargetInfo(0L, ScheduleInfo.TargetType.AGENT);
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                string = this.jobsTable;
                break;
            }
            case SNMP_TRAP_EVENT: 
            case SAP_MONITOR_EVENT: 
            case REMOTE_EVENT: {
                return new ForecastTargetInfo(0L, ScheduleInfo.TargetType.AGENT);
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prereq Event Type {0} is not supported by this method.", (Object[])new Object[]{prereqEventType}));
            }
        }
        String string2 = "SELECT target_id, target_type FROM " + string + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object;
                long l2 = resultSet.getLong("target_id");
                ScheduleInfo.TargetType targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                ForecastTargetInfo forecastTargetInfo = new ForecastTargetInfo(l2, targetType);
                if (targetType == ScheduleInfo.TargetType.AGENT_GROUP) {
                    object = resultSet.getStatement().getConnection();
                    forecastTargetInfo.setAgentGroupType(this.retrieveAgentGroupType(l2, (Connection)object));
                }
                object = forecastTargetInfo;
                return object;
            }
            try {
                String string3 = MessageUtil.formatMsg((String)"Target information for {0} {1} not found.", (Object[])new Object[]{this.toPrereqEventType_forMessageString(prereqEventType), l});
                throw new NoDataException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = MessageUtil.formatMsg((String)"SQL error while retrieving the Target information for {0} {1}.", (Object[])new Object[]{this.toPrereqEventType_forMessageString(prereqEventType), l});
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long getTheIdOfTheMostCommonlyUsedCalendar() throws ResourceUnavailableException {
        String string = "WITH counts AS (SELECT calendar_id, COUNT(calendar_id) FROM " + this.jobsTable + " WHERE calendar_id IS NOT NULL GROUP BY calendar_id) " + "SELECT calendar_id, count FROM counts ORDER BY count DESC LIMIT 1";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error creating a Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                long l = resultSet.getLong("calendar_id");
                int n = resultSet.getInt("count");
                logger.debug((Object)MessageUtil.formatMsg((String)"The Calendar Object with ID {0} was determined to be the most often used calendar, with a job/suite count of {1}", (Object[])new Object[]{l, n}));
                long l2 = l;
                return l2;
            }
            long l = 1L;
            return l;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the list of reactive jobs and suites whose non_workday_option = 'N'.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        }
    }

    @Override
    public boolean hasForecastSchedule(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
        ForecastScheduleParentType forecastScheduleParentType = ForecastScheduleParentType.forecastableEventToEnum(forecastableEvent);
        String string = "SELECT COUNT(*) FROM " + this.forecastSchedulesTable + " WHERE parent_id=? AND parent_type=? AND schedule_type<>?";
        Object[] objectArray = new Object[]{new Long(forecastableEvent.getID()), forecastScheduleParentType.persistanceCode, ScheduleJobProxy.ScheduleType.UNSCHEDULED.persistanceCode()};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if Forecastable Event {0} has a Forecast Schedule.", (Object[])new Object[]{forecastableEvent});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public boolean isJobInDatabase(long l) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.jobsTable + " WHERE id=?";
        Object[] objectArray = new Object[]{new Long(l)};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if job {0} exists.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public boolean isMemberInDatabase(long l) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.memberJobsTable + " WHERE id=?";
        Object[] objectArray = new Object[]{new Long(l)};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if member {0} exists.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public SharedResource insertForecastProcessEvent(long l, ForecastedEvent forecastedEvent, long l2, Map<ForecastableEvent, AgentGroupProxy> map) throws NotSavedException, ResourceUnavailableException {
        String string = "INSERT INTO " + this.forecastProcessEventsTable + " (forecast_process_id, forecasted_object_id, forecasted_object_type, " + "agent_id, scheduled_utc, created_at_utc, estimated_queue_duration, " + "estimated_running_duration, scheduled_code, job_suite_id, " + "job_suite_forecast_process_event_id, member_skipped_per_special_instance," + "agent_group_id, agent_group_name, job_queue_name) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string, null);
        try {
            SharedPreparedStatement sharedPreparedStatement = new SharedPreparedStatement(preparedStatement);
            this.insertForecastProcessEvent(l, forecastedEvent, l2, map, sharedPreparedStatement);
            return sharedPreparedStatement;
        }
        catch (NotSavedException notSavedException) {
            this.closeConnection(preparedStatement);
            throw notSavedException;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.closeConnection(preparedStatement);
            throw resourceUnavailableException;
        }
        catch (RuntimeException runtimeException) {
            this.closeConnection(preparedStatement);
            throw runtimeException;
        }
    }

    @Override
    public void insertForecastProcessEvent(long l, ForecastedEvent forecastedEvent, long l2, Map<ForecastableEvent, AgentGroupProxy> map, SharedResource sharedResource) throws NotSavedException, ResourceUnavailableException {
        Object object;
        ForecastSuiteEventInfo forecastSuiteEventInfo;
        long l3;
        SharedPreparedStatement sharedPreparedStatement = (SharedPreparedStatement)sharedResource;
        PreparedStatement preparedStatement = sharedPreparedStatement.getResource();
        ForecastableEvent forecastableEvent = forecastedEvent.getForecastableEvent();
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, forecastableEvent.getID());
            preparedStatement.setString(3, ForecastedObjectType.forecastableEventToEnum(forecastableEvent).persistanceCode());
            preparedStatement.setLong(4, forecastedEvent.getAgentID());
            l3 = forecastedEvent.getDateTime();
            if (forecastedEvent.isSuiteMember()) {
                ++l3;
            }
            preparedStatement.setLong(5, l3);
            preparedStatement.setLong(6, l2);
            preparedStatement.setLong(7, forecastedEvent.getQueueWait());
            preparedStatement.setLong(8, forecastedEvent.getRunDuration());
            preparedStatement.setInt(9, forecastedEvent.getForecastInitiationCode().persistanceCode());
            forecastSuiteEventInfo = forecastedEvent.getSuiteEventInfo();
            if (forecastSuiteEventInfo != null) {
                preparedStatement.setLong(10, forecastSuiteEventInfo.getSuiteID());
                preparedStatement.setLong(11, forecastSuiteEventInfo.getForecastProcessEventID());
            } else {
                preparedStatement.setNull(10, -5);
                preparedStatement.setNull(11, -5);
            }
            preparedStatement.setBoolean(12, forecastedEvent.isMemberSkippedPerSpecialInstance());
            object = map.get(forecastableEvent);
            if (object != null) {
                preparedStatement.setLong(13, object.getOid());
                preparedStatement.setString(14, object.getName());
            } else {
                preparedStatement.setNull(13, -5);
                preparedStatement.setString(14, null);
            }
            preparedStatement.setString(15, this.jobQueueName(forecastableEvent, forecastedEvent.getAgentID(), map));
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string = "Unable to add the Forecast Process Event.";
                throw new NotSavedException(string);
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while inserting the Forecast Process Event.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        if (forecastedEvent.isSuite()) {
            try {
                l3 = this.retrieveGeneratedID(preparedStatement);
            }
            catch (NoDataException noDataException) {
                object = MessageUtil.formatMsg((String)"Failure retrieving the generated ID in the forecast process event table, for {0}.", (Object[])new Object[]{forecastedEvent});
                throw new NotSavedException((String)object);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                object = MessageUtil.formatMsg((String)"Failure retrieving the generated ID in the forecast process event table, for {0}.", (Object[])new Object[]{forecastedEvent});
                throw new ResourceUnavailableException((String)object, (Throwable)resourceUnavailableException);
            }
            forecastSuiteEventInfo = forecastedEvent.getSuiteEventInfo();
            forecastSuiteEventInfo.setForecastProcessEventID(l3);
            try {
                this.populateSuiteEventID(l3);
            }
            catch (NotSavedException notSavedException) {
                String string = MessageUtil.formatMsg((String)"Failure writing the suite''s forecast process event ID, for {0}.", (Object[])new Object[]{forecastedEvent});
                logger.error((Object)string, (Throwable)notSavedException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Failure retrieving the generated ID in the forecast process event table, for {0}.", (Object[])new Object[]{forecastedEvent});
                throw new ResourceUnavailableException(string, (Throwable)resourceUnavailableException);
            }
        }
    }

    @Override
    public Set<ForecastableEvent> membersAssociatedWithJob(long l) throws ResourceUnavailableException {
        HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
        String string = "SELECT m.id AS member_id, name AS job_name, job_type FROM " + this.memberJobsTable + " m JOIN " + this.jobsTable + " j ON member_job_id = j.id " + "WHERE member_job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("member_id");
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                String string2 = resultSet.getString("job_name");
                ForecastableEvent_SuiteMember forecastableEvent_SuiteMember = new ForecastableEvent_SuiteMember(l2, l, jobType, string2);
                forecastableEvent_SuiteMember.setName(string2);
                hashSet.add(forecastableEvent_SuiteMember);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving the members associated with job {0}.", (Object[])new Object[]{l}), (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public int purgeForecastProcessData(long l) throws ResourceUnavailableException {
        Statement statement;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        logger.debug((Object)("Purging all forecast process data with a scheduled date/time prior to " + simpleDateFormat.format(new java.util.Date(l))));
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            String string = "DELETE FROM " + this.forecastProcessEventsTable + " WHERE scheduled_utc < " + l;
            int n = statement.executeUpdate(string);
            return n;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error purging the forecast process data.", (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, null);
        }
    }

    @Override
    public void recordForecastProcessStarted(long l, long l2, long l3) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessesTable + " SET start_timestamp_utc=?, regen_timestamp_utc=?, window_end_utc=? " + "WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.setLong(4, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 Forecast Process was updated (ID = {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the Forecast Process information for id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void recordForecastProcessRegenerated(long l, long l2, long l3) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessesTable + " SET regen_timestamp_utc=?, window_end_utc=?, lockout=FALSE WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l3);
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 Forecast Process was updated (ID = {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the Forecast Process information for id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long recordForecastRunStarted(ForecastRun forecastRun) throws NotSavedException, ResourceUnavailableException {
        String string = "INSERT INTO " + this.forecastHistoryTable + " (forecast_definition_id, creation_start_timestamp_utc, " + "window_start_timestamp_utc, window_end_timestamp_utc, " + "exclude_timed_interval_jobs, exclude_daily_interval_jobs, " + "status) " + "VALUES(?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string, null);
        try {
            preparedStatement.setLong(1, forecastRun.getForecastDefinitionID());
            preparedStatement.setLong(2, forecastRun.getGenerationBegin().getTimeInMillis());
            preparedStatement.setLong(3, forecastRun.getForecastWindowBegin().getTimeInMillis());
            preparedStatement.setLong(4, forecastRun.getForecastWindowEnd().getTimeInMillis());
            preparedStatement.setBoolean(5, forecastRun.isExcludeTimedIntervalJobs());
            preparedStatement.setBoolean(6, forecastRun.isExcludeDailyIntervalJobs());
            preparedStatement.setInt(7, forecastRun.getForecastStatus().persistanceCode());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string2 = MessageUtil.formatMsg((String)"Unable to record that the forecast run for forecast definition {0} has started.", (Object[])new Object[]{forecastRun.getForecastDefinitionID()});
                throw new NotSavedException(string2);
            }
            long l = this.retrieveGeneratedKey(preparedStatement);
            return l;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while creating the initial Forecast History entry for id {0}.", (Object[])new Object[]{forecastRun.getForecastDefinitionID()});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void recordExcludedJobs(long l, long l2) throws NotSavedException, ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT job_id FROM " + this.excludedJobsTable + " WHERE forecast_definition_id=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l3 = resultSet.getLong("job_id");
                logger.debug((Object)("Excluded job = " + l3));
                arrayList.add(l3);
            }
            string = "INSERT INTO " + this.forecastExcludedJobsTable + " (forecast_id, job_id) " + "VALUES(" + l2 + ",?)";
            preparedStatement = this.getDefaultPreparedStmt(string);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                preparedStatement.setLong(1, (Long)iterator.next());
                int n = preparedStatement.executeUpdate();
                if (n >= 0) continue;
                throw new RuntimeException("Forecast excluded job record was not created.");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error saving forecast excluded jobs.", exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void recordForecastResults(ForecastRun forecastRun, ForecastResults forecastResults) throws NotSavedException, ResourceUnavailableException {
        this.insertForecastedEvents(forecastResults.getForecastedEvents(), forecastRun.getForecastRunID());
        this.insertForecastErrors(forecastResults.getErrorMap(), forecastRun.getForecastRunID());
        forecastRun.setForecastStatus(ForecastStatus.COMPLETED);
        this.updateForecastRunData(forecastRun);
    }

    @Override
    public void setForecastProcessDataLockoutFlag(long l, boolean bl) throws ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessesTable + " SET lockout=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n != 1) {
                logger.error((Object)MessageUtil.formatMsg((String)"{0} rows updated while attempting to update the Forecast Process data lockout flag to {1}, for id {2}.", (Object[])new Object[]{n, bl, l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while updating the Forecast Process data lockout flag to {0}, for id {1}.", (Object[])new Object[]{bl, l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public int updateIfExactMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, ForecastDM.ActivityMatchCode activityMatchCode) throws ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=? WHERE scheduled_utc=? AND forecasted_object_id=? " + "AND forecasted_object_type=? AND agent_id=? AND match_code IS NULL";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, activityMatchCode.persistanceCode());
            preparedStatement.setLong(2, l);
            preparedStatement.setLong(3, l2);
            preparedStatement.setString(4, forecastedObjectType.persistanceCode());
            preparedStatement.setLong(5, l3);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while trying to update a matching record in the forecast_process_events table.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public int updateIfExactMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, ForecastDM.ActivityMatchCode activityMatchCode, long l4) throws ResourceUnavailableException {
        String string = this.toHistoryTypeString(forecastedObjectType);
        String string2 = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=?, history_id=?, history_type=? WHERE scheduled_utc=? AND forecasted_object_id=? " + "AND forecasted_object_type=? AND agent_id=? AND match_code IS NULL";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setInt(1, activityMatchCode.persistanceCode());
            preparedStatement.setLong(2, l4);
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, l);
            preparedStatement.setLong(5, l2);
            preparedStatement.setString(6, forecastedObjectType.persistanceCode());
            preparedStatement.setLong(7, l3);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while trying to update a matching record in the forecast_process_events table.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public int updateIfExactMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, long l4) throws ResourceUnavailableException {
        String string = this.toHistoryTypeString(forecastedObjectType);
        String string2 = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=?, history_id=?, history_type=? WHERE scheduled_utc=? " + "AND forecasted_object_id=? AND forecasted_object_type=? AND agent_id=? " + "AND match_code IS NULL";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setInt(1, ForecastDM.ActivityMatchCode.EXACT.persistanceCode());
            preparedStatement.setLong(2, l4);
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, l);
            preparedStatement.setLong(5, l2);
            preparedStatement.setString(6, forecastedObjectType.persistanceCode());
            preparedStatement.setLong(7, l3);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while trying to update a matching record in the forecast_process_events table.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long updateIfExactMatchAndReturnID(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, ForecastDM.ActivityMatchCode activityMatchCode) throws ResourceUnavailableException {
        long l4 = 0L;
        return this.updateIfExactMatchAndReturnID(l, l2, forecastedObjectType, l3, activityMatchCode, l4);
    }

    @Override
    public long updateIfExactMatchAndReturnID(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, ForecastDM.ActivityMatchCode activityMatchCode, long l4) throws ResourceUnavailableException {
        long l5 = 0L;
        String string = "SELECT id FROM " + this.forecastProcessEventsTable + " WHERE scheduled_utc=? AND forecasted_object_id=? " + "AND forecasted_object_type=? AND agent_id=? AND match_code IS NULL " + "LIMIT 1";
        String string2 = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=?, history_id=?, history_type=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        PreparedStatement preparedStatement2 = null;
        try {
            preparedStatement2 = this.getDefaultPreparedStmt(string2, preparedStatement.getConnection());
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setString(3, forecastedObjectType.persistanceCode());
            preparedStatement.setLong(4, l3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l5 = resultSet.getLong("id");
                preparedStatement2.setInt(1, activityMatchCode.persistanceCode());
                if (l4 == 0L) {
                    preparedStatement2.setNull(2, -5);
                    preparedStatement2.setNull(3, 12);
                } else {
                    preparedStatement2.setLong(2, l4);
                    preparedStatement2.setString(3, this.toHistoryTypeString(forecastedObjectType));
                }
                preparedStatement2.setLong(4, l5);
                int n = preparedStatement2.executeUpdate();
                if (n < 1) {
                    logger.error((Object)MessageUtil.formatMsg((String)"The record with ID {0} in the forecast_process_events table was identifed as an exact match for {1} with ID {2}, but the update of that record with match code {3} failed.", (Object[])new Object[]{l5, forecastedObjectType, l2, activityMatchCode}));
                    l5 = 0L;
                }
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while trying to update a matching record in the forecast_process_events table.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            ForecastDMJdbc.closeEm(null, (Statement)preparedStatement2, null);
            this.closeConnection(preparedStatement);
        }
        return l5;
    }

    @Override
    public long updateIfProbableMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, ForecastDM.ActivityMatchCode activityMatchCode) throws ResourceUnavailableException {
        long l4 = this.findBestMatch(l, l2, forecastedObjectType, l3);
        if (l4 > 0L) {
            String string = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=? WHERE id=?";
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
            try {
                preparedStatement.setInt(1, activityMatchCode.persistanceCode());
                preparedStatement.setLong(2, l4);
                int n = preparedStatement.executeUpdate();
                if (n == 1) {
                    long l5 = l4;
                    return l5;
                }
            }
            catch (SQLException sQLException) {
                String string2 = "SQL error while trying to update a matching record in the forecast_process_events table.";
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            finally {
                this.closeConnection(preparedStatement);
            }
        }
        return 0L;
    }

    @Override
    public int updateIfProbableMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3, long l4) throws ResourceUnavailableException {
        long l5 = this.findBestMatch(l, l2, forecastedObjectType, l3);
        if (l5 > 0L) {
            String string = this.toHistoryTypeString(forecastedObjectType);
            String string2 = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=?, history_id=?, history_type=? WHERE id=?";
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
            try {
                preparedStatement.setInt(1, ForecastDM.ActivityMatchCode.PROBABLE.persistanceCode());
                preparedStatement.setLong(2, l4);
                preparedStatement.setString(3, string);
                preparedStatement.setLong(4, l5);
                int n = preparedStatement.executeUpdate();
                return n;
            }
            catch (SQLException sQLException) {
                String string3 = "SQL error while trying to update a matching record in the forecast_process_events table.";
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
            finally {
                this.closeConnection(preparedStatement);
            }
        }
        return 0;
    }

    @Override
    public int updateAllMembersAsMatched(long l, ForecastDM.ActivityMatchCode activityMatchCode) throws ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessEventsTable + " SET match_code=? WHERE job_suite_forecast_process_event_id=? " + "AND job_suite_forecast_process_event_id <> id";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, activityMatchCode.persistanceCode());
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while trying to update a matching record in the forecast_process_events table.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String agentSelectionClause(ForecastFilter forecastFilter) {
        if (forecastFilter == null || forecastFilter.getIDs().length == 0) {
            return "";
        }
        switch (forecastFilter.getType()) {
            case BY_AGENT_GROUP: {
                return "(target_type = '" + ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode() + "' AND target_id " + this.inClause(forecastFilter.getIDs()) + ")";
            }
            case BY_AGENT: {
                long[] lArray = forecastFilter.getIDs();
                long[] lArray2 = this.agentGroupsThatContainTheseAgents(lArray);
                String string = "(target_type = '" + ScheduleInfo.TargetType.AGENT.persistanceCode() + "' AND target_id " + this.inClause(lArray);
                if (lArray2.length > 0) {
                    string = string + " OR target_type = '" + ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode() + "' AND target_id " + this.inClause(lArray2);
                }
                string = string + ")";
                return string;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecast Filter Type {0} is not supported by this method.", (Object[])new Object[]{forecastFilter.getType()}));
    }

    private long[] agentGroupsThatContainTheseAgents(long[] lArray) {
        return new long[0];
    }

    private void deleteForecastProcessEvents(ForecastableEvent.ForecastableEventType forecastableEventType, Set<ForecastableEvent> set, long l) throws ResourceUnavailableException {
        Object object;
        String string = null;
        for (ForecastableEvent object22 : set) {
            if (object22.getType() != forecastableEventType) continue;
            object = Long.toString(object22.getID());
            if (string == null) {
                string = "IN (" + (String)object;
                continue;
            }
            string = string + "," + (String)object;
        }
        if (string == null) {
            return;
        }
        string = string + ")";
        String string2 = "DELETE FROM " + this.forecastProcessEventsTable + " WHERE forecast_process_id=? AND forecasted_object_type=?" + " AND forecasted_object_id " + string;
        ForecastedObjectType forecastedObjectType = ForecastedObjectType.forecastableEventTypeToEnum(forecastableEventType);
        object = this.getDefaultPreparedStmt(string2);
        try {
            object.setLong(1, l);
            object.setString(2, forecastedObjectType.persistanceCode());
            object.execute();
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error deleting forecast process events.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection((Statement)object);
        }
    }

    private void deleteObsoleteForecastProcessEvents(ForecastableEvent.ForecastableEventType forecastableEventType, Set<ForecastableEvent> set, long l, long l2) throws ResourceUnavailableException {
        Object object;
        String string = null;
        for (ForecastableEvent object22 : set) {
            if (object22.getType() != forecastableEventType) continue;
            object = Long.toString(object22.getID());
            if (string == null) {
                string = "IN (" + (String)object;
                continue;
            }
            string = string + "," + (String)object;
        }
        if (string == null) {
            return;
        }
        string = string + ")";
        String string2 = "DELETE FROM " + this.forecastProcessEventsTable + " WHERE forecast_process_id=? AND forecasted_object_type=?" + " AND created_at_utc <? AND scheduled_utc >=?" + " AND forecasted_object_id " + string;
        ForecastedObjectType forecastedObjectType = ForecastedObjectType.forecastableEventTypeToEnum(forecastableEventType);
        object = this.getDefaultPreparedStmt(string2);
        try {
            object.setLong(1, l);
            object.setString(2, forecastedObjectType.persistanceCode());
            object.setLong(3, l2);
            object.setLong(4, l2);
            object.execute();
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error deleting forecast process events.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection((Statement)object);
        }
    }

    private long findBestMatch(long l, long l2, ForecastedObjectType forecastedObjectType, long l3) throws ResourceUnavailableException {
        long l4 = l - 3600000L;
        long l5 = this.findClosestMatch(l, l4, l2, forecastedObjectType, l3);
        if (l5 > 0L) {
            return l5;
        }
        l4 = l + 1800000L;
        return this.findClosestMatch(l, l4, l2, forecastedObjectType, l3);
    }

    private long findClosestMatch(long l, long l2, long l3, ForecastedObjectType forecastedObjectType, long l4) throws ResourceUnavailableException {
        String string;
        long l5;
        long l6;
        if (l2 < l) {
            l6 = l2;
            l5 = l;
            string = "DESC";
        } else {
            l6 = l;
            l5 = l2;
            string = "ASC";
        }
        String string2 = "SELECT id FROM " + this.forecastProcessEventsTable + " WHERE forecasted_object_id=? AND forecasted_object_type=? " + "AND agent_id=? AND scheduled_utc >= ? AND scheduled_utc <= ? " + "AND match_code IS NULL ORDER BY scheduled_utc " + string + " FETCH FIRST ROW ONLY";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, l3);
            preparedStatement.setString(2, forecastedObjectType.persistanceCode());
            preparedStatement.setLong(3, l4);
            preparedStatement.setLong(4, l6);
            preparedStatement.setLong(5, l5);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l7 = resultSet.getLong("id");
                return l7;
            }
            long l8 = 0L;
            return l8;
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while trying to find the closest match in the forecast_process_events table.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private long getCalendarObjectID_ForJob(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT calendar_id FROM " + this.jobsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("calendar_id");
                return l2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Calendar Object id for Job {0} not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Calendar Object id for Job {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private ForecastDefinition getDataFromRS(ResultSet resultSet) throws SQLException, BadDataException, ResourceUnavailableException {
        ForecastDefinition forecastDefinition = new ForecastDefinition();
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        for (int i = 1; i <= 11; ++i) {
            try {
                this.getDataFromRS(resultSet, forecastDefinition, i);
                continue;
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
        }
        try {
            forecastDefinition.validate();
        }
        catch (RuntimeException runtimeException) {
            exceptionErrorList.addException((Exception)runtimeException);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            String string = MessageUtil.formatMsg((String)"One or more errors occurred while retrieving the Forecast Definition Object {0}. Please see the error log for details.", (Object[])new Object[]{this.getIdentifierForMessage(forecastDefinition)});
            throw new BadDataException(string, (Object)forecastDefinition, (ErrorList)exceptionErrorList);
        }
        return forecastDefinition;
    }

    private void getDataFromRS(ResultSet resultSet, ForecastDefinition forecastDefinition, int n) throws SQLException, ResourceUnavailableException {
        switch (n) {
            case 1: {
                forecastDefinition.setID(resultSet.getLong("id"));
                break;
            }
            case 2: {
                forecastDefinition.setName(Convert.trimR((String)resultSet.getString("name")));
                break;
            }
            case 3: {
                forecastDefinition.setDescription(Convert.trimR((String)resultSet.getString("description")));
                break;
            }
            case 4: {
                forecastDefinition.setStartDateOption(ForecastDefinition.StartDateOption.persistanceCodeToEnum(resultSet.getInt("starting_date_option")));
                break;
            }
            case 5: {
                if (forecastDefinition.getStartDateOption() != ForecastDefinition.StartDateOption.SPECIFIC) break;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                gregorianCalendar.clear();
                Date date = resultSet.getDate("starting_date", (Calendar)gregorianCalendar);
                gregorianCalendar.setTime(date);
                forecastDefinition.setStartDate(gregorianCalendar);
                break;
            }
            case 6: {
                forecastDefinition.setStartTimeOption(ForecastDefinition.StartTimeOption.persistanceCodeToEnum(resultSet.getInt("starting_time_option")));
                break;
            }
            case 7: {
                if (forecastDefinition.getStartTimeOption() != ForecastDefinition.StartTimeOption.SPECIFIC) break;
                forecastDefinition.setStartTime(this.toLocalHHMM(resultSet.getInt("starting_time")));
                break;
            }
            case 8: {
                forecastDefinition.setDurationOption(ForecastDefinition.DurationOption.persistanceCodeToEnum(resultSet.getInt("duration_option")));
                break;
            }
            case 9: {
                forecastDefinition.setDuration(resultSet.getInt("duration_time"));
                break;
            }
            case 10: {
                forecastDefinition.setExcludeTimedIntervalJobs(resultSet.getBoolean("exclude_timed_interval_jobs"));
                break;
            }
            case 11: {
                forecastDefinition.setExcludeDailyIntervalJobs(resultSet.getBoolean("exclude_daily_interval_jobs"));
                break;
            }
            case 12: {
                forecastDefinition.setPurgeHistoryWithSystemSettings(resultSet.getBoolean("purge_history_with_system_settings"));
                break;
            }
            case 13: {
                forecastDefinition.setPurgeHistory(resultSet.getBoolean("purge_history"));
                break;
            }
            case 14: {
                forecastDefinition.setPurgeHistoryDays(resultSet.getInt("purge_history_days"));
                break;
            }
            case 15: {
                forecastDefinition.setCreatedAt(resultSet.getTimestamp("created_at"));
                break;
            }
            case 16: {
                forecastDefinition.setUpdatedAt(resultSet.getTimestamp("updated_at"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private ForecastProcessInfo getForecastProcessInfo(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT start_timestamp_utc, regen_timestamp_utc, window_end_utc FROM " + this.forecastProcessesTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ForecastProcessInfo forecastProcessInfo;
                ForecastProcessInfo forecastProcessInfo2 = forecastProcessInfo = new ForecastProcessInfo(l, resultSet.getLong("start_timestamp_utc"), resultSet.getLong("regen_timestamp_utc"), resultSet.getLong("window_end_utc"));
                return forecastProcessInfo2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Forecast Process (id = {0}) not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error retrieving information about Forecast Process {0}.", (Object[])new Object[]{l}), (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String getIdentifierForMessage(ForecastDefinition forecastDefinition) {
        String string = forecastDefinition.getName();
        if (string.length() == 0) {
            string = MessageUtil.formatMsg((String)"(ID = {0})", (Object[])new Object[]{forecastDefinition.getID()});
        }
        return string;
    }

    private long getJobID(ForecastedEvent forecastedEvent) {
        ForecastableEvent forecastableEvent = forecastedEvent.getForecastableEvent();
        if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.MEMBER_JOB) {
            return ((ForecastableEvent_SuiteMember)forecastableEvent).getJobID();
        }
        return forecastableEvent.getID();
    }

    private long getMemberID(ForecastedEvent forecastedEvent) {
        ForecastableEvent forecastableEvent = forecastedEvent.getForecastableEvent();
        if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.MEMBER_JOB) {
            return ((ForecastableEvent_SuiteMember)forecastableEvent).getID();
        }
        return 0L;
    }

    private long getSuiteID(ForecastedEvent forecastedEvent) {
        ForecastSuiteEventInfo forecastSuiteEventInfo = forecastedEvent.getSuiteEventInfo();
        if (forecastSuiteEventInfo != null) {
            return forecastSuiteEventInfo.getSuiteID();
        }
        return 0L;
    }

    private String getJobName(ForecastedEvent forecastedEvent) {
        ForecastableEvent forecastableEvent = forecastedEvent.getForecastableEvent();
        if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.MEMBER_JOB) {
            return ((ForecastableEvent_SuiteMember)forecastableEvent).getJobName();
        }
        return forecastableEvent.getName();
    }

    private ForecastTargetInfo getTargetInfo_ForJob(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT target_id, target_type FROM " + this.jobsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object;
                long l2 = resultSet.getLong("target_id");
                ScheduleInfo.TargetType targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                ForecastTargetInfo forecastTargetInfo = new ForecastTargetInfo(l2, targetType);
                if (targetType == ScheduleInfo.TargetType.AGENT_GROUP) {
                    object = resultSet.getStatement().getConnection();
                    forecastTargetInfo.setAgentGroupType(this.retrieveAgentGroupType(l2, (Connection)object));
                }
                object = forecastTargetInfo;
                return object;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Target information for Job {0} not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Target information for Job {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private ForecastTargetInfo getTargetInfo_ForMember(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT target_id, target_type FROM " + this.memberJobsTable + " m JOIN " + this.jobsTable + " j ON member_job_id = j.id WHERE m.id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object;
                long l2 = resultSet.getLong("target_id");
                ScheduleInfo.TargetType targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                ForecastTargetInfo forecastTargetInfo = new ForecastTargetInfo(l2, targetType);
                if (targetType == ScheduleInfo.TargetType.AGENT_GROUP) {
                    object = resultSet.getStatement().getConnection();
                    forecastTargetInfo.setAgentGroupType(this.retrieveAgentGroupType(l2, (Connection)object));
                }
                object = forecastTargetInfo;
                return object;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Target information for Member {0} not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Target information for Member {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String inClause(long[] lArray) {
        String string = null;
        for (int i = 0; i < lArray.length; ++i) {
            String string2 = Long.toString(lArray[i]);
            string = string == null ? "IN (" + string2 : string + "," + string2;
        }
        string = string + ")";
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void insertForecastedEvents(ForecastedEvent[] forecastedEventArray, long l) throws NotSavedException, ResourceUnavailableException {
        void object3;
        ArrayList<ForecastedEvent> arrayList = new ArrayList<ForecastedEvent>();
        Object arrayList2 = forecastedEventArray;
        int n = ((ForecastedEvent[])arrayList2).length;
        boolean bl = false;
        while (object3 < n) {
            ForecastedEvent forecastedEvent = arrayList2[object3];
            if (forecastedEvent.isPrerequisite() && !forecastedEvent.hasPrerequisites()) {
                arrayList.add(forecastedEvent);
            }
            ++object3;
        }
        arrayList2 = new ArrayList();
        for (ForecastedEvent forecastedEvent : forecastedEventArray) {
            if (!forecastedEvent.isPrerequisite() || !forecastedEvent.hasPrerequisites()) continue;
            arrayList2.add(forecastedEvent);
        }
        ArrayList arrayList3 = new ArrayList();
        for (ForecastedEvent forecastedEvent : forecastedEventArray) {
            if (forecastedEvent.isPrerequisite()) continue;
            arrayList3.add(forecastedEvent);
        }
        if (arrayList.size() + arrayList2.size() + arrayList3.size() != forecastedEventArray.length) {
            throw new IllegalStateException("Program error.");
        }
        String string = "INSERT INTO " + this.forecastedEventsTable + " (forecast_id, job_id, agent_id, " + "first_schedule_timestamp_utc, last_schedule_timestamp_utc, " + "job_name, agent_name, suite_id, suite_member_id, agent_group_id, agent_group_name, job_queue_name) " + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
        String string2 = "INSERT INTO " + this.forecastedJobRunsTable + " (forecast_id, forecast_job_id, " + "scheduled_timestamp_utc, scheduled_code, " + "queued_duration, running_duration, completed_timestamp_utc, " + "member_skipped_per_special_instance) " + "VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string, null);
        PreparedStatement preparedStatement2 = this.getPreparedStmtThatReturnsGeneratedKeys(string2, null);
        PreparedStatement preparedStatement3 = this.getDefaultPreparedStmt(string2);
        HashMap<AgentJobKey, AgentJobInfo> hashMap = new HashMap<AgentJobKey, AgentJobInfo>();
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
        Map<ForecastableEvent, AgentGroupProxy> map = this.getAllEventsThatRunOnAnAgentGroup();
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        try {
            Iterator iterator;
            long l2;
            ForecastedEvent forecastedEvent2;
            preparedStatement.setLong(1, l);
            preparedStatement2.setLong(1, l);
            preparedStatement3.setLong(1, l);
            for (ForecastedEvent forecastedEvent2 : arrayList) {
                l2 = this.insertForecastJobRun(preparedStatement2, preparedStatement3, preparedStatement, forecastedEvent2, hashMap, hashMap2, agentDM, map);
                this.setActualRowID(forecastedEvent2, l2);
            }
            while (arrayList2.size() > 0) {
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    forecastedEvent2 = (ForecastedEvent)iterator.next();
                    if (!forecastedEvent2.isPrereqsAllHaveActualIDs()) continue;
                    l2 = this.insertForecastJobRun(preparedStatement2, preparedStatement3, preparedStatement, forecastedEvent2, hashMap, hashMap2, agentDM, map);
                    this.setActualRowID(forecastedEvent2, l2);
                    iterator.remove();
                }
            }
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                forecastedEvent2 = (ForecastedEvent)iterator.next();
                l2 = this.insertForecastJobRun(preparedStatement2, preparedStatement3, preparedStatement, forecastedEvent2, hashMap, hashMap2, agentDM, map);
                this.setActualRowID(forecastedEvent2, l2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while inserting the Forecasted Events.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
            if (preparedStatement2 != null) {
                this.closeConnection(preparedStatement2);
            }
            if (preparedStatement3 != null) {
                this.closeConnection(preparedStatement3);
            }
        }
        this.updateFirstLastRuntimes(forecastedEventArray, hashMap);
        this.insertForecastedPrereqs(forecastedEventArray, l);
    }

    private long insertForecastJobRun(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, ForecastedEvent forecastedEvent, Map<AgentJobKey, AgentJobInfo> map, Map<Long, String> map2, AgentDM agentDM, Map<ForecastableEvent, AgentGroupProxy> map3) throws NotSavedException, SQLException, ResourceUnavailableException {
        ForecastedObjectRunID forecastedObjectRunID;
        long l = forecastedEvent.getAgentID();
        long l2 = this.getJobID(forecastedEvent);
        long l3 = this.getMemberID(forecastedEvent);
        long l4 = forecastedEvent.getDateTime();
        AgentJobKey agentJobKey = new AgentJobKey(l, l2, l3);
        AgentJobInfo agentJobInfo = null;
        if (map.containsKey(agentJobKey)) {
            agentJobInfo = map.get(agentJobKey);
        }
        if (agentJobInfo == null) {
            long l5 = this.insertForecastJobHeader(preparedStatement3, forecastedEvent, map2, agentDM, map3);
            agentJobInfo = new AgentJobInfo(l5, l4, l4);
            map.put(agentJobKey, agentJobInfo);
        }
        boolean bl = (forecastedObjectRunID = forecastedEvent.getForecastedObjectRunID()) != null;
        PreparedStatement preparedStatement4 = bl ? preparedStatement : preparedStatement2;
        preparedStatement4.setLong(2, agentJobInfo.key);
        preparedStatement4.setLong(3, l4);
        preparedStatement4.setInt(4, forecastedEvent.getForecastInitiationCode().persistanceCode());
        preparedStatement4.setLong(5, forecastedEvent.getQueueWait());
        preparedStatement4.setLong(6, forecastedEvent.getRunDuration());
        preparedStatement4.setLong(7, l4 + forecastedEvent.getQueueWait() + forecastedEvent.getRunDuration());
        preparedStatement4.setBoolean(8, forecastedEvent.isMemberSkippedPerSpecialInstance());
        int n = preparedStatement4.executeUpdate();
        if (n < 1) {
            String string = "Unable to add the Forecasted Job Runs.";
            throw new NotSavedException(string);
        }
        if (bl) {
            try {
                return this.retrieveGeneratedID(preparedStatement4);
            }
            catch (NoDataException noDataException) {
                String string = "Failure retrieving generated key for forecast job run - Job:" + l2 + " Agent:" + l + " Timestamp:" + l4;
                throw new NotSavedException(string);
            }
        }
        return 0L;
    }

    private long insertForecastJobHeader(PreparedStatement preparedStatement, ForecastedEvent forecastedEvent, Map<Long, String> map, AgentDM agentDM, Map<ForecastableEvent, AgentGroupProxy> map2) throws NotSavedException, ResourceUnavailableException {
        long l = forecastedEvent.getAgentID();
        long l2 = this.getJobID(forecastedEvent);
        long l3 = this.getSuiteID(forecastedEvent);
        long l4 = this.getMemberID(forecastedEvent);
        long l5 = forecastedEvent.getDateTime();
        try {
            boolean bl;
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l);
            preparedStatement.setLong(4, l5);
            preparedStatement.setLong(5, l5);
            preparedStatement.setString(6, this.getJobName(forecastedEvent));
            preparedStatement.setLong(8, l3);
            preparedStatement.setLong(9, l4);
            ForecastableEvent forecastableEvent = forecastedEvent.getForecastableEvent();
            AgentGroupProxy agentGroupProxy = map2.get(forecastableEvent);
            boolean bl2 = bl = agentGroupProxy != null;
            if (bl) {
                preparedStatement.setLong(10, agentGroupProxy.getOid());
                preparedStatement.setString(11, agentGroupProxy.getName());
            } else {
                preparedStatement.setNull(10, -5);
                preparedStatement.setString(11, null);
            }
            preparedStatement.setString(12, this.jobQueueName(forecastableEvent, forecastedEvent.getAgentID(), map2));
            String string = null;
            if (l == 0L) {
                if ((l3 == 0L || l4 != 0L) && bl) {
                    string = Agent.getTBDInGroupAgentName(agentGroupProxy.getName());
                }
            } else {
                if (!map.containsKey(l)) {
                    try {
                        map.put(l, agentDM.get(l).getName());
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error retrieving agent name for ID: " + l), (Throwable)exception);
                        map.put(l, "AGENT(" + l + ")");
                    }
                }
                string = map.get(l);
            }
            preparedStatement.setString(7, string);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string2 = "Unable to add the Forecasted Event.";
                throw new NotSavedException(string2);
            }
            try {
                return this.retrieveGeneratedID(preparedStatement);
            }
            catch (NoDataException noDataException) {
                String string3 = "Failure retrieving generated key for forecast job header - Job:" + l2 + " Agent:" + l;
                throw new NotSavedException(string3);
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while inserting the Forecast Job Header.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private void insertForecastedPrereqs(ForecastedEvent[] forecastedEventArray, long l) throws ResourceUnavailableException {
        String string = "INSERT INTO " + this.forecastedPrereqsTable + " (forecast_id, prereq_object_type, " + "prereq_object_id, prereq_agent_id, prereq_forecast_job_run_id, " + "forecast_job_run_id, status, occurred_timestamp_utc) " + "VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        for (ForecastedEvent forecastedEvent : forecastedEventArray) {
            if (!forecastedEvent.hasPrerequisites()) continue;
            long l2 = forecastedEvent.getForecastedObjectRunID().getActualID();
            for (ForecastReactivityCausePrereq forecastReactivityCausePrereq : forecastedEvent.getForecastReactivityCause()) {
                this.insertForecastedPrereq(preparedStatement, l, l2, forecastReactivityCausePrereq);
            }
        }
    }

    private void insertForecastedPrereq(PreparedStatement preparedStatement, long l, long l2, ForecastReactivityCausePrereq forecastReactivityCausePrereq) throws ResourceUnavailableException {
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, forecastReactivityCausePrereq.getPrereqObjectType().persistanceCode());
            preparedStatement.setLong(3, forecastReactivityCausePrereq.getPrereqObjectID());
            preparedStatement.setLong(4, forecastReactivityCausePrereq.getPrereqAgentID());
            ForecastedObjectRunID forecastedObjectRunID = forecastReactivityCausePrereq.getForecastedObjectRunID();
            long l3 = forecastedObjectRunID != null ? forecastedObjectRunID.getActualID() : 0L;
            preparedStatement.setLong(5, l3);
            preparedStatement.setLong(6, l2);
            preparedStatement.setString(7, forecastReactivityCausePrereq.getStatus().persistanceCode());
            preparedStatement.setLong(8, forecastReactivityCausePrereq.getTimestamp());
            int n = preparedStatement.executeUpdate();
            if (n < 0) {
                throw new RuntimeException("Forecast prerequisite record was not created.");
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while inserting the Forecasted Prerequisite.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private void insertForecastErrors(Map<ForecastableEvent, Exception> map, long l) {
        if (map == null || map.isEmpty()) {
            return;
        }
        logger.trace((Object)("forecastRunID: " + l + " forecastErrors: " + map.size()));
        String string = "INSERT INTO " + this.forecastMessagesTable + " (forecast_id, forecast_object_id, " + "forecast_object_type, message_type, message) " + "VALUES(" + l + ",?,?,?,?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            Set<ForecastableEvent> set = map.keySet();
            for (ForecastableEvent forecastableEvent : set) {
                Exception exception = map.get(forecastableEvent);
                logger.trace((Object)(l + ", " + forecastableEvent.getID() + ", " + ForecastMessageObjectType.forecastableEventToEnum(forecastableEvent).persistanceCode + ", " + ForecastMessageType.OBJECT_EXCLUDED.persistanceCode() + ", " + this.nestedMsgText(exception)));
                preparedStatement.setLong(1, forecastableEvent.getID());
                preparedStatement.setString(2, ForecastMessageObjectType.forecastableEventToEnum(forecastableEvent).persistanceCode);
                preparedStatement.setString(3, ForecastMessageType.OBJECT_EXCLUDED.persistanceCode());
                preparedStatement.setString(4, this.nestedMsgText(exception));
                int n = preparedStatement.executeUpdate();
                if (n >= 0) continue;
                throw new RuntimeException("Forecast message record was not created.");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error saving forecast messages.", exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private boolean isJobQueueExistsForAgent(long l, String string) {
        String string2 = "SELECT COUNT(*) FROM " + this.jobQueuesTable + " WHERE target_id=? AND name=?";
        Object[] objectArray = new Object[]{new Long(l), string};
        try {
            return this.doCount(string2, objectArray) > 0;
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error while checking if job queue {0} exists in the database, for the agent with ID {1}. {2}. It will be assumed not to exist.", (Object[])new Object[]{string, l, this.nestedMsgText(exception)}));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJobQueueExistsForAllAgentsInGroup(long l, String string) throws ResourceUnavailableException {
        long[] lArray = this.agentGroupDM.getAgentsIDsInGroup(l, null);
        if (lArray.length == 0) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"There are no agents in the Agent Group with ID {0}.", (Object[])new Object[]{l}));
        }
        String string2 = "SELECT COUNT(*) FROM " + this.jobQueuesTable + " WHERE target_id=? AND name=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(2, string);
            for (long l2 : lArray) {
                int n;
                preparedStatement.setLong(1, l2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                } else {
                    logger.warn((Object)MessageUtil.formatMsg((String)"Unable to get a count back from the database while checking if job queue {0} exists in the database, for the agent with ID {1}. It will be assumed not to exist.", (Object[])new Object[]{string, l2}));
                    n = 0;
                }
                if (n != 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error while checking if job queue {0} exists in the database, for each agent in the Agent Group with ID {1}. {2}. It will be assumed that it does not exist for each agent.", (Object[])new Object[]{string, l, this.nestedMsgText(exception)}));
            int n = 0;
            return n != 0;
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String jobQueueName(ForecastableEvent forecastableEvent, long l, Map<ForecastableEvent, AgentGroupProxy> map) throws ResourceUnavailableException {
        String string = forecastableEvent.getJobQueueName();
        boolean bl = map.containsKey(forecastableEvent);
        if (bl && !string.trim().equalsIgnoreCase("Default")) {
            AgentGroupProxy agentGroupProxy = map.get(forecastableEvent);
            switch (agentGroupProxy.getAgentGroupType()) {
                case ALL_AGENTS: {
                    if (this.isJobQueueExistsForAgent(l, string)) break;
                    string = "Default";
                    break;
                }
                case UTILIZATION_BALANCED: 
                case PREFERRED_AGENT: {
                    long l2 = agentGroupProxy.getOid();
                    if (this.isJobQueueExistsForAllAgentsInGroup(l2, string)) break;
                    string = "TBD";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{agentGroupProxy.getAgentGroupType()}));
                }
            }
        }
        return string;
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private void populateSuiteEventID(long l) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.forecastProcessEventsTable + " SET job_suite_forecast_process_event_id=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Forecast process event number {0} was not found.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while populating the job suite forecast process event ID for forecast process event number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private AgentGroupType retrieveAgentGroupType(long l, Connection connection) throws ResourceUnavailableException {
        try {
            AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l, connection);
            return agentGroupProxy.getAgentGroupType();
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group type because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
        }
    }

    private long retrieveGeneratedID(Statement statement) throws NoDataException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Statement", (Object)statement);
        ResultSet resultSet = null;
        try {
            resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
            try {
                String string = "There were no generated keys returned.";
                throw new NoDataException(string);
            }
            catch (SQLException sQLException) {
                String string = "SQL error while retrieving generated keys.";
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String scheduleTypeSelection(ForecastDefinition forecastDefinition) {
        return this.scheduleTypeSelection(forecastDefinition.isExcludeTimedIntervalJobs(), forecastDefinition.isExcludeDailyIntervalJobs());
    }

    private String scheduleTypeSelection(boolean bl, boolean bl2) {
        String string = "(schedule_type='DW' OR schedule_type='DP' OR schedule_type='DL' OR schedule_type='UJ' OR schedule_type='CE' OR schedule_type='RDW' OR schedule_type='RDP' OR schedule_type='RDL'OR schedule_type='" + ScheduleJobProxy.ScheduleType.SAP_RUN_INTERCEPT.persistanceCode() + "'";
        if (!bl) {
            string = string + " OR schedule_type='TI'";
        }
        if (!bl2) {
            string = string + " OR schedule_type='DC'";
        }
        string = string + ")";
        return string;
    }

    private void setActualRowID(ForecastedEvent forecastedEvent, long l) {
        ForecastedObjectRunID forecastedObjectRunID = forecastedEvent.getForecastedObjectRunID();
        if (forecastedObjectRunID != null) {
            if (forecastedObjectRunID.isActual()) {
                throw new IllegalStateException("Program error. Cannot overlay an actual Row ID.");
            }
            forecastedObjectRunID.setActualID(l);
        }
    }

    private String toHistoryTypeString(ForecastedObjectType forecastedObjectType) {
        switch (forecastedObjectType) {
            case JOB: 
            case JOB_SUITE: 
            case MEMBER_JOB: {
                return "JobHistory";
            }
            case AGENT_EVENT: {
                return "AgentEventHistory";
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecasted Object Type {0} is not supported by this method.", (Object[])new Object[]{forecastedObjectType}));
    }

    private LocalHHMM toLocalHHMM(int n) {
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        try {
            return new LocalHHMM(n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new LocalHHMM();
        }
    }

    private String toPrereqEventType_forMessageString(PrereqEventType prereqEventType) {
        switch (prereqEventType) {
            case JOB_STATUS_CHANGE: {
                return "Job";
            }
            case AGENT_EVENT: {
                return "Agent event";
            }
        }
        return prereqEventType.toString();
    }

    private void updateFirstLastRuntimes(ForecastedEvent[] forecastedEventArray, Map<AgentJobKey, AgentJobInfo> map) throws ResourceUnavailableException {
        long l;
        long l2;
        for (ForecastedEvent forecastedEvent : forecastedEventArray) {
            l2 = forecastedEvent.getAgentID();
            l = this.getJobID(forecastedEvent);
            long l3 = this.getMemberID(forecastedEvent);
            long l4 = forecastedEvent.getDateTime();
            AgentJobInfo agentJobInfo = map.get(new AgentJobKey(l2, l, l3));
            if (agentJobInfo != null) {
                if (l4 < agentJobInfo.firstScheduleTime) {
                    agentJobInfo.firstScheduleTime = l4;
                }
                if (l4 <= agentJobInfo.lastScheduleTime) continue;
                agentJobInfo.lastScheduleTime = l4;
                continue;
            }
            throw new IllegalStateException("Program error.");
        }
        String string = "UPDATE " + this.forecastedEventsTable + " SET first_schedule_timestamp_utc=?, " + "last_schedule_timestamp_utc=? " + "where id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            for (AgentJobInfo agentJobInfo : map.values()) {
                l2 = agentJobInfo.firstScheduleTime;
                l = agentJobInfo.lastScheduleTime;
                if (l2 == l) continue;
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                preparedStatement.setLong(3, agentJobInfo.key);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while updating the forecast job header first and last runtimes.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public void updateForecastRunData(ForecastRun forecastRun) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.forecastHistoryTable + " SET status=?, creation_end_timestamp_utc=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, forecastRun.getForecastStatus().persistanceCode());
            Calendar calendar = forecastRun.getGenerationEnd();
            if (calendar != null) {
                preparedStatement.setLong(2, calendar.getTimeInMillis());
            } else {
                preparedStatement.setLong(2, 0L);
            }
            preparedStatement.setLong(3, forecastRun.getForecastRunID());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 Forecast Run was updated (ID = {0}.", (Object[])new Object[]{forecastRun.getForecastRunID()});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the Forecast Run information for id {0}.", (Object[])new Object[]{forecastRun.getForecastRunID()});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public int failInactiveForecasts() throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.forecastHistoryTable + " SET status=?, creation_end_timestamp_utc=? WHERE status=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, ForecastStatus.FAILED.persistanceCode());
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.setLong(3, ForecastStatus.RUNNING.persistanceCode().intValue());
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                logger.debug((Object)(n + " forecast records were updated as Failed."));
            }
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while updating running forecast status to failed.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeForecasts(int n, boolean bl) throws SQLException {
        String[] stringArray;
        int n2 = 0;
        Connection connection = null;
        String string = RosettaMsg.PURGE_FORECAST_NAME.newLogEntry().getMessageText();
        String string2 = null;
        try {
            stringArray = new java.util.Date();
            long l = stringArray.getTime();
            connection = this.getConnection();
            String[] stringArray2 = new String[]{string, String.valueOf(n)};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray2);
            logger.debug((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write(connection, scheduleLogEntry);
            string2 = "delete from only forecasts using forecast_definitions where forecasts.forecast_definition_id=forecast_definitions.id and ( ( forecast_definitions.purge_history_with_system_settings=true and true=" + bl + " and " + "( " + l + " /* now milliseconds */ - forecasts.creation_start_timestamp_utc)>(" + n + " /* system days count */ * 86400000::INT8 /* 24*60*60*1000 */) " + ")" + " or " + "( " + "forecast_definitions.purge_history_with_system_settings=false and forecast_definitions.purge_history=true and " + "( " + l + " /* now milliseconds */ - forecasts.creation_start_timestamp_utc)>(forecast_definitions.purge_history_days * 86400000::INT8 /* 24*60*60*1000 */)" + ") " + ");";
            Statement statement = connection.createStatement();
            n2 = statement.executeUpdate(string2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Purged " + n2 + " forecasts"));
            }
        }
        catch (SQLException sQLException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error deleteing forecasts", (Throwable)sQLException);
                logger.debug((Object)("SQL query: " + string2));
            }
        }
        finally {
            connection.close();
        }
        if (n2 > 0) {
            stringArray = new String[]{String.valueOf(n2), string};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.FORECAST_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
    }

    private class AgentJobInfo {
        long key;
        long firstScheduleTime;
        long lastScheduleTime;

        AgentJobInfo(long l, long l2, long l3) {
            this.key = l;
            this.firstScheduleTime = l2;
            this.lastScheduleTime = l3;
        }
    }

    private class AgentJobKey {
        long agentID;
        long jobID;
        long memberID;

        AgentJobKey(long l, long l2, long l3) {
            this.agentID = l;
            this.jobID = l2;
            this.memberID = l3;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AgentJobKey)) {
                return false;
            }
            return this.agentID == ((AgentJobKey)object).agentID && this.jobID == ((AgentJobKey)object).jobID && this.memberID == ((AgentJobKey)object).memberID;
        }

        public int hashCode() {
            return (this.agentID + "." + this.jobID + "." + this.memberID).hashCode();
        }
    }

    private static enum ForecastMessageObjectType implements PersistableEnum<String>
    {
        JOB("Job"),
        JOB_SUITE("JobSuite"),
        MEMBER_JOB("MemberJob"),
        AGENT_EVENT("AgentEventMonitor");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, ForecastMessageObjectType> map;

        private ForecastMessageObjectType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static ForecastMessageObjectType persistanceCodeToEnum(String string) {
            ForecastMessageObjectType forecastMessageObjectType = map.get(string);
            if (forecastMessageObjectType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return forecastMessageObjectType;
        }

        public static ForecastMessageObjectType forecastableEventToEnum(ForecastableEvent forecastableEvent) {
            return ForecastMessageObjectType.forecastableEventTypeToEnum(forecastableEvent.getType());
        }

        public static ForecastMessageObjectType forecastableEventTypeToEnum(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return JOB;
                }
                case JOB_SUITE: {
                    return JOB_SUITE;
                }
                case MEMBER_JOB: {
                    return MEMBER_JOB;
                }
                case AGENT_EVENT_OCCURS: {
                    return AGENT_EVENT;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no {0} associated with ForecastableEvent type: {1}.", (Object[])new Object[]{map.getEnumName(), forecastableEventType}));
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ForecastMessageObjectType.values());
        }
    }

    public static enum ForecastScheduleParentType implements PersistableEnum<String>
    {
        JOB("Job"),
        JOB_SUITE("JobSuite"),
        AGENT_EVENT("AgentEventMonitor");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, ForecastScheduleParentType> map;

        private ForecastScheduleParentType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static ForecastScheduleParentType persistanceCodeToEnum(String string) {
            ForecastScheduleParentType forecastScheduleParentType = map.get(string);
            if (forecastScheduleParentType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return forecastScheduleParentType;
        }

        public static ForecastScheduleParentType forecastableEventToEnum(ForecastableEvent forecastableEvent) {
            switch (forecastableEvent.getType()) {
                case JOB_SUBMISSION: {
                    return JOB;
                }
                case JOB_SUITE: {
                    return JOB_SUITE;
                }
                case AGENT_EVENT_OCCURS: {
                    return AGENT_EVENT;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no {0} associated with ForecastableEvent type: {1}.", (Object[])new Object[]{map.getEnumName(), forecastableEvent.getType()}));
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ForecastScheduleParentType.values());
        }
    }
}

