/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.oracle;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.oracle.OracleSystemDefinition;
import com.helpsystems.enterprise.core.dm.oracle.OracleSystemDefinitionsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleSystemDefinitionsDMJdbc
extends AbstractHelpingDatabaseManager
implements OracleSystemDefinitionsDM {
    private static final String objDesc = "Oracle System Definition";
    private static final String ORACLE_SYSTEM_DEFINITIONS_TABLE = "oracle_system_definitions";
    private static final String COMMON_SQL_SELECT = "SELECT id, name, description, oracle_user_name, encrypted_password, password_salt,env_file_path, appl_short_name, responsibility, aol_user";
    private String oracleSystemDefinitionsTable;

    public OracleSystemDefinitionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.OracleSystemDefinitionsDM");
        this.oracleSystemDefinitionsTable = string2 + "." + ORACLE_SYSTEM_DEFINITIONS_TABLE;
    }

    @Override
    public OracleSystemDefinition getOracleSystemDefinition(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            OracleSystemDefinition oracleSystemDefinition;
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, name, description, oracle_user_name, encrypted_password, password_salt,env_file_path, appl_short_name, responsibility, aol_user FROM " + this.oracleSystemDefinitionsTable + " WHERE id=?";
            OracleSystemDefinitionGenerator oracleSystemDefinitionGenerator = new OracleSystemDefinitionGenerator(10);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            OracleSystemDefinition oracleSystemDefinition2 = oracleSystemDefinition = (OracleSystemDefinition)((Object)oracleSystemDefinitionGenerator.generateObject(resultSet));
            OracleSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return oracleSystemDefinition2;
        }
        try {
            try {
                throw new NoDataException("Oracle System Definition not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            OracleSystemDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class OracleSystemDefinitionGenerator
    extends AbstractBusObjGenerator {
        public OracleSystemDefinitionGenerator(int n) {
            super(n, OracleSystemDefinitionsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new OracleSystemDefinition();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            OracleSystemDefinition oracleSystemDefinition = (OracleSystemDefinition)((Object)object);
            switch (n) {
                case 1: {
                    oracleSystemDefinition.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    oracleSystemDefinition.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    oracleSystemDefinition.setDescription(string);
                    break;
                }
                case 4: {
                    oracleSystemDefinition.setOracleUserName(resultSet.getString("oracle_user_name"));
                    break;
                }
                case 5: {
                    oracleSystemDefinition.setEncryptedPassword(resultSet.getString("encrypted_password"));
                    break;
                }
                case 6: {
                    String string = resultSet.getString("password_salt");
                    if (string == null) {
                        string = "";
                    }
                    oracleSystemDefinition.setPasswordSalt(string);
                    break;
                }
                case 7: {
                    oracleSystemDefinition.setEnvironmentFilePath(resultSet.getString("env_file_path"));
                    break;
                }
                case 8: {
                    oracleSystemDefinition.setResponsibilityAppShortname(resultSet.getString("appl_short_name"));
                    break;
                }
                case 9: {
                    oracleSystemDefinition.setResponsibilityName(resultSet.getString("responsibility"));
                    break;
                }
                case 10: {
                    oracleSystemDefinition.setApplicationUsername(resultSet.getString("aol_user"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

