/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.service.JdbcService;
import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.access.service.JdbcServiceStarter;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.service.ServiceStarter;
import com.helpsystems.enterprise.access.EnterpriseDatabase;
import com.helpsystems.enterprise.core.db.JDBC_Descriptor_ID;

public class UnitTestJdbcPool {
    private static UnitTestJdbcPool defaultPool;
    private String JDBC_POOL_NAME = "JDBC_POOL";
    private String JDBC_POOL_URL = "jdbc:apache:commons:dbcp:" + this.JDBC_POOL_NAME;
    private Service jdbcPool;
    private ServiceStarter jdbcPoolStarter = new JdbcServiceStarter();

    private UnitTestJdbcPool() {
    }

    public Service startJdbcPool() throws ResourceUnavailableException {
        if (this.jdbcPool == null) {
            try {
                this.jdbcPool = this.jdbcPoolStarter.startService((ServiceDescriptor)this.getJdbcServiceDescriptor());
            }
            catch (ServiceException serviceException) {
                String string = "Error starting up the JDBC Connection Pool.";
                throw new ResourceUnavailableException(string, (Throwable)serviceException);
            }
        }
        return this.jdbcPool;
    }

    private JdbcServiceDescriptor getJdbcServiceDescriptor() {
        JdbcServiceDescriptor jdbcServiceDescriptor = EnterpriseDatabase.createDefaultJDBCServiceDescriptor(JDBC_Descriptor_ID.DEVELOPMENT);
        jdbcServiceDescriptor.setName(this.JDBC_POOL_NAME);
        return jdbcServiceDescriptor;
    }

    public void stopJdbcPool() throws ResourceUnavailableException {
        try {
            this.jdbcPoolStarter.stopService((Service)new JdbcService());
        }
        catch (ServiceException serviceException) {
            String string = "Error stopping the JDBC Connection Pool.";
            throw new ResourceUnavailableException(string, (Throwable)serviceException);
        }
    }

    String getPoolUrl() {
        return this.JDBC_POOL_URL;
    }

    public static String getJdbcPool() throws ResourceUnavailableException {
        if (defaultPool == null) {
            defaultPool = new UnitTestJdbcPool();
        }
        defaultPool.startJdbcPool();
        return defaultPool.getPoolUrl();
    }

    public static void releaseJdbcPool() throws ResourceUnavailableException {
        if (defaultPool == null) {
            defaultPool.stopJdbcPool();
        }
    }
}

