/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.SNMPTrapMonitor;
import com.helpsystems.enterprise.core.busobj.SNMPTrapMonitorProxy;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.util.SNMPMibCriteria;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SNMPTrapMonitorDMJdbc
extends AbstractDatabaseManager
implements SNMPTrapMonitorDM {
    private static final String objDesc = "SNMP Trap Monitor";
    private static Logger logger = Logger.getLogger(SNMPTrapMonitorDMJdbc.class);
    private static final String SNMP_TRAP_MONITOR_TABLE = "snmp_trap_monitors";
    private static final String SNMP_TRAP_MONITOR_FILTER_TABLE = "snmp_trap_monitor_filters";
    private String snmpTrapMonitorTable;
    private String snmpTrapMonitorFilterTable;

    public SNMPTrapMonitorDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.setName("ENTERPRISE.SNMPTrapMonitorDM");
        this.snmpTrapMonitorTable = string2 + "." + SNMP_TRAP_MONITOR_TABLE;
        this.snmpTrapMonitorFilterTable = string2 + "." + SNMP_TRAP_MONITOR_FILTER_TABLE;
    }

    @Override
    public SNMPTrapMonitor[] getList(boolean bl) throws ResourceUnavailableException, DataException {
        SNMPTrapMonitor[] sNMPTrapMonitorArray = new SNMPTrapMonitor[]{};
        String string = "SELECT id, name, description, send_email, notification_list_id, from_time, to_time, disabled, days_to_retain, system_defaults_for_event_log_purge FROM " + this.snmpTrapMonitorTable;
        if (!bl) {
            string = string + " WHERE disabled = false";
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        SNMPTrapMonitorGenerator sNMPTrapMonitorGenerator = new SNMPTrapMonitorGenerator();
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<SNMPTrapMonitor> arrayList = new ArrayList<SNMPTrapMonitor>();
            while (resultSet.next()) {
                SNMPTrapMonitor sNMPTrapMonitor = (SNMPTrapMonitor)((Object)sNMPTrapMonitorGenerator.generateObject(resultSet));
                arrayList.add(sNMPTrapMonitor);
            }
            sNMPTrapMonitorArray = arrayList.toArray(new SNMPTrapMonitor[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving SNMP Trap Monitors.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return sNMPTrapMonitorArray;
    }

    @Override
    public SNMPTrapMonitorProxy[] getProxyList() throws ResourceUnavailableException, DataException {
        SNMPTrapMonitorProxy[] sNMPTrapMonitorProxyArray = new SNMPTrapMonitorProxy[]{};
        SNMPTrapMonitorProxyGenerator sNMPTrapMonitorProxyGenerator = new SNMPTrapMonitorProxyGenerator();
        String string = "SELECT id, name, description, days_to_retain, system_defaults_for_event_log_purge FROM " + this.snmpTrapMonitorTable;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<SNMPTrapMonitorProxy> arrayList = new ArrayList<SNMPTrapMonitorProxy>();
            while (resultSet.next()) {
                SNMPTrapMonitorProxy sNMPTrapMonitorProxy = (SNMPTrapMonitorProxy)((Object)sNMPTrapMonitorProxyGenerator.generateObject(resultSet));
                arrayList.add(sNMPTrapMonitorProxy);
            }
            sNMPTrapMonitorProxyArray = arrayList.toArray(new SNMPTrapMonitorProxy[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving SNMP Trap Monitors.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return sNMPTrapMonitorProxyArray;
    }

    public SNMPTrapMonitor get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public SNMPTrapMonitor get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        boolean bl = false;
        Connection connection2 = null;
        SNMPTrapMonitorGenerator sNMPTrapMonitorGenerator = new SNMPTrapMonitorGenerator();
        String string = "SELECT id, name, description, send_email, notification_list_id, from_time, to_time, disabled, days_to_retain, system_defaults_for_event_log_purge FROM " + this.snmpTrapMonitorTable + " WHERE id=?";
        try {
            if (connection == null) {
                connection2 = this.getConnection();
            } else {
                connection2 = connection;
                bl = true;
            }
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            Object object = preparedStatement.executeQuery();
            if (object.next()) {
                SNMPTrapMonitor sNMPTrapMonitor;
                SNMPTrapMonitor sNMPTrapMonitor2 = sNMPTrapMonitor = (SNMPTrapMonitor)((Object)sNMPTrapMonitorGenerator.generateObject((ResultSet)object));
                return sNMPTrapMonitor2;
            }
            try {
                throw new NoDataException("SNMP Trap Monitor not found.");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                SNMPTrapMonitorDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    private void loadDataFilter(SNMPTrapMonitor sNMPTrapMonitor, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, oid_filter, field_name, condition, value FROM " + this.snmpTrapMonitorFilterTable + " WHERE snmp_trap_monitor_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, sNMPTrapMonitor.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            DataFilter dataFilter = new DataFilter();
            dataFilter.setConjunction(0);
            while (resultSet.next()) {
                String string2;
                try {
                    boolean bl = resultSet.getBoolean("oid_filter");
                    string2 = resultSet.getString("field_name");
                    int n = resultSet.getInt("condition");
                    String string3 = resultSet.getString("value");
                    SNMPMibCriteria sNMPMibCriteria = bl ? new SNMPMibCriteria(string2, (Serializable)((Object)string3), n) : new FilterCriteria(string2, (Serializable)((Object)string3), n);
                    dataFilter.addCriteria((FilterCriteria)sNMPMibCriteria);
                }
                catch (Exception exception) {
                    string2 = "Error while retrieving the data filter.";
                    logger.debug((Object)string2, (Throwable)exception);
                }
            }
            sNMPTrapMonitor.setDataFilter(dataFilter);
        }
        catch (Exception exception) {
            String string4 = "Error while retrieving the data filter.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new RuntimeException(string4, exception);
        }
    }

    private class SNMPTrapMonitorProxyGenerator
    extends AbstractBusObjGenerator {
        public SNMPTrapMonitorProxyGenerator() {
            super(5, SNMPTrapMonitorDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SNMPTrapMonitorProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SNMPTrapMonitorProxy sNMPTrapMonitorProxy = (SNMPTrapMonitorProxy)((Object)object);
            switch (n) {
                case 1: {
                    sNMPTrapMonitorProxy.setID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sNMPTrapMonitorProxy.setName(resultSet.getString("name"));
                    break;
                }
                case 3: {
                    sNMPTrapMonitorProxy.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    sNMPTrapMonitorProxy.setDaysToRetainHistory(resultSet.getInt("days_to_retain"));
                    break;
                }
                case 5: {
                    sNMPTrapMonitorProxy.setUseDefaultsForHistoryPurge(resultSet.getBoolean("system_defaults_for_event_log_purge"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class SNMPTrapMonitorGenerator
    extends AbstractBusObjGenerator {
        public SNMPTrapMonitorGenerator() {
            super(11, SNMPTrapMonitorDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SNMPTrapMonitor();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SNMPTrapMonitor sNMPTrapMonitor = (SNMPTrapMonitor)((Object)object);
            switch (n) {
                case 1: {
                    sNMPTrapMonitor.setID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sNMPTrapMonitor.setName(resultSet.getString("name"));
                    break;
                }
                case 3: {
                    sNMPTrapMonitor.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    sNMPTrapMonitor.setSendEmail(resultSet.getBoolean("send_email"));
                    break;
                }
                case 5: {
                    sNMPTrapMonitor.setNotificationListID(resultSet.getLong("notification_list_id"));
                    break;
                }
                case 6: {
                    sNMPTrapMonitor.setFromTime(resultSet.getInt("from_time"));
                    break;
                }
                case 7: {
                    sNMPTrapMonitor.setToTime(resultSet.getInt("to_time"));
                    break;
                }
                case 8: {
                    sNMPTrapMonitor.setDisabled(resultSet.getBoolean("disabled"));
                    break;
                }
                case 9: {
                    sNMPTrapMonitor.setDaysToRetainHistory(resultSet.getInt("days_to_retain"));
                    break;
                }
                case 10: {
                    sNMPTrapMonitor.setUseDefaultsForHistoryPurge(resultSet.getBoolean("system_defaults_for_event_log_purge"));
                    break;
                }
                case 11: {
                    Connection connection = resultSet.getStatement().getConnection();
                    SNMPTrapMonitorDMJdbc.this.loadDataFilter(sNMPTrapMonitor, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

