/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.dm.ReactivityDayOfPeriodDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReactivityDayOfPeriodDMJdbc
extends AbstractDatabaseManager
implements ReactivityDayOfPeriodDM {
    private static final String description = "Reactivity Day Of Period";
    private String table;
    ReactivityDayOfPeriodGenerator boGenerator = new ReactivityDayOfPeriodGenerator();

    public ReactivityDayOfPeriodDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.table = string2 + "." + "REACTIVITY_DAY_OF_PERIODS";
        this.setName("ENTERPRISE.ReactivityDayOfPeriodDM");
    }

    private String getSql() {
        return "SELECT id, job_id, day_number, period_type, react_after, react_before, react_after_option, react_before_option FROM " + this.table;
    }

    @Override
    public ReactivityDayOfPeriod[] get(long l) throws ResourceUnavailableException, DataException {
        String string = this.getSql() + " where job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ReactivityDayOfPeriod[] reactivityDayOfPeriodArray;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<ReactivityDayOfPeriod[]> arrayList = new ArrayList<ReactivityDayOfPeriod[]>();
            while (resultSet.next()) {
                reactivityDayOfPeriodArray = (ReactivityDayOfPeriod[])this.boGenerator.generateObject(resultSet);
                arrayList.add(reactivityDayOfPeriodArray);
            }
            if (arrayList.size() > 1) {
                throw new IllegalArgumentException("More than one object was loaded for Job ID " + l);
            }
            reactivityDayOfPeriodArray = new ReactivityDayOfPeriod[]{};
            ReactivityDayOfPeriod[] reactivityDayOfPeriodArray2 = reactivityDayOfPeriodArray = arrayList.toArray(reactivityDayOfPeriodArray);
            return reactivityDayOfPeriodArray2;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{description, Long.toString(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class ReactivityDayOfPeriodGenerator
    extends AbstractBusObjGenerator {
        public ReactivityDayOfPeriodGenerator() {
            super(8, ReactivityDayOfPeriodDMJdbc.description);
        }

        protected Object constructObject() {
            return new ReactivityDayOfPeriod();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ReactivityDayOfPeriod reactivityDayOfPeriod = (ReactivityDayOfPeriod)object;
            switch (n) {
                case 1: {
                    reactivityDayOfPeriod.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    reactivityDayOfPeriod.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    reactivityDayOfPeriod.setDayNumber(resultSet.getInt("day_number"));
                    break;
                }
                case 4: {
                    String string = resultSet.getString("period_type");
                    reactivityDayOfPeriod.setPeriodType(CalendarObject.PeriodType.persistanceCodeToEnum(string));
                    break;
                }
                case 5: {
                    reactivityDayOfPeriod.setStartTime(resultSet.getInt("react_after"));
                    break;
                }
                case 6: {
                    reactivityDayOfPeriod.setEndTime(resultSet.getInt("react_before"));
                    if (!resultSet.wasNull()) break;
                    reactivityDayOfPeriod.setEndTime(TimeHelper.END_OF_DAY_TIME);
                    break;
                }
                case 7: {
                    int n2 = resultSet.getInt("react_after_option");
                    reactivityDayOfPeriod.setStartOption(WindowStartOption.persistanceCodeToEnum(n2));
                    break;
                }
                case 8: {
                    int n3 = resultSet.getInt("react_before_option");
                    reactivityDayOfPeriod.setEndOption(WindowEndOption.persistanceCodeToEnum(n3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

