/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.PersistedJobQueueEntry;
import com.helpsystems.enterprise.core.dm.PersistedJobQueueEntryDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PersistedJobQueueEntryDMJdbc
extends AbstractHelpingDatabaseManager
implements PersistedJobQueueEntryDM {
    private static final String objDesc = "PersistedJobQueueEntry";

    public PersistedJobQueueEntryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.PersistedJobQueueEntryDM");
    }

    @Override
    public int delete(long l) throws ResourceUnavailableException, DataException {
        int n;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from persisted_job_queue_entries where job_history_id = ?");
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to purge records for event ID " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                PersistedJobQueueEntryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        PersistedJobQueueEntryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n;
    }

    @Override
    public PersistedJobQueueEntry[] getAllEntries() throws ResourceUnavailableException, DataException {
        PersistedJobQueueEntry[] persistedJobQueueEntryArray = new PersistedJobQueueEntry[]{};
        PersistedJobQueueEntryGenerator persistedJobQueueEntryGenerator = new PersistedJobQueueEntryGenerator();
        String string = "SELECT job_history_id, action, group_id, created_at FROM persisted_job_queue_entries ORDER BY created_at";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<PersistedJobQueueEntry> arrayList = new ArrayList<PersistedJobQueueEntry>();
            while (resultSet.next()) {
                PersistedJobQueueEntry persistedJobQueueEntry = (PersistedJobQueueEntry)((Object)persistedJobQueueEntryGenerator.generateObject(resultSet));
                arrayList.add(persistedJobQueueEntry);
            }
            persistedJobQueueEntryArray = arrayList.toArray(new PersistedJobQueueEntry[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} objects from the table {1}.", (Object[])new Object[]{objDesc, "persisted_job_queue_entries"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return persistedJobQueueEntryArray;
    }

    @Override
    public void save(PersistedJobQueueEntry[] persistedJobQueueEntryArray) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            for (int i = 0; i < persistedJobQueueEntryArray.length; ++i) {
                PersistedJobQueueEntry persistedJobQueueEntry = persistedJobQueueEntryArray[i];
                super.save((Connection)wrappedConnection, (Object)persistedJobQueueEntry);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error saving PersistedJobQueueEntry. ", (Throwable)sQLException);
        }
        finally {
            PersistedJobQueueEntryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public void save(PersistedJobQueueEntry persistedJobQueueEntry) throws ResourceUnavailableException, DataException {
        PersistedJobQueueEntry[] persistedJobQueueEntryArray = new PersistedJobQueueEntry[]{persistedJobQueueEntry};
        this.save(persistedJobQueueEntryArray);
    }

    @Override
    public int delete(ArrayList<Long> arrayList) throws ResourceUnavailableException, DataException {
        int n;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        Long l2 = 0L;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from persisted_job_queue_entries where job_history_id = ?");
            for (Long l2 : arrayList) {
                preparedStatement.setLong(1, l2);
                n2 += preparedStatement.executeUpdate();
            }
            n = n2;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to purge records for event ID " + l2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                PersistedJobQueueEntryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        PersistedJobQueueEntryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n;
    }

    private class PersistedJobQueueEntryGenerator
    extends AbstractBusObjGenerator {
        public PersistedJobQueueEntryGenerator() {
            super(4, PersistedJobQueueEntryDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new PersistedJobQueueEntry();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            PersistedJobQueueEntry persistedJobQueueEntry = (PersistedJobQueueEntry)((Object)object);
            switch (n) {
                case 1: {
                    persistedJobQueueEntry.setJobHistoryOID(resultSet.getLong("job_history_id"));
                    break;
                }
                case 2: {
                    persistedJobQueueEntry.setAction_asInt(resultSet.getInt("action"));
                    break;
                }
                case 3: {
                    persistedJobQueueEntry.setGroupID(resultSet.getInt("group_id"));
                    break;
                }
                case 4: {
                    persistedJobQueueEntry.setCreatedAt(resultSet.getTimestamp("created_at"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

