/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.RecordActionType;
import com.helpsystems.enterprise.core.dm.JobMonitorEventCountRollupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.DateConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class JobMonitorEventCountRollupDMJdbc
extends AbstractHelpingDatabaseManager
implements JobMonitorEventCountRollupDM {
    private static final String TABLE = "job_monitor_event_count_rollups";
    private static final Logger logger = Logger.getLogger(JobMonitorEventCountRollupDMJdbc.class);
    private Object lockObject = new Object();

    public JobMonitorEventCountRollupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobMonitorEventCountRollupDM");
    }

    @Override
    public void saveJobMonEventsCount(int n, long l) throws ResourceUnavailableException, DataException {
        String string = null;
        switch (n) {
            case 1: {
                string = "job_underrun_count";
                break;
            }
            case 2: {
                string = "job_overrun_count";
                break;
            }
            case 3: {
                string = "late_start_count";
                break;
            }
            default: {
                logger.error((Object)("Event type is not valid: " + n));
            }
        }
        if (string != null) {
            this.updateInsertRow(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInsertRow(String string, long l) {
        long l2 = DateConverter.calculateDay(l);
        Object object = this.lockObject;
        synchronized (object) {
            RecordActionType recordActionType = this.getCurrentRowAction(l2);
            if (recordActionType == RecordActionType.UPDATE) {
                this.updateRow(string, l2);
            } else if (recordActionType == RecordActionType.INSERT) {
                this.insertRow(string, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RecordActionType getCurrentRowAction(long l) {
        RecordActionType recordActionType = RecordActionType.IGNORE;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT 1 FROM job_monitor_event_count_rollups WHERE day = ?";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            recordActionType = resultSet.next() ? RecordActionType.UPDATE : RecordActionType.INSERT;
            if (wrappedConnection == null) return recordActionType;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            if (wrappedConnection == null) return recordActionType;
            JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Selecting job_monitor_event_count_rollups for specified Day", (Throwable)sQLException);
            if (wrappedConnection == null) return recordActionType;
            {
                catch (Throwable throwable) {
                    if (wrappedConnection == null) throw throwable;
                    JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return recordActionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateRow(String string, long l) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            String string2 = "UPDATE job_monitor_event_count_rollups SET " + string + " = " + string + " + 1 " + "WHERE day = ?";
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Updating to job_monitor_event_count_rollups table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
            }
        }
        JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertRow(String string, long l) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string2 = null;
        PreparedStatement preparedStatement = null;
        try {
            string2 = "INSERT INTO job_monitor_event_count_rollups (day, " + string + ") values (?, 1)";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Inserting to job_monitor_event_count_rollups table ", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobMonitorEventCountRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manualJobMonEventsPurge(long l) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            long l2 = DateConverter.getCompDay(l);
            logger.debug((Object)("Purging Job Monitor Event Count Rollup older than: " + ScheduleLogger.formatTimeStamp(l2)));
            wrappedConnection = this.getConnectionOrFail();
            String string = "DELETE FROM job_monitor_event_count_rollups WHERE day < ?";
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Deleting from job_monitor_event_count_rollups table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobMonitorEventCountRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobMonitorEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }
}

