/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.jdbc.ResultSetSimpleList;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobHistoryProxy;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.OutputDistributionHistory;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.AgentLogAM;
import com.helpsystems.enterprise.core.dm.EmailTargetAttachmentDM;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobSuiteAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.forecast.ForecastDurations;
import com.helpsystems.enterprise.core.forecast.ForecastJobAgentPair;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class JobHistoryDMJdbc
extends AbstractHelpingDatabaseManager
implements JobHistoryDM {
    private static final Logger logger = Logger.getLogger(JobHistoryDMJdbc.class);
    private static final String TABLE = "job_histories";
    private static final String JOBS_TABLE = "jobs";
    private String table;
    private ReactivityAM reactivityAM;
    private JobSuiteAM jobSuiteAM;
    private EventHistoryXRefDM eventHistoryXRefDM;
    private AgentLogAM agentLogAM = null;
    private ArrayList<String> parentRootArray;
    private OutputDistributionHistoryDM odhDM = null;
    private OutputDistributionAM odAM = null;
    private EmailTargetAttachmentDM etaDM = null;
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM = null;
    private ActivityMatcherAM activityMatcherAM;
    private String jobStatusFilterClause;

    public JobHistoryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, ActivityMatcherAM activityMatcherAM) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.table = string2 + "." + TABLE;
        this.setName("ENTERPRISE.JobHistoryDM");
        ValidationHelper.checkForNull((String)"ActivityMatcherAM", (Object)activityMatcherAM);
        this.activityMatcherAM = activityMatcherAM;
    }

    public static final boolean isOkToDeleteJobHistory(JobStatusCode jobStatusCode, boolean bl) {
        List<JobStatusCode> list = JobStatusCode.TERMINAL_STATES;
        if (bl) {
            list = JobStatusCode.MANUAL_PURGE_TERMINAL_STATES;
        }
        if (jobStatusCode == null) {
            throw new IllegalArgumentException("The Job status code is required.");
        }
        if (list.contains(jobStatusCode)) {
            return true;
        }
        throw new IllegalStateException("Cannot delete Job History for jobs in status " + jobStatusCode.name());
    }

    @Override
    public JobHistory get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobHistory getWithAgentEnvironment(long l) throws ResourceUnavailableException, DataException {
        JobHistory jobHistory = this.get(l, null);
        String string = "SELECT agent_environment_type FROM jobs WHERE ID = ?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, jobHistory.getJobID());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoDataException("No Automate Schedule job found in jobs for job ID " + jobHistory.getJobID());
            }
            String string2 = resultSet.getString("agent_environment_type");
            logger.trace((Object)("Job History ID " + l + " agentEnvironmentType set to: " + string2));
            jobHistory.setAgentEnvironmentType(string2);
        }
        catch (SQLException sQLException) {
            try {
                logger.error((Object)("Error getting agentEnvironmentType for JobHistory ID " + l));
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
            JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        }
        JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return jobHistory;
    }

    @Override
    public JobHistory get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        JobHistory jobHistory = new JobHistory();
        jobHistory.setId(l);
        jobHistory = connection != null ? (JobHistory)((Object)super.get(connection, (Object)jobHistory)) : (JobHistory)((Object)super.get((Object)jobHistory));
        if (jobHistory == null) {
            throw new NoDataException("The Job History for oid " + l + " was not found.");
        }
        return jobHistory;
    }

    @Override
    public ArrayList<Long> getInitJobs() throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id FROM " + this.table + " WHERE job_status = '" + JobStatusCode.INITIATED.persistanceCode() + "' ORDER BY id asc";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                ++n;
                arrayList.add(resultSet.getLong("id"));
            }
            logger.debug((Object)("Found " + n + " job(s) in INIT state."));
        }
        catch (Exception exception) {
            try {
                String string = "Error collecting Job History records in INIT state.";
                logger.debug((Object)string, (Throwable)exception);
                throw new ResourceUnavailableException(string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public ArrayList<Long> getConditionalJobs() throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id FROM " + this.table + " WHERE job_status = '" + JobStatusCode.CONDITION_CHECK.persistanceCode() + "' OR job_status = '" + JobStatusCode.CONDITION_RETRY_WAIT.persistanceCode() + "' ORDER BY id asc";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (Exception exception) {
            try {
                String string = "Error collecting Job History records in Condition_check or Contition_Retry_Wait states.";
                logger.debug((Object)string, (Throwable)exception);
                throw new ResourceUnavailableException(string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public JobHistoryProxy getProxy(long l) throws ResourceUnavailableException, DataException {
        return this.getProxy(l, null);
    }

    @Override
    public JobHistoryProxy getProxy(long l, Connection connection) throws DataException, ResourceUnavailableException {
        JobHistoryProxy jobHistoryProxy = new JobHistoryProxy();
        jobHistoryProxy.setId(l);
        jobHistoryProxy = connection != null ? (JobHistoryProxy)((Object)super.get(connection, (Object)jobHistoryProxy)) : (JobHistoryProxy)((Object)super.get((Object)jobHistoryProxy));
        if (jobHistoryProxy == null) {
            throw new NoDataException("The Job History for oid " + l + " was not found.");
        }
        return jobHistoryProxy;
    }

    @Override
    public int getManagedJobCount() throws ResourceUnavailableException, DataException {
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE job_status=?";
        Object[] objectArray = new Object[]{JobStatusCode.MANAGED.persistanceCode()};
        try {
            return this.doCount(string, objectArray);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if Managed job histories exists.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public boolean hasJobEnded(long l) throws DataException, DataSetException, ResourceUnavailableException {
        Iterator<JobStatusCode> iterator = JobStatusCode.TERMINAL_STATES.iterator();
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE id=? and job_status in (";
        boolean bl = false;
        while (iterator.hasNext()) {
            if (bl) {
                string = string + ",";
            }
            String string2 = iterator.next().persistanceCode();
            string = string + "'" + string2 + "'";
            bl = true;
        }
        string = string + ")";
        Object[] objectArray = new Object[]{l};
        try {
            if (this.doCount(string, objectArray) > 0) {
                if (logger.isTraceEnabled()) {
                    String string3 = "Job with Run ID " + l + " is in a terminal status.";
                    logger.trace((Object)string3);
                }
                return true;
            }
            if (logger.isTraceEnabled()) {
                String string4 = "Job with Run ID " + l + " is not in a terminal status.";
                logger.trace((Object)string4);
            }
            return false;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if job history is in a terminal status.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public boolean isJobRunningOrHasEnded(long l) {
        JobStatusCode jobStatusCode;
        try {
            JobHistoryProxy jobHistoryProxy = this.getProxy(l);
            jobStatusCode = jobHistoryProxy.getStatusCode();
        }
        catch (NoDataException noDataException) {
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to determine the status of run ID {0}.", (Object[])new Object[]{l}), exception);
        }
        switch (jobStatusCode) {
            case RUNNING: 
            case COMPLETED: 
            case FAILED: 
            case CANCELED: {
                return true;
            }
            case ERROR: {
                return false;
            }
            case INITIATED: 
            case SUBMITTED: 
            case CONDITION_CHECK: 
            case CONDITION_RETRY_WAIT: 
            case SKIPPED: 
            case MANAGED: 
            case MEMBER_CANCELED: 
            case MEMBER_FAILED: {
                return false;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Status {0} is not supported by this method.", (Object[])new Object[]{jobStatusCode}));
    }

    @Override
    public JobHistoryProxy[] getByJobId(long l) throws DataException, ResourceUnavailableException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("getJobID", l);
        JobHistoryProxy[] jobHistoryProxyArray = (JobHistoryProxy[])super.search((Object)new JobHistoryProxy(), hashMap);
        return jobHistoryProxyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleAgentKey[] getAgentsWithJobHistory(long l) {
        ArrayList<SimpleAgentKey> arrayList = new ArrayList<SimpleAgentKey>();
        String string = "select distinct agent_id, agent_name from job_histories where job_id = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("agent_id");
                String string2 = resultSet.getString("agent_name");
                SimpleAgentKey simpleAgentKey = new SimpleAgentKey(l2, string2);
                arrayList.add(simpleAgentKey);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error getting agents with history for job: " + l), (Throwable)exception);
        }
        finally {
            super.closeConnection((Statement)preparedStatement);
        }
        SimpleAgentKey[] simpleAgentKeyArray = new SimpleAgentKey[]{};
        simpleAgentKeyArray = arrayList.toArray(simpleAgentKeyArray);
        return arrayList.toArray(simpleAgentKeyArray);
    }

    public JobHistoryProxy getById(long l) throws DataException, ResourceUnavailableException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("getId", l);
        JobHistoryProxy[] jobHistoryProxyArray = (JobHistoryProxy[])super.search((Object)new JobHistoryProxy(), hashMap);
        return jobHistoryProxyArray[0];
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int purgeForJob(Connection connection, long l, int n, long l2, long l3) throws ResourceUnavailableException, DataException {
        int n2;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT id, job_id, agent_id, job_name, agent_name, job_status, was_missed, copied_joblog_to_server, server_ended_time_utc, job_priority, agent_ended_time_utc, job_suite_history_id, job_suite_member_job_id, job_suite_id FROM " + this.table + " WHERE job_id=?  and job_status in ('" + JobStatusCode.CANCELED.persistanceCode() + "','" + JobStatusCode.COMPLETED.persistanceCode() + "','" + JobStatusCode.ERROR.persistanceCode() + "','" + JobStatusCode.FAILED.persistanceCode() + "','" + JobStatusCode.SKIPPED.persistanceCode() + "')";
        if (l3 != 0L && l2 != 0L) {
            string = string + " AND agent_id=? AND agent_group_id=?";
        } else if (l3 != 0L && l2 == 0L) {
            string = string + " AND agent_group_id!=?";
        }
        string = string + " ORDER BY id desc";
        try {
            connection2 = connection != null ? connection : super.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(string, connection2);
            JobHistoryProxyGenerator jobHistoryProxyGenerator = new JobHistoryProxyGenerator();
            preparedStatement.setLong(1, l);
            if (l3 != 0L && l2 != 0L) {
                preparedStatement.setLong(2, l2);
                preparedStatement.setLong(3, l3);
            } else if (l3 != 0L && l2 == 0L) {
                preparedStatement.setLong(2, l3);
            }
            resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            int n4 = 0;
            while (resultSet.next()) {
                if (++n3 <= n) continue;
                JobHistoryProxy jobHistoryProxy = (JobHistoryProxy)((Object)jobHistoryProxyGenerator.generateObject(resultSet));
                this.purgeJobHistory(connection2, jobHistoryProxy, null);
                ++n4;
            }
            n2 = n4;
        }
        catch (SQLException sQLException) {
            try {
                String string2 = "Error purging Job History for jobID " + l;
                logger.debug((Object)string2, (Throwable)sQLException);
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
                catch (Throwable throwable) {
                    String string3 = "Error purging Job History for jobID " + l;
                    logger.debug((Object)string3, throwable);
                    throw new ResourceUnavailableException(string3, throwable);
                }
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm(null, preparedStatement, resultSet);
                if (connection == null) {
                    JobHistoryDMJdbc.closeEm((Connection)connection2, null, null);
                }
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        if (connection == null) {
            JobHistoryDMJdbc.closeEm((Connection)connection2, null, null);
        }
        return n2;
    }

    private void purgeJobHistory(Connection connection, JobHistoryProxy jobHistoryProxy, String string) {
        String string2;
        if (logger.isDebugEnabled()) {
            string2 = jobHistoryProxy.getServerEndedTime() > 0L ? ScheduleLogger.formatTimeStamp(jobHistoryProxy.getServerEndedTime()) : "0";
            logger.debug((Object)MessageUtil.formatMsg((String)"  Purged run {0} ended {1} for {2} {3}", (Object[])new Object[]{jobHistoryProxy.getId(), string2, this.jobType(jobHistoryProxy), jobHistoryProxy.getJobName()}));
        }
        string2 = null;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deleting job history for job " + jobHistoryProxy.getJobName() + " with run number " + jobHistoryProxy.getId()));
        }
        if (jobHistoryProxy.isCopiedJobLogToServer()) {
            try {
                string2 = this.getAgentLogAM().purgeAndGetParentDirectory(jobHistoryProxy.getId(), jobHistoryProxy.getAgentName(), jobHistoryProxy.getJobName(), jobHistoryProxy.getAgentEndedTime());
            }
            catch (Exception exception) {
                logger.debug((Object)("Error deleting Job log for run number " + jobHistoryProxy.getId()), (Throwable)exception);
                string2 = null;
            }
        }
        try {
            long l = jobHistoryProxy.getId();
            this.removeOutputDistributionHistory(connection, l);
            this.removeEmailTargetAttachment(connection, l);
            this.removeJobHistory(connection, l);
            if (jobHistoryProxy.getMissedCode().equals(JobMissedCode.MISSED) && string != null) {
                this.logRemoveManagedJobHistory(jobHistoryProxy, string, connection);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)("Error deleting Job History for run number " + jobHistoryProxy.getId()), (Throwable)exception);
        }
        if (string2 != null) {
            if (this.parentRootArray == null) {
                this.parentRootArray = new ArrayList();
            }
            if (!this.parentRootArray.contains(string2)) {
                this.parentRootArray.add(string2);
            }
        }
    }

    private void removeOutputDistributionHistory(Connection connection, long l) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            OutputDistributionHistory[] outputDistributionHistoryArray;
            if (this.odhDM == null) {
                this.odhDM = (OutputDistributionHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionHistoryDM");
            }
            if (this.odAM == null) {
                this.odAM = (OutputDistributionAM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionAM");
            }
            for (OutputDistributionHistory outputDistributionHistory : outputDistributionHistoryArray = this.odhDM.getByJobHistoryId(l)) {
                if (outputDistributionHistory.getKeepUntil() != 0L) continue;
                arrayList.add(outputDistributionHistory.getOid());
                this.odAM.purgeOutputDistributionHistoryFiles(outputDistributionHistory);
            }
            this.odhDM.limitedDelete(connection, arrayList, l);
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            resourceUnavailableException.printStackTrace();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int removeJobHistory(Connection connection, long l) throws ResourceUnavailableException {
        int n;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "DELETE FROM " + this.table + " WHERE id=?";
        try {
            connection2 = connection != null ? connection : super.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                String string2 = "Error Deleting Job History  " + l;
                logger.debug((Object)string2, (Throwable)sQLException);
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
                catch (Throwable throwable) {
                    String string3 = "Error Deleting Job History " + l;
                    logger.debug((Object)string3, throwable);
                    throw new ResourceUnavailableException(string3, throwable);
                }
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm(null, preparedStatement, resultSet);
                if (connection != null) throw throwable;
                JobHistoryDMJdbc.closeEm((Connection)connection2, null, null);
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
        if (connection != null) return n;
        JobHistoryDMJdbc.closeEm((Connection)connection2, null, null);
        return n;
    }

    private void removeEmailTargetAttachment(Connection connection, long l) {
        if (this.etaDM == null) {
            this.etaDM = (EmailTargetAttachmentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EmailTargetAttachmentDM");
        }
        try {
            this.etaDM.purgeEmailTargetAttachment(connection, l);
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            resourceUnavailableException.printStackTrace();
        }
    }

    private void logRemoveManagedJobHistory(JobHistoryProxy jobHistoryProxy, String string, Connection connection) {
        String[] stringArray = new String[]{jobHistoryProxy.getJobName(), Long.toString(jobHistoryProxy.getId()), string, ScheduleLogger.formatTimeStamp(new Date(System.currentTimeMillis()))};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.MANAGED_JOB_REMOVED_BY_USER.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(jobHistoryProxy.getAgentID());
        scheduleLogEntry.setJobID(jobHistoryProxy.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistoryProxy.getId());
        ScheduleLogger.write(connection, scheduleLogEntry);
    }

    @Override
    public JobHistory save(JobHistory jobHistory) throws ResourceUnavailableException, DataException {
        return this.save(jobHistory, false);
    }

    @Override
    public JobHistory save(JobHistory jobHistory, boolean bl) throws ResourceUnavailableException, DataException {
        return this.internal_save(jobHistory, bl, false);
    }

    @Override
    public void updatePriority(int n, long l) throws DataException, ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET job_priority=? WHERE id=?";
        int n2 = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, n);
            preparedStatement.setLong(2, l);
            n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                String string2 = MessageUtil.formatMsg((String)"Error updating job priority.  Job Run Number {0} was not found.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error updating priority for Job Run Number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateQueuedEndedTime(long l, long l2) throws DataException, ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET queue_ended_time_utc=? WHERE id=?";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                String string2 = MessageUtil.formatMsg((String)"Job number {0} was not found while updating queue ended information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error updating queue ended information for Job Run Number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateToRunning(JobHistory jobHistory) throws ResourceUnavailableException, DataException {
        boolean bl = false;
        try {
            if (this.hasJobEnded(jobHistory.getId())) {
                bl = true;
                logger.warn((Object)("Job history ID " + jobHistory.getId() + " is already in a terminal status." + "  Status will not be updated to Running."));
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Error checking if job history ID " + jobHistory.getId() + " has already ended."), (Throwable)exception);
        }
        String string = "UPDATE " + this.table + " SET server_running_time_utc=?, agent_started_time_utc=?";
        if (!bl) {
            string = string + ", job_status=?";
        }
        string = string + " WHERE id=?";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            int n2 = 1;
            preparedStatement.setLong(n2++, jobHistory.getServerRunningTime());
            preparedStatement.setLong(n2++, jobHistory.getAgentStartedTime());
            if (!bl) {
                jobHistory.setStatusCode(JobStatusCode.RUNNING);
                preparedStatement.setString(n2++, JobStatusCode.RUNNING.persistanceCode());
            }
            preparedStatement.setLong(n2, jobHistory.getId());
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                String string2 = MessageUtil.formatMsg((String)"Job History ID {0} was not found while updating to running status.", (Object[])new Object[]{jobHistory.getId()});
                throw new ResourceUnavailableException(string2);
            }
            this.closeConnection(preparedStatement);
            preparedStatement = null;
            if (!bl) {
                logger.trace((Object)("Updated history for " + jobHistory.getId() + " to Running status."));
                if (jobHistory.isJobSuiteMember()) {
                    this.jobSuiteAM.memberStatusChange(jobHistory);
                }
                this.reactivityAM.notifyJobStatusChange(jobHistory);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error updating history record to running status for Job Run Number {0}.", (Object[])new Object[]{jobHistory.getId()});
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public JobHistory updateToRunWithoutConditions(long l) throws ResourceUnavailableException, DataException {
        JobHistory jobHistory = this.get(l);
        jobHistory.setRetryNextTime(System.currentTimeMillis());
        jobHistory.setBypassConditions(true);
        return this.save(jobHistory, true);
    }

    @Override
    public JobHistory updateToCopiedJobLog(long l) throws ResourceUnavailableException, DataException {
        JobHistory jobHistory = this.get(l);
        jobHistory.setCopiedJobLogToServer(true);
        return this.internal_save(jobHistory, false, false);
    }

    @Override
    public void updateToIBMiSubmitted(long l, String string, String string2, String string3) throws DataException, ResourceUnavailableException {
        String string4 = "UPDATE " + this.table + " SET ibmi_job_number=?, ibmi_job_name=?, ibmi_job_user=? WHERE id=?";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string4);
        try {
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setLong(4, l);
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                String string5 = MessageUtil.formatMsg((String)"Job number {0} was not found while updating IBM i  Job information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string5);
            }
            logger.trace((Object)("Updated history for " + l + " ibmi_job_number= " + string3 + " ibmi_job_name= " + string + " ibmi_job_user= " + string2));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string6 = MessageUtil.formatMsg((String)"Error updating IBM i Job information for Job Run Number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string6, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateAgentInfo(long l, long l2) throws DataException, ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET agent_ended_time_utc=? WHERE id=?";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                String string2 = MessageUtil.formatMsg((String)"Job number {0} was not found while updating agent ended information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2);
            }
            logger.trace((Object)("Updated history for " + l + " agent_ended_time_utc = " + l2));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error updating agent ended information for Job Run Number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateJobParameters(long l, String string, String string2) throws ResourceUnavailableException {
        String string3 = "UPDATE " + this.table + " SET job_parameters=?, default_suite_parameters=? WHERE id=?";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setLong(3, l);
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                String string4 = MessageUtil.formatMsg((String)"Job number {0} was not found while updating jobParameter information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string4);
            }
            logger.trace((Object)("Updated history for " + l + " jobParameters = " + string + " defaultSuiteParameters = " + string2));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string5 = MessageUtil.formatMsg((String)"Error updating jobParameter information for Job Run Number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobHistory saveManaged(JobHistory jobHistory, boolean bl) throws ResourceUnavailableException, DataException {
        return this.internal_save(jobHistory, bl, true);
    }

    @Override
    public JobHistory saveSkipped(JobHistory jobHistory, boolean bl) throws ResourceUnavailableException, DataException {
        return this.internal_save(jobHistory, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobHistory internal_save(JobHistory jobHistory, boolean bl, boolean bl2) throws ResourceUnavailableException, DataException {
        JobHistory jobHistory2 = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            Object object;
            if (jobHistory.getInitiationData() != null && jobHistory.getInitiationData().length() > 4096) {
                object = "Job History Initiation Data length " + jobHistory.getInitiationData().length() + " exceeds maximum length of " + 4096 + ". Initiation Data will be cleared.";
                logger.warn(object);
                jobHistory.setInitiationData("");
            }
            wrappedConnection = this.getConnection();
            object = (JobHistory)((Object)super.get((Connection)wrappedConnection, (Object)jobHistory));
            if (bl2) {
                if (!((JobHistory)((Object)object)).getStatusCode().equals(JobStatusCode.MANAGED)) {
                    throw new NoDataException("The job history record is no longer managed.  The current state is " + ((JobHistory)((Object)object)).getStatusCode_asText());
                }
                jobHistory2 = (JobHistory)((Object)super.save((Connection)wrappedConnection, (Object)jobHistory));
            } else {
                jobHistory2 = (JobHistory)((Object)super.save((Connection)wrappedConnection, (Object)jobHistory));
            }
            JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            wrappedConnection = null;
            boolean bl3 = true;
            if (object != null && ((JobHistory)((Object)object)).getStatusCode().isTerminalState()) {
                bl3 = false;
                if (jobHistory.isJobSuiteMember() && jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.PARENT_SUITE_ENDED) {
                    bl3 = true;
                }
            }
            if (object != null && ((JobHistory)((Object)object)).isJobSuiteMember() && JobStatusCode.FAILED == ((JobHistory)((Object)object)).getStatusCode() && JobStatusCode.COMPLETED == jobHistory.getStatusCode() && JobEndedReasonCode.ENDED_MANUALLY == jobHistory.getJobEndedReasonCode()) {
                bl3 = true;
            }
            if (bl3 && bl) {
                this.reactivityAM.notifyJobStatusChange(jobHistory2);
            }
            if (jobHistory.isJobSuiteMember()) {
                boolean bl4;
                boolean bl5 = bl4 = object == null || jobHistory.getStatusCode() != ((JobHistory)((Object)object)).getStatusCode();
                if (bl4) {
                    this.jobSuiteAM.memberStatusChange(jobHistory);
                }
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("Error saving Job History ID " + jobHistory.getId()), (Throwable)sQLException);
        }
        finally {
            if (wrappedConnection != null) {
                JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            }
        }
        logger.trace((Object)("Saved history for " + jobHistory2.getId() + " with queue_ended_time = " + jobHistory2.getQueueEndedTime() + " and status = " + jobHistory2.getStatusCode()));
        return jobHistory2;
    }

    private AgentLogAM getAgentLogAM() {
        if (this.agentLogAM == null) {
            this.agentLogAM = (AgentLogAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentLogAM");
        }
        return this.agentLogAM;
    }

    private EventHistoryXRefDM getEventHistoryXRefDM() {
        if (this.eventHistoryXRefDM == null) {
            this.eventHistoryXRefDM = (EventHistoryXRefDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EventHistoryXRefDM");
        }
        return this.eventHistoryXRefDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeJobHistory(long l, String string) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            JobHistoryProxy jobHistoryProxy = this.getProxy(l, (Connection)wrappedConnection);
            if (jobHistoryProxy == null) {
                return;
            }
            if (JobHistoryDMJdbc.isOkToDeleteJobHistory(jobHistoryProxy.getStatusCode(), true)) {
                if (jobHistoryProxy.isJobSuite()) {
                    this.purgeJobSuiteHistory((Connection)wrappedConnection, jobHistoryProxy, string);
                } else {
                    this.purgeJobHistory((Connection)wrappedConnection, jobHistoryProxy, string);
                }
            }
        }
        finally {
            JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public void automaticJobHistoryPurge(SystemSetup systemSetup) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"System Setup", (Object)systemSetup);
        JobHistoryProxyGenerator jobHistoryProxyGenerator = new JobHistoryProxyGenerator();
        this.jobStatusFilterClause = MessageUtil.formatMsg((String)"job_status IN (''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}'')", (Object[])new Object[]{JobStatusCode.CANCELED.persistanceCode(), JobStatusCode.COMPLETED.persistanceCode(), JobStatusCode.ERROR.persistanceCode(), JobStatusCode.FAILED.persistanceCode(), JobStatusCode.SKIPPED.persistanceCode()});
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = RosettaMsg.PURGE_JOB_HISTORY_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
        logger.info((Object)scheduleLogEntry.getMessageText());
        int n5 = systemSetup.getJobHistoryDaysToKeepOrphans();
        String string2 = "SELECT id, name, job_type, target_type, target_id, system_defaults_for_job_history_purge, job_history_purge, job_history_purge_option, job_history_runs_to_keep, job_history_days_to_keep FROM jobs WHERE job_type =? OR job_type =? ORDER BY name";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            Connection connection = preparedStatement.getConnection();
            preparedStatement.setInt(1, JobType.JOB.persistanceCode());
            preparedStatement.setInt(2, JobType.SUITE.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                PurgeJob purgeJob = this.loadJobToPurge(resultSet, systemSetup);
                if (purgeJob.isPurgeEnabledForThisJob()) {
                    int n6 = 0;
                    switch (purgeJob.getJobType()) {
                        case JOB: {
                            n6 = this.purgeJob(purgeJob, connection, (BusinessObjectGenerator)jobHistoryProxyGenerator, n5);
                            n += n6;
                            break;
                        }
                        case SUITE: {
                            n6 = this.purgeSuite(purgeJob, connection, (BusinessObjectGenerator)jobHistoryProxyGenerator);
                            n2 += n6;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{purgeJob.getJobType()}));
                        }
                    }
                    this.logDetailResults(purgeJob, n6);
                    continue;
                }
                logger.debug((Object)MessageUtil.formatMsg((String)"Job History purge is disabled for job/suite {0}", (Object[])new Object[]{purgeJob.getName()}));
            }
            n3 = this.purgeEntriesForDeletedJobsAndSuites(n5, connection, (BusinessObjectGenerator)jobHistoryProxyGenerator);
            n4 = this.purgeOrphanedMembers(connection);
            if (this.parentRootArray != null) {
                logger.debug((Object)"Clearing Empty Parent Roots....");
                this.clearEmptyParentRoots();
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while trying to run the automatic Job History purge.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        logger.info((Object)"Finished Job History purge.");
        this.logGrandTotals(n, n2, n3, n4);
    }

    private AgentGroupDM agentGroupDM() {
        return (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
    }

    /*
     * Loose catch block
     */
    private JobHistoryProxy getMostRecentRun(long l, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        JobHistoryProxy jobHistoryProxy;
        block6: {
            jobHistoryProxy = null;
            String string = "SELECT " + this.proxyFields() + " FROM " + this.table + " WHERE job_id =? ORDER BY id DESC LIMIT 1";
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            resultSet = null;
            try {
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                jobHistoryProxy = (JobHistoryProxy)((Object)businessObjectGenerator.generateObject(resultSet));
            }
            catch (BadDataException badDataException) {
                jobHistoryProxy = (JobHistoryProxy)((Object)badDataException.getLoadedObject());
                JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the most recent Job History run for the job/suite with ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
                {
                    catch (Throwable throwable) {
                        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                        throw throwable;
                    }
                }
            }
        }
        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        return jobHistoryProxy;
    }

    private boolean isInArray(long[] lArray, long l) {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] != l) continue;
            return true;
        }
        return false;
    }

    private boolean isRunsOnAllTypeAgentGroup(long l, ScheduleInfo.TargetType targetType, long l2, Connection connection) throws DataException, ResourceUnavailableException {
        AgentGroupProxy agentGroupProxy;
        boolean bl = false;
        if (targetType != null && targetType == ScheduleInfo.TargetType.AGENT_GROUP && (agentGroupProxy = this.agentGroupDM().getProxy(l2, connection)).getAgentGroupType() == AgentGroupType.ALL_AGENTS) {
            bl = true;
        }
        return bl;
    }

    private SimpleList<JobHistoryProxy> jobHistoryRuns(long l, String string, Connection connection, BusinessObjectGenerator businessObjectGenerator, boolean bl) throws ResourceUnavailableException {
        String string2 = "SELECT {0} FROM {1} WHERE job_id =? AND {2} ORDER BY {3}";
        String string3 = "id DESC";
        if (bl) {
            string3 = "agent_id, id DESC";
        }
        String string4 = MessageUtil.formatMsg((String)string2, (Object[])new Object[]{this.proxyFields(), this.table, this.jobStatusFilterClause, string3});
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string4, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string5 = MessageUtil.formatMsg((String)"SQL error while retrieving the job history runs for job {0}.", (Object[])new Object[]{string});
            JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            throw new ResourceUnavailableException(string5, (Throwable)sQLException);
        }
        return new ResultSetSimpleList<JobHistoryProxy>(resultSet, businessObjectGenerator, true);
    }

    private SimpleList<JobHistoryProxy> jobHistoryRuns(long l, String string, Connection connection, BusinessObjectGenerator businessObjectGenerator, int n) throws ResourceUnavailableException {
        String string2 = "SELECT {0} FROM {1} WHERE job_id =? AND {2} AND server_ended_time_utc < ? AND server_ended_time_utc <> 0{3}";
        String string3 = "";
        if (logger.isDebugEnabled()) {
            string3 = " ORDER BY id DESC";
        }
        String string4 = MessageUtil.formatMsg((String)string2, (Object[])new Object[]{this.proxyFields(), this.table, this.jobStatusFilterClause, string3});
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string4, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            long l2 = DateTranslator.getDaysOldAsMilliseconds((long)n);
            preparedStatement.setLong(2, l2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string5 = MessageUtil.formatMsg((String)"SQL error while retrieving the job history runs for job {0}.", (Object[])new Object[]{string});
            JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            throw new ResourceUnavailableException(string5, (Throwable)sQLException);
        }
        return new ResultSetSimpleList<JobHistoryProxy>(resultSet, businessObjectGenerator, true);
    }

    private String jobType(JobHistoryProxy jobHistoryProxy) {
        String string = "job";
        if (jobHistoryProxy.isJobSuite()) {
            string = "suite";
        } else if (jobHistoryProxy.isJobSuiteMember()) {
            string = "member";
        }
        return string;
    }

    private PurgeJob loadJobToPurge(ResultSet resultSet, SystemSetup systemSetup) throws SQLException {
        JobHistoryPurgeOption jobHistoryPurgeOption;
        int n;
        int n2;
        PurgeJob purgeJob;
        block11: {
            block10: {
                int n3;
                boolean bl;
                purgeJob = new PurgeJob();
                purgeJob.setSkybotJobNumber(resultSet.getLong("id"));
                purgeJob.setName(Convert.trimR((String)resultSet.getString("name")));
                purgeJob.setJobType(JobType.persistanceCodeToEnum(resultSet.getInt("job_type")));
                if (purgeJob.getJobType() == JobType.SUITE) {
                    purgeJob.setTargetType(null);
                    purgeJob.setTargetId(0L);
                } else {
                    String string = Convert.trimR((String)resultSet.getString("target_type"));
                    purgeJob.setTargetType(ScheduleInfo.TargetType.persistanceCodeToEnum(string));
                    purgeJob.setTargetId(resultSet.getLong("target_id"));
                }
                boolean bl2 = resultSet.getBoolean("system_defaults_for_job_history_purge");
                if (bl2) {
                    bl = systemSetup.getJobHistoryPurgeDefault();
                    n3 = systemSetup.getJobHistoryPurgeOptionDefault();
                    n2 = systemSetup.getJobHistoriesToKeepDefault();
                    n = systemSetup.getJobHistoryDaysToKeepDefault();
                } else {
                    bl = resultSet.getBoolean("job_history_purge");
                    n3 = resultSet.getInt("job_history_purge_option");
                    n2 = resultSet.getInt("job_history_runs_to_keep");
                    n = resultSet.getInt("job_history_days_to_keep");
                }
                if (!bl) break block10;
                switch (n3) {
                    case 0: {
                        jobHistoryPurgeOption = JobHistoryPurgeOption.PURGE_BY_RUNS_TO_KEEP;
                        break block11;
                    }
                    case 1: {
                        jobHistoryPurgeOption = JobHistoryPurgeOption.PURGE_BY_DAYS_TO_KEEP;
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Purge option code {0} is not supported by this method.", (Object[])new Object[]{n3}));
                    }
                }
            }
            jobHistoryPurgeOption = JobHistoryPurgeOption.DO_NOT_PURGE;
        }
        purgeJob.setPurgeOption(jobHistoryPurgeOption);
        if (jobHistoryPurgeOption == JobHistoryPurgeOption.PURGE_BY_RUNS_TO_KEEP) {
            purgeJob.setRunsToKeep(n2);
        }
        if (jobHistoryPurgeOption == JobHistoryPurgeOption.PURGE_BY_DAYS_TO_KEEP) {
            purgeJob.setDaysToKeep(n);
        }
        return purgeJob;
    }

    private PurgeJob loadJobToPurge_ForDeletedJobs(long l, int n, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        PurgeJob purgeJob = new PurgeJob();
        purgeJob.setSkybotJobNumber(l);
        JobHistoryProxy jobHistoryProxy = this.getMostRecentRun(l, connection, businessObjectGenerator);
        purgeJob.setName(jobHistoryProxy.getJobName());
        JobType jobType = JobType.JOB;
        if (jobHistoryProxy.isJobSuite()) {
            jobType = JobType.SUITE;
        } else if (jobHistoryProxy.isJobSuiteMember()) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{JobType.SUITE_MEMBER}));
        }
        purgeJob.setJobType(jobType);
        purgeJob.setTargetType(null);
        purgeJob.setTargetId(0L);
        purgeJob.setPurgeOption(JobHistoryPurgeOption.PURGE_BY_DAYS_TO_KEEP);
        purgeJob.setDaysToKeep(n);
        return purgeJob;
    }

    private void logAgentLevelDetails(String string, String string2, long l, int n) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageUtil.formatMsg((String)"{0} runs purged for job {1}, on agent {2} (id {3})", (Object[])new Object[]{n, string, string2, l}));
        }
    }

    private void logDetailResults(PurgeJob purgeJob, int n) {
        if (n > 0) {
            int n2;
            String string;
            String string2 = purgeJob.getJobType() == JobType.JOB ? "{0} runs purged for job  {1} - {2} {3} retained" : "{0} runs purged for suite {1} - {2} {3} retained";
            if (purgeJob.getPurgeOption() == JobHistoryPurgeOption.PURGE_BY_RUNS_TO_KEEP) {
                string = "runs";
                n2 = purgeJob.getRunsToKeep();
            } else {
                string = "days";
                n2 = purgeJob.getDaysToKeep();
            }
            logger.info((Object)MessageUtil.formatMsg((String)string2, (Object[])new Object[]{n, purgeJob.getName(), n2, string}));
        }
    }

    private void logGrandTotals(int n, int n2, int n3, int n4) {
        if (n > 0) {
            logger.info((Object)MessageUtil.formatMsg((String)"{0} Job History entries were deleted for active jobs.", (Object[])new Object[]{n}));
        }
        if (n2 > 0) {
            logger.info((Object)MessageUtil.formatMsg((String)"{0} Job History entries were deleted for active suites.", (Object[])new Object[]{n2}));
        }
        if (n3 > 0) {
            logger.info((Object)MessageUtil.formatMsg((String)"{0} Job History entries were deleted for deleted jobs and suites.", (Object[])new Object[]{n3}));
        }
        if (n4 > 0) {
            logger.info((Object)MessageUtil.formatMsg((String)"{0} Job History entries were deleted for orphaned suite members. The associated suite Job History entry no longer existed.", (Object[])new Object[]{n4}));
        }
        int n5 = n + n2 + n3 + n4;
        String string = RosettaMsg.PURGE_JOB_HISTORY_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{String.valueOf(n5), string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private String proxyFields() {
        return "id, job_id, job_name, agent_id, agent_name, copied_joblog_to_server, job_status, was_missed, server_ended_time_utc, job_priority, agent_ended_time_utc, job_suite_history_id, job_suite_member_job_id, job_suite_id";
    }

    private int purgeJob(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator, int n) throws ResourceUnavailableException {
        int n2 = 0;
        String string = "";
        Exception exception = null;
        try {
            n2 = purgeJob.isPurgeByDaysToKeep() ? this.purgeJob_byDaysToKeep(purgeJob, connection, businessObjectGenerator) : this.purgeJob_byRunsToKeep(purgeJob, connection, businessObjectGenerator, n);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (PurgeException purgeException) {
            exception = purgeException;
            if (purgeException.hasCount()) {
                string = MessageUtil.formatMsg((String)" {0} runs were able to be purged.", (Object[])new Object[]{purgeException.getPurgedRunsCount()});
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            logger.warn((Object)MessageUtil.formatMsg((String)"An error occurred while purging the Job History runs for job {0}.{1} Details: {2}", (Object[])new Object[]{purgeJob.getName(), string, this.nestedMsgText(exception)}));
        }
        return n2;
    }

    private int purgeJob_byDaysToKeep(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws PurgeException, ResourceUnavailableException {
        SimpleList<JobHistoryProxy> simpleList;
        int n = 0;
        long l = purgeJob.getSkybotJobNumber();
        int n2 = purgeJob.getDaysToKeep();
        try {
            simpleList = this.jobHistoryRuns(l, purgeJob.getName(), connection, businessObjectGenerator, n2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Unable to get the list of Job History runs.", (Throwable)resourceUnavailableException);
        }
        JobHistoryProxy jobHistoryProxy = null;
        try {
            while (simpleList.next()) {
                jobHistoryProxy = simpleList.get();
                this.purgeJobHistory(connection, jobHistoryProxy, null);
                ++n;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new PurgeException("Error while processing the list of Job History runs.", exception, n);
        }
        finally {
            simpleList.close();
        }
        return n;
    }

    private int purgeJob_byRunsToKeep(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator, int n) throws PurgeException, ResourceUnavailableException {
        SimpleList<JobHistoryProxy> simpleList;
        boolean bl;
        int n2 = 0;
        long l = purgeJob.getSkybotJobNumber();
        String string = purgeJob.getName();
        int n3 = purgeJob.getRunsToKeep();
        try {
            bl = this.isRunsOnAllTypeAgentGroup(l, purgeJob.getTargetType(), purgeJob.getTargetId(), connection);
        }
        catch (DataException dataException) {
            throw new PurgeException("Unable to get the list of Job History runs.", dataException, n2);
        }
        boolean bl2 = bl;
        try {
            simpleList = this.jobHistoryRuns(l, string, connection, businessObjectGenerator, bl2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Unable to get the list of Job History runs.", (Throwable)resourceUnavailableException);
        }
        JobHistoryProxy jobHistoryProxy = null;
        int n4 = 0;
        try {
            if (!bl) {
                while (simpleList.next()) {
                    if (++n4 <= n3) continue;
                    jobHistoryProxy = simpleList.get();
                    this.purgeJobHistory(connection, jobHistoryProxy, null);
                    ++n2;
                }
                int n5 = n2;
                return n5;
            }
            logger.debug((Object)MessageUtil.formatMsg((String)"Job {0} runs on an all-type Agent Group. {1} runs will be retained for each agent.", (Object[])new Object[]{string, n3}));
            long l2 = purgeJob.getTargetId();
            long[] lArray = this.agentGroupDM().getAgentsIDsInGroup(l2, connection);
            long l3 = DateTranslator.getDaysOldAsMilliseconds((long)n);
            long l4 = 0L;
            String string2 = "";
            int n6 = 0;
            boolean bl3 = true;
            while (simpleList.next()) {
                long l5;
                jobHistoryProxy = simpleList.get();
                long l6 = jobHistoryProxy.getAgentID();
                if (l6 != l4) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        this.logAgentLevelDetails(string, string2, l4, n6);
                        n6 = 0;
                        n4 = 0;
                    }
                    l4 = l6;
                    string2 = jobHistoryProxy.getAgentName();
                }
                boolean bl4 = false;
                if (++n4 > n3) {
                    bl4 = true;
                } else if (!this.isInArray(lArray, l6) && (l5 = jobHistoryProxy.getServerEndedTime()) < l3 && l5 != 0L) {
                    bl4 = true;
                }
                if (!bl4) continue;
                this.purgeJobHistory(connection, jobHistoryProxy, null);
                ++n2;
                ++n6;
            }
            if (l4 != 0L) {
                this.logAgentLevelDetails(string, string2, l4, n6);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new PurgeException("Error while processing the list of Job History runs.", exception, n2);
        }
        finally {
            simpleList.close();
        }
        return n2;
    }

    private int purgeSuite(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        int n = 0;
        String string = "";
        Exception exception = null;
        try {
            n = purgeJob.isPurgeByDaysToKeep() ? this.purgeSuite_byDaysToKeep(purgeJob, connection, businessObjectGenerator) : this.purgeSuite_byRunsToKeep(purgeJob, connection, businessObjectGenerator);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (PurgeException purgeException) {
            exception = purgeException;
            if (purgeException.hasCount()) {
                string = MessageUtil.formatMsg((String)" {0} runs were able to be purged.", (Object[])new Object[]{purgeException.getPurgedRunsCount()});
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            logger.warn((Object)MessageUtil.formatMsg((String)"An error occurred while purging the Job History runs for suite {0}.{1} Details: {2}", (Object[])new Object[]{purgeJob.getName(), string, this.nestedMsgText(exception)}));
        }
        return n;
    }

    private int purgeSuite_byDaysToKeep(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws PurgeException, ResourceUnavailableException {
        SimpleList<JobHistoryProxy> simpleList;
        int n = 0;
        long l = purgeJob.getSkybotJobNumber();
        int n2 = purgeJob.getDaysToKeep();
        try {
            simpleList = this.jobHistoryRuns(l, purgeJob.getName(), connection, businessObjectGenerator, n2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Unable to get the list of Job History runs.", (Throwable)resourceUnavailableException);
        }
        JobHistoryProxy jobHistoryProxy = null;
        try {
            while (simpleList.next()) {
                jobHistoryProxy = simpleList.get();
                this.purgeJobSuiteHistory(connection, jobHistoryProxy, null);
                ++n;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new PurgeException("Error while processing the list of Job History runs.", exception, n);
        }
        finally {
            simpleList.close();
        }
        return n;
    }

    private int purgeSuite_byRunsToKeep(PurgeJob purgeJob, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws PurgeException, ResourceUnavailableException {
        SimpleList<JobHistoryProxy> simpleList;
        int n = 0;
        long l = purgeJob.getSkybotJobNumber();
        int n2 = purgeJob.getRunsToKeep();
        boolean bl = false;
        try {
            simpleList = this.jobHistoryRuns(l, purgeJob.getName(), connection, businessObjectGenerator, bl);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Unable to get the list of Job History runs.", (Throwable)resourceUnavailableException);
        }
        JobHistoryProxy jobHistoryProxy = null;
        int n3 = 0;
        try {
            while (simpleList.next()) {
                if (++n3 <= n2) continue;
                jobHistoryProxy = simpleList.get();
                this.purgeJobSuiteHistory(connection, jobHistoryProxy, null);
                ++n;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            throw new PurgeException("Error while processing the list of Job History runs.", exception, n);
        }
        finally {
            simpleList.close();
        }
        return n;
    }

    private int purgeEntriesForDeletedJobsAndSuites(int n, Connection connection, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        String string = "SELECT DISTINCT job_id FROM " + this.table + " WHERE job_suite_member_job_id = 0 " + "AND job_id NOT IN (SELECT id FROM " + JOBS_TABLE + ") AND " + "server_ended_time_utc < ? AND server_ended_time_utc <> 0 " + "ORDER BY job_id";
        int n2 = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("job_id");
                PurgeJob purgeJob = this.loadJobToPurge_ForDeletedJobs(l2, n, connection, businessObjectGenerator);
                int n3 = 0;
                switch (purgeJob.getJobType()) {
                    case JOB: {
                        n3 = this.purgeJob(purgeJob, connection, businessObjectGenerator, n);
                        break;
                    }
                    case SUITE: {
                        n3 = this.purgeSuite(purgeJob, connection, businessObjectGenerator);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{purgeJob.getJobType()}));
                    }
                }
                if (n3 > 0) {
                    String string2 = purgeJob.getJobType() == JobType.JOB ? "{0} runs purged for deleted job  {1} (id {2}) - {3} days retained" : "{0} runs purged for deleted suite {1} (id {2}) - {3} days retained";
                    logger.info((Object)MessageUtil.formatMsg((String)string2, (Object[])new Object[]{n3, purgeJob.getName(), l2, n}));
                }
                n2 += n3;
            }
        }
        catch (SQLException sQLException) {
            try {
                String string3 = "SQL error while purging orphaned Job History entries.";
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        return n2;
    }

    private int purgeOrphanedMembers(Connection connection) throws ResourceUnavailableException {
        String string = "SELECT m.id FROM " + this.table + " AS m LEFT OUTER JOIN " + this.table + " AS s ON m.job_suite_history_id = s.id " + "WHERE m.job_suite_history_id <> 0 " + "AND s.id IS NULL";
        int n = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JobHistoryProxy jobHistoryProxy;
                long l = resultSet.getLong("id");
                try {
                    jobHistoryProxy = this.getProxy(l, connection);
                }
                catch (DataException dataException) {
                    logger.warn((Object)MessageUtil.formatMsg((String)"An error occurred while trying to read the Job History entry for an orphaned suite member, so that it could be purged. Job History run ID {0}. Details: {1}", (Object[])new Object[]{l, this.nestedMsgText((Exception)((Object)dataException))}));
                    continue;
                }
                this.purgeJobHistory(connection, jobHistoryProxy, null);
                ++n;
                String string2 = this.suiteName(l, connection);
                logger.info((Object)MessageUtil.formatMsg((String)"The Job History entry for an orphaned suite member run was deleted. Details: Run number {0} | member name {1} | agent name {2} | suite name {3} | suite run number {4}. This entry was deleted because the Job History entry for its associated suite run (number {4}) was missing.", (Object[])new Object[]{jobHistoryProxy.getId(), jobHistoryProxy.getJobName(), jobHistoryProxy.getAgentName(), string2, jobHistoryProxy.getJobSuiteHistoryID()}));
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while purging orphaned member Job History entries.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        }
        return n;
    }

    private String suiteName(long l, Connection connection) {
        String string;
        try {
            JobHistory jobHistory = this.get(l, connection);
            string = jobHistory.isJobSuiteMember() ? jobHistory.getJobSuiteName() : (jobHistory.isJobSuite() ? jobHistory.getJobName() : "??");
        }
        catch (Exception exception) {
            string = "?";
        }
        return string;
    }

    @Override
    public void manualJobHistoryPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException {
        Object object;
        String[] stringArray;
        Object object2;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"About to start Job History purge.");
        }
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = RosettaMsg.PURGE_JOB_HISTORY_NAME.newLogEntry().getMessageText();
        String[] stringArray2 = new String[]{string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE.newLogEntry(stringArray2);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
        int n = 0;
        int n2 = 0;
        try {
            object2 = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
            stringArray = JobType.JOB.persistanceCode() + "," + JobType.SUITE.persistanceCode();
            object = "select id, name, job_type, job_history_purge, job_history_runs_to_keep, system_defaults_for_job_history_purge, target_id, target_type from jobs where job_type in (" + (String)stringArray + ")";
            logger.debug((Object)("Querying jobs to purge: " + (String)object));
            statement = wrappedConnection.createStatement();
            resultSet = statement.executeQuery((String)object);
            while (resultSet.next()) {
                PurgeJob purgeJob = new PurgeJob();
                purgeJob.setSkybotJobNumber(resultSet.getLong("id"));
                purgeJob.setName(resultSet.getString("name"));
                purgeJob.setJobType(JobType.persistanceCodeToEnum(resultSet.getInt("job_type")));
                purgeJob.setPurgeJobHistory(resultSet.getBoolean("job_history_purge"));
                purgeJob.setJobHistoriesToKeep(resultSet.getInt("job_history_runs_to_keep"));
                purgeJob.setUseDefaultsForJobHistoryPurge(resultSet.getBoolean("system_defaults_for_job_history_purge"));
                String string2 = resultSet.getString("target_type");
                if (string2 == null || string2.trim().length() == 0) {
                    purgeJob.setTargetType(null);
                } else {
                    purgeJob.setTargetType(ScheduleInfo.TargetType.persistanceCodeToEnum(string2.trim()));
                }
                purgeJob.setTargetId(resultSet.getLong("target_id"));
                int n3 = -1;
                if (purgeJob.isUseDefaultsForJobHistoryPurge()) {
                    if (systemSetup.isJobHistoryPurgeDefault()) {
                        n3 = systemSetup.getJobHistoriesToKeepDefault();
                    }
                } else if (purgeJob.isPurgeJobHistory()) {
                    n3 = purgeJob.getJobHistoriesToKeep();
                }
                if (purgeJob.getJobType() == JobType.SUITE) {
                    logger.debug((Object)("About to purge the Job History for the suite named " + purgeJob.getName() + " retaining the last " + n3 + " runs."));
                    n2 += this.purgeJobSuitesWithMembers((Connection)wrappedConnection, purgeJob, n3);
                    this.cleanupJobSuiteMembers((Connection)wrappedConnection);
                    continue;
                }
                if (n3 > 0) {
                    String string3 = purgeJob.getName();
                    logger.info((Object)("About to purge the Job History for the job named " + string3 + " retaining the last " + n3 + " runs."));
                    long l = purgeJob.getSkybotJobNumber();
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    ArrayList<Long> arrayList2 = null;
                    if (purgeJob.getTargetType().equals(ScheduleInfo.TargetType.AGENT_GROUP)) {
                        int n4;
                        long l2 = purgeJob.getTargetId();
                        AgentGroupProxy agentGroupProxy = object2.getProxy(l2);
                        if (agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED || agentGroupProxy.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT) {
                            int n5 = this.purgeAgentJob((Connection)wrappedConnection, l, n3, string3);
                            n += n5;
                            continue;
                        }
                        long[] lArray = object2.getAgentsIDsInGroup(l2, (Connection)wrappedConnection);
                        arrayList2 = new ArrayList<Long>(lArray.length);
                        Object[] objectArray = lArray;
                        int n6 = objectArray.length;
                        for (n4 = 0; n4 < n6; ++n4) {
                            long l3 = objectArray[n4];
                            arrayList2.add(l3);
                        }
                        Object[] objectArray2 = objectArray = (Object[])this.getAgentsWithJobHistory(l);
                        n4 = objectArray2.length;
                        for (int i = 0; i < n4; ++i) {
                            long l4 = objectArray2[i];
                            if (!arrayList.contains(l4.agentID)) {
                                int n7;
                                if (arrayList2 != null && !arrayList2.contains(l4.agentID)) {
                                    logger.info((Object)("Agent " + l4.getNameWithID() + " is no longer assigned to job " + string3));
                                    n7 = this.purgeForJob((Connection)wrappedConnection, l, 0, l4.agentID, l2);
                                } else {
                                    n7 = this.purgeForJob((Connection)wrappedConnection, l, n3, l4.agentID, l2);
                                }
                                arrayList.add(l4.agentID);
                                n += n7;
                                int n8 = this.purgeForJob((Connection)wrappedConnection, l, n3, 0L, l2);
                                n += n8;
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(n7);
                                stringBuilder.append(" runs were purged for job ");
                                stringBuilder.append(string3);
                                stringBuilder.append(" on agent ");
                                stringBuilder.append(l4.getNameWithID());
                                logger.info((Object)stringBuilder);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Agent ID " + l4.agentID + " was already purged for job " + string3 + " Skipping purge for agent " + l4.getNameWithID()));
                        }
                        continue;
                    }
                    int n9 = this.purgeAgentJob((Connection)wrappedConnection, l, n3, string3);
                    n += n9;
                    continue;
                }
                logger.debug((Object)("Job history will not be purged for job " + purgeJob.getName()));
            }
            if (this.parentRootArray != null) {
                logger.debug((Object)"Clearing Empty Parent Roots....");
                this.clearEmptyParentRoots();
            }
            this.removeDeletedJobsJobHistory((Connection)wrappedConnection);
        }
        catch (SQLException sQLException) {
            try {
                throw new RuntimeException("Error purging job history.", sQLException);
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, statement, resultSet);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Finished Job History purge.");
                }
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finished Job History purge.");
        }
        if (n > 0) {
            object2 = RosettaMsg.PURGE_JOB_HISTORY_NAME.newLogEntry().getMessageText();
            stringArray = new String[]{String.valueOf(n), object2};
            object = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write((ScheduleLogEntry)object);
            logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
        }
        if (n2 > 0) {
            object2 = RosettaMsg.PURGE_SUITE_HISTORY_NAME.newLogEntry().getMessageText();
            stringArray = new String[]{String.valueOf(n2), object2};
            object = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write((ScheduleLogEntry)object);
        }
    }

    private int purgeAgentJob(Connection connection, long l, int n, String string) throws DataException, ResourceUnavailableException {
        int n2 = this.purgeForJob(connection, l, n, 0L, 0L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append(" runs were purged for job ");
        stringBuilder.append(string);
        logger.info((Object)stringBuilder);
        return n2;
    }

    private void removeDeletedJobsJobHistory(Connection connection) throws ResourceUnavailableException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT id, job_name, server_ended_time_utc FROM " + this.table + " WHERE job_suite_member_job_id = 0 AND " + "job_id not in (SELECT id FROM " + JOBS_TABLE + ") AND server_ended_time_utc < ? ORDER BY id asc";
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -90);
        long l = calendar.getTimeInMillis();
        String[] stringArray = new String[]{"Job History", "90"};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_DELETED_OVER_DAYS.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                long l2 = resultSet.getLong("id");
                String string2 = resultSet.getString("job_name");
                try {
                    this.purgeJobHistory(l2, null);
                    ++n;
                    logger.debug((Object)("Deleted Job History run " + l2 + " for deleted job " + string2));
                }
                catch (NoDataException noDataException) {
                    logger.debug((Object)("Unable to purge run number " + l2 + " for deleted job " + string2 + ".  " + noDataException.getMessage()));
                }
                catch (DataException dataException) {
                    logger.error((Object)("Error purging run number " + l2 + " for deleted job " + string2), (Throwable)dataException);
                }
            }
            String string3 = ScheduleLogger.formatTimeStamp(l);
            logger.debug((Object)("Deleted " + n + " job history record(s) completed prior to " + string3 + " for deleted jobs."));
        }
        catch (SQLException sQLException) {
            try {
                String string4 = MessageUtil.formatMsg((String)"SQL error while purging job history records for deleted jobs that ended before {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        JobHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int purgeJobSuitesWithMembers(Connection connection, PurgeJob purgeJob, int n) throws SQLException, DataException, ResourceUnavailableException {
        String string = "SELECT id FROM " + this.table + " WHERE job_id = ? " + " AND job_status IN ('" + JobStatusCode.CANCELED.persistanceCode() + "','" + JobStatusCode.COMPLETED.persistanceCode() + "','" + JobStatusCode.ERROR.persistanceCode() + "','" + JobStatusCode.FAILED.persistanceCode() + "','" + JobStatusCode.SKIPPED.persistanceCode() + "')" + " ORDER BY id DESC OFFSET " + n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, purgeJob.getSkybotJobNumber());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("id");
                try {
                    JobHistoryProxy jobHistoryProxy = this.getProxy(l);
                    this.purgeJobSuiteHistory(connection, jobHistoryProxy, null);
                    ++n2;
                }
                catch (Exception exception) {
                    logger.error((Object)("Error purging run number " + l + " for job suite " + purgeJob.name + " with job suite ID " + purgeJob.getSkybotJobNumber()), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            try {
                logger.error((Object)("Error purging history for job suite " + purgeJob.name + " with job suite ID " + purgeJob.getSkybotJobNumber()), (Throwable)exception);
            }
            catch (Throwable throwable) {
                AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
            AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        }
        AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        String string2 = purgeJob.getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append(" runs were purged for suite ");
        stringBuilder.append(string2);
        logger.info((Object)stringBuilder);
        return n2;
    }

    private int purgeJobSuiteHistory(Connection connection, JobHistoryProxy jobHistoryProxy, String string) {
        int n;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        try {
            if (connection2 == null) {
                connection2 = super.getConnectionOrFail();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleting job suite history for job suite" + jobHistoryProxy.getJobName() + " with run number " + jobHistoryProxy.getId()));
            }
            String string2 = "SELECT id FROM " + this.table + " WHERE job_suite_history_id = ?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, jobHistoryProxy.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.purgeJobHistory(connection, this.getById(resultSet.getLong("id")), null);
            }
            String string3 = "DELETE FROM " + this.table + " WHERE id = ?";
            preparedStatement2 = connection.prepareStatement(string3);
            preparedStatement2.setLong(1, jobHistoryProxy.getId());
            int n2 = preparedStatement2.executeUpdate();
            if (jobHistoryProxy.getMissedCode().equals(JobMissedCode.MISSED) && string != null) {
                this.logRemoveManagedJobHistory(jobHistoryProxy, string, connection);
            }
            if (jobHistoryProxy.getStatusCode() == JobStatusCode.MANAGED) {
                long l = jobHistoryProxy.getId();
                this.activityMatcherAM.suiteManaged_Deleted(l);
            }
            n = n2;
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("Error purging history for job suite history ID " + String.valueOf(jobHistoryProxy.getId()), exception);
            }
            catch (Throwable throwable) {
                AbstractHelpingDatabaseManager.closeEm(null, preparedStatement2, null);
                if (connection == null) {
                    AbstractHelpingDatabaseManager.closeEm((Connection)connection2, preparedStatement, resultSet);
                } else {
                    AbstractHelpingDatabaseManager.closeEm(null, preparedStatement, resultSet);
                }
                throw throwable;
            }
        }
        AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement2, null);
        if (connection == null) {
            AbstractHelpingDatabaseManager.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
        } else {
            AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        }
        return n;
    }

    private void cleanupJobSuiteMembers(Connection connection) throws SQLException, ResourceUnavailableException, DataException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "SELECT suit_history.id FROM " + this.table + " AS suit_history" + " LEFT JOIN " + this.table + " AS job_history" + " ON suit_history.job_suite_history_id = job_history.id" + " WHERE suit_history.job_suite_history_id !=0" + " AND suit_history.job_status IN ('" + JobStatusCode.CANCELED.persistanceCode() + "','" + JobStatusCode.COMPLETED.persistanceCode() + "','" + JobStatusCode.ERROR.persistanceCode() + "','" + JobStatusCode.FAILED.persistanceCode() + "','" + JobStatusCode.SKIPPED.persistanceCode() + "')" + " AND job_history.id IS NULL";
        statement = connection.createStatement();
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            this.purgeJobHistory(connection, this.getById(resultSet.getLong("id")), null);
        }
    }

    private void clearEmptyParentRoots() {
        if (this.parentRootArray == null || this.parentRootArray.size() < 1) {
            return;
        }
        String string = this.agentLogAM.getTodaysParentDirectory();
        String string2 = this.agentLogAM.getVersionOneDirectory();
        while (this.parentRootArray.size() > 0) {
            String string3 = this.parentRootArray.remove(0);
            if (string3.equals(string) || string3.equals(string2)) continue;
            try {
                File file = new File(string3);
                if (!file.isDirectory() || !file.exists() || file.list().length != 0) continue;
                file.delete();
                this.putStandbyBackupFileForDelete(file.getAbsolutePath());
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to remove the parent directory " + string3));
            }
        }
    }

    private void putStandbyBackupFileForDelete(String string) {
        StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
        standbyBackupFile.setServerFileName(string);
        standbyBackupFile.setActionType(1);
        standbyBackupFile.setFileType(0);
        try {
            this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)"Can't put standby backup file in queue", (Throwable)actionFailedException);
        }
    }

    private StandbyBackupFileQueueAM getStandbyBackupFileQueueAM() {
        if (this.standbyBackupFileQueueAM == null) {
            this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
        }
        return this.standbyBackupFileQueueAM;
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    public void setJobSuiteAM(JobSuiteAM jobSuiteAM) {
        ValidationHelper.checkForNull((String)"JobSuiteAM", (Object)jobSuiteAM);
        this.jobSuiteAM = jobSuiteAM;
    }

    @Override
    public boolean hasActiveStatus(long l, long l2) throws ResourceUnavailableException {
        Object object;
        String string = "and agent_id=? ";
        Object[] objectArray = new Object[]{l2, l};
        if (l == 0L) {
            string = "";
            object = new Object[]{l2};
            objectArray = object;
        }
        object = "SELECT COUNT(*) FROM " + this.table + " WHERE job_id=? " + string + "and job_status in (" + "'" + JobStatusCode.INITIATED.persistanceCode() + "'" + ",'" + JobStatusCode.SUBMITTED.persistanceCode() + "'" + ",'" + JobStatusCode.RUNNING.persistanceCode() + "'" + ",'" + JobStatusCode.CONDITION_CHECK.persistanceCode() + "'" + ",'" + JobStatusCode.CONDITION_RETRY_WAIT.persistanceCode() + "')";
        try {
            if (this.doCount((String)object, objectArray) > 0) {
                if (logger.isTraceEnabled()) {
                    String string2 = "Interval job " + l2 + " on agent " + l + " has have an active status already.";
                    logger.trace((Object)string2);
                }
                return true;
            }
            if (logger.isTraceEnabled()) {
                String string3 = "Interval job " + l2 + " on agent " + l + " does not have an active status already.";
                logger.trace((Object)string3);
            }
            return false;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if Active job histories exists.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public boolean hasActiveStatus(long l, JobInfo jobInfo) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE job_id=? AND job_status IN ('" + JobSuiteStatus.INITIATED.persistanceCode() + "', '" + JobSuiteStatus.RUNNING.persistanceCode() + "', '" + JobSuiteStatus.MEMBER_CANCELED.persistanceCode() + "', '" + JobSuiteStatus.MEMBER_FAILED.persistanceCode() + "')";
        Object[] objectArray = new Object[]{l};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if suite {0} is in an active status.", (Object[])new Object[]{jobInfo.getJobName()});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public SimpleList<ForecastJobAgentPair> getCompletionActivitySince(long l) throws ResourceUnavailableException {
        ResultSet resultSet;
        String string = "SELECT DISTINCT job_id, agent_id FROM " + this.table + " WHERE server_ended_time_utc >? and job_status=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, JobStatusCode.COMPLETED.persistanceCode());
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while identifying the completed jobs that ended after {0}.", (Object[])new Object[0]);
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        class PairGenerator
        implements BusinessObjectGenerator<ForecastJobAgentPair> {
            PairGenerator() {
            }

            public ForecastJobAgentPair generateObject(ResultSet resultSet) throws BadDataException, SQLException, ResourceUnavailableException {
                return new ForecastJobAgentPair(resultSet.getLong("job_id"), resultSet.getLong("agent_id"));
            }

            public ForecastJobAgentPair[] generateObjectArray(ResultSet resultSet) throws BadDataArrayException, SQLException, ResourceUnavailableException {
                throw new IllegalStateException("The generateObjectArray method is not implemented.");
            }
        }
        return new ResultSetSimpleList<ForecastJobAgentPair>(resultSet, new PairGenerator());
    }

    @Override
    public ForecastDurations calculateDurations(long l, long l2) throws ResourceUnavailableException {
        String string = this.agentSelectionClause(l2);
        String string2 = "WITH t AS (SELECT (server_ended_time_utc - server_running_time_utc) AS run_ms, CASE server_submitted_time_utc WHEN 0 THEN 0 ELSE (server_running_time_utc - server_submitted_time_utc) END AS queue_ms FROM " + this.table + " WHERE job_id=? AND job_status=? " + string + " AND ended_reason_code IS NULL AND " + "server_ended_time_utc>0 AND server_running_time_utc>0 " + "ORDER BY server_initiated_time_utc DESC LIMIT 10) " + "SELECT AVG(run_ms), AVG(queue_ms) FROM t";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            ResultSet resultSet;
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, JobStatusCode.COMPLETED.persistanceCode());
            if (!string.isEmpty()) {
                preparedStatement.setLong(3, l2);
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                long l3 = resultSet.getLong(1);
                long l4 = resultSet.getLong(2);
                ForecastDurations forecastDurations = new ForecastDurations(l3, l4);
                return forecastDurations;
            }
            ForecastDurations forecastDurations = new ForecastDurations(0L, 0L);
            return forecastDurations;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while calculating the run and queue durations for the job with id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateJobHistoryForConditionRetry(JobHistory jobHistory, boolean bl) throws DataException, ResourceUnavailableException {
        boolean bl2;
        block17: {
            if (jobHistory == null) {
                logger.warn((Object)"Job history is null.  Unable to update condition retry status.");
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating job history for job " + jobHistory.getJobName() + "with run ID " + jobHistory.getId() + " of condition retry status."));
            }
            long l = jobHistory.getId();
            int n = 0;
            bl2 = false;
            PreparedStatement preparedStatement = null;
            try {
                JobHistory jobHistory2 = (JobHistory)((Object)super.get((Object)jobHistory));
                if (jobHistory2 == null) {
                    logger.warn((Object)("Job history was not found for history ID " + l + "."));
                    return;
                }
                if (jobHistory2.getStatusCode().isTerminalState()) {
                    logger.warn((Object)("Job history already has terminal status was not updated for condition retry status for ID " + l + "."));
                } else {
                    String string = "UPDATE " + this.table + " SET retry_number=?, retry_next_time=?, termination_data=?, job_status=? WHERE id=?";
                    preparedStatement = this.getDefaultPreparedStmt(string);
                    preparedStatement.setInt(1, jobHistory.getRetryNumber());
                    preparedStatement.setLong(2, jobHistory.getRetryNextTime());
                    preparedStatement.setString(3, jobHistory.getTerminationData());
                    preparedStatement.setString(4, jobHistory.getStatusCode().persistanceCode());
                    preparedStatement.setLong(5, jobHistory.getId());
                    n = preparedStatement.executeUpdate();
                    if (n != 1) {
                        logger.warn((Object)("A job history record was not updated for job history id " + l + ")."));
                    } else {
                        bl2 = true;
                    }
                }
                if (preparedStatement == null) break block17;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)("Error updating job history (" + l + ") for condition retry wait."), (Throwable)resourceUnavailableException);
                break block17;
            }
            catch (Exception exception) {
                logger.error((Object)("Exception updating job history (" + l + ") for condition retry wait."), (Throwable)exception);
                break block17;
            }
            this.closeConnection(preparedStatement);
            break block17;
            finally {
                if (preparedStatement != null) {
                    this.closeConnection(preparedStatement);
                }
            }
        }
        if (!bl2) return;
        if (!bl) return;
        this.reactivityAM.notifyJobStatusChange(jobHistory);
    }

    private String agentSelectionClause(long l) {
        if (l != 0L) {
            return "AND agent_id=?";
        }
        return "";
    }

    public static void main(String[] stringArray) {
        List<JobStatusCode> list = JobStatusCode.MANUAL_PURGE_TERMINAL_STATES;
        Iterator<JobStatusCode> iterator = list.iterator();
        while (iterator.hasNext()) {
            System.out.println("OK TO PURGE: " + iterator.next());
        }
    }

    @Override
    public int getCountByStatusCodeInPeriod(String string, Long l, Long l2) throws DataException, ResourceUnavailableException {
        String string2 = "SELECT COUNT(*) FROM " + this.table + " WHERE job_status=? AND ((server_ended_time_utc >= ? AND server_ended_time_utc <= ?) " + "OR (server_initiated_time_utc >= ? AND server_initiated_time_utc <= ?))";
        Object[] objectArray = new Object[]{string, l, l2, l, l2};
        try {
            return this.doCount(string2, objectArray);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if Faild job histories exists.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public int getCountByManagedinPeriod(Long l, Long l2) throws DataException, ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE job_status='" + JobStatusCode.MANAGED.persistanceCode() + "' AND server_initiated_time_utc >= ? AND server_initiated_time_utc <= ?";
        Object[] objectArray = new Object[]{l, l2};
        try {
            return this.doCount(string, objectArray);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if managed job histories exists.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void setTimezoneValues(JobHistory jobHistory, long l, long l2, ScheduleJobProxy scheduleJobProxy, Agent agent) throws DataException, ResourceUnavailableException {
        Object object;
        ScheduleJobProxy scheduleJobProxy2;
        ScheduleInfo.TimeZoneType timeZoneType = null;
        String string = null;
        String string2 = null;
        if (scheduleJobProxy != null) {
            scheduleJobProxy2 = scheduleJobProxy;
        } else {
            object = (ScheduleJobDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.ScheduleJobDM");
            scheduleJobProxy2 = object.getScheduleJobProxy(l2);
        }
        if (scheduleJobProxy2 != null) {
            timeZoneType = scheduleJobProxy2.getTimezoneType();
            string2 = scheduleJobProxy2.getJobTimezone();
        }
        object = null;
        if (agent != null) {
            object = agent;
        } else if (l != 0L) {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.AgentDM");
            object = agentDM.get(l);
        }
        if (object != null) {
            string = ((Agent)((Object)object)).getTimeZone();
        }
        if (timeZoneType != null) {
            jobHistory.setTimezoneType(timeZoneType.persistanceCode());
        }
        jobHistory.setAgentTimezone(string);
        jobHistory.setJobTimezone(string2);
    }

    private class PurgeException
    extends Exception {
        private int purgedRuns;
        boolean isCountHasBeenSet;

        private PurgeException(String string) {
            super(string);
        }

        private PurgeException(String string, int n) {
            super(string);
            this.setPurgedRunsCount(n);
        }

        private PurgeException(String string, Throwable throwable) {
            super(string, throwable);
        }

        private PurgeException(String string, Throwable throwable, int n) {
            super(string, throwable);
            this.setPurgedRunsCount(n);
        }

        private int getPurgedRunsCount() {
            return this.purgedRuns;
        }

        private void setPurgedRunsCount(int n) {
            this.purgedRuns = n;
            this.isCountHasBeenSet = true;
        }

        private boolean hasCount() {
            return this.isCountHasBeenSet;
        }
    }

    class SimpleAgentKey {
        public long agentID = 0L;
        public String agentName = null;

        public SimpleAgentKey(long l, String string) {
            this.agentID = l;
            this.agentName = string;
        }

        public String getNameWithID() {
            return this.agentName + " (ID: " + this.agentID + ")";
        }
    }

    class PurgeJob {
        private long skybotJobNumber;
        private String name;
        private JobType jobType;
        private boolean useDefaultsForJobHistoryPurge;
        private boolean purgeJobHistory;
        private int jobHistoriesToKeep;
        private ScheduleInfo.TargetType targetType;
        private long targetId;
        private JobHistoryPurgeOption purgeOption;
        private int runsToKeep;
        private int daysToKeep;

        PurgeJob() {
        }

        public long getSkybotJobNumber() {
            return this.skybotJobNumber;
        }

        public void setSkybotJobNumber(long l) {
            this.skybotJobNumber = l;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public JobType getJobType() {
            return this.jobType;
        }

        public void setJobType(JobType jobType) {
            this.jobType = jobType;
        }

        public boolean isUseDefaultsForJobHistoryPurge() {
            return this.useDefaultsForJobHistoryPurge;
        }

        public void setUseDefaultsForJobHistoryPurge(boolean bl) {
            this.useDefaultsForJobHistoryPurge = bl;
        }

        public boolean isPurgeJobHistory() {
            return this.purgeJobHistory;
        }

        public void setPurgeJobHistory(boolean bl) {
            this.purgeJobHistory = bl;
        }

        public int getJobHistoriesToKeep() {
            return this.jobHistoriesToKeep;
        }

        public void setJobHistoriesToKeep(int n) {
            this.jobHistoriesToKeep = n;
        }

        public ScheduleInfo.TargetType getTargetType() {
            return this.targetType;
        }

        public void setTargetType(ScheduleInfo.TargetType targetType) {
            this.targetType = targetType;
        }

        public long getTargetId() {
            return this.targetId;
        }

        public void setTargetId(long l) {
            this.targetId = l;
        }

        public JobHistoryPurgeOption getPurgeOption() {
            return this.purgeOption;
        }

        public void setPurgeOption(JobHistoryPurgeOption jobHistoryPurgeOption) {
            this.purgeOption = jobHistoryPurgeOption;
        }

        public int getRunsToKeep() {
            return this.runsToKeep;
        }

        public void setRunsToKeep(int n) {
            this.runsToKeep = n;
        }

        public int getDaysToKeep() {
            return this.daysToKeep;
        }

        public void setDaysToKeep(int n) {
            this.daysToKeep = n;
        }

        public boolean isPurgeEnabledForThisJob() {
            if (this.purgeOption == null) {
                return false;
            }
            return this.purgeOption != JobHistoryPurgeOption.DO_NOT_PURGE;
        }

        public boolean isPurgeByDaysToKeep() {
            return this.purgeOption == JobHistoryPurgeOption.PURGE_BY_DAYS_TO_KEEP;
        }

        public String toString() {
            return this.jobType + " " + this.name;
        }
    }

    private class JobHistoryProxyGenerator
    extends AbstractBusObjGenerator {
        public JobHistoryProxyGenerator() {
            super(14, "JobHistoryProxy");
        }

        protected Object constructObject() {
            return new JobHistoryProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobHistoryProxy jobHistoryProxy = (JobHistoryProxy)((Object)object);
            switch (n) {
                case 1: {
                    jobHistoryProxy.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    jobHistoryProxy.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    jobHistoryProxy.setAgentID(resultSet.getLong("agent_id"));
                    break;
                }
                case 4: {
                    jobHistoryProxy.setJobName(resultSet.getString("job_name"));
                    break;
                }
                case 5: {
                    jobHistoryProxy.setAgentName(resultSet.getString("agent_name"));
                    break;
                }
                case 6: {
                    jobHistoryProxy.setStatusCode_asStr(resultSet.getString("job_status"));
                    break;
                }
                case 7: {
                    jobHistoryProxy.setMissedCode_asInt(resultSet.getInt("was_missed"));
                    break;
                }
                case 8: {
                    jobHistoryProxy.setCopiedJobLogToServer(resultSet.getBoolean("copied_joblog_to_server"));
                    break;
                }
                case 9: {
                    jobHistoryProxy.setServerEndedTime(resultSet.getLong("server_ended_time_utc"));
                    break;
                }
                case 10: {
                    jobHistoryProxy.setJobPriority(resultSet.getInt("job_priority"));
                    break;
                }
                case 11: {
                    jobHistoryProxy.setAgentEndedTime(resultSet.getLong("agent_ended_time_utc"));
                    break;
                }
                case 12: {
                    jobHistoryProxy.setJobSuiteID(resultSet.getLong("job_suite_id"));
                    break;
                }
                case 13: {
                    jobHistoryProxy.setJobSuiteMemberID(resultSet.getLong("job_suite_member_job_id"));
                    break;
                }
                case 14: {
                    jobHistoryProxy.setJobSuiteHistoryID(resultSet.getLong("job_suite_history_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private static enum JobHistoryPurgeOption {
        DO_NOT_PURGE,
        PURGE_BY_RUNS_TO_KEEP,
        PURGE_BY_DAYS_TO_KEEP;

    }
}

