/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.dm.AgentEventCountRollupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.DateConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AgentEventCountRollupDMJdbc
extends AbstractHelpingDatabaseManager
implements AgentEventCountRollupDM {
    private static final String TABLE = "agent_event_count_rollups";
    private static final Logger logger = Logger.getLogger(AgentEventCountRollupDMJdbc.class);
    private Object lockObject = new Object();

    public AgentEventCountRollupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AgentEventCountRollupDM");
    }

    @Override
    public void saveAgentEventCount(Connection connection, int n, long l) throws ResourceUnavailableException, DataException {
        String string = null;
        switch (n) {
            case 0: {
                string = "manual_type_count";
                break;
            }
            case 1: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                string = "file_type_count";
                break;
            }
            case 2: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                string = "directory_type_count";
                break;
            }
            case 3: 
            case 301: 
            case 302: {
                string = "process_type_count";
                break;
            }
            default: {
                logger.error((Object)("Agent Event type is not valid: " + n));
            }
        }
        if (string != null) {
            this.updateInsertRow(connection, string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInsertRow(Connection connection, String string, long l) {
        long l2 = DateConverter.calculateDay(l);
        Object object = this.lockObject;
        synchronized (object) {
            try {
                if (this.updateRow(connection, string, l2) == 0) {
                    this.insertRow(connection, string, l2);
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error performing 'updateInsertRow' for column " + string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRow(Connection connection, String string, long l) throws ResourceUnavailableException, SQLException {
        int n;
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        try {
            connection2 = connection == null ? this.getConnectionOrFail() : connection;
            String string2 = "UPDATE agent_event_count_rollups SET " + string + " = " + string + " + 1 " + "WHERE day = ?";
            preparedStatement = connection2.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            AgentEventCountRollupDMJdbc.closeEm(null, preparedStatement, null);
            if (connection == null) {
                AgentEventCountRollupDMJdbc.closeEm((Connection)connection2, null, null);
            }
            throw throwable;
        }
        AgentEventCountRollupDMJdbc.closeEm(null, (Statement)preparedStatement, null);
        if (connection == null) {
            AgentEventCountRollupDMJdbc.closeEm((Connection)connection2, null, null);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void insertRow(Connection connection, String string, long l) {
        Connection connection2 = null;
        String string2 = null;
        PreparedStatement preparedStatement = null;
        try {
            string2 = "INSERT INTO agent_event_count_rollups (day, " + string + ") values (?, 1)";
            connection2 = connection == null ? this.getConnectionOrFail() : connection;
            preparedStatement = connection2.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            AgentEventCountRollupDMJdbc.closeEm(null, preparedStatement, null);
            if (connection == null) {
                AgentEventCountRollupDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Inserting to agent_event_count_rollups table ", (Throwable)sQLException);
            {
                catch (Throwable throwable) {
                    AgentEventCountRollupDMJdbc.closeEm(null, preparedStatement, null);
                    if (connection == null) {
                        AgentEventCountRollupDMJdbc.closeEm(connection2, null, null);
                    }
                    throw throwable;
                }
            }
            AgentEventCountRollupDMJdbc.closeEm(null, preparedStatement, null);
            if (connection == null) {
                AgentEventCountRollupDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
        AgentEventCountRollupDMJdbc.closeEm(null, (Statement)preparedStatement, null);
        if (connection == null) {
            AgentEventCountRollupDMJdbc.closeEm((Connection)connection2, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manualAgentEventPurge(long l) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            long l2 = DateConverter.getCompDay(l);
            logger.debug((Object)("Purging Agent Event Count Rollup older than: " + ScheduleLogger.formatTimeStamp(l2)));
            wrappedConnection = this.getConnectionOrFail();
            String string = "DELETE FROM agent_event_count_rollups WHERE day < ?";
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Deleting from agent_event_count_rollups table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                AgentEventCountRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        AgentEventCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }
}

