/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.MultipleMatchesException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.AgentDM;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AgentDMJdbc
extends AbstractHelpingDatabaseManager
implements AgentDM {
    private static Logger logger = Logger.getLogger(AgentDMJdbc.class);
    BusinessObjectGenerator busObjGenerator = new AgentProxyGenerator();
    private static final String TABLE = "agents";
    private String table;

    public AgentDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AgentDM");
        this.table = string2 + "." + TABLE;
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException, DataSetException {
        try {
            return super.getDataSet((Object)new AgentProxy(), dataFilter, sortField);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to retrieve a set of Agent objects.", (Throwable)sQLException);
        }
    }

    @Override
    public DataSet getAgentDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException, DataSetException {
        try {
            return super.getDataSet((Object)new Agent(), dataFilter, sortField);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to retrieve a set of Agent objects.", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Agent save(Agent agent) throws ResourceUnavailableException, DataException {
        Agent agent2 = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            agent2 = (Agent)((Object)super.save((Connection)wrappedConnection, (Object)agent));
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"Error saving agent", (Throwable)sQLException);
        }
        finally {
            AgentDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return agent2;
    }

    @Override
    public void updateDefaultJobQueueID(long l, long l2) throws Exception {
        String string = "update agents set default_job_queue_id=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new Exception("Error updating the agent's default job queue ID.", exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void updateLock(long l, boolean bl) throws Exception {
        String string = "update agents set queues_locked=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new Exception("Error updating the agent's lock state.", exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLicenseAllocation(long l, boolean bl) {
        String string = "update agents set allocate_license=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.debug((Object)"Error updating the agent's license allocation.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRuntimeState(long l, int n) {
        String string = "update agents set runtime_state=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.debug((Object)"Error updating the agent's runtime state.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePoints(long l, int n) {
        String string = "update agents set license_points=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.debug((Object)"Error updating the agent points.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTier(long l, int n) {
        String string = "update agents set tier=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.debug((Object)"Error updating the agent tier.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public Agent get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    @Override
    public Agent get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        Agent agent = new Agent();
        agent.setOid(l);
        agent = connection == null ? (Agent)((Object)super.get((Object)agent)) : (Agent)((Object)super.get(connection, (Object)agent));
        if (agent == null) {
            throw new NoDataException("The requested Agent was not found for ID " + l + ".");
        }
        return agent;
    }

    @Override
    public AgentProxy[] getList() throws DataException, ResourceUnavailableException {
        return this.getList(null);
    }

    @Override
    public AgentProxy[] getList(Connection connection) throws DataException, ResourceUnavailableException {
        String string = this.getSqlStatement();
        Connection connection2 = connection;
        ResultSet resultSet = null;
        if (connection2 == null) {
            connection2 = super.getConnectionOrFail();
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
        try {
            resultSet = preparedStatement.executeQuery();
            AgentProxy[] agentProxyArray = (AgentProxy[])this.busObjGenerator.generateObjectArray(resultSet);
            return agentProxyArray;
        }
        catch (SQLException sQLException) {
            String string2 = "Unable to retrieve the list of Job Monitor Events.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (connection != null) {
                AgentDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            } else {
                AgentDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    @Override
    public ArrayList<Long> getLockedAgentIDs() throws ResourceUnavailableException, DataException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("getQueuesLocked", true);
        Agent[] agentArray = (Agent[])super.search((Object)new Agent(), hashMap);
        for (int i = 0; i < agentArray.length; ++i) {
            arrayList.add(agentArray[i].getOid());
        }
        return arrayList;
    }

    @Override
    public Agent getByHardwareHashAndInstanceIdentifier(String string, String string2) throws DataException, ResourceUnavailableException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("getHardwareHash", (Serializable)((Object)string));
        hashMap.put("getInstanceIdentifier", (Serializable)((Object)string2));
        return this.doHardwareSearch(hashMap);
    }

    @Override
    public Agent getByHardwareKeyAndInstanceIdentifier(String string, String string2) throws DataException, ResourceUnavailableException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("getHardwareKey", (Serializable)((Object)string));
        hashMap.put("getInstanceIdentifier", (Serializable)((Object)string2));
        return this.doHardwareSearch(hashMap);
    }

    @Override
    public Agent getByAgentName(String string) throws DataException, ResourceUnavailableException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("getName", (Serializable)((Object)string));
        return this.doHardwareSearch(hashMap);
    }

    private Agent doHardwareSearch(HashMap<String, Serializable> hashMap) throws DataException, ResourceUnavailableException {
        Agent[] agentArray = (Agent[])super.search((Object)new Agent(), hashMap);
        if (agentArray.length == 0) {
            return null;
        }
        if (agentArray.length > 1) {
            throw new MultipleMatchesException("Found " + agentArray.length + " matches.");
        }
        return agentArray[0];
    }

    @Override
    public Agent[] getByState(int n) throws DataException, ResourceUnavailableException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("getRuntimeState", n);
        return (Agent[])super.search((Object)new Agent(), hashMap);
    }

    @Override
    public void saveLicenseInfo(Agent agent) throws ResourceUnavailableException {
        String string = "update agents set allocate_license = ? where ID = ?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            int n = 0;
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, agent.getLicenseAllocated());
            preparedStatement.setLong(2, agent.getOid());
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                logger.debug((Object)("Agent " + agent.getName() + " not updated."));
            }
        }
        catch (Exception exception) {
            try {
                throw new ResourceUnavailableException("Could not update license information.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllAllocated() {
        String string = "update agents set allocate_license = ?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, true);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.debug((Object)"Could not get a count of allocated license agents.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                AgentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        AgentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public Agent[] getByLicenseAllocation(boolean bl) throws DataException, ResourceUnavailableException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("getLicenseAllocated", bl);
        return (Agent[])super.search((Object)new Agent(), hashMap);
    }

    private String getSqlStatement() {
        return "SELECT id, name, description, operating_system, license_points, hardware_hash, allocate_license, runtime_state, tier, instance_identifier, connection_match_type FROM " + this.table;
    }

    private class AgentProxyGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 11;

        AgentProxyGenerator() {
            super(11, AgentProxy.class.getName());
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentProxy agentProxy = (AgentProxy)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    agentProxy.setName(string);
                    break;
                }
                case 2: {
                    agentProxy.setOid(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    agentProxy.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    agentProxy.setOperatingSystem(resultSet.getString("operating_system"));
                    break;
                }
                case 5: {
                    agentProxy.setLicensePoints(resultSet.getInt("license_points"));
                    break;
                }
                case 6: {
                    agentProxy.setHardwareHash(resultSet.getString("hardware_hash"));
                    break;
                }
                case 7: {
                    agentProxy.setLicenseAllocated(resultSet.getBoolean("allocate_license"));
                    break;
                }
                case 8: {
                    agentProxy.setRuntimeState(resultSet.getInt("runtime_state"));
                    break;
                }
                case 9: {
                    agentProxy.setLicenseTier(resultSet.getInt("tier"));
                    break;
                }
                case 10: {
                    agentProxy.setInstanceIdentifier(resultSet.getString("instance_identifier"));
                    break;
                }
                case 11: {
                    agentProxy.setConnectionMatchType(resultSet.getInt("connection_match_type"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected Object constructObject() {
            return new AgentProxy();
        }
    }
}

