/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.informatica;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Parameter;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaWorkflowCommandsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InformaticaWorkflowCommandsDMJdbc
extends AbstractHelpingDatabaseManager
implements InformaticaWorkflowCommandsDM {
    private static Logger LOGGER = Logger.getLogger(InformaticaWorkflowCommandsDMJdbc.class);
    private static final String OBJ_DESC = "Informatica Workflow Command";
    private static final String INFORMATICA_WORLFLOW_COMMANDS_TABLE = "informatica_workflow_commands";
    private String informaticaWorkflowCommandsTable;
    private static final String WORKFLOW_PARAMETER_TABLE = "informatica_workflow_command_parameters";
    private String workflowParameterTable;

    public InformaticaWorkflowCommandsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.InformaticaCommandsDM");
        this.informaticaWorkflowCommandsTable = string2 + "." + INFORMATICA_WORLFLOW_COMMANDS_TABLE;
        this.workflowParameterTable = string2 + "." + WORKFLOW_PARAMETER_TABLE;
    }

    @Override
    public InformaticaWorkflowCommand get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            InformaticaWorkflowCommand informaticaWorkflowCommand;
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, command_id, informatica_repository_id, integration_service_name,folder_name,workflow_name, run_instance_name, task_instance_path,run_task,os_user,parameter_file,retrieve_log FROM " + this.informaticaWorkflowCommandsTable + " WHERE id=?";
            InformaticaWorkflowCommandGenerator informaticaWorkflowCommandGenerator = new InformaticaWorkflowCommandGenerator(12);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            InformaticaWorkflowCommand informaticaWorkflowCommand2 = informaticaWorkflowCommand = (InformaticaWorkflowCommand)((Object)informaticaWorkflowCommandGenerator.generateObject(resultSet));
            InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return informaticaWorkflowCommand2;
        }
        try {
            try {
                throw new NoDataException("Informatica Workflow Command not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public List<InformaticaWorkflowCommand> getByCmdID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<InformaticaWorkflowCommand> arrayList = new ArrayList<InformaticaWorkflowCommand>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "SELECT id, command_id, informatica_repository_id, integration_service_name,folder_name,workflow_name, run_instance_name, task_instance_path,run_task,os_user,parameter_file,retrieve_log FROM " + this.informaticaWorkflowCommandsTable + " WHERE command_id=?";
        InformaticaWorkflowCommandGenerator informaticaWorkflowCommandGenerator = new InformaticaWorkflowCommandGenerator(12);
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add((InformaticaWorkflowCommand)((Object)informaticaWorkflowCommandGenerator.generateObject(resultSet)));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public List<Parameter> getParameterListByCmdID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "SELECT name, value,scope FROM " + this.workflowParameterTable + " WHERE informatica_workflow_command_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new Parameter(resultSet.getString("scope"), resultSet.getString("name"), resultSet.getString("value")));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        InformaticaWorkflowCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    private class InformaticaWorkflowCommandGenerator
    extends AbstractBusObjGenerator {
        public InformaticaWorkflowCommandGenerator(int n) {
            super(n, InformaticaWorkflowCommandsDMJdbc.OBJ_DESC);
        }

        protected Object constructObject() {
            return new InformaticaWorkflowCommand();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            InformaticaWorkflowCommand informaticaWorkflowCommand = (InformaticaWorkflowCommand)((Object)object);
            switch (n) {
                case 1: {
                    informaticaWorkflowCommand.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    informaticaWorkflowCommand.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    informaticaWorkflowCommand.setInfaRepoID(resultSet.getLong("informatica_repository_id"));
                    break;
                }
                case 4: {
                    informaticaWorkflowCommand.setIntegrationSvcName(resultSet.getString("integration_service_name"));
                    break;
                }
                case 5: {
                    informaticaWorkflowCommand.setFolderName(resultSet.getString("folder_name"));
                    break;
                }
                case 6: {
                    informaticaWorkflowCommand.setWorkflowName(resultSet.getString("workflow_name"));
                    break;
                }
                case 7: {
                    informaticaWorkflowCommand.setRunInstanceName(resultSet.getString("run_instance_name"));
                    break;
                }
                case 8: {
                    informaticaWorkflowCommand.setTaskInstancePath(resultSet.getString("task_instance_path"));
                    break;
                }
                case 9: {
                    informaticaWorkflowCommand.setRunTask(resultSet.getBoolean("run_task"));
                    break;
                }
                case 10: {
                    informaticaWorkflowCommand.setOsUser(resultSet.getString("os_user"));
                    break;
                }
                case 11: {
                    informaticaWorkflowCommand.setParameterFile(resultSet.getString("parameter_file"));
                    break;
                }
                case 12: {
                    informaticaWorkflowCommand.setRetrieveLog(resultSet.getBoolean("retrieve_log"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

