/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.informatica;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudServer;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaCloudServersDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class InformaticaCloudServersDMJdbc
extends AbstractHelpingDatabaseManager
implements InformaticaCloudServersDM {
    private static Logger LOGGER = Logger.getLogger(InformaticaCloudServersDMJdbc.class);
    private static final String OBJ_DESC = "Informatica Cloud Server";
    private static final String INFORMATICA_CLOUD_SERVICES_TABLE = "informatica_cloud_servers";
    private String informaticaCloudServicesTable;

    public InformaticaCloudServersDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.InformaticaCloudServersDM");
        this.informaticaCloudServicesTable = string2 + "." + INFORMATICA_CLOUD_SERVICES_TABLE;
    }

    @Override
    public InformaticaCloudServer get(long l) throws ResourceUnavailableException, BadDataException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            InformaticaCloudServer informaticaCloudServer;
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, name,description,base_url, user_email,encrypted_password,password_salt, verbose_logging, initial_polling_interval,initial_polling_attempts,status_polling_interval FROM " + this.informaticaCloudServicesTable + " WHERE id=?";
            InformaticaCloudServerGenerator informaticaCloudServerGenerator = new InformaticaCloudServerGenerator(11);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            InformaticaCloudServer informaticaCloudServer2 = informaticaCloudServer = (InformaticaCloudServer)((Object)informaticaCloudServerGenerator.generateObject(resultSet));
            InformaticaCloudServersDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return informaticaCloudServer2;
        }
        try {
            try {
                throw new NoDataException("Informatica Cloud Server not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            InformaticaCloudServersDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class InformaticaCloudServerGenerator
    extends AbstractBusObjGenerator {
        public InformaticaCloudServerGenerator(int n) {
            super(n, InformaticaCloudServersDMJdbc.OBJ_DESC);
        }

        protected Object constructObject() {
            return new InformaticaCloudServer();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            InformaticaCloudServer informaticaCloudServer = (InformaticaCloudServer)((Object)object);
            switch (n) {
                case 1: {
                    informaticaCloudServer.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    informaticaCloudServer.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    informaticaCloudServer.setDescription(string);
                    break;
                }
                case 4: {
                    informaticaCloudServer.setBaseURL(resultSet.getString("base_url"));
                    break;
                }
                case 5: {
                    informaticaCloudServer.setUserEmail(resultSet.getString("user_email"));
                    break;
                }
                case 6: {
                    informaticaCloudServer.setEncryptedPassword(resultSet.getString("encrypted_password"));
                    break;
                }
                case 7: {
                    String string = resultSet.getString("password_salt");
                    if (string == null) {
                        string = "";
                    }
                    informaticaCloudServer.setPasswordSalt(string);
                    break;
                }
                case 8: {
                    informaticaCloudServer.setVerboseLogging(resultSet.getBoolean("verbose_logging"));
                    break;
                }
                case 9: {
                    informaticaCloudServer.setInitialPollingInterval(resultSet.getInt("initial_polling_interval"));
                    break;
                }
                case 10: {
                    informaticaCloudServer.setInitialPollingAttempts(resultSet.getInt("initial_polling_attempts"));
                    break;
                }
                case 11: {
                    informaticaCloudServer.setStatusPollingInterval(resultSet.getInt("status_polling_interval"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

