/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.informatica;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudCommand;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaCloudCommandsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class InformaticaCloudCommandsDMJdbc
extends AbstractHelpingDatabaseManager
implements InformaticaCloudCommandsDM {
    private static final String OBJ_DESC = "Informatica Cloud Command";
    private static final String INFORMATICA_CLOUD_COMMANDS_TABLE = "informatica_cloud_commands";
    private String informaticaCloudCommandsTable;
    private final String fields = "id, command_id, informatica_cloud_server_id,task_type,task_name,task_id, continue_immediately";
    private final int filedsCount = 7;

    public InformaticaCloudCommandsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.InformaticaCloudCommandsDM");
        this.informaticaCloudCommandsTable = string2 + "." + INFORMATICA_CLOUD_COMMANDS_TABLE;
    }

    @Override
    public InformaticaCloudCommand get(long l) throws ResourceUnavailableException, BadDataException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            InformaticaCloudCommand informaticaCloudCommand;
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, command_id, informatica_cloud_server_id,task_type,task_name,task_id, continue_immediately FROM " + this.informaticaCloudCommandsTable + " WHERE id=?";
            InformaticaCloudCommandGenerator informaticaCloudCommandGenerator = new InformaticaCloudCommandGenerator(7);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            InformaticaCloudCommand informaticaCloudCommand2 = informaticaCloudCommand = (InformaticaCloudCommand)((Object)informaticaCloudCommandGenerator.generateObject(resultSet));
            InformaticaCloudCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return informaticaCloudCommand2;
        }
        try {
            try {
                throw new NoDataException("Informatica Cloud Command not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            InformaticaCloudCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public List<InformaticaCloudCommand> getByCmdID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<InformaticaCloudCommand> arrayList = new ArrayList<InformaticaCloudCommand>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "SELECT id, command_id, informatica_cloud_server_id,task_type,task_name,task_id, continue_immediately FROM " + this.informaticaCloudCommandsTable + " WHERE command_id=?";
        InformaticaCloudCommandGenerator informaticaCloudCommandGenerator = new InformaticaCloudCommandGenerator(7);
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add((InformaticaCloudCommand)((Object)informaticaCloudCommandGenerator.generateObject(resultSet)));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{OBJ_DESC, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                InformaticaCloudCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        InformaticaCloudCommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    private class InformaticaCloudCommandGenerator
    extends AbstractBusObjGenerator {
        public InformaticaCloudCommandGenerator(int n) {
            super(n, InformaticaCloudCommandsDMJdbc.OBJ_DESC);
        }

        protected Object constructObject() {
            return new InformaticaCloudCommand();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            InformaticaCloudCommand informaticaCloudCommand = (InformaticaCloudCommand)((Object)object);
            switch (n) {
                case 1: {
                    informaticaCloudCommand.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    informaticaCloudCommand.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    informaticaCloudCommand.setCloudServerID(resultSet.getLong("informatica_cloud_server_id"));
                    break;
                }
                case 4: {
                    informaticaCloudCommand.setTaskType(resultSet.getString("task_type"));
                    break;
                }
                case 5: {
                    informaticaCloudCommand.setTaskName(resultSet.getString("task_name"));
                    break;
                }
                case 6: {
                    informaticaCloudCommand.setTaskID(resultSet.getString("task_id"));
                    break;
                }
                case 7: {
                    informaticaCloudCommand.setContinueImmediately(resultSet.getBoolean("continue_immediately"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

