/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.dm.IBMiJobExecDM;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import java.beans.PropertyVetoException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IBMiJobStatusMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(IBMiJobStatusMonitor.class);
    private static String messageQueueName = "SKYJOBSTS";
    private volatile boolean endMonitor;
    private IBMiJobExecDM jobExecDM;

    public IBMiJobStatusMonitor(IBMiJobExecDM iBMiJobExecDM) {
        this.jobExecDM = iBMiJobExecDM;
        this.setupShutdownHook();
    }

    @Override
    public void run() {
        Throwable throwable = null;
        try {
            logger.info((Object)"The Job Status Monitor has been started.");
            this.processNotifications();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
        }
        finally {
            try {
                String string = "The Job Status Monitor is ending";
                if (this.endMonitor) {
                    logger.info((Object)(string + ", due to a requested shutdown."));
                } else if (throwable != null) {
                    logger.fatal((Object)(string + ", due to an error."), throwable);
                } else {
                    logger.fatal((Object)(string + ", due to an error. See previous message(s)."));
                }
            }
            catch (Throwable throwable3) {}
        }
    }

    public void endMonitor() throws ActionFailedException {
        if (!this.endMonitor) {
            this.endMonitor = true;
            logger.info((Object)"A request was received to end the Job Status Monitor.");
            try {
                this.sendDummyMessage();
            }
            catch (Exception exception) {
                String string = "Unable to end the Job Status Monitor, via the technique of sending a message to the Job Status Message Queue.";
                throw new ActionFailedException(string, (Throwable)exception);
            }
        }
    }

    private MessageQueue getLinkToJobStatusMessageQueue() {
        String string = IBMiAgent.getAS400SystemName();
        String string2 = IBMiAgent.getAS400UserName();
        String string3 = IBMiAgent.getAS400Password();
        AS400 aS400 = new AS400(string, string2, string3);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false).");
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        return this.getMessageQueue(aS400);
    }

    private MessageQueue getMessageQueue(AS400 aS400) {
        String string = QSYSObjectPathName.toPath((String)this.libraryName(), (String)messageQueueName, (String)"MSGQ");
        return new MessageQueue(aS400, string);
    }

    private String libraryName() {
        return IBMiAgent.getProdlib();
    }

    private String messageTypeText(int n) {
        switch (n) {
            case 1: {
                return "COMPLETION";
            }
            case 2: {
                return "DIAGNOSTIC";
            }
            case 4: {
                return "INFORMATIONAL";
            }
            case 5: {
                return "INQUIRY";
            }
            case 15: {
                return "ESCAPE";
            }
        }
        return "Unknown";
    }

    private void processMessage(QueuedMessage queuedMessage, MessageQueue messageQueue) {
        if (queuedMessage != null) {
            String string = queuedMessage.getID();
            if (string.equals("SK10001")) {
                if (!this.endMonitor) {
                    JobStatusMessage jobStatusMessage = new JobStatusMessage(queuedMessage.getSubstitutionData());
                    long l = queuedMessage.getDate().getTimeInMillis();
                    this.jobExecDM.notifyOfJobStatusChange(jobStatusMessage.getJobHistoryID(), jobStatusMessage.getStatusCode(), jobStatusMessage.getJobIdentifier(), l, jobStatusMessage.getFailedAtCommandSequence());
                    this.removeMessageFromQueue(queuedMessage.getKey(), messageQueue);
                }
            } else if (queuedMessage.getText().startsWith("Dummy message")) {
                this.removeMessageFromQueue(queuedMessage.getKey(), messageQueue);
            } else {
                String string2 = MessageUtil.formatMsg((String)"Invalid message received on message queue {0}. The message will be removed from the queue and ignored. Message details - Text: {1} From: {2}/{3}/{4} Type: {5}-{6}", (Object[])new Object[]{messageQueue.getPath(), queuedMessage.getText(), queuedMessage.getFromJobNumber(), queuedMessage.getUser(), queuedMessage.getFromJobName(), queuedMessage.getType(), this.messageTypeText(queuedMessage.getType())});
                logger.warn((Object)string2);
                this.removeMessageFromQueue(queuedMessage.getKey(), messageQueue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        MessageQueue messageQueue = this.getLinkToJobStatusMessageQueue();
        try {
            while (!this.endMonitor) {
                QueuedMessage queuedMessage = this.receiveMessage(messageQueue);
                this.processMessage(queuedMessage, messageQueue);
            }
        }
        finally {
            try {
                messageQueue.getSystem().disconnectAllServices();
            }
            catch (Exception exception) {
                try {
                    logger.error((Object)"", (Throwable)exception);
                }
                catch (Exception exception2) {}
            }
        }
    }

    private QueuedMessage receiveMessage(MessageQueue messageQueue) {
        int n = (int)TimeUnit.MINUTES.toSeconds(2L);
        int n2 = 0;
        while (!this.endMonitor) {
            try {
                QueuedMessage queuedMessage = messageQueue.receive(null, n, "*SAME", "*FIRST");
                if (n2 > 0) {
                    logger.info((Object)MessageUtil.formatMsg((String)"The Job Status Monitor is now receiving job status messages from {0} normally.", (Object[])new Object[]{messageQueue.getPath()}));
                }
                return queuedMessage;
            }
            catch (InterruptedException interruptedException) {
                logger.info((Object)"The Job Status Monitor was interrupted while waiting to receive a message from the queue. This is typically associated with a shutdown request.", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                if (++n2 == 1) {
                    String string = MessageUtil.formatMsg((String)"The Job Status Monitor was unable to receive a message from {0} and is therefore unable to notify the server of job status changes. The Job Status Monitor will retry every minute and will issue a message and resume normal processing when (if) it is successful.", (Object[])new Object[]{messageQueue.getPath()});
                    logger.error((Object)string, (Throwable)exception);
                    this.jobExecDM.notifyServerOfError();
                }
                try {
                    Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    private void removeMessageFromQueue(byte[] byArray, MessageQueue messageQueue) {
        int n = 0;
        while (true) {
            try {
                messageQueue.remove(byArray);
                if (n > 0) {
                    logger.info((Object)MessageUtil.formatMsg((String)"The Job Status Monitor is now able to remove job status messages from {0} normally.", (Object[])new Object[]{messageQueue.getPath()}));
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                logger.warn((Object)"The Job Status Monitor was interrupted while trying to remove a message from the queue, after it was processed.", (Throwable)interruptedException);
                return;
            }
            catch (Exception exception) {
                if (++n == 1) {
                    String string = MessageUtil.formatMsg((String)"The Job Status Monitor was unable to remove a message from {0}. No statuses will be sent to the server until this status message can be removed from the message queue. The Job Status Monitor will retry every minute and will issue a message and resume normal processing when (if) it is successful.", (Object[])new Object[]{messageQueue.getPath()});
                    logger.error((Object)string, (Throwable)exception);
                    this.jobExecDM.notifyServerOfError();
                }
                try {
                    Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.endMonitor) continue;
                return;
            }
            break;
        }
    }

    private void sendDummyMessage() throws ActionFailedException {
        try {
            MessageQueue messageQueue = this.getLinkToJobStatusMessageQueue();
            messageQueue.sendInformational("Dummy message used to release the QMHRCVM lock.");
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to send a message to the Job Status Message Queue.", (Throwable)exception);
        }
    }

    private void setupShutdownHook() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!IBMiJobStatusMonitor.this.endMonitor) {
                    try {
                        logger.warn((Object)"The agent has been notified that the JVM is shutting down.");
                        logger.info((Object)"The Job Status Monitor will be requested to end.");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        IBMiJobStatusMonitor.this.endMonitor();
                    }
                    catch (ActionFailedException actionFailedException) {
                        // empty catch block
                    }
                }
            }
        });
        try {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to add a JVM shutdown hook. This will prevent the immediate release of the lock on the job status message queue in the event of a JVM shutdown.", (Throwable)exception);
        }
    }

    private class JobStatusMessage {
        private byte[] messageData;

        private JobStatusMessage(byte[] byArray) {
            this.messageData = byArray;
        }

        private long getJobHistoryID() {
            long l = BinaryConverter.byteArrayToLong((byte[])this.messageData, (int)0);
            return l;
        }

        private IBMiJobIdentifier getJobIdentifier() {
            AS400Text aS400Text = new AS400Text(10);
            String string = ((String)aS400Text.toObject(this.messageData, 16)).trim();
            String string2 = ((String)aS400Text.toObject(this.messageData, 26)).trim();
            String string3 = ((String)new AS400Text(6).toObject(this.messageData, 36)).trim();
            return new IBMiJobIdentifier(string, string2, string3);
        }

        private char getStatusCode() {
            String string = (String)new AS400Text(1).toObject(this.messageData, 42);
            return string.charAt(0);
        }

        private int getFailedAtCommandSequence() {
            String string = (String)new AS400Text(6).toObject(this.messageData, 43);
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to convert the command sequence {0} for run ID {1} to a number", (Object[])new Object[]{string, this.getJobHistoryID()}), (Throwable)numberFormatException);
                return 0;
            }
        }
    }
}

