/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.access.ibmi.IBMiJobInfoDMImpl;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.dm.IBMiJobDM;
import com.helpsystems.enterprise.core.dm.IBMiJobExecDM;
import com.helpsystems.enterprise.core.dm.IBMiJobInfoDM;
import com.helpsystems.enterprise.core.ibmi.IBMiJob;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.helpsystems.enterprise.core.ibmi.IBMiJobInfo;
import com.helpsystems.enterprise.core.ibmi.IBMiJobStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IBMiJobStateMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(IBMiJobStateMonitor.class);
    private boolean endMonitor;
    private IBMiJobExecDM jobExecDM;
    private IBMiJobDM jobDM;
    private IBMiJobInfoDM jobInfoDM = new IBMiJobInfoDMImpl();

    public IBMiJobStateMonitor(IBMiJobExecDM iBMiJobExecDM, IBMiJobDM iBMiJobDM) {
        this.jobExecDM = iBMiJobExecDM;
        this.jobDM = iBMiJobDM;
    }

    @Override
    public void run() {
        Throwable throwable = null;
        try {
            logger.info((Object)"The Job State Monitor has been started.");
            this.monitorState();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
        }
        finally {
            try {
                String string = "The Job State Monitor is ending";
                if (this.endMonitor) {
                    logger.info((Object)(string + ", due to a requested shutdown."));
                } else if (throwable != null) {
                    logger.fatal((Object)(string + ", due to an error."), throwable);
                } else {
                    logger.fatal((Object)(string + ", due to an error. See previous message(s)."));
                }
            }
            catch (Throwable throwable3) {}
        }
    }

    public void endMonitor() {
        if (!this.endMonitor) {
            this.endMonitor = true;
            logger.info((Object)"A request was received to end the Job State Monitor.");
        }
    }

    private void monitorState() {
        long l = TimeUnit.MINUTES.toMillis(3L);
        while (!this.endMonitor) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                logger.info((Object)"The Job State Monitor was interrupted while sleeping. This is typically associated with a shutdown request.", (Throwable)interruptedException);
                return;
            }
            try {
                this.verifyTheStateOfAllActiveJobs();
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)"An error occurred that prevented the Job State Monitor from identifying IBM i jobs that have been ended via the IBM i operating system, rather than from Automate Schedule. The monitor will retry at its next scheduled wakeup.", (Throwable)actionFailedException);
            }
        }
    }

    private boolean areThereAnyJobsInEndedStatus(IBMiJob[] iBMiJobArray) {
        for (IBMiJob iBMiJob : iBMiJobArray) {
            JobStatusCode jobStatusCode = iBMiJob.getJobStatus();
            IBMiJobStatus iBMiJobStatus = iBMiJob.getIBMiJobStatus();
            if (jobStatusCode != JobStatusCode.SUBMITTED || iBMiJobStatus != IBMiJobStatus.ENDED && iBMiJobStatus != IBMiJobStatus.OUT_QUEUE) continue;
            return true;
        }
        return false;
    }

    private void clearWaitingFlags(IBMiJob[] iBMiJobArray) {
        for (IBMiJob iBMiJob : iBMiJobArray) {
            if (!this.isWaitingOrHeld(iBMiJob.getIBMiActiveJobStatus())) continue;
            try {
                this.jobDM.clearActiveJobStatuses();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Unable to clear the active job status column in the database.", (Throwable)resourceUnavailableException);
            }
            return;
        }
    }

    private boolean isWaitingOrHeld(String string) {
        return string.equals("MSGW") || string.equals("LCKW") || string.equals("HLD");
    }

    private void verifyTheStateOfAllActiveJobs() throws ActionFailedException {
        IBMiJob[] iBMiJobArray = null;
        try {
            iBMiJobArray = this.jobDM.getJobs();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ActionFailedException("Unable to get a list of the IBM i jobs that we have initiated.", (Throwable)resourceUnavailableException);
        }
        boolean bl = this.areThereAnyJobsInEndedStatus(iBMiJobArray);
        this.clearWaitingFlags(iBMiJobArray);
        HashMap<Long, IBMiJobIdentifier> hashMap = null;
        for (IBMiJob object2 : iBMiJobArray) {
            Object object = object2.getIBMiJobStatus();
            if (object != IBMiJobStatus.ACTIVE && object != IBMiJobStatus.JOB_QUEUE && object != IBMiJobStatus.UNKNOWN) continue;
            if (hashMap == null) {
                hashMap = new HashMap<Long, IBMiJobIdentifier>(iBMiJobArray.length);
            }
            hashMap.put(object2.getJobHistoryID(), object2.getJobIdentifier());
        }
        if (hashMap != null) {
            Map<Long, IBMiJobInfo> map = this.jobInfoDM.getJobInfo(hashMap);
            int n = 0;
            Set set = map.entrySet();
            for (Object object : set) {
                String string;
                Long l = (Long)object.getKey();
                IBMiJobInfo iBMiJobInfo = (IBMiJobInfo)object.getValue();
                IBMiJobStatus iBMiJobStatus = iBMiJobInfo == null ? IBMiJobStatus.ENDED : iBMiJobInfo.getJobStatus();
                if (iBMiJobStatus == IBMiJobStatus.ENDED || iBMiJobStatus == IBMiJobStatus.OUT_QUEUE) {
                    try {
                        this.jobDM.updateIBMiJobStatus(l, iBMiJobStatus);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        throw new ActionFailedException(MessageUtil.formatMsg((String)"Unable to update the job status for run ID {0} to {1}.", (Object[])new Object[]{l, iBMiJobStatus}), (Throwable)resourceUnavailableException);
                    }
                    n = 1;
                    bl = true;
                }
                if (iBMiJobStatus != IBMiJobStatus.ACTIVE || !this.isWaitingOrHeld(string = iBMiJobInfo.getActiveJobStatus())) continue;
                try {
                    this.jobDM.updateIBMiActiveJobStatus(l, string);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.warn((Object)MessageUtil.formatMsg((String)"Unable to update the active job status for run ID {0} to {1}.", (Object[])new Object[]{l, string}), (Throwable)resourceUnavailableException);
                }
                this.jobExecDM.notifyOfRunningJobWaitingOrHeld(l, string);
            }
            if (n != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            try {
                iBMiJobArray = this.jobDM.getJobs();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new ActionFailedException("Unable to get a list of the IBM i jobs that we have initiated.", (Throwable)resourceUnavailableException);
            }
            for (IBMiJob iBMiJob : iBMiJobArray) {
                if (iBMiJob.getJobStatus() != JobStatusCode.SUBMITTED || iBMiJob.getIBMiJobStatus() != IBMiJobStatus.ENDED && iBMiJob.getIBMiJobStatus() != IBMiJobStatus.OUT_QUEUE) continue;
                try {
                    this.jobExecDM.notifyOfJobEndedOrNotFound(iBMiJob.getJobHistoryID(), iBMiJob.getJobIdentifier());
                }
                catch (Exception exception) {
                    logger.warn((Object)MessageUtil.formatMsg((String)"Error while trying to notify the server that job {0} (run ID {1}) is no longer running or on a job queue.", (Object[])new Object[]{iBMiJob.getJobIdentifier(), iBMiJob.getJobHistoryID()}), (Throwable)exception);
                }
            }
        }
    }
}

