/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.IBMiAgentEnvironment;
import com.helpsystems.enterprise.core.busobj.IBMiCallException;
import com.helpsystems.enterprise.core.busobj.JobData;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.helpsystems.enterprise.core.ibmi.IBMiJobNotFoundException;
import com.helpsystems.enterprise.core.ibmi.IBMiJobStatus;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class IBMiJobExecDMHelper {
    private static final Logger logger = Logger.getLogger(IBMiJobExecDMHelper.class);
    private static final String PCML_FILE = "com.helpsystems.enterprise.access.ibmi.IBMiJobExecDMHelper";
    private static final String JOB_TABLE = "SKYJOB";
    private static final String COMMAND_TABLE = "SKYCMD";
    private static String library = IBMiAgent.getProdlib();
    private String jobTable = library + "." + "SKYJOB";
    private String commandTable = library + "." + "SKYCMD";
    private static final String PROGRAM_NAME = "SKY163";
    private static final String PROGRAM_SKY702 = "SKY702";

    public int activeJobCount() throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.jobTable + " WHERE (jobsts=? OR jobsts=?) AND jobibmsts<>? AND jobibmsts<>?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, JobStatusCode.SUBMITTED.persistanceCode());
            preparedStatement.setString(2, JobStatusCode.RUNNING.persistanceCode());
            preparedStatement.setString(3, IBMiJobStatus.ENDED.persistanceCode());
            preparedStatement.setString(4, IBMiJobStatus.OUT_QUEUE.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            try {
                throw new IllegalStateException("Unable to obtain the active job count.");
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Error retrieving the active job count.", (Throwable)exception);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void appendIBMiJobLog(IBMiJobIdentifier iBMiJobIdentifier, String string) throws ActionFailedException, IBMiCallException, IBMiJobNotFoundException {
        block9: {
            String string2 = PROGRAM_SKY702;
            AS400 aS400 = this.establishAS400Connection();
            logger.debug((Object)("Established AS400Connection to: " + aS400.getSystemName()));
            try {
                ProgramCallDocument programCallDocument = new ProgramCallDocument(aS400, PCML_FILE);
                String string3 = QSYSObjectPathName.toPath((String)library, (String)string2, (String)"PGM");
                programCallDocument.setPath(string2, string3);
                this.setSKY702PcmlParameterValues(programCallDocument, iBMiJobIdentifier.getPaddedJobIdentifier(), string);
                boolean bl = false;
                bl = programCallDocument.callProgram(string2);
                if (bl) break block9;
                try {
                    AS400Message[] aS400MessageArray = this.getAS400Messages(programCallDocument, string2);
                    this.scanAS400MessagesForErrors(aS400MessageArray);
                    throw new IBMiCallException("Error in call to program: " + string2, this.getAS400MessageTexts(aS400MessageArray));
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)"IBM i job log not available.", (Throwable)resourceUnavailableException);
                }
                catch (IBMiJobNotFoundException iBMiJobNotFoundException) {
                    throw new IBMiJobNotFoundException("Job " + iBMiJobIdentifier + " not found.");
                }
            }
            catch (PcmlException pcmlException) {
                String string4 = MessageUtil.formatMsg((String)"Unable to get the job log for job {0}.", (Object[])new Object[]{iBMiJobIdentifier});
                logger.error((Object)string4, (Throwable)pcmlException);
                throw new ActionFailedException(string4, (Throwable)pcmlException);
            }
            catch (QualifiedObjectNameException qualifiedObjectNameException) {
                String string5 = MessageUtil.formatMsg((String)"Unable to get the job log for job {0}.", (Object[])new Object[]{iBMiJobIdentifier});
                logger.error((Object)string5, (Throwable)qualifiedObjectNameException);
                throw new ActionFailedException(string5, (Throwable)qualifiedObjectNameException);
            }
            finally {
                aS400.disconnectAllServices();
                logger.debug((Object)("Disconnected AS400Connection to: " + aS400.getSystemName()));
            }
        }
    }

    public JobData[] getActiveJobs() throws ResourceUnavailableException {
        JobDataGenerator jobDataGenerator = new JobDataGenerator();
        String string = "SELECT jobid, jobhid, jobsname, jobname, jobuser, jobnum, jobsvrtrm, jobagstts, jobcpyjl, jobsrints, joblogfil FROM " + this.jobTable + " WHERE (jobsts=? OR jobsts=?) AND jobibmsts<>? AND jobibmsts<>?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        ArrayList<JobData> arrayList = new ArrayList<JobData>();
        try {
            preparedStatement.setString(1, JobStatusCode.SUBMITTED.persistanceCode());
            preparedStatement.setString(2, JobStatusCode.RUNNING.persistanceCode());
            preparedStatement.setString(3, IBMiJobStatus.ENDED.persistanceCode());
            preparedStatement.setString(4, IBMiJobStatus.OUT_QUEUE.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    JobData jobData = (JobData)jobDataGenerator.generateObject(resultSet);
                    arrayList.add(jobData);
                }
                catch (BadDataException badDataException) {
                    String string2 = this.constructBadDataDetails(badDataException.getErrorList());
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to construct job data for an active job, due to corrupt data.{0}", (Object[])new Object[]{string2}));
                }
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving the list of active jobs.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new JobData[arrayList.size()]);
    }

    public JobData getJobData(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        JobDataGenerator jobDataGenerator = new JobDataGenerator();
        String string = "SELECT jobid, jobhid, jobsname, jobname, jobuser, jobnum, jobsvrtrm, jobagstts, jobcpyjl, jobsrints, joblogfil FROM " + this.jobTable + " WHERE jobhid = ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JobData jobData = (JobData)jobDataGenerator.generateObject(resultSet);
                return jobData;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Data for the job with run ID {0} was not found.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving data for the job with run ID {0}.", (Object[])new Object[]{l}), (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public String getJobStatusCode(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT jobsts FROM " + this.jobTable + " WHERE jobhid = ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("jobsts");
                return string2;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Data for the job with run ID {0} was not found.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving data for the job with run ID {0}.", (Object[])new Object[]{l}), (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBMiJobIdentifier submitJob(ExecutableJob executableJob) throws ActionFailedException, IBMiCallException {
        IBMiJobIdentifier iBMiJobIdentifier;
        AS400 aS400;
        try {
            aS400 = this.establishAS400Connection();
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Unable to submit the job.", (Object[])new Object[0]);
            throw new ActionFailedException(string, (Throwable)exception);
        }
        String string = PROGRAM_NAME;
        try {
            boolean bl;
            Object object;
            ProgramCallDocument programCallDocument;
            try {
                programCallDocument = new ProgramCallDocument(aS400, PCML_FILE);
                object = QSYSObjectPathName.toPath((String)library, (String)string, (String)"PGM");
                programCallDocument.setPath(string, (String)object);
                this.setPcmlParameterValues(programCallDocument, executableJob);
                bl = programCallDocument.callProgram(string);
            }
            catch (Exception exception) {
                String string2 = MessageUtil.formatMsg((String)"Unable to submit the job.", (Object[])new Object[0]);
                throw new ActionFailedException(string2, (Throwable)exception);
            }
            if (!bl) {
                object = this.getAS400Messages(programCallDocument, string);
                throw new IBMiCallException("Error in call to program: " + string, this.getAS400MessageTexts((AS400Message[])object));
            }
            try {
                object = (String)programCallDocument.getValue(string + ".submittedJobName");
                String string3 = (String)programCallDocument.getValue(string + ".submittedJobUser");
                String string4 = (String)programCallDocument.getValue(string + ".submittedJobNumber");
                iBMiJobIdentifier = new IBMiJobIdentifier((String)object, string3, string4);
            }
            catch (Exception exception) {
                logger.error((Object)"Unable to construct the IBM i job identifier. Error while reading the fields", (Throwable)exception);
                iBMiJobIdentifier = null;
            }
        }
        finally {
            aS400.disconnectAllServices();
        }
        return iBMiJobIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobInfoAndCommands(long l) throws ResourceUnavailableException {
        Connection connection = this.getJDBCConnection();
        try {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("DELETE FROM " + this.commandTable + " WHERE cmdhid=?");
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
            }
            try {
                try {
                    preparedStatement.setLong(1, l);
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    String string = MessageUtil.formatMsg((String)"SQL error while deleting the command entries for the job with run ID {0}.", (Object[])new Object[]{l});
                    throw new ResourceUnavailableException(string, (Throwable)sQLException);
                }
            }
            finally {
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, null);
            }
            PreparedStatement preparedStatement2 = null;
            try {
                preparedStatement2 = connection.prepareStatement("DELETE FROM " + this.jobTable + " WHERE jobhid=?");
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
            }
            try {
                try {
                    preparedStatement2.setLong(1, l);
                    preparedStatement2.executeUpdate();
                }
                catch (SQLException sQLException) {
                    String string = MessageUtil.formatMsg((String)"SQL error while deleting the job information for the job with run ID {0}.", (Object[])new Object[]{l});
                    throw new ResourceUnavailableException(string, (Throwable)sQLException);
                }
            }
            finally {
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement2, null);
            }
        }
        finally {
            AbstractDatabaseManager.closeEm((Connection)connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String terminateJob(IBMiJobIdentifier iBMiJobIdentifier) throws ActionFailedException, IBMiCallException {
        AS400 aS400;
        try {
            aS400 = this.establishAS400Connection();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Error establishing a connection.", (Throwable)exception);
        }
        String string = "ENDJOB JOB(" + iBMiJobIdentifier.getJobNumber() + "/" + iBMiJobIdentifier.getJobUser() + "/" + iBMiJobIdentifier.getJobName() + ") OPTION(*IMMED)";
        try {
            boolean bl;
            CommandCall commandCall;
            try {
                commandCall = new CommandCall(aS400, string);
                bl = commandCall.run();
            }
            catch (Exception exception) {
                String string2 = MessageUtil.formatMsg((String)"Error on call to command {0}.", (Object[])new Object[]{string});
                throw new ActionFailedException(string2, (Throwable)exception);
            }
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            String[] stringArray = this.getAS400MessageTexts(aS400MessageArray);
            if (!bl) {
                throw new IBMiCallException("Error while running command: " + string, stringArray);
            }
            if (stringArray.length > 0) {
                String string3 = stringArray[0];
                return string3;
            }
        }
        finally {
            aS400.disconnectAllServices();
        }
        return string + " completed.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJobInfo(ExecutableJob executableJob, String string) throws ResourceUnavailableException {
        ScheduleJob scheduleJob = executableJob.getScheduleJob();
        String string2 = "INSERT INTO " + this.jobTable + " (" + "JOBID, JOBSNAME, JOBHID, JOBSTS, JOBNAME, JOBJOBD, JOBJOBQ, " + "JOBPRIOR, JOBOUTQ, JOBMSGQ, JOBMSGRP, JOBACTCD, JOBCURLB, " + "JOBASPGR, JOBLIBL, JOBSTRCMD, JOBAGSTTS, JOBCPYJL, JOBSRINTS, JOBLOGFIL) " + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            boolean bl = scheduleJob.isSendCompleteEmail() && scheduleJob.isSendCompleteJobLog();
            try {
                preparedStatement.setLong(1, scheduleJob.getSkybotJobNumber());
                preparedStatement.setString(2, scheduleJob.getName());
                preparedStatement.setLong(3, executableJob.getJobHistory().getId());
                preparedStatement.setString(4, " ");
                preparedStatement.setString(5, scheduleJob.getIBMiJobName());
                IBMiAgentEnvironment iBMiAgentEnvironment = (IBMiAgentEnvironment)executableJob.getSharedAgentEnvironment();
                preparedStatement.setString(6, this.max(iBMiAgentEnvironment.getJobDescription(), 21));
                preparedStatement.setString(7, this.max(iBMiAgentEnvironment.getJobQueue(), 21));
                preparedStatement.setInt(8, iBMiAgentEnvironment.getJobQueuePriority());
                preparedStatement.setString(9, this.max(iBMiAgentEnvironment.getOutputQueue(), 21));
                preparedStatement.setString(10, this.max(iBMiAgentEnvironment.getMessageQueue(), 21));
                preparedStatement.setString(11, this.max(iBMiAgentEnvironment.getMessageReply(), 10));
                preparedStatement.setString(12, this.max(iBMiAgentEnvironment.getAccountingCode(), 15));
                preparedStatement.setString(13, this.max(iBMiAgentEnvironment.getCurrentLibrary(), 10));
                preparedStatement.setString(14, this.max(iBMiAgentEnvironment.getInitialASPGroup(), 10));
                preparedStatement.setString(15, iBMiAgentEnvironment.getLibraryList());
                preparedStatement.setInt(16, executableJob.getJobHistory().getStartAtCommandSequence());
                preparedStatement.setLong(17, executableJob.getAgentStartedTime());
                preparedStatement.setBoolean(18, scheduleJob.isCopyJobLogToServer() || bl);
                preparedStatement.setLong(19, executableJob.getJobHistory().getServerInitiatedTime());
                preparedStatement.setString(20, string);
                int n = preparedStatement.executeUpdate();
                if (n < 1) {
                    logger.info((Object)MessageUtil.formatMsg((String)"Insert did not generate any rows in {0}.", (Object[])new Object[]{JOB_TABLE}));
                }
            }
            catch (SQLException sQLException) {
                String string3 = "SQL error while inserting the rows into SKYJOB.";
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommands(ExecutableJob executableJob) throws ResourceUnavailableException {
        String string = "INSERT INTO " + this.commandTable + " (" + "CMDJID, CMDHID, CMDNBR, CMDCMD, CMDCANCEL, CMDRETRY, CMDRTWAIT, " + "CMDRTMAX) VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            CommandSetCommand[] commandSetCommandArray;
            try {
                preparedStatement.setLong(1, executableJob.getScheduleJob().getSkybotJobNumber());
                preparedStatement.setLong(2, executableJob.getJobHistory().getId());
            }
            catch (SQLException sQLException) {
                String string2 = "SQL error while inserting the rows into SKYCMD.";
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            for (CommandSetCommand commandSetCommand : commandSetCommandArray = executableJob.getScheduleJob().getCommandSet().getCommands()) {
                this.writeCommand(commandSetCommand, preparedStatement);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void closeConnection(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("Statement cannot be null.");
        }
        Connection connection = null;
        try {
            connection = statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ResultSet resultSet = null;
        try {
            resultSet = statement.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AbstractDatabaseManager.closeEm((Connection)connection, (Statement)statement, (ResultSet)resultSet);
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    private AS400 establishAS400Connection() throws ActionFailedException {
        AS400 aS400 = null;
        String string = IBMiAgent.getAS400SystemName();
        String string2 = IBMiAgent.getAS400UserName();
        String string3 = IBMiAgent.getAS400Password();
        aS400 = new AS400(string, string2, string3);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        try {
            aS400.validateSignon();
        }
        catch (Exception exception) {
            String string4 = MessageUtil.formatMsg((String)"Error trying to create a connection for user {0} on server {1}. Unable to validate the user.", (Object[])new Object[]{string2, string});
            throw new ActionFailedException(string4, (Throwable)exception);
        }
        return aS400;
    }

    private AS400Message[] getAS400Messages(ProgramCallDocument programCallDocument, String string) {
        AS400Message[] aS400MessageArray = new AS400Message[]{};
        try {
            aS400MessageArray = programCallDocument.getMessageList(string);
            if (aS400MessageArray == null) {
                aS400MessageArray = new AS400Message[]{};
            }
        }
        catch (PcmlException pcmlException) {
            logger.debug((Object)"Failed to retrieve AS400Messages.", (Throwable)pcmlException);
        }
        return aS400MessageArray;
    }

    private String[] getAS400MessageTexts(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[aS400MessageArray.length];
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string = aS400MessageArray[i].getID();
            String string2 = aS400MessageArray[i].getText();
            stringArray[i] = string + " " + string2;
            if (aS400MessageArray[i].getHelp() == null) continue;
            int n = i;
            stringArray[n] = stringArray[n] + "(" + aS400MessageArray[i].getHelp() + ")";
        }
        return stringArray;
    }

    private PreparedStatement getDefaultPreparedStmt(String string) throws ResourceUnavailableException {
        Connection connection = this.getJDBCConnection();
        Object var3_3 = null;
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            AbstractDatabaseManager.closeEm((Connection)connection, var3_3, null);
            connection = null;
            var3_3 = null;
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
    }

    private Connection getJDBCConnection() throws ResourceUnavailableException {
        String string = IBMiAgent.getJDBCDriver();
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"JDBC driver {0} not found.", (Object[])new Object[]{string}));
        }
        String string2 = IBMiAgent.getJDBCSystemName();
        String string3 = IBMiAgent.getJDBCConnectionURL(string2);
        String string4 = IBMiAgent.getJDBCUserName();
        String string5 = IBMiAgent.getJDBCPassword();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string3, string4, string5);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while trying to establish a JDBC connection to {0}.", (Object[])new Object[]{string2}), (Throwable)sQLException);
        }
        if (connection == null) {
            throw new ResourceUnavailableException("Unable to get a JDBC Connection.");
        }
        return connection;
    }

    private String max(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    private void scanAS400MessagesForErrors(AS400Message[] aS400MessageArray) throws ResourceUnavailableException, IBMiJobNotFoundException {
        if (aS400MessageArray == null) {
            return;
        }
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string = aS400MessageArray[i].getText();
            if (string.contains("CPF3482")) {
                throw new ResourceUnavailableException("Spool file is open.");
            }
            if (string.contains("CPF3303")) {
                throw new ResourceUnavailableException("Spool file not found.");
            }
            if (!string.contains("CPF3342")) continue;
            throw new IBMiJobNotFoundException();
        }
    }

    private void setPcmlParameterValues(ProgramCallDocument programCallDocument, ExecutableJob executableJob) throws PcmlException, QualifiedObjectNameException {
        programCallDocument.setValue("SKY163.skybotLib", (Object)library);
        programCallDocument.setValue("SKY163.skybotHistoryID", (Object)executableJob.getJobHistory().getId());
        programCallDocument.setValue("SKY163.skybotJobID", (Object)executableJob.getScheduleJob().getSkybotJobNumber());
        programCallDocument.setValue("SKY163.skybotJobName", (Object)executableJob.getScheduleJob().getName());
        programCallDocument.setValue("SKY163.jobName", (Object)executableJob.getScheduleJob().getIBMiJobName());
        IBMiAgentEnvironment iBMiAgentEnvironment = (IBMiAgentEnvironment)executableJob.getSharedAgentEnvironment();
        QualifiedObjectNameHelper qualifiedObjectNameHelper = new QualifiedObjectNameHelper();
        programCallDocument.setValue("SKY163.jobDescLib", (Object)qualifiedObjectNameHelper.getLibrary(iBMiAgentEnvironment.getJobDescription()));
        programCallDocument.setValue("SKY163.jobDesc", (Object)qualifiedObjectNameHelper.getName(iBMiAgentEnvironment.getJobDescription()));
        programCallDocument.setValue("SKY163.jobQueueLib", (Object)qualifiedObjectNameHelper.getLibrary(iBMiAgentEnvironment.getJobQueue()));
        programCallDocument.setValue("SKY163.jobQueue", (Object)qualifiedObjectNameHelper.getName(iBMiAgentEnvironment.getJobQueue()));
        programCallDocument.setValue("SKY163.jobPriority", (Object)iBMiAgentEnvironment.getJobQueuePriority());
        programCallDocument.setValue("SKY163.outQueueLib", (Object)qualifiedObjectNameHelper.getLibrary(iBMiAgentEnvironment.getOutputQueue()));
        programCallDocument.setValue("SKY163.outQueue", (Object)qualifiedObjectNameHelper.getName(iBMiAgentEnvironment.getOutputQueue()));
        programCallDocument.setValue("SKY163.jobUser", (Object)iBMiAgentEnvironment.getUserProfile());
        programCallDocument.setValue("SKY163.acctCode", (Object)iBMiAgentEnvironment.getAccountingCode());
        programCallDocument.setValue("SKY163.currentLib", (Object)iBMiAgentEnvironment.getCurrentLibrary());
        programCallDocument.setValue("SKY163.aspGroup", (Object)iBMiAgentEnvironment.getInitialASPGroup());
        programCallDocument.setValue("SKY163.libraryList", (Object)iBMiAgentEnvironment.getLibraryList());
        programCallDocument.setValue("SKY163.msgReply", (Object)iBMiAgentEnvironment.getMessageReply());
        programCallDocument.setValue("SKY163.msgQueueLib", (Object)qualifiedObjectNameHelper.getLibrary(iBMiAgentEnvironment.getMessageQueue()));
        programCallDocument.setValue("SKY163.msgQueue", (Object)qualifiedObjectNameHelper.getName(iBMiAgentEnvironment.getMessageQueue()));
    }

    private void setSKY702PcmlParameterValues(ProgramCallDocument programCallDocument, String string, String string2) throws PcmlException, QualifiedObjectNameException {
        programCallDocument.setValue("SKY702.stmf", (Object)string2);
        logger.debug((Object)("SKY702.stmf set to: " + programCallDocument.getValue("SKY702.stmf")));
        programCallDocument.setValue("SKY702.endlinfmt", (Object)"*LF");
        logger.debug((Object)("SKY702.endlinfmt set to: " + programCallDocument.getValue("SKY702.endlinfmt")));
    }

    private void writeCommand(CommandSetCommand commandSetCommand, PreparedStatement preparedStatement) throws ResourceUnavailableException {
        try {
            preparedStatement.setInt(3, commandSetCommand.getLineNumber());
            String string = commandSetCommand.getCommandString();
            preparedStatement.setString(4, string);
            preparedStatement.setBoolean(5, commandSetCommand.isCancelOnError());
            preparedStatement.setBoolean(6, commandSetCommand.isErrorHandlingRetry());
            preparedStatement.setInt(7, commandSetCommand.getWaitCount());
            preparedStatement.setInt(8, commandSetCommand.getRetriesCount());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                logger.info((Object)MessageUtil.formatMsg((String)"Insert did not generate any rows in {0}.", (Object[])new Object[]{"SKYCMD."}));
            }
        }
        catch (SQLException sQLException) {
            String string = "SQL error while inserting a row into SKYCMD.";
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private class JobDataGenerator
    extends AbstractBusObjGenerator {
        private JobDataGenerator() {
            super(9, "JobData");
        }

        protected Object constructObject() {
            return new JobData();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            JobData jobData = (JobData)object;
            switch (n) {
                case 1: {
                    jobData.setJobHistoryID(resultSet.getLong("jobhid"));
                    break;
                }
                case 2: {
                    jobData.setJobID(resultSet.getLong("jobid"));
                    break;
                }
                case 3: {
                    jobData.setJobName(Convert.trimR((String)resultSet.getString("jobsname")));
                    break;
                }
                case 4: {
                    String string = Convert.trimR((String)resultSet.getString("jobname"));
                    String string2 = Convert.trimR((String)resultSet.getString("jobuser"));
                    String string3 = Convert.trimR((String)resultSet.getString("jobnum"));
                    jobData.setJobIdentifier(new IBMiJobIdentifier(string, string2, string3));
                    break;
                }
                case 5: {
                    jobData.setTerminatedByServer(resultSet.getBoolean("jobsvrtrm"));
                    break;
                }
                case 6: {
                    jobData.setAgentStartedTime(resultSet.getLong("jobagstts"));
                    break;
                }
                case 7: {
                    jobData.setCopyJobLogToServer(resultSet.getBoolean("jobcpyjl"));
                    break;
                }
                case 8: {
                    jobData.setServerInitiatedTime(resultSet.getLong("jobsrints"));
                    break;
                }
                case 9: {
                    jobData.setLogFilePathAndName(Convert.trimR((String)resultSet.getString("joblogfil")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            ((JobData)object).validate();
        }
    }

    private class QualifiedObjectNameException
    extends Exception {
        private QualifiedObjectNameException(String string) {
            super(string);
        }
    }

    private class QualifiedObjectName {
        private String name;
        private String library;

        private QualifiedObjectName(String string, String string2) {
            this.name = string;
            this.library = string2;
        }

        private String getName() {
            return this.name;
        }

        private String getLibrary() {
            return this.library;
        }
    }

    private class QualifiedObjectNameHelper {
        private char separator = (char)47;
        private int maxLength = 10;

        private QualifiedObjectNameHelper() {
        }

        private String getName(String string) throws QualifiedObjectNameException {
            return this.parseAndValidate(string).getName();
        }

        private String getLibrary(String string) throws QualifiedObjectNameException {
            return this.parseAndValidate(string).getLibrary();
        }

        private QualifiedObjectName parseAndValidate(String string) throws QualifiedObjectNameException {
            String string2;
            String string3;
            if (string.isEmpty()) {
                throw new QualifiedObjectNameException("The qualified object name is empty.");
            }
            int n = string.indexOf(this.separator);
            if (n == -1) {
                string3 = string.trim().toUpperCase();
                string2 = "";
            } else {
                if (n != string.lastIndexOf(this.separator)) {
                    throw new QualifiedObjectNameException(MessageUtil.formatMsg((String)"The qualified object name ''{0}'' is invalid. It contains multiple separator (''{1}'') characters.", (Object[])new Object[]{string, Character.valueOf(this.separator)}));
                }
                string2 = string.substring(0, n).trim().toUpperCase();
                string3 = string.substring(n + 1).trim().toUpperCase();
            }
            String string4 = null;
            if (string3.isEmpty()) {
                string4 = "The name portion of the qualified object name is empty.";
            }
            if (string3.length() > this.maxLength) {
                string4 = MessageUtil.formatMsg((String)"The name portion ''{0}'' of the qualified object name ''{1}'' exceeds the maximum length of {2}.", (Object[])new Object[]{string3, string, this.maxLength});
            }
            if (string2.length() > this.maxLength) {
                string4 = MessageUtil.formatMsg((String)"The library portion ''{0}'' of the qualified object name ''{1}'' exceeds the maximum length of {2}.", (Object[])new Object[]{string2, string, this.maxLength});
            }
            if (string4 != null) {
                throw new QualifiedObjectNameException(string4);
            }
            return new QualifiedObjectName(string3, string2);
        }
    }
}

