/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.enterprise.scheduler.executors.DailyCleanupExecutor;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class ScheduledRunner
implements InterruptibleProcess {
    private static Logger logger = Logger.getLogger(DailyCleanupExecutor.class);
    public static final long SECONDS_IN_A_DAY = 86400L;
    public static final long ONE_TIME_RUN = 0L;
    private static final long MIN_DELTA_TIME = 3L;
    private Runnable action = null;
    private String actionName;
    private long run_time = new Date().getTime();
    private long wait_time = 0L;
    private boolean is_terminated = false;
    private Thread thread_runner = null;
    private static final long NOT_SET = -1L;
    private static final int NOT_SET_INT = -1;
    private long base_time = -1L;
    private long delta_time_factor = 24L;
    private int mins = -1;
    private int hour = -1;

    public void scheduleAtFixedRate(Runnable runnable, long l, long l2, String string) {
        this.action = runnable;
        this.actionName = string;
        this.run_time = System.currentTimeMillis() + l * 1000L;
        this.setHHMM(this.run_time);
        this.wait_time = l2 * 1000L;
        this.calculateDeltaTimeFactor(l2);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                while (!ScheduledRunner.this.isTerminated()) {
                    long l = 0L;
                    long l2 = System.currentTimeMillis();
                    if (l2 + l >= ScheduledRunner.this.getRunTime()) {
                        ScheduledRunner.this.getAction().run();
                        if (ScheduledRunner.this.getWaitTime() > 0L) {
                            ScheduledRunner.this.setNextRuntime();
                        } else {
                            ScheduledRunner.this.setIsTerminated(true);
                            return;
                        }
                    }
                    long l3 = ScheduledRunner.this.getRunTime() - System.currentTimeMillis();
                    try {
                        if (l3 <= 0L) continue;
                        l = l3 / ScheduledRunner.this.delta_time_factor;
                        if (ScheduledRunner.this.base_time == -1L) {
                            ScheduledRunner.this.base_time = l;
                        } else if (l > ScheduledRunner.this.base_time) {
                            ScheduledRunner.this.delta_time_factor++;
                            l = l3 / ScheduledRunner.this.delta_time_factor;
                            ScheduledRunner.this.base_time = l;
                        } else if (l < ScheduledRunner.this.base_time && ScheduledRunner.this.delta_time_factor > 3L) {
                            ScheduledRunner.this.delta_time_factor--;
                            l = l3 / ScheduledRunner.this.delta_time_factor;
                            ScheduledRunner.this.base_time = l;
                        }
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        ScheduledRunner.this.setIsTerminated(true);
                    }
                }
            }
        };
        this.thread_runner = new Thread(runnable2);
        this.thread_runner.setName(this.getActionName());
        this.thread_runner.start();
    }

    private void setHHMM(long l) {
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.hour = gregorianCalendar.get(11);
        this.mins = gregorianCalendar.get(12);
    }

    private long getNextWakeupTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, this.hour);
        gregorianCalendar.set(12, this.mins);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (date.getTime() >= gregorianCalendar.getTimeInMillis()) {
            gregorianCalendar.add(6, 1);
        }
        return gregorianCalendar.getTimeInMillis();
    }

    public void clearRuntime() {
        this.mins = -1;
        this.hour = -1;
    }

    public void setMinute(int n) {
        this.mins = n;
    }

    public void setHour(int n) {
        this.hour = n;
    }

    private void calculateDeltaTimeFactor(long l) {
        long l2 = l / 3600L;
        this.delta_time_factor = l2 <= 1L ? 60L : (l2 < 24L ? 24L : l2);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting delta time factor to " + this.delta_time_factor));
        }
    }

    protected void setIsTerminated(boolean bl) {
        this.is_terminated = bl;
    }

    public boolean isTerminated() {
        return this.is_terminated;
    }

    private void setNextRuntime() {
        if (this.getWaitTime() == 86400000L) {
            this.setNextRuntime(this.getNextWakeupTime());
        } else {
            long l = System.currentTimeMillis();
            long l2 = l / 1000L;
            long l3 = l2 * 1000L + this.getWaitTime();
            long l4 = System.currentTimeMillis() - l;
            this.setNextRuntime(l3 -= l4);
        }
    }

    private void setNextRuntime(long l) {
        this.run_time = l;
    }

    private long getWaitTime() {
        return this.wait_time;
    }

    private long getRunTime() {
        return this.run_time;
    }

    private String getActionName() {
        return this.actionName;
    }

    private Runnable getAction() {
        return this.action;
    }

    public void awaitTermination(long l) throws InterruptedException {
        if (this.thread_runner != null) {
            this.thread_runner.interrupt();
        }
        Thread.sleep(l * 1000L);
    }

    public void shutdown() {
        this.setIsTerminated(true);
        try {
            this.awaitTermination(3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isShutdown() {
        return this.isTerminated();
    }

    public void interrupt() {
        if (this.thread_runner == null) {
            return;
        }
        try {
            this.thread_runner.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        if (this.thread_runner == null) {
            return false;
        }
        return this.thread_runner.isInterrupted();
    }

    public static final void main(String[] stringArray) {
        final ScheduledRunner scheduledRunner = new ScheduledRunner();
        Date date = new Date();
        long l = date.getSeconds();
        long l2 = 0L;
        if (l > 0L) {
            l2 = 60L - l;
        }
        long l3 = 30000L + l2;
        System.out.println("About to start the cancel thread to run in " + l3 + " seconds.");
        ScheduledRunner scheduledRunner2 = new ScheduledRunner();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.out.println("Cancel thread starting at - " + new Date());
                scheduledRunner.shutdown();
            }
        };
        scheduledRunner2.scheduleAtFixedRate(runnable, l3, 0L, "Cancel Thread");
        long l4 = 86400L;
        System.out.println("About to start Bazinga thread in " + l2 + " and run each " + l4 + " seconds.");
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                System.out.println("Bazinga! - " + new Date(l) + " - Next Runtime: " + new Date(scheduledRunner.getRunTime()));
            }
        };
        scheduledRunner.scheduleAtFixedRate(runnable2, l2, l4, "Test Runner");
    }
}

