/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.logger.ScheduleLogDM;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.sql.SQLException;

public class ScheduleLogPurgeRunner
extends AbstractPurgeRunner {
    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        ScheduleLogDM scheduleLogDM = (ScheduleLogDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleLogDM");
        scheduleLogDM.purge(systemSetup.getScheduleLogDaysToKeep());
    }

    @Override
    public String getName() {
        return RosettaMsg.PURGE_SCHEDULE_LOG_NAME.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return systemSetup.isScheduleLogAutoPurge();
    }
}

