/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.SNMPTrapEventDM;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.sql.SQLException;

public class SNMPTrapPurgeRunner
extends AbstractPurgeRunner {
    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        SNMPTrapEventDM sNMPTrapEventDM = (SNMPTrapEventDM)ManagerRegistry.getManager((String)"ENTERPRISE.SNMPTrapEventDM");
        sNMPTrapEventDM.purgeHistory(systemSetup.getSnmpTrapDaysToRetain());
    }

    @Override
    public String getName() {
        return RosettaMsg.PURGE_SNMP_EVENTS_NAME.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return systemSetup.isSnmpTrapAutoPurge();
    }
}

