/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.io.File;
import java.io.FileFilter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;

public class LogPurgeRunner
extends AbstractPurgeRunner {
    private static final int PURGE_DAYS = 30;
    private static final int PURGE_MINUTS = 10;
    private static final int PURGE_LIMIT = 30;
    private static final String userDir = System.getProperty("user.dir");
    private static final String logDirName = userDir + File.separator + "logs";
    private static final String PglogDirName = userDir + File.separator + "pgsql" + File.separator + "data" + File.separator + "pg_log";
    private static final String logTempDirName = userDir + File.separator + "tmp" + File.separator + "JobLogs";

    @Override
    public String getName() {
        return RosettaMsg.LOG_PURGE_RUNNER_NAME.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return true;
    }

    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        this.cleanupLogsDayOld();
        this.cleanupLogsMinuteOld();
        this.cleanupPgLogsOld();
    }

    private void cleanupLogsDayOld() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.add(5, -30);
        String[] stringArray = new String[]{"'" + logDirName + "'", ScheduleLogger.formatTimeStamp((Calendar)calendar)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_LOGS.newLogEntry(stringArray);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        PurgeLogFilterDayOld purgeLogFilterDayOld = new PurgeLogFilterDayOld(calendar.getTimeInMillis());
        File file = new File(logDirName);
        int n = 0;
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(purgeLogFilterDayOld)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Purging: " + file2.getAbsolutePath()));
                }
                file2.delete();
                ++n;
            }
            logger.info((Object)(n + " files were purged from " + logDirName));
        } else {
            logger.error((Object)("Logs directory path '" + file.getAbsolutePath() + "' is not found or it is not a directory."));
        }
    }

    private void cleanupLogsMinuteOld() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, -10);
        String[] stringArray = new String[]{"'" + logTempDirName + "'", ScheduleLogger.formatTimeStamp((Calendar)calendar)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_LOGS.newLogEntry(stringArray);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        PurgeLogFilter purgeLogFilter = new PurgeLogFilter(calendar.getTimeInMillis());
        File file = new File(logTempDirName);
        int n = 0;
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(purgeLogFilter)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Purging: " + file2.getAbsolutePath()));
                }
                file2.delete();
                ++n;
            }
            logger.info((Object)(n + " files were purged from " + logTempDirName));
        } else {
            logger.warn((Object)("Temp logs directory path '" + file.getAbsolutePath() + "' is not found or it is not a directory."));
        }
    }

    private void cleanupPgLogsOld() {
        String[] stringArray = new String[]{"'" + PglogDirName + "'", "last 30"};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_LOGS.newLogEntry(stringArray);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        File file = new File(PglogDirName);
        int n = 0;
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return Long.valueOf(file.lastModified()).compareTo(file2.lastModified());
                }
            });
            if (fileArray.length > 30) {
                for (int i = fileArray.length - 1 - 30; i >= 0; --i) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Purging: " + fileArray[i].getAbsolutePath()));
                    }
                    fileArray[i].delete();
                    ++n;
                }
            }
            logger.info((Object)(n + " files were purged from " + PglogDirName));
        } else {
            logger.error((Object)("Logs directory path '" + file.getAbsolutePath() + "' is not found or it is not a directory."));
        }
    }

    private class PurgeLogFilterDayOld
    implements FileFilter {
        private long purgeTimeStamp;

        public PurgeLogFilterDayOld(long l) {
            this.purgeTimeStamp = l;
        }

        @Override
        public boolean accept(File file) {
            boolean bl = false;
            if (file.isFile()) {
                if (file.getName().toLowerCase().endsWith(".log") && file.lastModified() < this.purgeTimeStamp) {
                    bl = true;
                } else if (file.getName().toLowerCase().startsWith("localhost") && file.getName().toLowerCase().endsWith(".txt") && file.lastModified() < this.purgeTimeStamp) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class PurgeLogFilter
    implements FileFilter {
        private long purgeTimeStamp;

        public PurgeLogFilter(long l) {
            this.purgeTimeStamp = l;
        }

        @Override
        public boolean accept(File file) {
            boolean bl = false;
            if (file.isFile() && file.getName().toLowerCase().endsWith(".log") && file.lastModified() < this.purgeTimeStamp) {
                bl = true;
            }
            return bl;
        }
    }
}

