/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.scheduler.executors.ScheduledRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public abstract class CleanupExecutor
implements Runnable {
    protected static Logger logger = Logger.getLogger(CleanupExecutor.class);
    private ScheduledRunner service = new ScheduledRunner();
    private String threadName = "Cleanup Thread";
    private boolean inDebug = false;
    private List<Runnable> list = Collections.synchronizedList(new ArrayList());
    private RosettaMsg nextWakeupLog;
    private RosettaMsg noCleanupRunnersLog;
    private RosettaMsg cleanupRunnerErrorLog;

    public CleanupExecutor() {
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SERVER.getMDCKeyValue());
    }

    protected abstract long getNextWakeupTime();

    protected abstract long getWaitTime();

    protected abstract boolean isServerLogEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        thread.setName(this.threadName);
        thread.setPriority(3);
        this.printLogMessage("The " + this.threadName + " process is starting...");
        String[] stringArray = new String[]{ScheduleLogger.formatTimeStamp((long)this.getNextWakeupTime())};
        ScheduleLogEntry scheduleLogEntry = this.nextWakeupLog.newLogEntry(stringArray);
        if (this.isServerLogEnabled()) {
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
        logger.debug((Object)scheduleLogEntry.getMessageText());
        if (this.inDebug) {
            this.printDebug();
        }
        List<Runnable> list = this.list;
        synchronized (list) {
            if (this.list.size() < 1) {
                scheduleLogEntry = this.noCleanupRunnersLog.newLogEntry();
                logger.info((Object)scheduleLogEntry.getMessageText());
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            } else {
                for (int i = 0; i < this.list.size(); ++i) {
                    Runnable runnable = this.list.get(i);
                    try {
                        String string = "Processing " + this.threadName + " Runner:  " + runnable.toString();
                        logger.debug((Object)string);
                        runnable.run();
                        continue;
                    }
                    catch (Exception exception) {
                        logger.debug((Object)(this.threadName + " Runner encounted an error."), (Throwable)exception);
                        String[] stringArray2 = new String[]{runnable.toString(), exception.getLocalizedMessage()};
                        scheduleLogEntry = this.cleanupRunnerErrorLog.newLogEntry(stringArray2);
                        logger.info((Object)scheduleLogEntry.getMessageText());
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    }
                }
            }
        }
        this.printLogMessage("The " + this.threadName + " process has completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunner(Runnable runnable) {
        if (runnable != null) {
            List<Runnable> list = this.list;
            synchronized (list) {
                this.list.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRunner(Runnable runnable) {
        if (runnable != null) {
            List<Runnable> list = this.list;
            synchronized (list) {
                return this.list.remove(runnable);
            }
        }
        return false;
    }

    public void scheduleService() {
        long l = this.getNextWakeupTime();
        long l2 = l - System.currentTimeMillis();
        long l3 = Math.round(l2 / 1000L) + 1;
        this.service.scheduleAtFixedRate(this, l3, this.getWaitTime(), this.threadName + " Clean Executor");
    }

    public void interrupt() {
    }

    public void setThreadName(String string) {
        this.threadName = string;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setService(ScheduledRunner scheduledRunner) {
        this.service = scheduledRunner;
    }

    public ScheduledRunner getService() {
        return this.service;
    }

    private void printLogMessage(String string) {
        if (string != null) {
            if (this.isServerLogEnabled()) {
                logger.info((Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)string);
            }
        }
    }

    private void printDebug() {
        Date date = new Date();
        System.out.println("Running task: " + date.toString());
        Date date2 = new Date(this.getNextWakeupTime());
        System.out.println("Next task: " + date2.toString());
    }

    public void setLogMessages(RosettaMsg rosettaMsg, RosettaMsg rosettaMsg2, RosettaMsg rosettaMsg3) {
        this.nextWakeupLog = rosettaMsg;
        this.noCleanupRunnersLog = rosettaMsg2;
        this.cleanupRunnerErrorLog = rosettaMsg3;
    }
}

