/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractPurgeRunner
implements Runnable {
    static Logger logger = Logger.getLogger(AbstractPurgeRunner.class);

    @Override
    public void run() {
        try {
            SystemSetupDM systemSetupDM = MRHelper.getSystemSetupDM();
            SystemSetup systemSetup = systemSetupDM.get();
            if (this.isOkToRunPurge(systemSetup)) {
                this.doPurge(systemSetup);
            } else {
                this.showSkippedMessage();
            }
        }
        catch (Exception exception) {
            this.sendFailedMessage(exception);
        }
    }

    private void showSkippedMessage() {
        ScheduleLogEntry scheduleLogEntry = this.getScheduleLogEntrySkippedMessage();
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        logger.info((Object)scheduleLogEntry.getMessageText());
    }

    private void sendFailedMessage(Exception exception) {
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.FAILED_TO_RUN.newLogEntry(this.getNameForRosettaMsg());
        logger.error((Object)scheduleLogEntry.getMessageText(), (Throwable)exception);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    public String toString() {
        return RosettaMsg.PURGE_RUNNER_NAME.newLogEntry(this.getNameForRosettaMsg()).getMessageText();
    }

    private String[] getNameForRosettaMsg() {
        String[] stringArray = new String[]{this.getName()};
        return stringArray;
    }

    public ScheduleLogEntry getScheduleLogEntrySkippedMessage() {
        return RosettaMsg.PURGE_LOG_SKIPPED.newLogEntry(this.getNameForRosettaMsg());
    }

    public abstract String getName();

    public abstract boolean isOkToRunPurge(SystemSetup var1);

    public abstract void doPurge(SystemSetup var1) throws ResourceUnavailableException, DataException, SQLException;
}

