/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.JobReactCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEventHistory;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventHistory;
import com.helpsystems.enterprise.core.dm.AgentEventCountRollupDM;
import com.helpsystems.enterprise.core.dm.JobMonitorEventCountRollupDM;
import com.helpsystems.enterprise.core.dm.PrereqEventDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.SnmpEventCountRollupDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventHistoryDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventSource;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.remoteserver.RemoteServerNotifier;
import com.helpsystems.enterprise.scheduler.ReactivityMonitor;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class ReactivityAMImpl
extends AbstractManager
implements ReactivityAM {
    private static final Logger logger = Logger.getLogger(ReactivityAMImpl.class);
    private PrereqEventDM prereqEventDM;
    private PrereqDM prereqDM;
    private ReactivityMonitor reactivityMonitor;
    private JobMonitorEventCountRollupDM jobMonitorEventCountRollupDM;
    private AgentEventCountRollupDM agentEventCountRollupDM;
    private SnmpEventCountRollupDM snmpEventCountRollupDM;
    private RemoteServerNotifier remoteServerNotifier;

    public ReactivityAMImpl(PrereqEventDM prereqEventDM, PrereqDM prereqDM) {
        this.setName("ENTERPRISE.ReactivityAM");
        ValidationHelper.checkForNull((String)"PrereqEventDM", (Object)prereqEventDM);
        ValidationHelper.checkForNull((String)"PrereqDM", (Object)prereqDM);
        this.prereqEventDM = prereqEventDM;
        this.prereqDM = prereqDM;
        this.reactivityMonitor = new ReactivityMonitor(this.prereqEventDM);
        this.remoteServerNotifier = new RemoteServerNotifier();
    }

    private JobMonitorEventCountRollupDM getJobMonitorEventCountRollupDM() {
        if (this.jobMonitorEventCountRollupDM == null) {
            this.jobMonitorEventCountRollupDM = (JobMonitorEventCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorEventCountRollupDM");
        }
        return this.jobMonitorEventCountRollupDM;
    }

    private AgentEventCountRollupDM getAgentEventCountRollupDM() {
        if (this.agentEventCountRollupDM == null) {
            this.agentEventCountRollupDM = (AgentEventCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventCountRollupDM");
        }
        return this.agentEventCountRollupDM;
    }

    private SnmpEventCountRollupDM getSnmpEventCountRollupDM() {
        if (this.snmpEventCountRollupDM == null) {
            this.snmpEventCountRollupDM = (SnmpEventCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SnmpEventCountRollupDM");
        }
        return this.snmpEventCountRollupDM;
    }

    public void notifyAgentEvent(Connection connection, AgentEventHistoryInfo agentEventHistoryInfo) {
        if (logger.isTraceEnabled()) {
            String string = MessageUtil.formatMsg((String)"{0} ({1}) received from monitor {2} ({3}) for agent {4} ({5}).", (Object[])new Object[]{PrereqEventType.AGENT_EVENT.toString(), agentEventHistoryInfo.getOID(), agentEventHistoryInfo.getEventMonitorName(), agentEventHistoryInfo.getEventOID(), agentEventHistoryInfo.getAgentName(), agentEventHistoryInfo.getAgentOID()});
            logger.trace((Object)string);
        }
        if (agentEventHistoryInfo.getSendStatusEvent() == null) {
            try {
                this.getAgentEventCountRollupDM().saveAgentEventCount(connection, agentEventHistoryInfo.getEventType(), agentEventHistoryInfo.getServerTimeStamp());
            }
            catch (Exception exception) {
                logger.debug((Object)"Error saving agent_event_count_rollups for agent event processing", (Throwable)exception);
            }
        }
        if (agentEventHistoryInfo.getSendStatusEvent() != null || this.usedAsPrerequisite(connection, agentEventHistoryInfo.getEventOID(), PrereqEventType.AGENT_EVENT)) {
            try {
                this.prereqEventDM.generateEvent(connection, agentEventHistoryInfo);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for Agent Event.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        }
        this.remoteServerNotifier.notifyOfAgentEvent(agentEventHistoryInfo);
    }

    public void notifyJobMonitorEvent(JobMonitorEvent jobMonitorEvent) {
        String string;
        PrereqEventType prereqEventType = jobMonitorEvent.determinePrereqEventType();
        if (logger.isTraceEnabled()) {
            string = MessageUtil.formatMsg((String)"{0} {1} ({2}) occurred for job {3} ({4}) on agent {5} ({6}) with history id {7} with JobType {8} with JobSuiteHistoryID {9} with JobSuiteMemberJobID {10}.", (Object[])new Object[]{prereqEventType, jobMonitorEvent.getEventTypeDescription(), jobMonitorEvent.getID(), jobMonitorEvent.getRuntimeJobName(), jobMonitorEvent.getJobID(), jobMonitorEvent.getAgentName(), jobMonitorEvent.getAgentID(), jobMonitorEvent.getJobRunID(), jobMonitorEvent.getJobType(), jobMonitorEvent.getJobSuiteHistoryID(), jobMonitorEvent.getJobSuiteMemberJobID()});
            logger.trace((Object)string);
        }
        try {
            this.getJobMonitorEventCountRollupDM().saveJobMonEventsCount(jobMonitorEvent.getEventType(), jobMonitorEvent.getTimeDetected());
        }
        catch (Exception exception) {
            logger.debug((Object)"Error saving job_monitor_event_count_rollups for job monitor processing", (Throwable)exception);
        }
        if (!this.reactableJobMonitorEvent(jobMonitorEvent.getEventType())) {
            if (logger.isTraceEnabled()) {
                string = MessageUtil.formatMsg((String)"{0} {1} is not reactable.", (Object[])new Object[]{prereqEventType, jobMonitorEvent.getEventTypeDescription()});
                logger.trace((Object)string);
            }
            return;
        }
        if (this.usedAsPrerequisite(null, jobMonitorEvent.getJobID(), prereqEventType)) {
            try {
                this.prereqEventDM.generateEvent(jobMonitorEvent);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for Job Monitor Event.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"The event is not used as a prerequisite!");
        }
        this.remoteServerNotifier.notifyOfJobMonitorEvent(jobMonitorEvent);
    }

    private boolean reactableJobMonitorEvent(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void notifyJobStatusChange(JobHistory jobHistory) {
        String string;
        if (logger.isTraceEnabled()) {
            string = MessageUtil.formatMsg((String)"Job {0} ({1}) for agent {2} ({3}) with history id {4} changed status to {5}", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getJobID(), jobHistory.getAgentName(), jobHistory.getAgentID(), jobHistory.getId(), jobHistory.getStatusCode()});
            logger.trace((Object)string);
        }
        if (jobHistory.getReactCode() == JobReactCode.SKIP_REACTIVITY) {
            if (logger.isTraceEnabled()) {
                string = MessageUtil.formatMsg((String)"Skipping reactivity for job {0} ({1}) on agent {2} ({3}) with history ID {4}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getJobID(), jobHistory.getAgentName(), jobHistory.getAgentID(), jobHistory.getId()});
                logger.trace((Object)string);
            }
            return;
        }
        if (!jobHistory.getStatusCode().isReactable()) {
            if (logger.isTraceEnabled()) {
                string = MessageUtil.formatMsg((String)"Status {5} is not reactable for job {0} ({1}) on agent {2} ({3}) with history ID {4}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getJobID(), jobHistory.getAgentName(), jobHistory.getAgentID(), jobHistory.getId(), jobHistory.getStatusCode()});
                logger.trace((Object)string);
            }
            return;
        }
        if (jobHistory.getInitiationCode() == JobInitCode.RESTART && (jobHistory.getStatusCode() == JobStatusCode.SUBMITTED || jobHistory.getStatusCode() == JobStatusCode.RUNNING)) {
            if (logger.isTraceEnabled()) {
                string = MessageUtil.formatMsg((String)"Status {5} is not processed for restarted job {0} ({1}) on agent {2} ({3}) with history ID {4}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getJobID(), jobHistory.getAgentName(), jobHistory.getAgentID(), jobHistory.getId(), jobHistory.getStatusCode()});
                logger.trace((Object)string);
            }
            return;
        }
        long l = jobHistory.getJobID();
        PrereqEventType prereqEventType = PrereqEventType.JOB_STATUS_CHANGE;
        if (jobHistory.isJobSuiteMember()) {
            prereqEventType = PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE;
            l = jobHistory.getJobSuiteMemberID();
        } else if (jobHistory.isJobSuite()) {
            prereqEventType = PrereqEventType.JOB_SUITE_STATUS_CHANGE;
        }
        if (this.usedAsPrerequisite(null, l, prereqEventType)) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Generating Job Status " + jobHistory.getStatusCode() + " event for type: " + prereqEventType + " Prereq Object ID: " + l + " Prereq Object Name: " + jobHistory.getJobName()));
                }
                this.prereqEventDM.generateEvent(jobHistory, prereqEventType);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for Job Status Change.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("Not generating event - Prereq Object is not used:  Object ID: " + l + " Event Type: " + prereqEventType + " Job Name: " + jobHistory.getJobName() + " Agent: " + jobHistory.getAgentName() + " Status: " + jobHistory.getStatusCode()));
        }
        this.remoteServerNotifier.notifyOfJobStatusChange(jobHistory);
    }

    public void notifySNMPTrapEvent(SNMPTrapEvent sNMPTrapEvent) {
        String string = MessageUtil.formatMsg((String)"{0} ({1}) received for monitor {2} ({3}).", (Object[])new Object[]{PrereqEventType.SNMP_TRAP_EVENT.toString(), sNMPTrapEvent.getID(), sNMPTrapEvent.getSNMPTrapMonitorName(), sNMPTrapEvent.getSNMPTrapMonitorID()});
        logger.trace((Object)string);
        try {
            this.getSnmpEventCountRollupDM().saveSNMPEventCount(sNMPTrapEvent.getTimeDetected());
        }
        catch (Exception exception) {
            logger.debug((Object)"Error saving snmp_event_count_rollups for Snmp event processing", (Throwable)exception);
        }
        if (this.usedAsPrerequisite(null, sNMPTrapEvent.getSNMPTrapMonitorID(), PrereqEventType.SNMP_TRAP_EVENT)) {
            try {
                this.prereqEventDM.generateEvent(sNMPTrapEvent);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for SNMP Trap Event.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        }
    }

    private void testNotifySAPEvent(AgentEventHistoryInfo agentEventHistoryInfo) {
        SAPEventHistory sAPEventHistory = new SAPEventHistory();
        sAPEventHistory.setOID(22L);
        sAPEventHistory.setEventMonitorOID(1000L);
        sAPEventHistory.setEventParameters(agentEventHistoryInfo.getEventData());
        sAPEventHistory.setEventMonitorName("EventMonitorName");
        sAPEventHistory.setEventTimestampUTC(System.currentTimeMillis());
        sAPEventHistory.setStatus('*');
        SAPEventHistoryDM sAPEventHistoryDM = (SAPEventHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPEventHistoryDM");
        try {
            sAPEventHistoryDM.save(sAPEventHistory, null);
        }
        catch (Exception exception) {
            logger.error((Object)"Error testing SAPEventHistoryDM.save method.", (Throwable)exception);
        }
    }

    public void notifySAPEvent(Connection connection, SAPEventHistory sAPEventHistory) {
        String string = MessageUtil.formatMsg((String)"{0} ({1}) received for monitor {2} ({3}).", (Object[])new Object[]{PrereqEventType.SAP_MONITOR_EVENT.toString(), sAPEventHistory.getOID(), sAPEventHistory.getName(), sAPEventHistory.getEventMonitorOID()});
        logger.trace((Object)string);
        logger.info((Object)("-------------------->>>>: " + string));
        if (sAPEventHistory.isFromSendStatus() || this.usedAsPrerequisite(connection, sAPEventHistory.getEventMonitorOID(), PrereqEventType.SAP_MONITOR_EVENT)) {
            try {
                this.prereqEventDM.generateEvent(connection, sAPEventHistory);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for SAP Event.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        }
    }

    private boolean jobHasPrerequisites(long l) {
        boolean bl = false;
        try {
            bl = this.prereqDM.jobIsDependent(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string = MessageUtil.formatMsg((String)"Can''t determine if job {0} has dependent records; sending the event to reactivity monitor.", (Object[])new Object[]{l});
            logger.error((Object)string, (Throwable)resourceUnavailableException);
            return true;
        }
        if (!bl && logger.isTraceEnabled()) {
            String string = MessageUtil.formatMsg((String)"Job ({0}) does NOT have Dependent records.", (Object[])new Object[]{l});
            logger.trace((Object)string);
        }
        return bl;
    }

    private boolean usedAsPrerequisite(Connection connection, long l, PrereqEventType prereqEventType) {
        boolean bl = false;
        try {
            bl = this.prereqDM.eventIsPrerequisite(connection, l, prereqEventType);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string = MessageUtil.formatMsg((String)"Can''t determine if {0} ({1}) is a prerequisite; sending the event to reactivity monitor.", (Object[])new Object[]{prereqEventType.toString(), l});
            logger.error((Object)string, (Throwable)resourceUnavailableException);
            return true;
        }
        if (!bl && logger.isTraceEnabled()) {
            String string = MessageUtil.formatMsg((String)"Object ({0}) associated with {1} is not a prerequisite.", (Object[])new Object[]{l, prereqEventType.toString()});
            logger.trace((Object)string);
        }
        return bl;
    }

    public Object getReactivityMonitor() {
        return this.reactivityMonitor;
    }

    public void notifySendStatusEvent(SendStatusEvent sendStatusEvent) {
        logger.debug((Object)sendStatusEvent.toString());
        try {
            this.prereqEventDM.generateEvent(sendStatusEvent);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error saving Prereq Event for Send Status Event.", throwable);
            return;
        }
        this.reactivityMonitor.wakeUp();
        this.remoteServerNotifier.notifyOfStatusChange(sendStatusEvent);
    }

    public void notifyJobChange(String string, String string2, long l) {
        if (this.jobHasPrerequisites(l)) {
            long l2 = 0L;
            long l3 = 0L;
            SendStatusEvent sendStatusEvent = SendStatusEvent.sendJobChangeEvent((String)string, (String)string2, (long)l, (long)l2, (long)l3);
            try {
                this.prereqEventDM.generateEvent(sendStatusEvent);
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error saving Prereq Event for Job Changed Event.", throwable);
                return;
            }
            this.reactivityMonitor.wakeUp();
        }
    }

    private void testRemoteEvent() {
        RemoteEventHistory remoteEventHistory = new RemoteEventHistory();
        remoteEventHistory.setId(1000L);
        remoteEventHistory.setRemoteEventID(1000L);
        remoteEventHistory.setType(RemoteEventType.JOB_STATUS_CHANGE);
        remoteEventHistory.setObjectID(789L);
        remoteEventHistory.setObjectName("RBTJOB");
        remoteEventHistory.setStatus(PrereqStatusType.COMPLETED);
        remoteEventHistory.setServerTime(System.currentTimeMillis());
        remoteEventHistory.setSource(RemoteEventSource.REMOTE_SERVER);
        remoteEventHistory.setSourceName("123456/USER/JOB");
        remoteEventHistory.setRemoteSystemTime(0L);
        remoteEventHistory.setSourceKey(1234567890L);
        remoteEventHistory.setAgentName(null);
        remoteEventHistory.setSendStatusEvent(null);
        this.notifyRemoteEvent(remoteEventHistory);
    }

    public void notifyRemoteEvent(RemoteEventHistory remoteEventHistory) {
        try {
            this.prereqEventDM.generateEvent(remoteEventHistory);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error saving Prereq Event for Remote Event.", throwable);
            return;
        }
        this.reactivityMonitor.wakeUp();
    }
}

