/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.MissedJobsAccountant;
import com.helpsystems.enterprise.core.busobj.ReactivityDateObject;
import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.ReactivityDays;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.ReactivityDateObjectDM;
import com.helpsystems.enterprise.core.dm.ReactivityDayOfPeriodDM;
import com.helpsystems.enterprise.core.dm.ReactivityDaysDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsType;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqGroup;
import com.helpsystems.enterprise.core.scheduler.PrereqList;
import com.helpsystems.enterprise.core.scheduler.PrereqSet;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.util.LongConverter;
import com.helpsystems.enterprise.scheduler.JobSubmitter;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class PrereqEvaluator {
    private static final Logger logger = Logger.getLogger(PrereqEvaluator.class);
    private NSTCalculator nstCalculator;
    private ScheduleJobDM scheduleJobDM;
    private CalendarObjectDM calendarObjectDM;
    private JobSubmitter jobSubmitter;
    private ActivityMatcherAM activityMatcherAM;
    private Calendar currentDateTime = Calendar.getInstance();
    private PrereqDM prereqDM;
    private PrereqList prereqList;
    private ReactivityDaysDM reactivityDaysDM;
    private ReactivityDayOfPeriodDM reactivityDayOfPeriodDM;
    private ReactivityDateObjectDM reactivityDateObjectDM;
    private JobTrackerAM jobTrackerAM;
    private AgentGroupDM agentGroupDM;
    private ScheduledTimeDM scheduledTimeDM;
    private JobDateObjectsDM jobDateObjectsDM;
    private static final String SKIPPED_INITATION_DATA_MESSAGE = "Skipped";

    public PrereqEvaluator(NSTCalculator nSTCalculator, ScheduleJobDM scheduleJobDM, PrereqDM prereqDM) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"NSTCalculator", (Object)nSTCalculator);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        this.nstCalculator = nSTCalculator;
        this.scheduleJobDM = scheduleJobDM;
        this.prereqDM = prereqDM;
        this.jobSubmitter = new JobSubmitter(this.scheduleJobDM);
        this.prereqList = prereqDM.createPrereqList();
        this.reactivityDaysDM = (ReactivityDaysDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDaysDM");
        this.reactivityDayOfPeriodDM = (ReactivityDayOfPeriodDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDayOfPeriodDM");
        this.reactivityDateObjectDM = (ReactivityDateObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDateObjectDM");
        this.calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        this.activityMatcherAM = (ActivityMatcherAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ActivityMatcherAM");
        this.jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        this.scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
        this.jobDateObjectsDM = (JobDateObjectsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobDateObjectsDM");
    }

    public void shutDown() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Shutting Down PrereqEvaluator...");
        }
        if (this.prereqList != null) {
            this.prereqList.close();
        }
    }

    public void prereqEvent(ScheduleJobProxy scheduleJobProxy, int n) {
        block20: {
            int n2 = LongConverter.intValue((long)scheduleJobProxy.getSkybotJobNumber());
            JobInfo jobInfo = this.constructJobInfo(n2, scheduleJobProxy, n);
            if (scheduleJobProxy.isScheduleTypeJob()) {
                if (logger.isDebugEnabled()) {
                    if (scheduleJobProxy.getJobType() == JobType.SUITE) {
                        logger.debug((Object)("Prereq status was not evaluated for job suite " + jobInfo.getJobNameWithID() + " because the job suite is specifically scheduled."));
                    }
                    if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT) {
                        logger.debug((Object)("Prereq status was not evaluated for job " + jobInfo.getJobNameWithID() + " on agent " + jobInfo.getAgentNameWithID() + " because the job is specifically scheduled."));
                    } else if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                        logger.debug((Object)("Prereq status was not evaluated for job " + jobInfo.getJobNameWithID() + " on agent group" + jobInfo.getAgentNameWithID() + " because the job is specifically scheduled."));
                    }
                }
                return;
            }
            try {
                PrereqSet prereqSet = this.prereqDM.loadPrereqSet((long)n, (long)n2, this.prereqList);
                if (prereqSet.getPrereqGroups().length == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("There are no prerequisites for job " + jobInfo.getJobNameWithID() + " on agent " + jobInfo.getAgentNameWithID()));
                    }
                    return;
                }
                PrereqResults prereqResults = this.prereqsHaveBeenMet(n2, n, prereqSet, scheduleJobProxy);
                if (prereqResults.isSatisfied()) {
                    Calendar calendar = this.currentDateTime();
                    TimeZone timeZone = this.timezone(scheduleJobProxy, n);
                    calendar.setTimeZone(timeZone);
                    CalendarObject calendarObject = null;
                    RosettaMsg rosettaMsg = null;
                    String[] stringArray = null;
                    if (this.isOutsideReactiveRange(scheduleJobProxy, calendar, calendarObject)) {
                        rosettaMsg = scheduleJobProxy.isSuite() ? RosettaMsg.JOB_SUITE_NOT_SUBMITTED_REACTIVE_TIME_RANGE : RosettaMsg.JOB_NOT_SUBMITTED_REACTIVE_TIME_RANGE;
                        stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID()};
                    } else if (this.isOmitDate(scheduleJobProxy, calendar, calendarObject)) {
                        rosettaMsg = scheduleJobProxy.isSuite() ? RosettaMsg.REACTIVE_JOB_SUITE_NOT_SUBMITTED_OMITTED_PER_DATE_LIST : RosettaMsg.REACTIVE_JOB_NOT_SUBMITTED_OMITTED_PER_DATE_LIST;
                        String string = this.nameOfOmitDateList(scheduleJobProxy);
                        stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID(), string};
                    } else if (this.isBypassDueToNonWorkday(scheduleJobProxy, calendar, calendarObject)) {
                        rosettaMsg = scheduleJobProxy.isSuite() ? RosettaMsg.REACTIVE_JOB_SUITE_NOT_SUBMITTED_NON_WORKDAY_RULE : RosettaMsg.REACTIVE_JOB_NOT_SUBMITTED_NON_WORKDAY_RULE;
                        stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID()};
                    }
                    if (rosettaMsg == null) {
                        boolean bl = this.jobSubmitter.submit(n2, n, jobInfo, calendar.getTime(), JobInitCode.REACTIVE, prereqResults.getHistoryCodes(), false, scheduleJobProxy);
                        if (!bl) {
                            this.clearPrereqStatuses(n, n2, PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS);
                        }
                    } else {
                        long l = scheduleJobProxy.getSkybotJobNumber();
                        ScheduleLogEntry scheduleLogEntry = scheduleJobProxy.isSuite() ? rosettaMsg.newLogEntryForSuite(stringArray, l) : rosettaMsg.newLogEntry(stringArray, (long)jobInfo.getAgentID(), l);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)scheduleLogEntry.getMessageText());
                        }
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        this.clearPrereqStatuses(n, n2, PrereqDM.ResetOption.CLEAR_UNKEPT_PREREQ_STATUS);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("PrereqEvaluator error");
                if (exception == null) break block20;
                exception.printStackTrace();
            }
        }
    }

    private boolean isBypassDueToNonWorkday(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        ScheduleInfo.NonWorkdayOption nonWorkdayOption = scheduleJobProxy.getNonWorkdayOption();
        boolean bl = false;
        switch (nonWorkdayOption) {
            case RUN: {
                break;
            }
            case RUN_ON_NEAREST_PRIOR_WORKDAY: 
            case RUN_ON_NEAREST_SUBSEQUENT_WORKDAY: {
                logger.warn((Object)MessageUtil.formatMsg((String)"Invalid non-work day option ''{0}'' selected for {1} {2}. Will process as ''{3}''.", (Object[])new Object[]{nonWorkdayOption, scheduleJobProxy.getJobType(), scheduleJobProxy.getName(), ScheduleInfo.NonWorkdayOption.DO_NOT_RUN}));
            }
            case DO_NOT_RUN: {
                calendarObject = this.calendarObject(calendarObject, scheduleJobProxy);
                bl = calendar != null && calendarObject.isNonWorkday(calendar);
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Non-work day option {0} is not supported by this method.", (Object[])new Object[]{nonWorkdayOption}));
            }
        }
        return bl;
    }

    private boolean isOmitDate(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        long l = scheduleJobProxy.getSkybotJobNumber();
        try {
            DateObject dateObject = this.jobDateObjectsDM.get(JobDateObjectsType.OMIT_DATE_OBJECTS, l);
            if (dateObject != null) {
                calendarObject = this.calendarObject(calendarObject, scheduleJobProxy);
                int n = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
                return dateObject.contains(n);
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Unable to check for an omit date for {0} {1}. Will assume it is not an omit date. Details: {2}", (Object[])new Object[]{scheduleJobProxy.getJobType(), scheduleJobProxy.getName(), this.nestedMsgText(exception)});
            logger.error((Object)string);
        }
        return false;
    }

    private boolean isOutsideReactiveRange(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        switch (scheduleJobProxy.getScheduleType()) {
            case REACTIVITY_DAY_OF_WEEK: {
                return !this.isReactiveTime_DOW(scheduleJobProxy, calendar, calendarObject);
            }
            case REACTIVITY_DAY_OF_PERIOD: {
                return !this.isReactiveTime_DOP(scheduleJobProxy, calendar, calendarObject);
            }
            case REACTIVITY_DATE_LIST: {
                return !this.isReactiveTime_DateList(scheduleJobProxy, calendar, calendarObject);
            }
        }
        return false;
    }

    private boolean isReactiveTime_DOW(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        long l = scheduleJobProxy.getSkybotJobNumber();
        try {
            ReactivityDays[] reactivityDaysArray = this.reactivityDaysDM.get(l);
            if (reactivityDaysArray != null && reactivityDaysArray.length > 0) {
                calendarObject = this.calendarObject(calendarObject, scheduleJobProxy);
                long l2 = 0L;
                for (int i = 0; i < reactivityDaysArray.length; ++i) {
                    if (!reactivityDaysArray[i].isTimeAccepted(calendar, l2, calendarObject)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (NoDataException noDataException) {
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"Error checking day of week reactivity schedule.", (Throwable)exception);
        }
        return true;
    }

    private boolean isReactiveTime_DOP(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        long l = scheduleJobProxy.getSkybotJobNumber();
        try {
            ReactivityDayOfPeriod[] reactivityDayOfPeriodArray = this.reactivityDayOfPeriodDM.get(l);
            if (reactivityDayOfPeriodArray != null && reactivityDayOfPeriodArray.length > 0) {
                calendarObject = this.calendarObject(calendarObject, scheduleJobProxy);
                for (int i = 0; i < reactivityDayOfPeriodArray.length; ++i) {
                    if (!reactivityDayOfPeriodArray[i].isTimeAccepted(calendar, calendarObject, scheduleJobProxy)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (NoDataException noDataException) {
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"Error checking day of period reactivity schedule.", (Throwable)exception);
        }
        return true;
    }

    private boolean isReactiveTime_DateList(ScheduleJobProxy scheduleJobProxy, Calendar calendar, CalendarObject calendarObject) {
        long l = scheduleJobProxy.getSkybotJobNumber();
        try {
            ReactivityDateObject[] reactivityDateObjectArray = this.reactivityDateObjectDM.get(l);
            if (reactivityDateObjectArray != null && reactivityDateObjectArray.length > 0) {
                calendarObject = this.calendarObject(calendarObject, scheduleJobProxy);
                for (ReactivityDateObject reactivityDateObject : reactivityDateObjectArray) {
                    if (!reactivityDateObject.isTimeAccepted(calendar, calendarObject)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (NoDataException noDataException) {
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"Error checking date list reactivity schedule.", (Throwable)exception);
        }
        return true;
    }

    public void timerEvent(int n, int n2, Calendar calendar) {
        ValidationHelper.checkForNull((String)"Scheduled Time", (Object)calendar);
        ScheduleJobProxy scheduleJobProxy = this.getScheduleJobProxy(n);
        if (!this.isValidNST(n, n2, scheduleJobProxy)) {
            this.purgeInvalidNST(n, n2);
            return;
        }
        JobInfo jobInfo = this.constructJobInfo(n, scheduleJobProxy, n2);
        boolean bl = false;
        PrereqSet prereqSet = null;
        try {
            prereqSet = this.prereqDM.loadPrereqSet((long)n2, (long)n, this.prereqList);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error loading Prereq Set.", (Throwable)resourceUnavailableException);
        }
        PrereqResults prereqResults = this.prereqsHaveBeenMet(n, n2, prereqSet, scheduleJobProxy);
        if (prereqResults.isSatisfied()) {
            JobInitCode jobInitCode = JobInitCode.SCHEDULE;
            if (prereqSet.getPrereqGroups().length > 0) {
                jobInitCode = JobInitCode.SCHEDULED_WITH_PREREQS;
            }
            if (!(bl = this.jobSubmitter.submit(n, n2, jobInfo, this.currentDateTime().getTime(), calendar, jobInitCode, prereqResults.getHistoryCodes(), false, scheduleJobProxy))) {
                this.clearPrereqStatuses(n2, n, PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS);
            }
        } else {
            JobType jobType = scheduleJobProxy.getJobType();
            long l = 0L;
            boolean bl2 = this.jobSubmitter.isJobHeld(scheduleJobProxy, jobInfo, calendar, n2);
            if (bl2) {
                if (scheduleJobProxy.isLateStartMonitorSelected()) {
                    this.jobSubmitter.sendJobIsHeld(n, jobInfo, calendar);
                }
            } else if (scheduleJobProxy.isGenerateSkippedHistory()) {
                JobHistory jobHistory = new JobHistory();
                l = this.jobSubmitter.createSkippedHistory(jobHistory, n, n2, jobInfo, this.currentDateTime().getTime(), calendar, JobInitCode.SCHEDULED_WITH_PREREQS, JobEndedReasonCode.PREREQUISITE_NOT_MET, scheduleJobProxy.getDefaultPriority(), SKIPPED_INITATION_DATA_MESSAGE, JobMissedCode.SKIPPED, jobType, scheduleJobProxy);
                this.notifySkippedStatus(jobHistory, jobInfo, calendar, jobType);
            } else if (scheduleJobProxy.getJobType() == JobType.SUITE) {
                String[] stringArray = new String[]{scheduleJobProxy.getName(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
                long l2 = scheduleJobProxy.getSkybotJobNumber();
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_PREREQS_NOT_MET.newLogEntryForSuite(stringArray, l2);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.debug((Object)scheduleLogEntry.getMessageText());
            } else {
                this.logThatPrereqsWereNotMet(jobInfo, true, calendar);
            }
            if (l > 0L) {
                this.activityMatcherAM.jobSkipped_PrereqsNotMet((long)n, jobType, (long)n2, calendar.getTimeInMillis(), l);
            } else {
                this.activityMatcherAM.jobSkipped_PrereqsNotMet((long)n, jobType, (long)n2, calendar.getTimeInMillis());
            }
            this.clearPrereqStatuses(n2, n, PrereqDM.ResetOption.CLEAR_UNKEPT_PREREQ_STATUS);
        }
        this.calculateNST(n, n2, calendar, jobInfo);
    }

    public Calendar timerEventMissed(int n, int n2, Calendar calendar, boolean bl, boolean bl2, MissedJobsAccountant missedJobsAccountant, boolean bl3, Date date, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        String[] stringArray;
        ValidationHelper.checkForNull((String)"Scheduled Time", (Object)calendar);
        JobInfo jobInfo = this.constructJobInfo(n, scheduleJobProxy, n2);
        boolean bl4 = false;
        PrereqSet prereqSet = null;
        try {
            prereqSet = this.prereqDM.loadPrereqSet((long)n2, (long)n, this.prereqList);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error loading Prereq Set.", (Throwable)resourceUnavailableException);
        }
        PrereqResults prereqResults = this.prereqsHaveBeenMet(n, n2, prereqSet, scheduleJobProxy);
        if (!prereqResults.isSatisfied()) {
            stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.PREREQ_NOT_MET_FOR_MISSED.newLogEntry(stringArray, (long)n, (long)n, 0L);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)scheduleLogEntry.getMessageText());
            }
            JobType jobType = scheduleJobProxy.getJobType();
            long l = 0L;
            boolean bl5 = this.jobSubmitter.isJobHeld(scheduleJobProxy, jobInfo, calendar, n2);
            if (bl5) {
                if (scheduleJobProxy.isLateStartMonitorSelected()) {
                    this.jobSubmitter.sendJobIsHeld(n, jobInfo, calendar);
                }
            } else {
                if (scheduleJobProxy.isGenerateSkippedHistory()) {
                    JobHistory jobHistory = new JobHistory();
                    l = this.jobSubmitter.createSkippedHistory(jobHistory, n, n2, jobInfo, this.currentDateTime().getTime(), calendar, JobInitCode.SCHEDULED_WITH_PREREQS, JobEndedReasonCode.PREREQUISITE_NOT_MET, scheduleJobProxy.getDefaultPriority(), SKIPPED_INITATION_DATA_MESSAGE, JobMissedCode.SKIPPED_AFTER_MISS, jobType, scheduleJobProxy);
                    scheduleLogEntry.setJobHistoryID(jobHistory.getId());
                    try {
                        this.jobTrackerAM.notifyOfJobStatus(jobHistory, null, scheduleLogEntry.getMessageText());
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error sending notification for job status change.", (Throwable)exception);
                    }
                }
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            }
            this.clearPrereqStatuses(n2, n, PrereqDM.ResetOption.CLEAR_UNKEPT_PREREQ_STATUS);
            if (l > 0L) {
                this.activityMatcherAM.jobSkipped_PrereqsNotMet((long)n, jobType, (long)n2, calendar.getTimeInMillis(), l);
            } else {
                this.activityMatcherAM.jobSkipped_PrereqsNotMet((long)n, jobType, (long)n2, calendar.getTimeInMillis());
            }
        } else {
            stringArray = JobInitCode.SCHEDULE;
            if (prereqSet.getPrereqGroups().length > 0) {
                stringArray = JobInitCode.SCHEDULED_WITH_PREREQS;
            }
            if (!(bl4 = this.jobSubmitter.submitMissedJob(n, n2, jobInfo, this.currentDateTime().getTime(), calendar, bl, bl2, (JobInitCode)stringArray, prereqResults.getHistoryCodes(), missedJobsAccountant, bl3, date, scheduleJobProxy))) {
                this.clearPrereqStatuses(n2, n, PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS);
            }
        }
        stringArray = this.calculateNST(n, n2, calendar, jobInfo);
        return stringArray.getNextScheduledTime();
    }

    private void clearPrereqStatuses(long l, long l2, PrereqDM.ResetOption resetOption) {
        try {
            this.prereqDM.resetPrereqStatus(l, l2, resetOption);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error resetting prereq status.", (Throwable)resourceUnavailableException);
        }
    }

    private ScheduledTime calculateNST(int n, int n2, Calendar calendar, JobInfo jobInfo) {
        ScheduledTime scheduledTime = new ScheduledTime();
        scheduledTime.setJobNumber(n);
        scheduledTime.setSystem(n2);
        scheduledTime.setConsideredScheduledTime(calendar);
        scheduledTime.setConsideredAtDateTime(this.currentDateTime());
        this.nstCalculator.calcNST(scheduledTime, jobInfo);
        return scheduledTime;
    }

    private CalendarObject calendarObject(CalendarObject calendarObject, ScheduleJobProxy scheduleJobProxy) {
        if (calendarObject == null) {
            try {
                return this.calendarObjectDM.get(scheduleJobProxy.getCalendarID());
            }
            catch (Exception exception) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load a CalendarObject for {0} {1}.", (Object[])new Object[]{scheduleJobProxy.getJobType(), scheduleJobProxy.getName()}), exception);
            }
        }
        return calendarObject;
    }

    private JobInfo constructJobInfo(int n, ScheduleJobProxy scheduleJobProxy, int n2) {
        String string;
        if (scheduleJobProxy != null && scheduleJobProxy.getJobType() == JobType.SUITE) {
            return new JobInfo(n, scheduleJobProxy.getName());
        }
        int n3 = n2;
        int n4 = 0;
        String string2 = null;
        if (scheduleJobProxy != null) {
            string2 = scheduleJobProxy.getName();
            if (n3 == 0 && scheduleJobProxy.getSystem() != 0) {
                n3 = scheduleJobProxy.getSystem();
            }
            n4 = scheduleJobProxy.getModel();
        } else {
            string2 = String.valueOf(n);
        }
        String string3 = "";
        if (n3 != 0) {
            string = this.getAgent(n3);
            string3 = string != null ? string.getName() : String.valueOf(n3);
        }
        string = "";
        if (n4 != 0) {
            AgentGroupProxy agentGroupProxy = this.getAgentGroupProxy(n4);
            if (agentGroupProxy != null) {
                string = agentGroupProxy.getName();
                if (n3 == 0 && (agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED || agentGroupProxy.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT)) {
                    string3 = Agent.getTBDInGroupAgentName((String)string);
                }
            } else {
                string = String.valueOf(n4);
            }
        }
        long l = 0L;
        String string4 = "Default";
        if (scheduleJobProxy != null) {
            l = scheduleJobProxy.getJobQueueID();
            string4 = scheduleJobProxy.getJobQueueName();
        }
        return new JobInfo(n, string2, n2, string3, n4, string, l, string4);
    }

    private Calendar currentDateTime() {
        this.currentDateTime.setTimeInMillis(System.currentTimeMillis());
        return (Calendar)this.currentDateTime.clone();
    }

    private Agent getAgent(long l) {
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        try {
            return agentDM.get(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Agent for Agent ID " + l), (Throwable)exception);
            return null;
        }
    }

    private AgentGroupProxy getAgentGroupProxy(long l) {
        AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        try {
            return agentGroupDM.getProxy(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Agent Group Proxy for Agent Group ID " + l), (Throwable)exception);
            return null;
        }
    }

    private ScheduleJobProxy getScheduleJobProxy(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Job Proxy for Job ID " + l + "."), (Throwable)exception);
            return null;
        }
    }

    private boolean isAgentInGroup(long l, long l2) {
        try {
            long[] lArray;
            for (long l3 : lArray = this.agentGroupDM.getAgentsIDsInGroup(l2, null)) {
                if (l3 != l) continue;
                return true;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to verify that agent ID {0} is part of agent group with ID {1}, due to an error.", (Object[])new Object[]{l, l2}), (Throwable)resourceUnavailableException);
            return true;
        }
        return false;
    }

    private boolean isValidNST(int n, int n2, ScheduleJobProxy scheduleJobProxy) {
        return this.isValidAgentForJob(n, n2, scheduleJobProxy);
    }

    private boolean isValidAgentForJob(int n, int n2, ScheduleJobProxy scheduleJobProxy) {
        long l = n2;
        if (scheduleJobProxy.getTargetType() != null) {
            block1 : switch (scheduleJobProxy.getTargetType()) {
                case AGENT: {
                    if (l == scheduleJobProxy.getTargetId()) break;
                    JobInfo jobInfo = this.constructJobInfo(n, scheduleJobProxy, n2);
                    String string = jobInfo.getAgentNameWithID();
                    long l2 = scheduleJobProxy.getTargetId();
                    String string2 = this.getAgent(l2).getName();
                    RosettaMsg rosettaMsg = RosettaMsg.INVALID_NST_WRONG_AGENT_FOR_JOB;
                    String[] stringArray = new String[]{jobInfo.getJobNameWithID(), string, jobInfo.getJobName(), string2};
                    ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                    scheduleLogEntry.setJobID((long)n);
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    String string3 = jobInfo.getJobName();
                    SystemMessage systemMessage = RosettaMsg.INVALID_NST.newSystemMessage(string3);
                    SystemMessageQueue.write((SystemMessage)systemMessage);
                    String string4 = MessageUtil.formatMsg((String)"An invalid next scheduled time entry was encountered: job = {0}, agent = {1}. Job {2} is currently defined to run on 1 agent and that agent is {3}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), string, jobInfo.getJobName(), string2});
                    logger.error((Object)string4);
                    return false;
                }
                case AGENT_GROUP: {
                    AgentGroupType agentGroupType;
                    long l3 = scheduleJobProxy.getTargetId();
                    try {
                        agentGroupType = this.retrieveAgentGroupType(l3);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        logger.error((Object)MessageUtil.formatMsg((String)"Unable to verify that the agent with ID {0} is valid for the job with ID {1}, due to an error. The assumption will be that it is valid and processing will continue.", (Object[])new Object[]{l, n}), (Throwable)resourceUnavailableException);
                        return true;
                    }
                    switch (agentGroupType) {
                        case ALL_AGENTS: {
                            if (this.isAgentInGroup(l, l3)) break block1;
                            JobInfo jobInfo = this.constructJobInfo(n, scheduleJobProxy, n2);
                            RosettaMsg rosettaMsg = RosettaMsg.INVALID_NST_AGENT_NOT_PART_OF_GROUP;
                            String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), jobInfo.getJobName(), jobInfo.getAgentGroupName(), jobInfo.getAgentName()};
                            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                            scheduleLogEntry.setJobID((long)n);
                            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                            String string = jobInfo.getJobName();
                            SystemMessage systemMessage = RosettaMsg.INVALID_NST.newSystemMessage(string);
                            SystemMessageQueue.write((SystemMessage)systemMessage);
                            String string5 = MessageUtil.formatMsg((String)"An invalid next scheduled time entry was encountered: job = {0}, agent = {1}. Job {2} is currently defined to run on agent group {3}. Agent {4} is not defined as part of {3}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), jobInfo.getJobName(), jobInfo.getAgentGroupName(), jobInfo.getAgentName()});
                            logger.error((Object)string5);
                            return false;
                        }
                        case UTILIZATION_BALANCED: 
                        case PREFERRED_AGENT: {
                            if (l == 0L) break block1;
                            JobInfo jobInfo = this.constructJobInfo(n, scheduleJobProxy, n2);
                            RosettaMsg rosettaMsg = RosettaMsg.INVALID_NST_AGENT_SHOULD_BE_UNASSIGNED;
                            String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), jobInfo.getJobName(), jobInfo.getAgentGroupName(), jobInfo.getAgentName()};
                            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                            scheduleLogEntry.setJobID((long)n);
                            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                            String string = jobInfo.getJobName();
                            SystemMessage systemMessage = RosettaMsg.INVALID_NST.newSystemMessage(string);
                            SystemMessageQueue.write((SystemMessage)systemMessage);
                            return false;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                        }
                    }
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{scheduleJobProxy.getTargetType()}));
                }
            }
        }
        return true;
    }

    private void logThatPrereqsWereNotMet(JobInfo jobInfo, boolean bl, Calendar calendar) {
        String[] stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PREREQ_NOT_MET.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
        if (bl) {
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
    }

    private PrereqResults prereqsHaveBeenMet(int n, int n2, PrereqSet prereqSet, ScheduleJobProxy scheduleJobProxy) {
        Object object;
        if (logger.isDebugEnabled()) {
            object = MessageUtil.formatMsg((String)"Evaluating Prerequisite Status for dependent job {0} on agent {1}.", (Object[])new Object[]{n, n2});
            logger.debug(object);
        }
        if (prereqSet == null) {
            throw new NullPointerException("Prerequisite Set is null for job number " + n);
        }
        try {
            object = this.prereqDM.getPrereqState((long)n2, prereqSet, scheduleJobProxy);
            if (object.isSatisfied()) {
                PrereqGroup prereqGroup = object.getSatisfiedBy();
                PrereqResults prereqResults = null;
                prereqResults = prereqGroup == null ? new PrereqResults(true, null) : new PrereqResults(true, prereqGroup.getHistoryCodes());
                return prereqResults;
            }
            return new PrereqResults();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error checking prerequisites.", (Throwable)resourceUnavailableException);
            return new PrereqResults();
        }
    }

    private String nameOfOmitDateList(ScheduleJobProxy scheduleJobProxy) {
        long l = scheduleJobProxy.getSkybotJobNumber();
        try {
            DateObject dateObject = this.jobDateObjectsDM.get(JobDateObjectsType.OMIT_DATE_OBJECTS, l);
            if (dateObject != null) {
                return dateObject.getName();
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Unable to check for an omit date list for {0} {1}. {2}", (Object[])new Object[]{scheduleJobProxy.getJobType(), scheduleJobProxy.getName(), this.nestedMsgText(exception)});
            logger.warn((Object)string);
        }
        return null;
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private void notifySkippedStatus(JobHistory jobHistory, JobInfo jobInfo, Calendar calendar, JobType jobType) {
        String[] stringArray;
        ScheduleLogEntry scheduleLogEntry = null;
        if (jobType == JobType.SUITE) {
            stringArray = new String[]{jobInfo.getJobName(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
            long l = jobInfo.getJobID();
            long l2 = jobHistory.getId();
            scheduleLogEntry = RosettaMsg.SUITE_PREREQS_NOT_MET.newLogEntryForSuite(stringArray, l, l2);
        } else {
            stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
            scheduleLogEntry = RosettaMsg.PREREQ_NOT_MET.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID(), jobHistory.getId());
        }
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        try {
            this.jobTrackerAM.notifyOfJobStatus(jobHistory, null, scheduleLogEntry.getMessageText());
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending notification for job status change.", (Throwable)exception);
        }
    }

    private void purgeInvalidNST(int n, int n2) {
        block4: {
            try {
                int n3 = this.scheduledTimeDM.delete(n, n2);
                if (n3 == 1) {
                    RosettaMsg rosettaMsg = RosettaMsg.INVALID_NST_PURGED;
                    String[] stringArray = new String[]{Integer.toString(n), Integer.toString(n2)};
                    ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                    scheduleLogEntry.setJobID((long)n);
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    break block4;
                }
                if (n3 > 1) {
                    RosettaMsg rosettaMsg = RosettaMsg.INVALID_NST_PURGED_MULTIPLE;
                    String[] stringArray = new String[]{Integer.toString(n3), Integer.toString(n), Integer.toString(n2)};
                    ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                    scheduleLogEntry.setJobID((long)n);
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    break block4;
                }
                return;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to delete the next scheduled time entry with job ID = {0} and agent ID = {1}, due to an error.", (Object[])new Object[]{n, n2}), (Throwable)resourceUnavailableException);
            }
        }
    }

    private AgentGroupType retrieveAgentGroupType(long l) throws ResourceUnavailableException {
        try {
            AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l);
            return agentGroupProxy.getAgentGroupType();
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group type because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
        }
    }

    private TimeZone timezone(ScheduleJobProxy scheduleJobProxy, long l) {
        TimeZone timeZone;
        String string = scheduleJobProxy.getName();
        ScheduleInfo.TimeZoneType timeZoneType = scheduleJobProxy.getTimezoneType();
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                String string2 = this.agentTimezoneID(l);
                timeZone = this.timezone(string2, string);
                break;
            }
            case JOB: {
                String string3 = scheduleJobProxy.getJobTimezone();
                if (string3 != null && !string3.isEmpty()) {
                    timeZone = this.timezone(string3, string);
                    break;
                }
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string4}));
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private String agentTimezoneID(long l) {
        String string;
        try {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
            Agent agent = agentDM.get(l);
            string = agent.getTimeZone();
        }
        catch (Exception exception) {
            TimeZone timeZone = this.serverTimeZone();
            string = timeZone.getID();
            String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
            logger.error((Object)string2, (Throwable)exception);
        }
        return string;
    }

    private class PrereqResults {
        boolean satisfied;
        String historyCodes;

        PrereqResults() {
            this.satisfied = false;
            this.historyCodes = null;
        }

        PrereqResults(boolean bl, String string) {
            this.satisfied = bl;
            this.historyCodes = string;
        }

        protected boolean isSatisfied() {
            return this.satisfied;
        }

        protected String getHistoryCodes() {
            return this.historyCodes;
        }
    }
}

